/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.cert.CertificateFactoryImpl;
import com.ibm.security.cert.CompositeCRL;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CRLReasonCodeExtension;
import com.ibm.security.x509.DeltaCRLIndicatorExtension;
import com.ibm.security.x509.DistributionPoint;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.IssuingDistributionPointExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.ReasonFlags;
import com.ibm.security.x509.X509CRLEntryImpl;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRSChecker {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    static final String[] myExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.CRLDistributionPoints").toString()};
    static final String[] deltaCRLAttrIDArray = new String[]{"deltaRevocationList"};
    static final String[] baseCRLAttrIDArray = new String[]{"certificateRevocationList"};
    static final String[] baseARLAttrIDArray = new String[]{"authorityRevocationList"};
    static final String[] allCRLAttrIDArray = new String[]{"authorityRevocationList", "authorityRevocationList;binary", "certificateRevocationList", "certificateRevocationList;binary", "deltaRevocationList", "deltaRevocationList;binary"};
    private CertPath certPath;
    private Collection certStores;
    private boolean trustCertPathForCRLs;
    private boolean useDeltas;
    private Set trustBaseSet;
    private Date validationDate;
    private int numberOfCertsInCertPath;
    private String sigProvider;
    private Collection ibmCollectionCertStores = null;
    private int currentCertIndex;
    private Vector willBeTrustedCollection;
    private Hashtable CRLCache = new Hashtable();
    private boolean[] userReasons = new boolean[]{false, true, true, true, true, true, true};
    private TrustAnchor trustAnchor;
    private static final int CHECK_INTERVAL = 30000;

    public CRSChecker(CertPath certPath, Collection certStores, boolean trustCertPathForCRLs, boolean useDeltas, Set trustBaseSet, Date validationDate, boolean useFreshestData, String sigProvider) throws CertPathValidatorException {
        this.certPath = certPath;
        this.certStores = certStores;
        this.trustCertPathForCRLs = trustCertPathForCRLs;
        this.useDeltas = useDeltas;
        this.trustBaseSet = trustBaseSet;
        this.validationDate = validationDate;
        this.sigProvider = sigProvider;
        List<? extends Certificate> certPathCerts = certPath.getCertificates();
        this.numberOfCertsInCertPath = certPathCerts.size();
        this.currentCertIndex = this.numberOfCertsInCertPath - 1;
        this.willBeTrustedCollection = new Vector();
        this.ibmCollectionCertStores = this.getIBMCollectionCertStores(certStores);
        this.CRLCache = this.setCRLCache(certStores);
        X509Certificate rootCert = null;
        if (this.numberOfCertsInCertPath > 0) {
            rootCert = (X509Certificate)certPathCerts.get(this.numberOfCertsInCertPath - 1);
        }
        if (rootCert != null) {
            this.trustAnchor = null;
            try {
                this.trustAnchor = CertPathUtil.findIssuer(rootCert, trustBaseSet, sigProvider);
            }
            catch (CertPathValidatorException e) {
                throw new CertPathValidatorException("The certificate issued by " + rootCert.getIssuerX500Principal().toString() + " is not trusted", (Throwable)e, certPath, this.numberOfCertsInCertPath - 1);
            }
        }
    }

    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("The direction of forward is not supported");
        }
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public void check(Certificate certificate, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        Object cpvException = null;
        X509Certificate currentCert = (X509Certificate)certificate;
        if (currentCert.getIssuerX500Principal().equals(currentCert.getSubjectX500Principal())) {
            try {
                this.trustAnchor = new TrustAnchor(currentCert, null);
            }
            catch (IllegalArgumentException e) {
                throw new CertPathValidatorException("Fail to instantiate trust anchor for certificate revocation status processing", (Throwable)e, this.certPath, this.currentCertIndex);
            }
            --this.currentCertIndex;
            return;
        }
        boolean caCertificate = true;
        Object[] bcResult = CertPathUtil.getBasicConstraints(currentCert);
        caCertificate = (Boolean)bcResult[1];
        int certificateRevocationStatus = 2001;
        certificateRevocationStatus = this.checkCRLCache(currentCert, this.trustAnchor, caCertificate);
        if (certificateRevocationStatus == 2001) {
            if (this.checkCRLDPEnabled()) {
                if (debug != null) {
                    System.out.println("CERTPATH: check distribution points in certificate:" + currentCert.toString());
                }
                certificateRevocationStatus = 2000;
                DistributionPoint[] distributionPoints = CertPathUtil.getCRLDistributionPoints(currentCert);
                if (distributionPoints != null) {
                    if (debug != null) {
                        System.out.println("CERTPATH: get distribution points");
                    }
                    certificateRevocationStatus = this.processDistributionPoints(distributionPoints, currentCert, this.willBeTrustedCollection, this.certStores, this.useDeltas, this.trustBaseSet, caCertificate, this.validationDate, this.userReasons, this.sigProvider);
                }
            } else if (debug != null) {
                System.out.println("CERTPATH: CRL distribution point extension check is disabled");
            }
        }
        String subject = currentCert.getSubjectX500Principal().toString();
        String expString = null;
        switch (certificateRevocationStatus) {
            case 1000: {
                expString = "The certificate with subject (" + subject + ") has been revoked for an unspecified reason.";
                break;
            }
            case 1001: {
                expString = "The certificate with subject (" + subject + ") has been revoked because the key has been compromised.";
                break;
            }
            case 1002: {
                expString = "The certificate with subject (" + subject + ") has been revoked because the CA key has been compromised.";
                break;
            }
            case 1003: {
                expString = "The certificate with subject (" + subject + ") has been revoked because the owner's affiliation has changed.";
                break;
            }
            case 1004: {
                expString = "The certificate with subject (" + subject + ") has been revoked because is is superseded.";
                break;
            }
            case 1005: {
                expString = "The certificate with subject (" + subject + ") has been revoked because of cessation of operation.";
                break;
            }
            case 1006: {
                expString = "The certificate with subject (" + subject + ") has been put on hold.";
                break;
            }
            case 2000: {
                break;
            }
            case 2001: {
                expString = "The revocation status of the certificate with subject (" + subject + ") could not be determined.";
                break;
            }
            case 2002: {
                expString = "The certificate with subject (" + subject + ") has been revoked, revocation reason unknown.";
                break;
            }
            default: {
                expString = "An internal error has occurred in processing the certificate:" + certificateRevocationStatus;
            }
        }
        if (expString != null) {
            throw new CertPathValidatorException(expString, null, this.certPath, this.currentCertIndex);
        }
        try {
            this.trustAnchor = new TrustAnchor(currentCert, null);
        }
        catch (IllegalArgumentException e) {
            throw new CertPathValidatorException("Fail to instantiate trust anchor for certificate revocation status processing", (Throwable)e, this.certPath, this.currentCertIndex);
        }
        --this.currentCertIndex;
        if (this.trustCertPathForCRLs) {
            this.willBeTrustedCollection.add(currentCert);
        }
    }

    int checkCRLCache(X509Certificate cert, TrustAnchor anchor, boolean caCertificate) throws CertPathValidatorException {
        X500Principal issuer = null;
        PublicKey key = null;
        X509Certificate trustedCert = null;
        boolean[] keyUsage = CertPathUtil.getKeyUsage(cert);
        if (this.currentCertIndex != 0 && caCertificate && keyUsage != null && !keyUsage[6]) {
            if (debug != null) {
                System.out.println("CERTPATH: This certificate is not for CRL signing, serial number=" + cert.getSerialNumber());
            }
            return 2001;
        }
        trustedCert = anchor.getTrustedCert();
        if (trustedCert != null) {
            if (!(trustedCert instanceof X509CertImpl)) {
                try {
                    trustedCert = new X509CertImpl(trustedCert.getEncoded());
                }
                catch (CertificateException ex) {
                    throw new CertPathValidatorException(ex.getMessage());
                }
            }
            issuer = trustedCert.getSubjectX500Principal();
            key = trustedCert.getPublicKey();
        } else {
            issuer = anchor.getCA();
            key = anchor.getCAPublicKey();
        }
        BigInteger serialNum = cert.getSerialNumber();
        ArrayList list = null;
        int result = 2001;
        boolean found = false;
        list = this.getCRLCache(issuer);
        if (list != null) {
            for (X509CRL crl : list) {
                block30: {
                    CRLReasonCodeExtension ext;
                    DerValue derValue;
                    block29: {
                        Date today;
                        Date nextUpdate = crl.getNextUpdate();
                        if (nextUpdate != null && nextUpdate.before(today = new Date())) {
                            if (debug == null) continue;
                            System.out.println("CERTPATH: We can't use this crl, nextUpdate is earlier than current time");
                            continue;
                        }
                        try {
                            crl.verify(key);
                            if (found) break block29;
                            found = true;
                        }
                        catch (Exception e) {
                            if (debug == null) continue;
                            System.out.println("CERTPATH: Unable to verify CRL signature" + e.toString() + "CRL issuer=" + crl.getIssuerDN().getName());
                            continue;
                        }
                    }
                    byte[] extValue = crl.getExtensionValue("2.5.29.28");
                    if (extValue != null) {
                        try {
                            DerValue derValue2 = new DerValue(extValue);
                            extValue = derValue2.getOctetString();
                            IssuingDistributionPointExtension ext2 = new IssuingDistributionPointExtension(extValue);
                            if (caCertificate) {
                                if (((Boolean)ext2.get("user_certs_only")).booleanValue()) {
                                    found = false;
                                    continue;
                                }
                            } else if (((Boolean)ext2.get("ca_certs_only")).booleanValue()) {
                                found = false;
                                continue;
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    X509CRLEntryImpl entry = null;
                    entry = (X509CRLEntryImpl)crl.getRevokedCertificate(serialNum);
                    if (entry != null) {
                        byte[] value = entry.getExtensionValue("2.5.29.21");
                        if (value != null) {
                            try {
                                derValue = new DerValue(value);
                                value = derValue.getOctetString();
                                ext = new CRLReasonCodeExtension(Boolean.FALSE, (Object)value);
                                int reason = (Integer)ext.get("reason");
                                result = 1000 + reason;
                            }
                            catch (IOException e) {
                                result = 2002;
                            }
                        } else {
                            result = 2002;
                        }
                        return result;
                    }
                    byte[] extVal = crl.getExtensionValue("2.5.29.27");
                    if (extVal == null) continue;
                    try {
                        derValue = new DerValue(extVal);
                        extVal = derValue.getOctetString();
                        ext = new DeltaCRLIndicatorExtension(Boolean.TRUE, (Object)extVal);
                    }
                    catch (IOException e) {
                        if (debug == null) break block30;
                        System.out.println("CERTPATH: Failed to construct DeltaCRLIndicatorExtension" + e.toString());
                    }
                }
                if (debug != null) {
                    System.out.println("CERTPATH: Delta crl: " + crl.getIssuerDN().getName());
                }
                found = false;
            }
            if (found) {
                result = 2000;
            }
            if (debug != null) {
                System.out.println("CERTPATH: Verify crl in memory cache, result=" + result);
            }
        }
        return result;
    }

    ArrayList getCRLCache(X500Principal issuer) {
        ArrayList list = null;
        list = (ArrayList)this.CRLCache.get(issuer);
        if (list == null) {
            Enumeration keys = this.CRLCache.keys();
            while (keys.hasMoreElements()) {
                X500Principal name = (X500Principal)keys.nextElement();
                if (!name.equals(issuer)) continue;
                list = (ArrayList)this.CRLCache.get(name);
                break;
            }
        }
        if (debug != null) {
            if (list == null) {
                System.out.println("CERTPATH: Inside memory cache, cannot find crl with issuer " + issuer.getName());
            } else {
                System.out.println("CERTPATH: Found crl with issuer " + issuer.getName() + " in memory cache");
            }
        }
        return list;
    }

    int processDistributionPoints(DistributionPoint[] distributionPoints, X509Certificate cert, Collection willBeTrustedCollection, Collection certStores, boolean useDeltas, Collection trustBaseSet, boolean caCertificate, Date validationDate, boolean[] userReasons, String sigProvider) throws CertPathValidatorException {
        CompositeCRL compCRL = null;
        Object reasonMask = null;
        boolean[] interimReasonMask = null;
        boolean[] dpReasons = null;
        int certificateRevocationStatus = 2000;
        boolean allreasons = false;
        for (int i = 0; i < distributionPoints.length; ++i) {
            try {
                ReasonFlags rf = distributionPoints[i].getReasons();
                if (rf == null) {
                    dpReasons = null;
                } else {
                    BitArray baRF = rf.getReasonFlags();
                    dpReasons = baRF.toBooleanArray();
                }
            }
            catch (IOException e) {
                if (debug != null) {
                    System.out.println("CERTPATH: Exception in processing distribution points" + e.toString());
                }
                throw new CertPathValidatorException("An internal error has occurred in processing the certificate.", e);
            }
            compCRL = this.getCompositeCRLFromDP(distributionPoints[i], cert, willBeTrustedCollection, certStores, useDeltas, trustBaseSet, caCertificate, validationDate, dpReasons, sigProvider);
            if (compCRL == null) continue;
            interimReasonMask = compCRL.getReasons();
            if (interimReasonMask == null || dpReasons == null) {
                allreasons = true;
            } else if (!allreasons) {
                allreasons = this.intersectReasons(interimReasonMask, dpReasons);
            }
            try {
                GeneralNames issGNs = distributionPoints[i].getIssuer();
                Principal dpCRLIssuer = CertPathUtil.findDNCRLIssuer(issGNs);
                if (!(dpCRLIssuer != null ? ((Object)dpCRLIssuer).equals(compCRL.getIssuerName()) : ((Object)cert.getIssuerDN()).equals(compCRL.getIssuerName()))) continue;
                certificateRevocationStatus = compCRL.getStatus(cert.getSerialNumber(), validationDate);
                if (certificateRevocationStatus != 2000 && certificateRevocationStatus != 2001) break;
                continue;
            }
            catch (IOException e) {
                if (debug == null) continue;
                System.out.println("CERTPATH: Error occurs when processing distribution points " + e.toString());
                continue;
            }
            catch (GeneralNamesException e) {
                if (debug == null) continue;
                System.out.println("CERTPATH: Error occurs when processing distribution points " + e.toString());
            }
        }
        if (certificateRevocationStatus == 2000 && !allreasons) {
            certificateRevocationStatus = 2001;
        }
        return certificateRevocationStatus;
    }

    CompositeCRL getCompositeCRLFromDP(DistributionPoint distributionPoint, X509Certificate cert, Collection willBeTrustedCollection, Collection certStores, boolean useDeltas, Collection trustBaseSet, boolean caCertificate, Date validationDate, boolean[] reasons, String sigProvider) throws CertPathValidatorException {
        CompositeCRL compCRL = null;
        GeneralNames issGNs = null;
        try {
            issGNs = distributionPoint.getIssuer();
        }
        catch (IOException e) {
        }
        catch (GeneralNamesException e) {
            // empty catch block
        }
        Principal crlIssuer = CertPathUtil.findDNCRLIssuer(issGNs);
        if (crlIssuer == null) {
            crlIssuer = cert.getIssuerDN();
        }
        GeneralName name = null;
        try {
            GeneralNames dpName = (GeneralNames)distributionPoint.getName();
            name = CertPathUtil.getSupportedNameObjectFromGeneralNames(dpName);
        }
        catch (IOException e) {
        }
        catch (GeneralNamesException e) {
            // empty catch block
        }
        if (name != null) {
            if (name.getType() == 6) {
                boolean trusted;
                String uriNameString = CertPathUtil.stripJunk(name.toString());
                if (debug != null) {
                    System.out.println("CERTPATH: Get a URI from distribution point: " + uriNameString);
                }
                if ((compCRL = this.getCompositeCRLByDPName(uriNameString, crlIssuer, certStores, useDeltas, willBeTrustedCollection, trustBaseSet, caCertificate, validationDate, sigProvider)) != null && !(trusted = this.isIssuerTrusted(compCRL.getIssuerCertificate(), willBeTrustedCollection, trustBaseSet, sigProvider))) {
                    compCRL = null;
                }
            } else if (name.getType() == 4) {
                String dnName = name.toString();
                compCRL = this.getCompositeCRLByIssuerName(dnName, validationDate, certStores, reasons, false, caCertificate, willBeTrustedCollection, trustBaseSet, useDeltas, sigProvider);
            }
        }
        return compCRL;
    }

    CompositeCRL getCompositeCRLByDPName(String dpName, Principal crlIssuer, Collection certStores, boolean useDeltas, Collection willBeTrustedCollection, Collection trustBaseSet, boolean caCertificate, Date validationDate, String sigProvider) throws CertPathValidatorException {
        Hashtable hashtableCompositeCRLs = null;
        hashtableCompositeCRLs = caCertificate ? CompositeCRL.CAcompositeCRLHashtable : CompositeCRL.EEcompositeCRLHashtable;
        String hashKey = dpName;
        CompositeCRL compCRL = (CompositeCRL)hashtableCompositeCRLs.get(hashKey);
        CompositeCRL[] newComposites = null;
        URLConnection conn = null;
        long lastModified = -1L;
        boolean connected = false;
        if (CertPathUtil.isHTTPURI(dpName)) {
            block43: {
                try {
                    URL url = new URL(dpName);
                    conn = url.openConnection();
                    lastModified = conn.getLastModified();
                    connected = true;
                }
                catch (MalformedURLException ex) {
                    if (debug != null) {
                        System.out.println("CERTPATH: exception thrown when trying to connect to " + dpName + ":" + ex.toString());
                    }
                }
                catch (IOException ex) {
                    if (debug == null) break block43;
                    System.out.println("CERTPATH: exception thrown when trying to connect to " + dpName + ":" + ex.toString());
                }
            }
            if (compCRL != null) {
                if (debug != null) {
                    System.out.println("CERTPATH: found a comp crl in the cache");
                }
                if (connected && lastModified != compCRL.getModifiedTime()) {
                    int result = 0;
                    if (debug != null) {
                        System.out.println("CERTPATH: current lastModified=" + lastModified + ", last lastModified=" + compCRL.getModifiedTime());
                        System.out.println("CERTPATH: refresh it");
                    }
                    if (conn instanceof HttpURLConnection) {
                        X509CRL crl = this.getCRLWithHttp((HttpURLConnection)conn);
                        if (crl != null) {
                            result = compCRL.update(crl, validationDate, sigProvider, lastModified);
                        }
                    } else {
                        throw new CertPathValidatorException("distribution point name error");
                    }
                    if (result != 1003) {
                        compCRL = null;
                    }
                } else if (compCRL.getNextUpdate().getTime() < validationDate.getTime()) {
                    compCRL = null;
                }
            } else if (connected) {
                newComposites = new CompositeCRL[2];
                X509CRL crl = this.getCRLWithHttp((HttpURLConnection)conn);
                if (crl != null) {
                    compCRL = new CompositeCRL(null);
                    compCRL.update(crl);
                    if (debug != null) {
                        System.out.println("CERTPATH: Set lastmodified=" + lastModified);
                    }
                    compCRL.setModifiedTime(lastModified);
                    X509Certificate issuerCert = null;
                    try {
                        issuerCert = CertPathUtil.findIssuerOfCRL(crl, willBeTrustedCollection, trustBaseSet, certStores, sigProvider);
                    }
                    catch (CertificateNotYetValidException e) {
                        issuerCert = null;
                    }
                    if (issuerCert == null) {
                        compCRL = null;
                    } else {
                        compCRL.setIssuerCertificate(issuerCert);
                        boolean isTrusted = this.isIssuerTrusted(issuerCert, willBeTrustedCollection, trustBaseSet, sigProvider);
                        if (isTrusted) {
                            newComposites[0] = compCRL;
                            newComposites[1] = compCRL;
                        }
                    }
                }
                if (newComposites[0] != null && caCertificate) {
                    CompositeCRL.CAcompositeCRLHashtable.put(hashKey, newComposites[0]);
                }
                if (newComposites[1] != null && !caCertificate) {
                    CompositeCRL.EEcompositeCRLHashtable.put(hashKey, newComposites[1]);
                }
                if (caCertificate) {
                    compCRL = newComposites[0];
                } else if (!caCertificate) {
                    compCRL = newComposites[1];
                }
            }
        } else if (CertPathUtil.isLDAPURI(dpName)) {
            long currenttime = System.currentTimeMillis();
            if (compCRL != null) {
                if (currenttime - compCRL.getModifiedTime() < 30000L) {
                    if (debug != null) {
                        System.out.println("CERTPATH: reuse the crl in cache within interval time");
                    }
                } else {
                    compCRL = null;
                }
            }
            if (compCRL == null) {
                if (debug != null) {
                    System.out.println("CERTPATH: fetch a crl from LDAP");
                }
                if ((newComposites = this.createCompositeCRLWithDPName(dpName, willBeTrustedCollection, certStores, sigProvider))[0] != null) {
                    if (caCertificate) {
                        CompositeCRL.CAcompositeCRLHashtable.put(hashKey, newComposites[0]);
                    } else {
                        CompositeCRL.EEcompositeCRLHashtable.put(hashKey, newComposites[0]);
                    }
                    compCRL = newComposites[0];
                    compCRL.setModifiedTime(currenttime);
                }
                if (newComposites[1] != null) {
                    if (caCertificate) {
                        CompositeCRL.CAcompositeCRLHashtable.put(hashKey, newComposites[1]);
                    } else {
                        CompositeCRL.EEcompositeCRLHashtable.put(hashKey, newComposites[1]);
                    }
                    compCRL = newComposites[1];
                    compCRL.setModifiedTime(currenttime);
                }
            }
        }
        return compCRL;
    }

    CompositeCRL[] createCompositeCRLWithDPName(String dpName, Collection willBeTrustedCollection, Collection certStores, String sigProvider) throws CertPathValidatorException {
        DirContext ctx;
        CompositeCRL[] compCRLs = new CompositeCRL[2];
        String[] stringAndName = this.getLDAPURLAndDN(dpName);
        if (stringAndName[0] != null & stringAndName[1] != null && (ctx = CertPathUtil.getDirContext(stringAndName[0])) != null) {
            X509CRLImpl[] getResults = CertPathUtil.retrieveCRLs(ctx, stringAndName[1], allCRLAttrIDArray);
            X509CRLImpl arl = getResults[0];
            X509Certificate caCert = null;
            CompositeCRL compARL = this.createOneCompositeCRL(stringAndName[1], willBeTrustedCollection, certStores, arl, caCert, sigProvider);
            X509CRLImpl crl = getResults[1];
            CompositeCRL compCRL = this.createOneCompositeCRL(stringAndName[1], willBeTrustedCollection, certStores, crl, caCert, sigProvider);
            compCRLs[0] = compARL;
            compCRLs[1] = compCRL;
            if (getResults[2] != null && compCRLs[1] != null) {
                compCRLs[1].refresh((X509CRL)getResults[2]);
            }
        }
        return compCRLs;
    }

    X509CRL getCRLWithHttp(HttpURLConnection conn) {
        X509CRL crl;
        block6: {
            crl = null;
            try {
                CertificateFactoryImpl cf = new CertificateFactoryImpl();
                InputStream is = conn.getInputStream();
                crl = (X509CRL)cf.engineGenerateCRL(is);
            }
            catch (MalformedURLException e) {
                if (debug != null) {
                    System.out.println("CERTPATH: Failed to retrieve CRL from " + conn.getURL());
                    e.printStackTrace();
                }
            }
            catch (CRLException e) {
                if (debug != null) {
                    System.out.println("CERTPATH: Failed to retrieve CRL from " + conn.getURL());
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (debug == null) break block6;
                System.out.println("CERTPATH: Failed to retrieve CRL from " + conn.getURL());
                e.printStackTrace();
            }
        }
        return crl;
    }

    CompositeCRL createOneCompositeCRL(String name, Collection willBeTrustedCollection, Collection certStores, X509CRLImpl crl, X509Certificate issuer, String sigProvider) throws CertPathValidatorException {
        X509Certificate crlIssuer = null;
        CompositeCRL newCompCRL = null;
        if (crl != null) {
            if (debug != null) {
                System.out.println("CERTPATH: CRSChecker.createOneCompositeCRL crl found");
            }
            if (issuer != null) {
                int result;
                if (!(issuer instanceof X509CertImpl)) {
                    try {
                        issuer = new X509CertImpl(issuer.getEncoded());
                    }
                    catch (CertificateException ex) {
                        throw new CertPathValidatorException(ex.getMessage());
                    }
                }
                try {
                    result = CertPathUtil.verifyCRLIssuer((X509CRL)crl, issuer.getPublicKey(), issuer.getIssuerX500Principal(), sigProvider);
                }
                catch (CertificateNotYetValidException e) {
                    result = Integer.MAX_VALUE;
                }
                if (result == 0) {
                    crlIssuer = issuer;
                }
            }
            if (crlIssuer == null) {
                if (debug != null) {
                    System.out.println("CERTPATH: crl issuer null");
                }
                try {
                    crlIssuer = CertPathUtil.findIssuerOfCRL((X509CRL)crl, willBeTrustedCollection, this.trustBaseSet, certStores, sigProvider);
                }
                catch (CertificateNotYetValidException e) {
                    if (debug != null) {
                        System.out.println("CERTPATH: CRSChecker.createOneCompositeCRL" + e.getMessage());
                    }
                    crlIssuer = null;
                }
            }
            if (crlIssuer != null) {
                if (debug != null) {
                    System.out.println("CERTPATH: componsiteCRL is created");
                }
                newCompCRL = new CompositeCRL(name);
                newCompCRL.update((X509CRL)crl);
                newCompCRL.setIssuerCertificate(crlIssuer);
            }
        }
        return newCompCRL;
    }

    int updateCompositeCRL(String dpName, CompositeCRL compCRL, boolean useDeltas, boolean caCertificate, Date validationDate, String sigProvider) throws CertPathValidatorException {
        int result = 0;
        String[] stringAndName = this.getLDAPURLAndDN(dpName);
        if (stringAndName[0] != null & stringAndName[1] != null) {
            DirContext ctx = CertPathUtil.getDirContext(stringAndName[0]);
            if (caCertificate) {
                result = this.retrieveBaseCRL(compCRL, ctx, stringAndName[1], baseARLAttrIDArray, validationDate, sigProvider);
            } else if (!caCertificate) {
                if (useDeltas) {
                    result = this.retrieveDeltaCRL(compCRL, ctx, stringAndName[1], deltaCRLAttrIDArray, validationDate, sigProvider);
                    if (result != 1001 && result != 1001) {
                        result = this.retrieveBaseCRL(compCRL, ctx, stringAndName[1], baseCRLAttrIDArray, validationDate, sigProvider);
                    }
                } else {
                    result = this.retrieveBaseCRL(compCRL, ctx, stringAndName[1], baseCRLAttrIDArray, validationDate, sigProvider);
                }
            }
        }
        return result;
    }

    CompositeCRL getCompositeCRLByIssuerName(String issuerDN, Date validationDate, Collection certStores, boolean[] reasons, boolean allReasons, boolean caCertificate, Collection willBeTrustedCollection, Collection trustBaseSet, boolean useDeltas, String sigProvider) throws CertPathValidatorException {
        CompositeCRL compCRL = this.getFirstFindFromCache(issuerDN, reasons, caCertificate);
        if (compCRL != null) {
            Object[] result = this.getStatusFromCertStores(issuerDN, caCertificate, validationDate, certStores, reasons, true, willBeTrustedCollection, trustBaseSet, useDeltas, sigProvider);
            compCRL = this.getFirstFindFromCache(issuerDN, reasons, caCertificate);
        }
        return compCRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompositeCRL getFirstFindFromCache(String issuerName, boolean[] reasons, boolean caCertificate) {
        Hashtable placeToLook = null;
        CompositeCRL compCRL = null;
        placeToLook = caCertificate ? (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(issuerName) : (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(issuerName);
        if (placeToLook != null) {
            Hashtable hashtable = placeToLook;
            synchronized (hashtable) {
                Enumeration enumeration = placeToLook.elements();
                while (enumeration.hasMoreElements() && !CertPathUtil.minimalUserReasonsSatisfied(reasons, (compCRL = (CompositeCRL)enumeration.nextElement()).getReasons())) {
                    compCRL = null;
                }
            }
        }
        return compCRL;
    }

    int processIssuerName(X509Certificate currentCert, Collection willBeTrustedCollection, Collection certStores, boolean useDeltas, Collection trustBaseSet, boolean caCertificate, Date validationDate, boolean[] userReasons, String sigProvider) throws CertPathValidatorException {
        Hashtable hashtableCompositeCRLs = null;
        String issuerDN = currentCert.getIssuerX500Principal().toString();
        int status = 2001;
        hashtableCompositeCRLs = caCertificate ? (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(issuerDN) : (Hashtable)CompositeCRL.EEcompositeCRLHashtable.get(issuerDN);
        if (hashtableCompositeCRLs != null) {
            status = this.getCRSFromCache(hashtableCompositeCRLs, validationDate, currentCert.getSerialNumber(), userReasons);
        }
        if (status == 2001) {
            Object[] result = this.getStatusFromCertStores(issuerDN, caCertificate, validationDate, certStores, userReasons, true, willBeTrustedCollection, trustBaseSet, useDeltas, sigProvider);
            hashtableCompositeCRLs = caCertificate ? (Hashtable)result[0] : (Hashtable)result[1];
            status = this.getCRSFromCache(hashtableCompositeCRLs, validationDate, currentCert.getSerialNumber(), userReasons);
        }
        return status;
    }

    int getCRSFromCache(Hashtable hashtableCompositeCRLs, Date validationDate, BigInteger serialNumber, boolean[] userReasons) throws CertPathValidatorException {
        boolean[] allCRLReasons = new boolean[]{false, false, false, false, false, false, false, false, false};
        int status = 2001;
        Enumeration enumeration = hashtableCompositeCRLs.elements();
        while (enumeration.hasMoreElements()) {
            CompositeCRL compCRL = (CompositeCRL)enumeration.nextElement();
            status = compCRL.getStatus(serialNumber, validationDate);
            if (status != 2001 && status != 2000) continue;
            CertPathUtil.unionReasons(allCRLReasons, compCRL.getReasons());
            if (!CertPathUtil.allUserReasonsSatisfied(userReasons, allCRLReasons)) continue;
            break;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getStatusFromCertStores(String issuerDN, boolean caCertificate, Date validationDate, Collection certStores, boolean[] userReasons, boolean allReasons, Collection willBeTrustedCollection, Collection trustBaseSet, boolean useDeltas, String sigProvider) throws CertPathValidatorException {
        Hashtable hashtableCACompositeCRLs = null;
        Hashtable hashtableEECompositeCRLs = null;
        Hashtable hashtable = CompositeCRL.CAcompositeCRLHashtable;
        synchronized (hashtable) {
            hashtableCACompositeCRLs = (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(issuerDN);
            if (hashtableCACompositeCRLs == null) {
                hashtableCACompositeCRLs = new Hashtable();
                CompositeCRL.CAcompositeCRLHashtable.put(issuerDN, hashtableCACompositeCRLs);
            }
        }
        hashtable = CompositeCRL.EEcompositeCRLHashtable;
        synchronized (hashtable) {
            hashtableEECompositeCRLs = (Hashtable)CompositeCRL.EEcompositeCRLHashtable.get(issuerDN);
            if (hashtableEECompositeCRLs == null) {
                hashtableEECompositeCRLs = new Hashtable();
                CompositeCRL.EEcompositeCRLHashtable.put(issuerDN, hashtableEECompositeCRLs);
            }
        }
        this.updateCachesFromCertStores(issuerDN, caCertificate, validationDate, certStores, hashtableCACompositeCRLs, hashtableEECompositeCRLs, userReasons, allReasons, willBeTrustedCollection, trustBaseSet, useDeltas, sigProvider);
        Object[] result = new Object[]{hashtableCACompositeCRLs, hashtableEECompositeCRLs};
        return result;
    }

    void updateCachesFromCertStores(String issuerDN, boolean caCertificate, Date validationDate, Collection certStores, Hashtable hashtableCACompositeCRLs, Hashtable hashtableEECompositeCRLs, boolean[] userReasons, boolean allReasons, Collection willBeTrustedCollection, Collection trustBaseSet, boolean useDeltas, String sigProvider) throws CertPathValidatorException {
        boolean[] allCRLReasons = new boolean[]{false, false, false, false, false, false, false, false, false};
        X509CRLSelector crlSelector = new X509CRLSelector();
        try {
            crlSelector.addIssuerName(issuerDN);
        }
        catch (IOException e) {
            return;
        }
        Vector<X509CRL> deltaCRLs = new Vector<X509CRL>();
        block4: for (CertStore currentCertStore : certStores) {
            Collection<? extends CRL> crls = null;
            try {
                crls = currentCertStore.getCRLs(crlSelector);
            }
            catch (CertStoreException e) {
                // empty catch block
            }
            if (crls == null) continue;
            for (X509CRL x509CRL : crls) {
                if (CompositeCRL.isDeltaCRL(x509CRL)) {
                    deltaCRLs.add(x509CRL);
                    continue;
                }
                CompositeCRL compCRL = this.createCompositeCRL(hashtableEECompositeCRLs, hashtableCACompositeCRLs, x509CRL, certStores, willBeTrustedCollection, trustBaseSet, sigProvider);
                if (compCRL == null || (!caCertificate || !compCRL.isTypeCA()) && (caCertificate || !compCRL.isTypeEE())) continue;
                CertPathUtil.unionReasons(allCRLReasons, compCRL.getReasons());
                if (allReasons) {
                    if (!CertPathUtil.allUserReasonsSatisfied(userReasons, allCRLReasons)) continue;
                    Date compNextUpdate = compCRL.getNextUpdate();
                    int compare = compNextUpdate.compareTo(validationDate);
                    if (compare > 0) break block4;
                    if (compare > 0) continue;
                }
                if (!CertPathUtil.minimalUserReasonsSatisfied(userReasons, allCRLReasons)) continue;
                break block4;
            }
        }
        Hashtable ht = caCertificate ? hashtableCACompositeCRLs : hashtableEECompositeCRLs;
        for (X509CRL deltaCRL : deltaCRLs) {
            CompositeCRL compositeCRL = (CompositeCRL)ht.get(CompositeCRL.getCRLNumber(deltaCRL));
            if (compositeCRL == null) continue;
            compositeCRL.refresh(deltaCRL);
        }
    }

    CompositeCRL createCompositeCRL(Hashtable hashtableEECompositeCRLs, Hashtable hashtableCACompositeCRLs, X509CRL crl, Collection certStores, Collection willBeTrustedCollection, Collection trustedCerts, String sigProvider) throws CertPathValidatorException {
        Object obj;
        CompositeCRL returnCompCRL = null;
        CompositeCRL compCRL = new CompositeCRL(null);
        compCRL.update(crl);
        BigInteger crlNumber = compCRL.getNumber();
        boolean updateEEList = false;
        boolean updateCAList = false;
        if (compCRL.isTypeEE() && (obj = hashtableEECompositeCRLs.get(crlNumber)) == null) {
            updateEEList = true;
        }
        if (compCRL.isTypeCA() && (obj = hashtableCACompositeCRLs.get(crlNumber)) == null) {
            updateCAList = true;
        }
        if (updateEEList || updateCAList) {
            X509Certificate issuerCert = null;
            try {
                issuerCert = CertPathUtil.findIssuerOfCRL(crl, willBeTrustedCollection, trustedCerts, certStores, sigProvider);
            }
            catch (CertificateNotYetValidException e) {
                issuerCert = null;
            }
            if (issuerCert != null) {
                compCRL.setIssuerCertificate(issuerCert);
                boolean isTrusted = this.isIssuerTrusted(issuerCert, willBeTrustedCollection, trustedCerts, sigProvider);
                returnCompCRL = compCRL;
                if (isTrusted) {
                    if (updateEEList) {
                        hashtableEECompositeCRLs.put(crlNumber, compCRL);
                    }
                    if (updateCAList) {
                        hashtableCACompositeCRLs.put(crlNumber, compCRL);
                    }
                }
            }
        }
        return returnCompCRL;
    }

    boolean isIssuerTrusted(X509Certificate cert, Collection willBeTrustedCollection, Collection trustedCerts, String sigProvider) {
        TrustAnchor issuer = null;
        boolean isTrusted = CertPathUtil.findIssuerForCRSCheck(cert, willBeTrustedCollection, sigProvider);
        if (!isTrusted) {
            try {
                issuer = CertPathUtil.findIssuer(cert, trustedCerts, sigProvider);
            }
            catch (CertPathValidatorException ex) {
                issuer = null;
            }
            if (issuer != null) {
                isTrusted = true;
            }
        }
        return isTrusted;
    }

    int retrieveBaseCRL(CompositeCRL compCRL, DirContext ctx, String name, String[] attribute, Date validationDate, String sigProvider) throws CertPathValidatorException {
        int status = 0;
        X509CRLImpl[] crl = CertPathUtil.retrieveCRLs(ctx, name, attribute);
        status = compCRL.updateBase((X509CRL)crl[0], validationDate, sigProvider);
        return status;
    }

    int retrieveDeltaCRL(CompositeCRL compCRL, DirContext ctx, String name, String[] attribute, Date validationDate, String sigProvider) throws CertPathValidatorException {
        int status = 0;
        X509CRLImpl[] crl = CertPathUtil.retrieveCRLs(ctx, name, attribute);
        status = compCRL.updateDelta((X509CRL)crl[0], validationDate, sigProvider);
        return status;
    }

    String[] getLDAPURLAndDN(String uri) {
        String[] ret;
        block12: {
            ret = new String[2];
            try {
                CompositeName cn = new CompositeName(uri);
                ret[0] = cn.get(0) + "//" + cn.get(2);
                String dnquery = cn.getSuffix(3).toString();
                int idx = dnquery.indexOf("?");
                if (idx >= 0) {
                    dnquery = dnquery.substring(0, idx);
                }
                StringBuffer result = new StringBuffer();
                if (dnquery.indexOf("%") >= 0) {
                    for (int i = 0; i < dnquery.length(); ++i) {
                        if (dnquery.charAt(i) != '%') {
                            result.append(dnquery.charAt(i));
                            continue;
                        }
                        if (i < dnquery.length() - 2) {
                            StringBuffer hex = new StringBuffer();
                            hex.append(dnquery.charAt(i + 1));
                            hex.append(dnquery.charAt(i + 2));
                            try {
                                Integer intg = Integer.valueOf(hex.toString(), 16);
                                i += 2;
                                result.append((char)intg.intValue());
                            }
                            catch (NumberFormatException ex) {
                                result.append(dnquery.charAt(i));
                            }
                            continue;
                        }
                        result.append(dnquery.charAt(i));
                    }
                    ret[1] = result.toString();
                } else {
                    ret[1] = dnquery;
                }
            }
            catch (InvalidNameException e) {
                if (debug != null) {
                    System.out.println("CERTPATH: Failed to retrieve CRL from " + uri);
                    e.printStackTrace();
                }
            }
            catch (NamingException e) {
                if (debug == null) break block12;
                System.out.println("CERTPATH: Failed to retrieve CRL from " + uri);
                e.printStackTrace();
            }
        }
        return ret;
    }

    private Collection getIBMCollectionCertStores(Collection certStores) {
        Vector<CertStore> ibmCollectionCertStores = new Vector<CertStore>();
        for (CertStore currentCertStore : certStores) {
            if (!currentCertStore.getType().equals("Collection")) continue;
            ibmCollectionCertStores.add(currentCertStore);
        }
        if (ibmCollectionCertStores.size() <= 0) {
            ibmCollectionCertStores = null;
        }
        return ibmCollectionCertStores;
    }

    /*
     * WARNING - void declaration
     */
    private Hashtable setCRLCache(Collection certStores) {
        if (!certStores.isEmpty()) {
            CertStore store = null;
            Iterator it = certStores.iterator();
            while (it.hasNext()) {
                List<? extends Certificate> certs;
                Collection<? extends CRL> result = null;
                store = (CertStore)it.next();
                if (store.getType().equals("Collection")) {
                    try {
                        result = store.getCRLs(null);
                    }
                    catch (CertStoreException e) {
                        result = null;
                    }
                } else if (store.getType().equals("LDAP") && !(certs = this.certPath.getCertificates()).isEmpty()) {
                    X509CRLSelector x509CRLSelector = new X509CRLSelector();
                    Object var7_16 = null;
                    X500Principal issuerName = null;
                    for (X509Certificate x509Certificate : certs) {
                        issuerName = x509Certificate.getIssuerX500Principal();
                        x509CRLSelector.addIssuer(issuerName);
                        if (!this.checkCRLDPEnabled()) continue;
                        try {
                            DistributionPoint[] distributionPoints = CertPathUtil.getCRLDistributionPoints(x509Certificate);
                            if (distributionPoints == null) continue;
                            for (int i = 0; i < distributionPoints.length; ++i) {
                                GeneralName name = null;
                                try {
                                    GeneralNames dpName = (GeneralNames)distributionPoints[i].getName();
                                    name = CertPathUtil.getSupportedNameObjectFromGeneralNames(dpName);
                                }
                                catch (IOException e) {
                                }
                                catch (GeneralNamesException e) {
                                    // empty catch block
                                }
                                if (name == null || name.getType() != 4) continue;
                                String dnName = name.toString();
                                X500Principal dnName2 = new X500Principal(dnName);
                                x509CRLSelector.addIssuer(dnName2);
                            }
                        }
                        catch (Exception ex) {
                        }
                    }
                    try {
                        result = store.getCRLs(x509CRLSelector);
                    }
                    catch (CertStoreException e) {
                        result = null;
                    }
                }
                if (result == null) continue;
                ArrayList<void> list = null;
                Object var6_9 = null;
                Object var7_19 = null;
                for (X509CRL x509CRL : result) {
                    void var6_13;
                    if (!(x509CRL instanceof X509CRLImpl)) {
                        try {
                            X509CRLImpl x509CRLImpl = new X509CRLImpl(x509CRL.getEncoded());
                        }
                        catch (CRLException ex) {
                            continue;
                        }
                    }
                    X500Principal x500Principal = var6_13.getIssuerX500Principal();
                    list = (ArrayList<void>)this.CRLCache.get(x500Principal);
                    if (list != null) {
                        list.add(var6_13);
                        this.CRLCache.put(x500Principal, list);
                        continue;
                    }
                    list = new ArrayList<void>();
                    list.add(var6_13);
                    this.CRLCache.put(x500Principal, list);
                }
            }
            if (debug != null) {
                System.out.println("CERTPATH: The list of CRLs in memory cache:");
                Enumeration enumeration = this.CRLCache.keys();
                while (enumeration.hasMoreElements()) {
                    Object crlkey = enumeration.nextElement();
                    ArrayList crllist = (ArrayList)this.CRLCache.get(crlkey);
                    for (int i = 0; i < crllist.size(); ++i) {
                        X509CRL x509CRL = (X509CRL)crllist.get(i);
                        System.out.println("\n" + x509CRL.getIssuerDN().getName() + ", " + x509CRL.getThisUpdate().toString());
                    }
                }
                System.out.println("End of list");
            }
        }
        return this.CRLCache;
    }

    private boolean intersectReasons(boolean[] reasons1, boolean[] reasons2) {
        int length = Math.min(reasons1.length, reasons2.length);
        for (int i = 0; i < length; ++i) {
            if (reasons1[i] != reasons2[i]) continue;
            return true;
        }
        return false;
    }

    private boolean checkCRLDPEnabled() {
        String enabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.security.enableCRLDP");
            }
        });
        return new Boolean(enabled);
    }

    void check() {
        --this.currentCertIndex;
    }
}

