/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.misc.IOUtils;
import com.ibm.security.cert.BasicOCSPResponse;
import com.ibm.security.cert.CertID;
import com.ibm.security.cert.CertStatus;
import com.ibm.security.cert.OCSPCertPathStatusUnknownException;
import com.ibm.security.cert.OCSPCertRevokedException;
import com.ibm.security.cert.OCSPException;
import com.ibm.security.cert.OCSPRequest;
import com.ibm.security.cert.OCSPResponse;
import com.ibm.security.cert.SingleRequest;
import com.ibm.security.cert.SingleResponse;
import com.ibm.security.x509.AccessDescription;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCSPChecker
extends PKIXCertPathChecker {
    public static final String OCSP_ENABLE = "ocsp.enable";
    public static final String OCSP_URL = "ocsp.responderURL";
    public static final String OCSP_CERT_SUBJECT = "ocsp.responderCertSubjectName";
    public static final String OCSP_CERT_ISSUER = "ocsp.responderCertIssuerName";
    public static final String OCSP_CERT_SERIAL_NUMBER = "ocsp.responderCertSerialNumber";
    private URL responderURL;
    private String responderIssuerName;
    private String responderSubjectName;
    private BigInteger responderSerialNumber;
    private CertPath certPath;
    private int remainingCerts;
    private Set<TrustAnchor> trustAnchors;
    private List<CertStore> certStores;
    private static final Debug debug = Debug.getInstance((String)"certpath");

    public OCSPChecker(String respURL, String respSubjectName, CertPath certPath, PKIXParameters params) throws CertPathValidatorException {
        block9: {
            try {
                this.responderURL = new URL(respURL);
            }
            catch (MalformedURLException muex) {
                this.responderURL = null;
                if (debug == null) break block9;
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  The following MalformedURLException was thrown while processing the OCSP responder URL:");
                System.out.println(muex.getMessage());
            }
        }
        try {
            this.responderSubjectName = respSubjectName != null ? new X500Name(respSubjectName).getRFC2253Name() : null;
        }
        catch (IOException ex) {
            this.responderSubjectName = null;
        }
        if (debug != null) {
            if (respURL == null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  respURL IS NULL");
            } else {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  respURL = " + respURL);
            }
            if (this.responderSubjectName == null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  responderSubjectName IS NULL");
            } else {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  responderSubjectName = " + this.responderSubjectName);
            }
        }
        this.certPath = certPath;
        this.trustAnchors = params.getTrustAnchors();
        this.certStores = params.getCertStores();
    }

    public OCSPChecker(String respURL, String respIssuerName, BigInteger respSerialNum, CertPath certPath, PKIXParameters params) throws CertPathValidatorException {
        block9: {
            try {
                this.responderURL = new URL(respURL);
            }
            catch (MalformedURLException muex) {
                this.responderURL = null;
                if (debug == null) break block9;
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  The following MalformedURLException was thrown while processing the OCSP responder URL:");
                System.out.println(muex.getMessage());
            }
        }
        try {
            this.responderIssuerName = new X500Name(respIssuerName).getRFC2253Name();
        }
        catch (IOException ex) {
            throw new CertPathValidatorException(ex);
        }
        this.responderSerialNumber = respSerialNum;
        if (debug != null) {
            if (respURL == null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  respURL IS NULL");
            } else {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  respURL = " + respURL);
            }
            if (this.responderSubjectName == null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  responderSubjectName IS NULL");
            } else {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  responderSubjectName = " + this.responderSubjectName);
            }
            System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  responderSerialNumber = " + this.responderSerialNumber);
        }
        this.certPath = certPath;
        this.trustAnchors = params.getTrustAnchors();
        this.certStores = params.getCertStores();
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
        this.remainingCerts = this.certPath.getCertificates().size();
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    public Set getSupportedExtensions() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        TrustAnchor responderTa = null;
        List<? extends Certificate> certList = this.certPath.getCertificates();
        X509Certificate[] cts = new X509Certificate[certList.size()];
        certList.toArray(cts);
        if (debug != null) {
            System.out.println("CERTPATH:  OCSPChecker.java:  check():  The array of certificates being checked is:");
            for (int ii = 0; ii < cts.length; ++ii) {
                System.out.println(cts[ii].toString() + "\n\n");
            }
        }
        if (this.responderSubjectName != null ? (responderTa = this.getResponderTA(this.responderSubjectName, cts)) == null : this.responderIssuerName != null && this.responderSerialNumber != null && (responderTa = this.getResponderTA(this.responderSerialNumber, this.responderIssuerName, cts)) == null) {
            throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
        }
        if (debug != null) {
            if (responderTa == null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  check():  The responderTa IS NULL.");
            } else {
                System.out.println("CERTPATH:  OCSPChecker.java:  check():  The responderTa is:  \n" + responderTa.toString());
            }
        }
        this.internalCheck(cts, responderTa);
    }

    private TrustAnchor getResponderTA(String sn, X509Certificate[] certs) throws CertPathValidatorException {
        for (TrustAnchor temp : this.trustAnchors) {
            String ca = temp.getCAName();
            if (ca != null) {
                if (!ca.equals(sn)) continue;
                return temp;
            }
            X509Certificate ct = temp.getTrustedCert();
            if (!(ct instanceof X509CertImpl ? ((X500Name)((X509CertImpl)ct).getSubjectDN()).getRFC2253Name().equals(sn) : ct.getSubjectX500Principal().getName("RFC2253").equals(sn))) continue;
            return new TrustAnchor(ct, null);
        }
        if (certs != null) {
            for (int i = 0; i < certs.length; ++i) {
                if (!(certs[i] instanceof X509CertImpl ? ((X500Name)((X509CertImpl)certs[i]).getSubjectDN()).getRFC2253Name().equals(sn) : certs[i].getSubjectX500Principal().getName("RFC2253").equals(sn))) continue;
                return new TrustAnchor(certs[i], null);
            }
        }
        Iterator<Object> it = this.certStores.iterator();
        X509CertSelector selector = new X509CertSelector();
        try {
            selector.setSubject(sn);
            if (debug != null) {
                System.out.println("CERTPATH, get responder cert using selector-" + selector);
            }
            while (it.hasNext()) {
                CertStore cs = (CertStore)it.next();
                Iterator<? extends Certificate> temp = cs.getCertificates(selector).iterator();
                if (!temp.hasNext()) continue;
                return new TrustAnchor((X509Certificate)temp.next(), null);
            }
        }
        catch (IOException ex) {
            throw new CertPathValidatorException(ex);
        }
        catch (CertStoreException ex) {
            throw new CertPathValidatorException(ex);
        }
        return null;
    }

    private TrustAnchor getResponderTA(BigInteger serialNum, String issuerName, X509Certificate[] certs) throws CertPathValidatorException {
        for (TrustAnchor temp : this.trustAnchors) {
            X509Certificate ct = temp.getTrustedCert();
            if (!(ct instanceof X509CertImpl ? ((X500Name)((X509CertImpl)ct).getIssuerDN()).getRFC2253Name().equals(issuerName) && ct.getSerialNumber().equals(serialNum) : ct.getIssuerX500Principal().getName("RFC2253").equals(issuerName) && ct.getSerialNumber().equals(serialNum))) continue;
            return new TrustAnchor(ct, null);
        }
        if (certs != null) {
            for (int i = 0; i < certs.length; ++i) {
                if (!(certs[i] instanceof X509CertImpl ? ((X500Name)((X509CertImpl)certs[i]).getIssuerDN()).getRFC2253Name().equals(issuerName) && certs[i].getSerialNumber().equals(serialNum) : certs[i].getIssuerX500Principal().getName("RFC2253").equals(issuerName) && certs[i].getSerialNumber().equals(serialNum))) continue;
                return new TrustAnchor(certs[i], null);
            }
        }
        Iterator<Object> it = this.certStores.iterator();
        X509CertSelector selector = new X509CertSelector();
        selector.setSerialNumber(serialNum);
        try {
            selector.setIssuer(issuerName);
            if (debug != null) {
                System.out.println("CERTPATH: get responder cert using selector -" + selector.toString());
            }
            while (it.hasNext()) {
                CertStore cs = (CertStore)it.next();
                Iterator<? extends Certificate> temp = cs.getCertificates(selector).iterator();
                if (!temp.hasNext()) continue;
                return new TrustAnchor((X509Certificate)temp.next(), null);
            }
        }
        catch (IOException ex) {
            throw new CertPathValidatorException(ex);
        }
        catch (CertStoreException ex) {
            throw new CertPathValidatorException(ex);
        }
        return null;
    }

    private void internalCheck(X509Certificate[] certs, TrustAnchor responderTa) throws CertPathValidatorException {
        CertID[] ids = new CertID[certs.length];
        for (int i = certs.length - 1; i >= 0; --i) {
            if (i == certs.length - 1) {
                TrustAnchor ta = this.getTrustAnchor(certs[i], this.trustAnchors);
                if (ta == null) {
                    throw new CertPathValidatorException("Unable to find the issuer cert");
                }
                X509Certificate trustedCert = ta.getTrustedCert();
                ids[i] = trustedCert != null ? new CertID(trustedCert, certs[i]) : new CertID(ta.getCAName(), ta.getCAPublicKey(), certs[i].getSerialNumber(), null);
            } else {
                ids[i] = new CertID(certs[i + 1], certs[i]);
            }
            if (debug == null) continue;
            System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  CertID[" + i + "] is:  " + ids[i].toString());
        }
        SingleRequest[] reqs = new SingleRequest[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            reqs[i] = new SingleRequest(ids[i], null);
            if (debug == null) continue;
            System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  SingleRequest[" + i + "] is:  " + reqs[i].toString() + "\n\n");
        }
        CertStatus[] st = new CertStatus[ids.length];
        if (this.responderURL != null) {
            HttpURLConnection con = null;
            try {
                con = (HttpURLConnection)this.responderURL.openConnection();
            }
            catch (IOException ex) {
                throw new CertPathValidatorException(ex);
            }
            OCSPRequest request = new OCSPRequest(reqs);
            try {
                this.sendRequest(con, request.encode());
            }
            catch (IOException ex) {
                if (debug != null) {
                    ex.printStackTrace();
                }
                throw new CertPathValidatorException(ex);
            }
            st = this.checkResponse(con, ids, responderTa);
        } else {
            if (debug != null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  The responderURL IS NOT defined in the SYSTEM PROPERTIES, therefore, we need to learn it from each cert.");
                System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  Begin the process of building and sending an OCSPRequest for 'each' certificate in the chain.");
            }
            for (int i = 0; i < certs.length; ++i) {
                try {
                    X509CertImpl impl;
                    if (!(certs[i] instanceof X509CertImpl)) {
                        try {
                            impl = new X509CertImpl(certs[i].getEncoded());
                        }
                        catch (CertificateException ex) {
                            throw new CertPathValidatorException(ex);
                        }
                    } else {
                        impl = (X509CertImpl)certs[i];
                    }
                    if (debug != null) {
                        System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  Beginning OCSP processing for the following SINGLE cert:");
                        System.out.println(impl.toString());
                    }
                    responderTa = this.getTrustedCert(certs[i], this.certStores);
                    Set c = null;
                    c = impl.getAuthorityInformationAccess();
                    URL url = null;
                    for (AccessDescription ad : c) {
                        GeneralName gn;
                        if (!ad.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (gn = ad.getAccessLocation()).getType() != 6) continue;
                        try {
                            URIName uri = (URIName)gn.getName();
                            url = new URL(uri.getName());
                        }
                        catch (MalformedURLException ex) {
                            if (debug == null) continue;
                            ex.printStackTrace();
                        }
                    }
                    if (debug != null) {
                        if (url == null) {
                            System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  No OCSP responder URL was found in the cert.");
                        } else {
                            System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  An OCSP responder URL 'WAS FOUND' in the cert.");
                            System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  The OCSP responder URL learned from the AIA extension is:  " + url.toString());
                        }
                    }
                    if (url == null) {
                        throw new IOException("Can't get the responder URL");
                    }
                    HttpURLConnection con = null;
                    con = (HttpURLConnection)url.openConnection();
                    OCSPRequest request = new OCSPRequest(new SingleRequest[]{reqs[i]});
                    this.sendRequest(con, request.encode());
                    CertStatus[] temp = new CertStatus[]{this.checkResponse(con, new CertID[]{ids[i]}, responderTa)[0]};
                    if (temp[0] != null && temp[0].getStatus() == 1) {
                        throw new CertPathValidatorException("certificate is revoked", new OCSPCertRevokedException(this.certPath, i));
                    }
                    st[i] = temp[0];
                    continue;
                }
                catch (CertificateException ex) {
                    if (debug != null) {
                        System.out.println("CERTPATH: internal error 1 , " + ex.getMessage());
                    }
                    st[i] = null;
                    continue;
                }
                catch (IOException ex) {
                    if (debug != null) {
                        System.out.println("CERTPATH: internal error 2, " + ex.getMessage());
                    }
                    st[i] = null;
                    continue;
                }
                catch (CertPathValidatorException ex) {
                    if (debug != null) {
                        System.out.println("CERTPATH: internal error 3, " + ex.getMessage());
                    }
                    st[i] = null;
                }
            }
        }
        block21: for (int i = 0; i < st.length; ++i) {
            if (st[i] == null) {
                if (debug != null) {
                    System.out.println("CERTPATH: error getting cert status for certificate, serial number is " + certs[i].getSerialNumber() + ", subject is " + certs[i].getSubjectDN().getName());
                }
                throw new CertPathValidatorException("certificate status undetermined", new OCSPCertPathStatusUnknownException(st, certs, this.certPath));
            }
            switch (st[i].getStatus()) {
                case 2: {
                    if (debug != null) {
                        System.out.println("CERTPATH: cert status is " + st[i].toString() + " for certificate serial number " + certs[i].getSerialNumber() + ", subject is " + certs[i].getSubjectDN().getName());
                    }
                    throw new CertPathValidatorException("certificate status unknown", new OCSPCertPathStatusUnknownException(st, certs, this.certPath));
                }
                case 1: {
                    if (debug != null) {
                        System.out.println("CERTPATH: cert status is  " + st[i].toString() + " for certificate " + certs[i].getSerialNumber() + ", subject is " + certs[i].getSubjectDN().getName());
                    }
                    throw new CertPathValidatorException("certificate is revoked", new OCSPCertRevokedException(this.certPath, i));
                }
                case 0: {
                    if (debug == null) continue block21;
                    System.out.println("CERTPATH: cert status is " + st[i].toString() + " for certificate " + certs[i].getSerialNumber() + ", subject is " + certs[i].getSubjectDN().getName());
                }
            }
        }
    }

    private CertStatus[] checkResponse(HttpURLConnection con, CertID[] ids, TrustAnchor responderTa) throws CertPathValidatorException {
        byte[] response;
        block28: {
            block27: {
                if (debug != null) {
                    try {
                        if (con.getResponseCode() != 200) {
                            throw new CertPathValidatorException("Received HTTP error: " + con.getResponseCode() + " - " + con.getResponseMessage());
                        }
                    }
                    catch (IOException ex) {
                        if (debug == null) break block27;
                        ex.printStackTrace();
                    }
                }
            }
            InputStream in = null;
            try {
                in = con.getInputStream();
            }
            catch (IOException ex) {
                throw new CertPathValidatorException(ex);
            }
            int length = con.getContentLength();
            response = null;
            try {
                response = IOUtils.readFully((InputStream)in, (int)length, (boolean)false);
                in.close();
            }
            catch (IOException ex) {
                if (debug == null) break block28;
                ex.printStackTrace();
            }
        }
        OCSPResponse ocspResponse = null;
        try {
            ocspResponse = new OCSPResponse(response);
        }
        catch (IOException ex) {
            throw new CertPathValidatorException(ex);
        }
        if (ocspResponse.getResponseStatus().getStatus() != 0) {
            throw (CertPathValidatorException)new CertPathValidatorException("Unsuccessful OCSP response").initCause(new OCSPException(OCSPException.setResponseErrorMsg(ocspResponse.getResponseStatus().getStatus())));
        }
        BasicOCSPResponse bresp = null;
        byte[] responseData = ocspResponse.getResponseData();
        if (responseData != null) {
            try {
                if (debug != null) {
                    System.out.println("Get response type: " + ocspResponse.getResponseType());
                }
                bresp = new BasicOCSPResponse(ocspResponse.getResponseData());
            }
            catch (IOException ex) {
                if (debug != null) {
                    ex.printStackTrace();
                }
                throw new CertPathValidatorException(ex);
            }
        } else {
            throw new CertPathValidatorException("No data was found in the OCSPResponse");
        }
        HashSet<TrustAnchor> tas = new HashSet<TrustAnchor>();
        if (responderTa == null) {
            for (int i = 0; i < ids.length; ++i) {
                TrustAnchor ta = new TrustAnchor(ids[i].getIssuerName(), ids[i].getIssuerPublicKey(), null);
                if (tas.contains(ta)) continue;
                tas.add(ta);
            }
        } else {
            tas.add(responderTa);
        }
        try {
            bresp.verify(tas);
        }
        catch (OCSPException ex) {
            if (debug != null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  checkOCSPResponse():  The following exception was thrown while trying to verify the BasicOCSPResponse:");
                System.out.println(ex.toString());
                ex.printStackTrace();
            }
            throw new CertPathValidatorException(ex);
        }
        CertStatus[] st = new CertStatus[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            SingleResponse singleResp = bresp.getSingleResponse(ids[i]);
            if (singleResp == null) {
                st[i] = null;
                continue;
            }
            Date thisUpdate = singleResp.getThisUpdate();
            Date today = new Date();
            Date nextUpdate = singleResp.getNextUpdate();
            if (nextUpdate != null && nextUpdate.before(today)) {
                st[i] = null;
            }
            if (thisUpdate.after(today)) {
                st[i] = null;
            }
            st[i] = singleResp.getCertStatus();
        }
        return st;
    }

    private void sendRequest(HttpURLConnection con, byte[] request) throws IOException {
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-type", "application/ocsp-request");
        con.setRequestProperty("Content-length", String.valueOf(request));
        OutputStream out = con.getOutputStream();
        out.write(request);
        out.flush();
        out.close();
    }

    private TrustAnchor getTrustedCert(X509Certificate cert, List certStores) {
        Iterator it = certStores.iterator();
        X500Principal issuer = cert.getIssuerX500Principal();
        while (it.hasNext()) {
            X509Certificate temp;
            block7: {
                Iterator<? extends Certificate> it2;
                CertStore store = (CertStore)it.next();
                X509CertSelector selector = new X509CertSelector();
                try {
                    selector.setSubject(issuer.getName("RFC2253"));
                }
                catch (IOException ex) {
                    if (debug == null) continue;
                    System.out.println(ex.getMessage());
                    continue;
                }
                Collection<? extends Certificate> certs = null;
                try {
                    certs = store.getCertificates(selector);
                }
                catch (CertStoreException ex) {
                    if (debug == null) continue;
                    System.out.println(ex.getMessage());
                    continue;
                }
                if (certs.size() <= 0 || !(it2 = certs.iterator()).hasNext()) continue;
                temp = (X509Certificate)it2.next();
                try {
                    cert.verify(temp.getPublicKey());
                }
                catch (Exception ex) {
                    if (debug == null) break block7;
                    System.out.println("CERTPATH: can not verify the signature" + ex.getMessage());
                }
            }
            return new TrustAnchor(temp, null);
        }
        return null;
    }

    private TrustAnchor getTrustAnchor(X509Certificate cert, Set trustAnchors) {
        Iterator it = trustAnchors.iterator();
        X500Principal issuer = cert.getIssuerX500Principal();
        while (it.hasNext()) {
            TrustAnchor ta = (TrustAnchor)it.next();
            X509Certificate trustedCert = ta.getTrustedCert();
            if (trustedCert != null) {
                X500Principal subject = trustedCert.getSubjectX500Principal();
                if (!subject.equals(issuer)) continue;
                return ta;
            }
            String caName = ta.getCAName();
            PublicKey key = ta.getCAPublicKey();
            if (!caName.equals(issuer.getName("RFC2253"))) continue;
            try {
                cert.verify(key);
            }
            catch (Exception ex) {
                if (debug == null) continue;
                System.out.println("CERTPATH: try to find the trust anchor of the cert chain " + ex.getMessage());
                continue;
            }
            return ta;
        }
        if (debug != null) {
            System.out.println("CERTPATH: failed to find the trust anchor");
        }
        return null;
    }
}

