/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

class OCSPResponseStatus {
    private int status;
    public static final int SUCCESS = 0;
    public static final int MALFORMEDREQUEST = 1;
    public static final int INTERNALERROR = 2;
    public static final int TRYLATER = 3;
    public static final int SIGREQUIRED = 5;
    public static final int UNAUTHORIZED = 6;

    public OCSPResponseStatus(int code) {
        this.status = code;
    }

    public OCSPResponseStatus(DerValue der) throws IOException {
        this.status = der.getEnumerated().intValue();
    }

    public OCSPResponseStatus(byte[] data) throws IOException {
        this(new DerValue(data));
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] encode() throws IOException {
        DerOutputStream dos = new DerOutputStream();
        dos.putEnumerated(BigInteger.valueOf(this.status));
        return dos.toByteArray();
    }

    public String getStatusAsString() {
        switch (this.status) {
            case 0: {
                return "success";
            }
            case 1: {
                return "malformed request";
            }
            case 2: {
                return "internal error";
            }
            case 3: {
                return "try later";
            }
            case 5: {
                return "signature required";
            }
            case 6: {
                return "unauthorized";
            }
        }
        return "invalid status";
    }
}

