/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.BasicChecker;
import com.ibm.security.cert.CRSChecker;
import com.ibm.security.cert.CertStatus;
import com.ibm.security.cert.NameChecker;
import com.ibm.security.cert.OCSPCertPathStatusUnknownException;
import com.ibm.security.cert.OCSPCertRevokedException;
import com.ibm.security.cert.OCSPChecker;
import com.ibm.security.cert.PolicyChecker;
import com.ibm.security.cert.PolicyTree;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PKIXCertPathValidatorImpl
extends CertPathValidatorSpi {
    private static final Debug debug = Debug.getInstance((String)"certpath");

    public CertPathValidatorResult engineValidate(CertPath cp, CertPathParameters param) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        int i;
        X509Certificate targetCert;
        if (cp == null || param == null) {
            throw new CertPathValidatorException("both certpath and certpath parameters can not be null", new NullPointerException());
        }
        PKIXCertPathValidatorResult result = null;
        int policy_mapping = 0;
        int inhibit_any_policy = 0;
        int explicit_policy = 0;
        HashSet<String> user_initial_policy_set = null;
        boolean policyQualifiersRejected = true;
        List<? extends Certificate> certPathCerts = cp.getCertificates();
        int numberOfCertsInCertPath = certPathCerts.size();
        PKIXParameters pkixParam = null;
        CertSelector certSelector = null;
        Set<TrustAnchor> trustBaseSet = null;
        Date validationDate = null;
        List<CertStore> certStoreList = null;
        boolean revocationEnabled = true;
        List<PKIXCertPathChecker> certPathCheckers = null;
        String sigProvider = null;
        if (!cp.getType().equals("X.509") && !cp.getType().equals("X509")) {
            throw new InvalidAlgorithmParameterException("inappropriate certification path type specified, must be X.509 or X509");
        }
        if (param instanceof PKIXParameters) {
            pkixParam = (PKIXParameters)param;
            user_initial_policy_set = new HashSet<String>(pkixParam.getInitialPolicies());
            if (user_initial_policy_set.isEmpty()) {
                user_initial_policy_set.add("2.5.29.32.0");
            }
            trustBaseSet = pkixParam.getTrustAnchors();
            certSelector = pkixParam.getTargetCertConstraints();
            revocationEnabled = pkixParam.isRevocationEnabled();
            policy_mapping = pkixParam.isPolicyMappingInhibited() ? 0 : numberOfCertsInCertPath + 1;
            inhibit_any_policy = pkixParam.isAnyPolicyInhibited() ? 0 : numberOfCertsInCertPath + 1;
            explicit_policy = pkixParam.isExplicitPolicyRequired() ? 0 : numberOfCertsInCertPath + 1;
            validationDate = pkixParam.getDate();
            if (validationDate == null) {
                validationDate = new Date();
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameter type unsupported - " + param.getClass().getName());
        }
        certStoreList = pkixParam.getCertStores();
        certPathCheckers = pkixParam.getCertPathCheckers();
        policyQualifiersRejected = pkixParam.getPolicyQualifiersRejected();
        sigProvider = pkixParam.getSigProvider();
        if (certSelector != null && certPathCerts.size() > 0 && !certSelector.match(targetCert = (X509Certificate)certPathCerts.get(0))) {
            throw new CertPathValidatorException("Certain certificate select criteria don't match", null, cp, numberOfCertsInCertPath);
        }
        BasicChecker basicChecker = new BasicChecker(cp, trustBaseSet, validationDate, sigProvider);
        CRSChecker crsChecker = null;
        OCSPChecker ocspChecker = null;
        if (revocationEnabled) {
            if (debug != null) {
                System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  Revocation checking is enabled");
            }
            crsChecker = new CRSChecker(cp, certStoreList, true, false, trustBaseSet, validationDate, true, sigProvider);
            String[] ocspProperties = this.getOCSPProperties();
            if (debug != null) {
                System.out.println("CERTPATH: OCSP properties-");
                System.out.println("          ocsp.enable=" + ocspProperties[0]);
                System.out.println("          ocsp.responderURL=" + ocspProperties[1]);
                System.out.println("          ocsp.responderCertSubjectName=" + ocspProperties[2]);
                System.out.println("          ocsp.responderCertIssuerName=" + ocspProperties[3]);
                System.out.println("          ocsp.responderCertSerialNumber=" + ocspProperties[4]);
            }
            if (ocspProperties[0] != null && ocspProperties[0].equalsIgnoreCase("true")) {
                if (ocspProperties[2] != null) {
                    ocspChecker = new OCSPChecker(ocspProperties[1], ocspProperties[2], cp, pkixParam);
                } else if (ocspProperties[3] != null && ocspProperties[4] != null) {
                    String HEX_DIGITS = "0123456789ABCDEFabcdef";
                    StringBuffer sb = new StringBuffer();
                    for (i = 0; i < ocspProperties[4].length(); ++i) {
                        if (HEX_DIGITS.indexOf(ocspProperties[4].charAt(i)) <= -1) continue;
                        sb.append(ocspProperties[4].charAt(i));
                    }
                    if (debug != null) {
                        System.out.println("CERTPATH: get serial number of responder certificate=" + sb.toString());
                    }
                    ocspChecker = new OCSPChecker(ocspProperties[1], ocspProperties[3], new BigInteger(sb.toString(), 16), cp, pkixParam);
                } else {
                    if (debug != null) {
                        System.out.println("\n\n\n==============================================================================");
                        System.out.println("CERTPATH:  PKIXCertPathValidator.java:  engineValidate():  REVOCATION CHECKING IS ENABLED");
                        System.out.println("CERTPATH:  PKIXCertPathValidator.java:  engineValidate():  OCSP IS ENABLED");
                        System.out.println("CERTPATH:  PKIXCertPathValidator.java:  engineValidate():  NO RESPONDER'S CERT SUBJECT NAME IS SPECIFIED");
                        System.out.println("CERTPATH:  PKIXCertPathValidator.java:  engineValidate():  NO RESPONDER'S CERT ISSUER AND RESPONDER'S CERT SERIAL IS SPECIFIED");
                        System.out.println("CERTPATH:  PKIXCertPathValidator.java:  engineValidate():  CREATING OCSPChecker WITH NULL RESPONDER URL AND NULL RESPONDER SUBJECT NAME\n\n");
                        System.out.println("==============================================================================\n\n\n");
                    }
                    ocspChecker = new OCSPChecker(null, null, cp, pkixParam);
                }
            }
        }
        PolicyChecker policyChecker = new PolicyChecker(cp, pkixParam.getPolicyQualifiersRejected(), user_initial_policy_set, explicit_policy, policy_mapping, inhibit_any_policy);
        NameChecker nameChecker = new NameChecker(cp, sigProvider);
        if (numberOfCertsInCertPath == 0) {
            Iterator<TrustAnchor> it = trustBaseSet.iterator();
            TrustAnchor ta = it.next();
            PublicKey pk = ta.getCAPublicKey();
            if (pk == null) {
                pk = ta.getTrustedCert().getPublicKey();
            }
            result = new PKIXCertPathValidatorResult(ta, policyChecker.getPolicyTree().getRoot(), pk);
            return result;
        }
        basicChecker.init(false);
        if (revocationEnabled) {
            crsChecker.init(false);
        }
        if (ocspChecker != null) {
            ocspChecker.init(false);
        }
        policyChecker.init(false);
        nameChecker.init(false);
        PKIXCertPathValidatorImpl.initCheckers(certPathCheckers);
        X509Extension currentCert = null;
        for (i = numberOfCertsInCertPath - 1; i >= 0; --i) {
            currentCert = (X509Certificate)certPathCerts.get(i);
            Set<String> unresolvedCriticalExtensions = currentCert.getCriticalExtensionOIDs();
            if (unresolvedCriticalExtensions == null) {
                unresolvedCriticalExtensions = new HashSet<String>();
            }
            basicChecker.check((Certificate)((Object)currentCert), unresolvedCriticalExtensions);
            if (revocationEnabled && ocspChecker == null) {
                crsChecker.check((Certificate)((Object)currentCert), unresolvedCriticalExtensions);
            }
            policyChecker.check((Certificate)((Object)currentCert), unresolvedCriticalExtensions);
            nameChecker.check((Certificate)((Object)currentCert), unresolvedCriticalExtensions);
            PKIXCertPathValidatorImpl.moreChecks((X509Certificate)currentCert, certPathCheckers, unresolvedCriticalExtensions);
            if (unresolvedCriticalExtensions.isEmpty()) continue;
            StringBuffer sb = new StringBuffer();
            Iterator<String> iter = unresolvedCriticalExtensions.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
            }
            throw new CertPathValidatorException(" The following critical extensions were not processed: " + sb, null, cp, i);
        }
        if (ocspChecker != null) {
            Set<String> unresolvedCriticalExtensions = currentCert.getCriticalExtensionOIDs();
            try {
                if (debug != null) {
                    System.out.println("CERTPATH: PKIXCertPathValidatorImpl.java:  engineValidate():  Invoking OCSPChecker.check() to check ENTIRE cert chain");
                }
                ocspChecker.check(null, unresolvedCriticalExtensions);
            }
            catch (CertPathValidatorException ex) {
                Throwable throwable;
                if (debug != null) {
                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  OCSPChecker.check() threw a CertPathValidatorException.");
                    System.out.println("                                                               This means that the revocation status returned for one or more certs");
                    System.out.println("                                                               in the cert chain was REVOKED, or UNKNOWN, or NULL.");
                    System.out.println(ex.toString());
                    ex.printStackTrace();
                }
                if ((throwable = ex.getCause()) != null) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  The CertPathValidator exception contains an embedded exception.");
                    }
                    if (throwable instanceof OCSPCertRevokedException) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  The embedded exception represents an OCSPCertRevokedException.  Just rethrow it.");
                        }
                        throw ex;
                    }
                    if (throwable instanceof OCSPCertPathStatusUnknownException) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  The embedded exception represents an OCSPCertPathStatusUnknownException.  Recheck each cert with a NULL or UNKNOWN status.");
                        }
                        this.recheck(((OCSPCertPathStatusUnknownException)throwable).getStatuses(), ((OCSPCertPathStatusUnknownException)throwable).getCertificates(), crsChecker, certPathCerts);
                    } else if (debug != null) {
                        System.out.println("CERTPATH:  PKIXCertPathValidator.java:  engineValidate():  The embedded exception represents an unspecified throwable object.  Rechecking ALL certs with CRSchecker.");
                    }
                    this.recheck(crsChecker, certPathCerts);
                }
                if (debug != null) {
                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  There is no embedded exception.  Rechecking ALL certs with CRSChecker.");
                }
                this.recheck(crsChecker, certPathCerts);
            }
        }
        PublicKey pKey = ((Certificate)((Object)currentCert)).getPublicKey();
        TrustAnchor anchor = basicChecker.getTrustAnchor();
        PolicyTree tree = policyChecker.getPolicyTree();
        PolicyNode node = null;
        if (tree.isValid()) {
            node = tree.getRoot();
        }
        result = new PKIXCertPathValidatorResult(anchor, node, pKey);
        return result;
    }

    private void recheck(CRSChecker checker, List certPathCerts) throws CertPathValidatorException {
        X509Certificate currentCert = null;
        int numberOfCertsInCertPath = certPathCerts.size();
        for (int i = numberOfCertsInCertPath - 1; i >= 0; --i) {
            currentCert = (X509Certificate)certPathCerts.get(i);
            checker.check(currentCert, null);
        }
    }

    private void recheck(CertStatus[] statuses, X509Certificate[] certs, CRSChecker checker, List certPathCerts) throws CertPathValidatorException {
        int i;
        int numberOfCertsInCertPath = certPathCerts.size();
        if (debug != null) {
            System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  recheck():  Rechecking ALL certs with NULL or UNKNOWN statuses with CRSChecker.check()");
            System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  recheck():  Before doing anything, dump the OCSP revocation status for each cert.");
            for (i = numberOfCertsInCertPath - 1; i >= 0; --i) {
                if (statuses[i] == null) {
                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  recheck():  st[" + i + "] is NULL for cert " + ((X509Certificate)certPathCerts.get(i)).getSubjectDN().getName());
                    continue;
                }
                if (statuses[i].getStatus() == 2) {
                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  recheck():  st[" + i + "] is UNKNOWN for cert " + ((X509Certificate)certPathCerts.get(i)).getSubjectDN().getName());
                    continue;
                }
                if (statuses[i].getStatus() == 1) {
                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  recheck():  st[" + i + "] is REVOKED for cert " + ((X509Certificate)certPathCerts.get(i)).getSubjectDN().getName());
                    continue;
                }
                if (statuses[i].getStatus() != 0) continue;
                System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  recheck():  st[" + i + "] is GOOD for cert " + ((X509Certificate)certPathCerts.get(i)).getSubjectDN().getName());
            }
            System.out.println("CERTPATH:  PKIXCertPathValidator.java:  recheck():  Call CRSChecker.check() for each cert with an OCSP revocation status of UNKNOWN or NULL.");
            System.out.println("                                                    Note:  If CRSWChecker.check() thorws an exception, it isn't caught.");
        }
        for (i = numberOfCertsInCertPath - 1; i >= 0; --i) {
            if (statuses[i] == null || statuses[i].getStatus() == 2) {
                checker.check((X509Certificate)certPathCerts.get(i), null);
                continue;
            }
            checker.check();
        }
    }

    static void initCheckers(Collection certPathCheckers) throws CertPathValidatorException {
        for (PKIXCertPathChecker pcpc : certPathCheckers) {
            pcpc.init(false);
        }
    }

    static void moreChecks(X509Certificate cert, List certPathCheckers, Collection unresolvedCriticalExtensions) throws CertPathValidatorException {
        for (PKIXCertPathChecker pcpc : certPathCheckers) {
            pcpc.check(cert, unresolvedCriticalExtensions);
        }
    }

    private String[] getOCSPProperties() {
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] result = new String[5];
                result[0] = Security.getProperty("ocsp.enable");
                if (result[0] != null && result[0].equalsIgnoreCase("true")) {
                    result[1] = Security.getProperty("ocsp.responderURL");
                    result[2] = Security.getProperty("ocsp.responderCertSubjectName");
                    result[3] = Security.getProperty("ocsp.responderCertIssuerName");
                    result[4] = Security.getProperty("ocsp.responderCertSerialNumber");
                }
                return result;
            }
        });
    }
}

