/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.PolicyNodeImpl;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.security.cert.PolicyNode;
import java.util.ArrayList;
import java.util.HashSet;

public class PolicyTree {
    private ArrayList nodes;
    private boolean valid;
    private int depth;

    public PolicyTree() {
        this.init();
    }

    private void init() {
        ObjectIdentifier oid = null;
        try {
            oid = new ObjectIdentifier("2.5.29.32.0");
        }
        catch (IOException ex) {
            // empty catch block
        }
        HashSet<String> set = new HashSet<String>();
        set.add(oid.toString());
        PolicyNodeImpl root = new PolicyNodeImpl(oid, new HashSet(), false, set, null);
        this.nodes = new ArrayList();
        ArrayList<PolicyNodeImpl> collection = new ArrayList<PolicyNodeImpl>();
        collection.add(root);
        this.nodes.add(root.getDepth(), collection);
        this.valid = true;
        this.depth = 0;
    }

    public ArrayList getNodes(int d) {
        if (this.depth >= d) {
            return (ArrayList)this.nodes.get(d);
        }
        return null;
    }

    public PolicyNode getRoot() {
        return (PolicyNode)this.getNodes(0).get(0);
    }

    public void addNode(PolicyNodeImpl n) {
        int d = n.getDepth();
        if (this.depth >= d) {
            this.getNodes(d).add(n);
        } else {
            ArrayList<PolicyNodeImpl> alist = new ArrayList<PolicyNodeImpl>();
            alist.add(n);
            this.nodes.add(d, alist);
            this.depth = d;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean indicator) {
        this.valid = indicator;
        if (!this.valid) {
            this.nodes = null;
        }
    }

    public void remove(PolicyNode n) {
        int d = n.getDepth();
        this.getNodes(d).remove(n);
        if (this.getNodes(d).isEmpty()) {
            this.depth = d - 1;
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public void print() {
        for (int i = 0; i < this.getDepth() + 1; ++i) {
            ArrayList alist = this.getNodes(i);
            System.out.println("tree level: " + i);
            for (int j = 0; j < alist.size(); ++j) {
                ((PolicyNodeImpl)alist.get(j)).print();
            }
        }
    }
}

