/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;

public class ResponderID {
    private X500Name issuerName;
    private byte[] keyHash;

    public ResponderID(String name) throws IOException {
        this.issuerName = new X500Name(name);
    }

    public ResponderID(X500Name name) {
        this.issuerName = name;
    }

    public ResponderID(PublicKey pubKey) throws IOException {
        byte[] data = pubKey.getEncoded();
        if (data == null) {
            throw new IOException("The key does not support encoding.");
        }
        MessageDigest sha1 = null;
        this.keyHash = new byte[20];
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
        sha1.update(data);
        this.keyHash = sha1.digest();
    }

    public ResponderID(byte[] encodedData) throws IOException {
        this(new DerValue(encodedData));
    }

    public ResponderID(DerValue der) throws IOException {
        int tag = der.getTag() & 0x1F;
        switch (tag) {
            case 1: {
                this.issuerName = new X500Name(der.getData());
                break;
            }
            case 2: {
                this.keyHash = der.getData().toByteArray();
                break;
            }
            default: {
                throw new IOException("Invalid tag");
            }
        }
    }

    public byte[] encode() throws IOException {
        DerValue der = null;
        if (this.issuerName != null) {
            byte[] name = this.issuerName.getEncoded();
            der = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), name);
        } else if (this.keyHash != null) {
            der = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.keyHash);
        }
        if (der != null) {
            return der.toByteArray();
        }
        return null;
    }

    public X500Name getName() {
        return this.issuerName;
    }

    public byte[] getKeyHash() {
        return this.keyHash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ResponderID:[\n");
        if (this.issuerName != null) {
            sb.append(this.issuerName.toString() + "]");
        } else if (this.keyHash != null) {
            sb.append(new HexDumpEncoder().encode(this.keyHash));
        }
        return sb.toString();
    }
}

