/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertID;
import com.ibm.security.cert.CertStatus;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.Extension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleResponse {
    private CertID certId;
    private CertStatus certStatus;
    private Date thisUpdate;
    private Date nextUpdate;
    private List<Extension> extensions;
    private static final Debug debug = Debug.getInstance((String)"certpath");

    public SingleResponse(CertID certId, CertStatus status, Date thisUpdate, Date nextUpdate, List<Extension> exts) {
        if (certId == null) {
            throw new NullPointerException("CertID can not be null");
        }
        if (status == null) {
            throw new NullPointerException("CertStatus can not be null");
        }
        if (thisUpdate == null) {
            throw new NullPointerException("thisUpdate can not be null");
        }
        this.certId = certId;
        this.certStatus = status;
        this.thisUpdate = thisUpdate;
        this.nextUpdate = nextUpdate;
        this.extensions = exts;
    }

    public SingleResponse(byte[] encodedData) throws IOException {
        DerInputStream dis = new DerInputStream(encodedData);
        DerValue[] ders = dis.getSequence(3);
        if (ders.length < 3) {
            throw new IOException("encoded data do not contain all required data fields");
        }
        this.certId = new CertID(ders[0]);
        this.certStatus = new CertStatus(ders[1]);
        this.thisUpdate = ders[2].getGeneralizedTime();
        if (ders.length > 3) {
            block4: for (int i = 3; i < ders.length; ++i) {
                int tag = ders[i].getTag() & 0x1F;
                switch (tag) {
                    case 0: {
                        this.nextUpdate = ders[i].getData().getGeneralizedTime();
                        continue block4;
                    }
                    case 1: {
                        DerInputStream temp = ders[i].getData();
                        DerValue[] values = temp.getSequence(1);
                        this.extensions = new ArrayList<Extension>();
                        for (int j = 0; j < values.length; ++j) {
                            this.extensions.add(new Extension(values[j]));
                        }
                        continue block4;
                    }
                    default: {
                        throw new IOException("invalid tag");
                    }
                }
            }
        }
    }

    public SingleResponse(DerValue der) throws IOException {
        this(der.toByteArray());
    }

    public CertID getCertID() {
        return this.certId;
    }

    public CertStatus getCertStatus() {
        return this.certStatus;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public Extension getExtension(String oidstring) {
        ObjectIdentifier oid = null;
        try {
            oid = new ObjectIdentifier(oidstring);
        }
        catch (IOException ex) {
            if (debug != null) {
                System.out.println("unable to construct OID");
                ex.printStackTrace();
            }
            return null;
        }
        for (Extension ext : this.extensions) {
            if (!ext.getExtensionId().equals(oid)) continue;
            return ext;
        }
        return null;
    }

    public List getExtensions() {
        return this.extensions;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SingleResponse:[\n");
        sb.append(this.certId.toString());
        sb.append(this.certStatus.toString() + "\n");
        sb.append("  thisUpdate: " + this.thisUpdate.toString() + "\n");
        if (this.nextUpdate != null) {
            sb.append("  nextUpdate: " + this.nextUpdate.toString() + "\n");
        }
        if (this.extensions != null) {
            Iterator<Extension> it = this.extensions.iterator();
            sb.append("  extensions:[\n");
            while (it.hasNext()) {
                sb.append(it.next().toString());
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public byte[] encode() throws IOException {
        ArrayList<DerValue> alist = new ArrayList<DerValue>();
        byte[] temp = this.certId.encode();
        alist.add(new DerValue(temp));
        alist.add(new DerValue(this.certStatus.encode()));
        DerOutputStream dos = new DerOutputStream();
        dos.putGeneralizedTime(this.thisUpdate);
        alist.add(new DerValue(dos.toByteArray()));
        if (this.nextUpdate != null) {
            dos = new DerOutputStream();
            dos.putGeneralizedTime(this.nextUpdate);
            DerValue der3 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), dos.toByteArray());
            alist.add(der3);
        }
        if (this.extensions != null) {
            DerValue[] ders = new DerValue[this.extensions.size()];
            Iterator<Extension> it = this.extensions.iterator();
            int count = 0;
            while (it.hasNext()) {
                Extension ext = it.next();
                dos = new DerOutputStream();
                ext.encode(dos);
                ders[count] = new DerValue(dos.toByteArray());
                ++count;
            }
            dos = new DerOutputStream();
            dos.putSequence(ders);
            DerValue der4 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), dos.toByteArray());
            alist.add(der4);
        }
        DerValue[] values = new DerValue[alist.size()];
        alist.toArray(values);
        dos = new DerOutputStream();
        dos.putSequence(values);
        return dos.toByteArray();
    }
}

