/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class X509CertificatePair {
    private X509Certificate forward;
    private X509Certificate reverse;
    public static final int VALID_STATUS = 0;
    public static final int INVALID_STATUS = 1;
    public static final int UNDETERMINED_STATUS = 2;

    public X509CertificatePair(byte[] data) throws CertificateException {
        try {
            this.decode(data);
        }
        catch (IOException ex) {
            throw new CertificateException(ex.getMessage());
        }
        if (this.validate() == 1) {
            throw new CertificateException("Invalid certificate pair");
        }
    }

    public X509CertificatePair(X509Certificate cert1, X509Certificate cert2) throws CertificateException {
        if (cert1 == null && cert2 == null) {
            throw new CertificateException("At least one certificate can not be null");
        }
        if (cert1 != null) {
            this.forward = new X509CertImpl(cert1.getEncoded());
        }
        if (cert2 != null) {
            this.reverse = new X509CertImpl(cert2.getEncoded());
        }
        if (this.validate() == 1) {
            throw new CertificateException("Invalid certificate pair");
        }
    }

    private void decode(byte[] data) throws IOException, CertificateException {
        DerInputStream dis = new DerInputStream(data);
        DerValue[] ders = dis.getSequence(2);
        if (ders.length > 0) {
            block4: for (int i = 0; i < ders.length; ++i) {
                int tag = ders[i].getTag() & 0x1F;
                switch (tag) {
                    case 0: {
                        this.forward = new X509CertImpl(ders[i].getData().getDerValue());
                        continue block4;
                    }
                    case 1: {
                        this.reverse = new X509CertImpl(ders[i].getData().getDerValue());
                        continue block4;
                    }
                    default: {
                        throw new IOException("Invalid tag number");
                    }
                }
            }
        }
    }

    public byte[] encode() throws IOException {
        ArrayList<DerValue> list = new ArrayList<DerValue>();
        DerValue der = null;
        if (this.forward != null) {
            try {
                der = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.forward.getEncoded());
            }
            catch (CertificateException ex) {
                throw new IOException(ex.getMessage());
            }
            list.add(der);
        }
        if (this.reverse != null) {
            try {
                der = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.reverse.getEncoded());
            }
            catch (CertificateException ex) {
                throw new IOException(ex.getMessage());
            }
            list.add(der);
        }
        DerValue[] ders = new DerValue[list.size()];
        list.toArray(ders);
        DerOutputStream dos = new DerOutputStream();
        dos.putSequence(ders);
        return dos.toByteArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("X509CertificatePair: [\n forward certificate: ");
        if (this.forward != null) {
            sb.append(this.forward);
        } else {
            sb.append("null");
        }
        sb.append("\n reverse certificate: ");
        if (this.reverse != null) {
            sb.append(this.reverse);
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public X509Certificate getForward() {
        if (this.forward != null) {
            return this.forward;
        }
        return null;
    }

    public X509Certificate getReverse() {
        if (this.reverse != null) {
            return this.reverse;
        }
        return null;
    }

    int validate() {
        int status = 2;
        if (this.forward != null && this.reverse != null) {
            if (!((Object)this.forward.getIssuerDN()).equals(this.reverse.getSubjectDN())) {
                return 1;
            }
            if (!((Object)this.forward.getSubjectDN()).equals(this.reverse.getIssuerDN())) {
                return 1;
            }
            status = this.verifySig(this.forward.getPublicKey(), this.reverse);
            if (status == 0) {
                status = this.verifySig(this.reverse.getPublicKey(), this.forward);
            }
            return status;
        }
        return 0;
    }

    private int verifySig(PublicKey key, X509Certificate cert) {
        try {
            cert.verify(key);
            return 0;
        }
        catch (NoSuchAlgorithmException ex) {
            try {
                cert.verify(key, "IBMJCE");
                return 0;
            }
            catch (NoSuchAlgorithmException ex2) {
                return 2;
            }
            catch (NoSuchProviderException ex2) {
                return 2;
            }
            catch (Exception ex2) {
                return 1;
            }
        }
        catch (Exception ex) {
            return 1;
        }
    }
}

