/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.CMSLoadParameter;
import com.ibm.security.cmskeystore.CMSStoreParameter;
import java.io.File;
import java.security.KeyStore;

public final class CMSLoadStoreParameterFactory {
    public static final KeyStore.LoadStoreParameter newCMSLoadParameter(File ksFile, KeyStore.ProtectionParameter protection) {
        return new CMSLoadParameterImpl(ksFile, protection);
    }

    public static final KeyStore.LoadStoreParameter newCMSStoreParameter(File ksFile, KeyStore.ProtectionParameter protection, boolean stashPassword) {
        return new CMSStoreParameterImpl(ksFile, protection, stashPassword);
    }

    public static final KeyStore.LoadStoreParameter newCMSStoreParameter(File ksFile, KeyStore.ProtectionParameter protection, boolean stashPassword, int passwordExpiry) {
        return new CMSStoreParameterImpl(ksFile, protection, stashPassword, passwordExpiry);
    }

    private CMSLoadStoreParameterFactory() {
    }

    private static final class CMSStoreParameterImpl
    implements CMSStoreParameter {
        private File keyStoreFile = null;
        private KeyStore.ProtectionParameter protection = null;
        boolean stashPassword = false;
        private int passwordExpiry = 0;

        CMSStoreParameterImpl(File kdbFile, KeyStore.ProtectionParameter protection, boolean stashPassword) {
            this.keyStoreFile = kdbFile;
            this.protection = protection;
            this.stashPassword = stashPassword;
        }

        private CMSStoreParameterImpl() {
            throw new UnsupportedOperationException();
        }

        CMSStoreParameterImpl(File kdbFile, KeyStore.ProtectionParameter protection, boolean stashPassword, int passwordExpiry) {
            this(kdbFile, protection, stashPassword);
            this.passwordExpiry = passwordExpiry;
        }

        public File getKeyStoreFile() {
            return this.keyStoreFile;
        }

        public boolean isStashPassword() {
            return this.stashPassword;
        }

        public KeyStore.ProtectionParameter getProtectionParameter() {
            return this.protection;
        }

        public int getPasswordExpiry() {
            return this.passwordExpiry;
        }

        public void setPasswordExpiry(int passwordExpiry) {
            throw new RuntimeException("Setting the password expiry of a CMS Store Parameter is not allowed.");
        }
    }

    private static final class CMSLoadParameterImpl
    implements CMSLoadParameter {
        private File keyStoreFile = null;
        private KeyStore.ProtectionParameter protection = null;
        private int passwordExpiry = 0;

        CMSLoadParameterImpl(File kdbFile, KeyStore.ProtectionParameter protection) {
            this.keyStoreFile = kdbFile;
            if (protection == null) {
                throw new NullPointerException("ProtectionParameter should not be null when loading CMS KeyStore.");
            }
            this.protection = protection;
        }

        private CMSLoadParameterImpl() {
            throw new UnsupportedOperationException();
        }

        public File getKeyStoreFile() {
            return this.keyStoreFile;
        }

        public KeyStore.ProtectionParameter getProtectionParameter() {
            return this.protection;
        }

        public int getPasswordExpiry() {
            return this.passwordExpiry;
        }

        public void setPasswordExpiry(int passwordExpiry) {
            this.passwordExpiry = passwordExpiry;
        }
    }
}

