/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import java.security.InvalidParameterException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

public class NonPrintableAsciiPBEKey
implements SecretKey {
    private byte[] keyData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NonPrintableAsciiPBEKey(KeySpec spec) {
        char[] password = null;
        try {
            if (!(spec instanceof PBEKeySpec)) {
                throw new InvalidParameterException("spec must be PBEKeySpec");
            }
            PBEKeySpec pbeSpec = (PBEKeySpec)spec;
            password = pbeSpec.getPassword();
            if (password == null || password.length == 0) {
                throw new InvalidParameterException("password is null or empty");
            }
            this.keyData = new byte[password.length];
            for (int i = 0; i < password.length; ++i) {
                if (password[i] >= '\u0080') {
                    Arrays.fill(this.keyData, (byte)0);
                    throw new InvalidParameterException("password is not ASCII");
                }
                this.keyData[i] = (byte)password[i];
            }
            if (password == null) return;
        }
        catch (Throwable throwable) {
            if (password == null) throw throwable;
            Arrays.fill(password, ' ');
            throw throwable;
        }
        Arrays.fill(password, ' ');
    }

    public String getAlgorithm() {
        return "PBE";
    }

    public byte[] getEncoded() {
        return this.keyData;
    }

    public String getFormat() {
        return "RAW";
    }
}

