/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.IntableByteSequence;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.cmskeystore.NonPrintableAsciiEncryptDecrypt;
import com.ibm.security.cmskeystore.RecordEncoding;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

final class RecordEncodingFactory {
    private static final byte[] NON_DEFAULT_KEY_FLAGS = new byte[]{7, -128};
    private static final byte[] DEFAULT_KEY_FLAGS = new byte[]{6, -64};
    private static final byte[] UNTRUSTED_CERT_FLAGS = new byte[]{7, 0};
    private static final byte[] TRUSTED_CERT_FLAGS = new byte[]{7, -128};

    private RecordEncodingFactory() {
        throw new UnsupportedOperationException();
    }

    public static RecordEncoding newRecordEncoding(Buffer buffer) throws IOException {
        return new RecordEncodingImpl(buffer);
    }

    public static RecordEncoding newRecordEncoding(int id, Certificate certificate, String alias, boolean trusted) throws CertificateEncodingException, IOException {
        byte[] encodedCert = certificate.getEncoded();
        DerOutputStream trustedRec = new DerOutputStream();
        trustedRec.putInteger(id);
        trustedRec.putTag((byte)-128, true, (byte)1);
        trustedRec.putLength(encodedCert.length);
        trustedRec.write(encodedCert);
        trustedRec.putVisibleString(alias);
        trustedRec.write(3);
        trustedRec.putLength(2);
        trustedRec.write(trusted ? TRUSTED_CERT_FLAGS : UNTRUSTED_CERT_FLAGS);
        DerOutputStream envelope = new DerOutputStream();
        envelope.write((byte)48, trustedRec);
        return new RecordEncodingImpl(IntableByteSequenceFactory.newIntableByteSequence(envelope.size()), ByteSequenceFactory.newByteSequence(envelope.toByteArray()));
    }

    public static RecordEncoding newKeyRecordEncoding(int id, Certificate certificate, PrivateKey key, char[] password, String alias, boolean isDefault) throws IOException, PKCSException, CertificateEncodingException, NoSuchAlgorithmException {
        byte[] encryptedKey;
        if (RecordEncodingFactory.isPrintable(password)) {
            PrivateKeyInfo info = new PrivateKeyInfo(key.getEncoded());
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(password, info, "MD2", "DES");
            encryptedKey = epki.encode();
        } else {
            encryptedKey = NonPrintableAsciiEncryptDecrypt.encrypt(password, key, AlgorithmId.get((String)"PBEWithMD2AndDES"));
        }
        DerOutputStream keyCertInfo = new DerOutputStream();
        keyCertInfo.putSequence(new DerValue[]{new DerValue(certificate.getEncoded()), new DerValue(encryptedKey)});
        byte[] keyCertInfoData = keyCertInfo.toByteArray();
        DerOutputStream keyRec = new DerOutputStream();
        keyRec.putInteger(id);
        keyRec.putTag((byte)-128, true, (byte)2);
        keyRec.putLength(keyCertInfoData.length);
        keyRec.write(keyCertInfoData);
        keyRec.putVisibleString(alias);
        keyRec.write(3);
        keyRec.putLength(2);
        keyRec.write(isDefault ? DEFAULT_KEY_FLAGS : NON_DEFAULT_KEY_FLAGS);
        DerOutputStream envelope = new DerOutputStream();
        envelope.write((byte)48, keyRec);
        return new RecordEncodingImpl(IntableByteSequenceFactory.newIntableByteSequence(envelope.size()), ByteSequenceFactory.newByteSequence(envelope.toByteArray()));
    }

    private static boolean isPrintable(char[] chars) {
        for (char c : chars) {
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    private static final class RecordEncodingImpl
    implements RecordEncoding {
        private final IntableByteSequence header;
        private final ByteSequence content;
        private DerValue recordID;
        private DerValue info;
        private DerValue alias;
        private DerValue recordFlags;
        private final ByteSequence sequence;

        private void initDerValues() throws IOException {
            byte[] contentBytes = new byte[this.header.toInt()];
            this.content.getInputStream().read(contentBytes);
            DerInputStream input = new DerInputStream(contentBytes);
            DerValue[] values = input.getSequence(4);
            if (values.length != 4) {
                throw new RuntimeException("Bad Record data.");
            }
            this.recordID = values[0];
            this.info = values[1];
            this.alias = values[2];
            this.recordFlags = values[3];
        }

        RecordEncodingImpl(Buffer buffer) throws IOException {
            this.header = buffer.getHeader();
            this.content = buffer.getContent();
            this.sequence = buffer;
            this.initDerValues();
        }

        RecordEncodingImpl(IntableByteSequence header, ByteSequence content) throws IOException {
            this.header = header;
            this.content = content;
            this.sequence = header.append(content);
            this.initDerValues();
        }

        public Certificate getCertificate() throws CertificateException, IOException {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            if (this.info.getTag() == -95) {
                return factory.generateCertificate(new ByteArrayInputStream(this.info.getDataBytes()));
            }
            if (this.info.getTag() == -94) {
                DerValue[] values = new DerInputStream(this.info.getDataBytes()).getSequence(2);
                if (values.length != 2) {
                    throw new RuntimeException("Bad record encoding.");
                }
                return factory.generateCertificate(new ByteArrayInputStream(values[0].toByteArray()));
            }
            return null;
        }

        public PrivateKey getPrivateKey(char[] password) throws IOException, PKCSException {
            byte[] privateKeyInfoBytes;
            if (!this.isPrivateKeyPresent()) {
                return null;
            }
            DerValue[] values = new DerInputStream(this.info.getDataBytes()).getSequence(2);
            if (values.length != 2) {
                throw new RuntimeException("Bad record encoding.");
            }
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(values[1].toByteArray());
            if (!RecordEncodingFactory.isPrintable(password)) {
                AlgorithmId tempId = epki.getAlgorithmId();
                if (tempId.getOID().equals(new ObjectIdentifier("1.2.840.113549.1.12.5.1.3"))) {
                    tempId = new AlgorithmId(new ObjectIdentifier("1.2.840.113549.1.12.1.3"), tempId.getEncodedParams());
                    tempId = new AlgorithmId(new ObjectIdentifier("1.2.840.113549.1.12.5.1.3"), tempId.getAlgParameters());
                }
                privateKeyInfoBytes = NonPrintableAsciiEncryptDecrypt.decrypt(epki.getEncryptedData(), password, tempId);
            } else {
                privateKeyInfoBytes = epki.decrypt(password);
            }
            return PrivateKeyInfo.parseKey((DerValue)new DerValue(privateKeyInfoBytes));
        }

        public boolean isDefaultKey() throws IOException {
            if (!this.isPrivateKeyPresent()) {
                return false;
            }
            this.recordFlags.reset();
            byte[] flag = this.recordFlags.getBitString();
            if (flag.length != 1) {
                throw new RuntimeException("Bad record encoding.");
            }
            return (flag[0] & 0x40) == 64;
        }

        public boolean isTrusted() throws IOException {
            this.recordFlags.reset();
            byte[] flag = this.recordFlags.getBitString();
            if (flag.length != 1) {
                throw new RuntimeException("Bad record encoding.");
            }
            return (flag[0] & 0xFFFFFF80) == -128;
        }

        public boolean isPrivateKeyPresent() {
            return this.info.getTag() == -94;
        }

        public IntableByteSequence getHeader() {
            return this.header;
        }

        public ByteSequence getContent() {
            return this.content;
        }

        public byte get(int index) throws IndexOutOfBoundsException {
            return this.sequence.get(index);
        }

        public int length() {
            return this.sequence.length();
        }

        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            return this.sequence.append(sequence);
        }

        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            return this.sequence.getSubSequence(fromPosition, toPosition);
        }

        public int indexOf(byte b) {
            return this.sequence.indexOf(b);
        }

        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            return this.sequence.indexOf(position, b);
        }

        public int lastIndexOf(byte b) {
            return this.sequence.lastIndexOf(b);
        }

        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            return this.sequence.lastIndexOf(position, b);
        }

        public boolean isEmpty() {
            return this.sequence.isEmpty();
        }

        public InputStream getInputStream() {
            return this.sequence.getInputStream();
        }

        public ByteSequenceIterator getIterator() {
            return this.sequence.getIterator();
        }

        public ByteSequenceIterator getIterator(int position) throws IndexOutOfBoundsException {
            return this.sequence.getIterator(position);
        }

        public String toBinaryString() {
            return this.sequence.toBinaryString();
        }

        public String toOctalString() {
            return this.sequence.toOctalString();
        }

        public String toHexString() {
            return this.sequence.toHexString();
        }

        public boolean equals(Object o) {
            return ((Object)this.sequence).equals(o);
        }

        public int hashCode() {
            return ((Object)this.sequence).hashCode();
        }

        public String toString() {
            return ((Object)this.sequence).toString();
        }
    }
}

