/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sequence.bytes;

import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.NoSuchElementException;

public final class ByteSequenceFactory {
    private static final char ZERO_PAD = '0';
    private static final int HEXADECIMAL_LENGTH = 2;
    private static final int OCTAL_LENGTH = 3;
    private static final int BINARY_LENGTH = 8;

    private ByteSequenceFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static ByteSequence newByteSequence(byte ... bytes) throws NullPointerException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        return new ArrayByteSequence(bytes);
    }

    public static ByteSequence newConstantByteSequence(byte constant, int length) throws IllegalArgumentException {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        return new ConstantByteSequence(constant, length);
    }

    private static final class ConstantByteSequence
    implements ByteSequence {
        private static final long serialVersionUID = 2L;
        private final byte constant;
        private final int length;
        private int hc;
        private boolean hcCalculated;
        private String ts;

        ConstantByteSequence(byte constant, int length) {
            this.constant = constant;
            this.length = length;
        }

        public byte get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.length) {
                throw new IndexOutOfBoundsException();
            }
            return this.constant;
        }

        public int length() {
            return this.length;
        }

        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (sequence.length() == 0) {
                return this;
            }
            return new CompositeByteSequence(this, sequence);
        }

        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.length || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return new ByteSubSequence(this, fromPosition, toPosition);
        }

        public int indexOf(byte b) {
            return b == this.constant ? 0 : -1;
        }

        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.length) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            ByteSequenceIterator it = this.getIterator(position);
            while (it.hasNextByte()) {
                int itPosition = it.getPosition();
                byte x = it.getNextByte();
                if (x != b) continue;
                return itPosition;
            }
            return -1;
        }

        public int lastIndexOf(byte b) {
            return b == this.constant ? this.length - 1 : -1;
        }

        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.length) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            ByteSequenceIterator it = this.getIterator(position);
            while (it.hasPreviousByte()) {
                byte x = it.getPreviousByte();
                int itPosition = it.getPosition();
                if (x != b) continue;
                return itPosition;
            }
            return -1;
        }

        public boolean isEmpty() {
            return false;
        }

        public InputStream getInputStream() {
            return new InputStream(){
                private int index;

                public int available() {
                    return ConstantByteSequence.this.length - this.index;
                }

                public int read() {
                    if (this.index >= ConstantByteSequence.this.length) {
                        return -1;
                    }
                    ++this.index;
                    return ConstantByteSequence.this.constant;
                }
            };
        }

        public ByteSequenceIterator getIterator() {
            return this.getIterator(0);
        }

        public ByteSequenceIterator getIterator(final int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.length) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return new ByteSequenceIterator(){
                private int pos;
                {
                    this.pos = position;
                }

                public boolean hasNextByte() {
                    return this.pos != ConstantByteSequence.this.length;
                }

                public byte getNextByte() throws NoSuchElementException {
                    if (this.pos == ConstantByteSequence.this.length) {
                        throw new NoSuchElementException();
                    }
                    ++this.pos;
                    return ConstantByteSequence.this.constant;
                }

                public boolean hasPreviousByte() {
                    return this.pos != 0;
                }

                public byte getPreviousByte() throws NoSuchElementException {
                    if (this.pos == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.pos;
                    return ConstantByteSequence.this.constant;
                }

                public int getPosition() {
                    return this.pos;
                }
            };
        }

        public String toBinaryString() {
            StringBuilder sb = new StringBuilder();
            ByteSequenceIterator it = this.getIterator();
            while (it.hasNextByte()) {
                int i = it.getNextByte();
                if (i < 0) {
                    i += 256;
                }
                String s = Integer.toBinaryString(i);
                for (int j = 0; j < 8 - s.length(); ++j) {
                    sb.append('0');
                }
                sb.append(s);
            }
            return sb.toString();
        }

        public String toOctalString() {
            StringBuilder sb = new StringBuilder();
            ByteSequenceIterator it = this.getIterator();
            while (it.hasNextByte()) {
                int i = it.getNextByte();
                if (i < 0) {
                    i += 256;
                }
                String s = Integer.toOctalString(i);
                for (int j = 0; j < 3 - s.length(); ++j) {
                    sb.append('0');
                }
                sb.append(s);
            }
            return sb.toString();
        }

        public String toHexString() {
            StringBuilder sb = new StringBuilder();
            ByteSequenceIterator it = this.getIterator();
            while (it.hasNextByte()) {
                int i = it.getNextByte();
                if (i < 0) {
                    i += 256;
                }
                String s = Integer.toHexString(i);
                for (int j = 0; j < 2 - s.length(); ++j) {
                    sb.append('0');
                }
                sb.append(s);
            }
            return sb.toString();
        }

        public String toString() {
            if (this.ts == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                for (int i = 0; i < this.length; ++i) {
                    sb.append(this.constant);
                    if (i == this.length - 1) continue;
                    sb.append("][");
                }
                sb.append("]");
                this.ts = sb.toString();
            }
            return this.ts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ByteSequence)) {
                return false;
            }
            ByteSequence s = (ByteSequence)o;
            return s.length() == this.length && s.get(0) == this.constant;
        }

        public int hashCode() {
            if (!this.hcCalculated) {
                int oddPrime = 461;
                int result = 73;
                result = result * 461 + this.constant;
                this.hc = result = result * 461 + this.length;
                this.hcCalculated = true;
            }
            return this.hc;
        }
    }

    private static final class ByteSubSequence
    implements ByteSequence {
        private static final long serialVersionUID = 2L;
        private final ByteSequence sequence;
        private final int fromPosition;
        private final int toPosition;
        private int hc;
        private boolean hcCalculated;
        private String ts;

        ByteSubSequence(ByteSequence sequence, int fromPosition, int toPosition) {
            this.sequence = sequence;
            this.fromPosition = fromPosition;
            this.toPosition = toPosition;
        }

        public byte get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.toPosition - this.fromPosition) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.get(index + this.fromPosition);
        }

        public int length() {
            return this.toPosition - this.fromPosition;
        }

        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (this.toPosition - this.fromPosition == 0) {
                return sequence;
            }
            if (sequence.length() == 0) {
                return this;
            }
            return new CompositeByteSequence(this, sequence);
        }

        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.toPosition - this.fromPosition || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return new ByteSubSequence(this, fromPosition, toPosition);
        }

        public int indexOf(byte b) {
            for (int i = this.fromPosition; i < this.toPosition; ++i) {
                byte x = this.sequence.get(i);
                if (x != b) continue;
                return i - this.fromPosition;
            }
            return -1;
        }

        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.toPosition - this.fromPosition) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            ByteSequenceIterator it = this.getIterator(position);
            while (it.hasNextByte()) {
                int itPosition = it.getPosition();
                byte x = it.getNextByte();
                if (x != b) continue;
                return itPosition;
            }
            return -1;
        }

        public int lastIndexOf(byte b) {
            for (int i = this.toPosition - 1; i >= this.fromPosition; --i) {
                byte x = this.sequence.get(i);
                if (x != b) continue;
                return i - this.fromPosition;
            }
            return -1;
        }

        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.toPosition - this.fromPosition) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            ByteSequenceIterator it = this.getIterator(position);
            while (it.hasPreviousByte()) {
                byte x = it.getPreviousByte();
                int itPosition = it.getPosition();
                if (x != b) continue;
                return itPosition;
            }
            return -1;
        }

        public boolean isEmpty() {
            return this.toPosition - this.fromPosition == 0;
        }

        public InputStream getInputStream() {
            return new InputStream(){
                private final ByteSequenceIterator i;
                private final int len;
                private int index;
                {
                    this.i = ByteSubSequence.this.getIterator();
                    this.len = ByteSubSequence.this.toPosition - ByteSubSequence.this.fromPosition;
                }

                public int available() {
                    return this.len - this.index;
                }

                public int read() {
                    if (!this.i.hasNextByte()) {
                        return -1;
                    }
                    ++this.index;
                    int b = this.i.getNextByte();
                    if (b < 0) {
                        b += 256;
                    }
                    return b;
                }
            };
        }

        public ByteSequenceIterator getIterator() {
            return this.getIterator(0);
        }

        public ByteSequenceIterator getIterator(final int position) throws IndexOutOfBoundsException {
            final int len = this.toPosition - this.fromPosition;
            if (position < 0 || position > len) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return new ByteSequenceIterator(){
                private int pos;
                {
                    this.pos = position;
                }

                public boolean hasNextByte() {
                    return this.pos != len;
                }

                public byte getNextByte() throws NoSuchElementException {
                    if (this.pos == len) {
                        throw new NoSuchElementException();
                    }
                    return ByteSubSequence.this.sequence.get(ByteSubSequence.this.fromPosition + this.pos++);
                }

                public boolean hasPreviousByte() {
                    return this.pos != 0;
                }

                public byte getPreviousByte() throws NoSuchElementException {
                    if (this.pos == 0) {
                        throw new NoSuchElementException();
                    }
                    return ByteSubSequence.this.sequence.get(ByteSubSequence.this.fromPosition + --this.pos);
                }

                public int getPosition() {
                    return this.pos;
                }
            };
        }

        public String toBinaryString() {
            StringBuilder sb = new StringBuilder();
            ByteSequenceIterator it = this.getIterator();
            while (it.hasNextByte()) {
                int i = it.getNextByte();
                if (i < 0) {
                    i += 256;
                }
                String s = Integer.toBinaryString(i);
                for (int j = 0; j < 8 - s.length(); ++j) {
                    sb.append('0');
                }
                sb.append(s);
            }
            return sb.toString();
        }

        public String toOctalString() {
            StringBuilder sb = new StringBuilder();
            ByteSequenceIterator it = this.getIterator();
            while (it.hasNextByte()) {
                int i = it.getNextByte();
                if (i < 0) {
                    i += 256;
                }
                String s = Integer.toOctalString(i);
                for (int j = 0; j < 3 - s.length(); ++j) {
                    sb.append('0');
                }
                sb.append(s);
            }
            return sb.toString();
        }

        public String toHexString() {
            StringBuilder sb = new StringBuilder();
            ByteSequenceIterator it = this.getIterator();
            while (it.hasNextByte()) {
                int i = it.getNextByte();
                if (i < 0) {
                    i += 256;
                }
                String s = Integer.toHexString(i);
                for (int j = 0; j < 2 - s.length(); ++j) {
                    sb.append('0');
                }
                sb.append(s);
            }
            return sb.toString();
        }

        public String toString() {
            if (this.ts == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                ByteSequenceIterator i = this.getIterator();
                while (i.hasNextByte()) {
                    sb.append(i.getNextByte());
                    if (!i.hasNextByte()) continue;
                    sb.append("][");
                }
                sb.append("]");
                this.ts = sb.toString();
            }
            return this.ts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ByteSequence)) {
                return false;
            }
            ByteSequence s = (ByteSequence)o;
            if (s.length() != this.toPosition - this.fromPosition) {
                return false;
            }
            ByteSequenceIterator it1 = this.getIterator();
            ByteSequenceIterator it2 = s.getIterator();
            while (it1.hasNextByte() && it2.hasNextByte()) {
                Byte e2;
                Byte e1 = it1.getNextByte();
                if (e1 == (e2 = Byte.valueOf(it2.getNextByte()))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (!this.hcCalculated) {
                int oddPrime = 461;
                int result = 73;
                ByteSequenceIterator i = this.getIterator();
                while (i.hasNextByte()) {
                    byte b = i.getNextByte();
                    result = result * 461 + b;
                }
                this.hc = result;
                this.hcCalculated = true;
            }
            return this.hc;
        }
    }

    private static final class CompositeByteSequence
    implements ByteSequence {
        private static final long serialVersionUID = 2L;
        private final ByteSequence seq1;
        private final ByteSequence seq2;
        private final int len1;
        private final int len2;
        private int hc;
        private boolean hcCalculated;
        private String ts;

        CompositeByteSequence(ByteSequence seq1, ByteSequence seq2) {
            this.seq1 = seq1;
            this.seq2 = seq2;
            this.len1 = seq1.length();
            this.len2 = seq2.length();
        }

        public byte get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.len1 + this.len2) {
                throw new IndexOutOfBoundsException();
            }
            if (index < this.len1) {
                return this.seq1.get(index);
            }
            return this.seq2.get(index - this.len1);
        }

        public int length() {
            return this.seq1.length() + this.len2;
        }

        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (sequence.length() == 0) {
                return this;
            }
            return new CompositeByteSequence(this, sequence);
        }

        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.len1 + this.len2 || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return new ByteSubSequence(this, fromPosition, toPosition);
        }

        public int indexOf(byte b) {
            int index1 = this.seq1.indexOf(b);
            if (index1 == -1) {
                int index2 = this.seq2.indexOf(b);
                return index2 == -1 ? -1 : index2 + this.len1;
            }
            return index1;
        }

        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.len1 + this.len2) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            ByteSequenceIterator it = this.getIterator(position);
            while (it.hasNextByte()) {
                int itPosition = it.getPosition();
                byte x = it.getNextByte();
                if (x != b) continue;
                return itPosition;
            }
            return -1;
        }

        public int lastIndexOf(byte b) {
            int index1 = this.seq2.lastIndexOf(b);
            if (index1 == -1) {
                return this.seq1.lastIndexOf(b);
            }
            return index1 + this.len1;
        }

        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.len1 + this.len2) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            ByteSequenceIterator it = this.getIterator(position);
            while (it.hasPreviousByte()) {
                byte x = it.getPreviousByte();
                int itPosition = it.getPosition();
                if (x != b) continue;
                return itPosition;
            }
            return -1;
        }

        public boolean isEmpty() {
            return false;
        }

        public InputStream getInputStream() {
            return new InputStream(){
                private final ByteSequenceIterator i;
                private int index;
                {
                    this.i = CompositeByteSequence.this.getIterator();
                }

                public int available() {
                    return CompositeByteSequence.this.len1 + CompositeByteSequence.this.len2 - this.index;
                }

                public int read() {
                    if (!this.i.hasNextByte()) {
                        return -1;
                    }
                    ++this.index;
                    int b = this.i.getNextByte();
                    if (b < 0) {
                        b += 256;
                    }
                    return b;
                }
            };
        }

        public ByteSequenceIterator getIterator() {
            return this.getIterator(0);
        }

        public ByteSequenceIterator getIterator(final int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.len1 + this.len2) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return new ByteSequenceIterator(){
                private int pos;
                {
                    this.pos = position;
                }

                public boolean hasNextByte() {
                    return this.pos != CompositeByteSequence.this.len1 + CompositeByteSequence.this.len2;
                }

                public byte getNextByte() {
                    if (this.pos == CompositeByteSequence.this.len1 + CompositeByteSequence.this.len2) {
                        throw new NoSuchElementException();
                    }
                    if (this.pos < CompositeByteSequence.this.len1) {
                        return CompositeByteSequence.this.seq1.get(this.pos++);
                    }
                    return CompositeByteSequence.this.seq2.get(this.pos++ - CompositeByteSequence.this.len1);
                }

                public boolean hasPreviousByte() {
                    return this.pos != 0;
                }

                public byte getPreviousByte() throws NoSuchElementException {
                    if (this.pos == 0) {
                        throw new NoSuchElementException();
                    }
                    if (this.pos <= CompositeByteSequence.this.len1) {
                        return CompositeByteSequence.this.seq1.get(--this.pos);
                    }
                    return CompositeByteSequence.this.seq2.get(--this.pos - CompositeByteSequence.this.len1);
                }

                public int getPosition() {
                    return this.pos;
                }
            };
        }

        public String toBinaryString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.seq1.toBinaryString());
            sb.append(this.seq2.toBinaryString());
            return sb.toString();
        }

        public String toOctalString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.seq1.toOctalString());
            sb.append(this.seq2.toOctalString());
            return sb.toString();
        }

        public String toHexString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.seq1.toHexString());
            sb.append(this.seq2.toHexString());
            return sb.toString();
        }

        public String toString() {
            if (this.ts == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                ByteSequenceIterator it1 = this.seq1.getIterator();
                ByteSequenceIterator it2 = this.seq2.getIterator();
                while (it1.hasNextByte()) {
                    sb.append(it1.getNextByte());
                    if (!it1.hasNextByte() && !it2.hasNextByte()) continue;
                    sb.append("][");
                }
                while (it2.hasNextByte()) {
                    sb.append(it2.getNextByte());
                    if (!it2.hasNextByte()) continue;
                    sb.append("][");
                }
                sb.append("]");
                this.ts = sb.toString();
            }
            return this.ts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ByteSequence)) {
                return false;
            }
            ByteSequence s = (ByteSequence)o;
            if (s.length() != this.len1 + this.len2) {
                return false;
            }
            ByteSequenceIterator it1 = this.getIterator();
            ByteSequenceIterator it2 = s.getIterator();
            while (it1.hasNextByte() && it2.hasNextByte()) {
                Byte e2;
                Byte e1 = it1.getNextByte();
                if (e1 == (e2 = Byte.valueOf(it2.getNextByte()))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (!this.hcCalculated) {
                int oddPrime = 461;
                int result = 73;
                ByteSequenceIterator i = this.getIterator();
                while (i.hasNextByte()) {
                    byte b = i.getNextByte();
                    result = result * 461 + b;
                }
                this.hc = result;
                this.hcCalculated = true;
            }
            return this.hc;
        }
    }

    private static final class ArrayByteSequence
    implements ByteSequence {
        private static final long serialVersionUID = 2L;
        private final byte[] bytes;
        private int hc;
        private boolean hcCalculated;
        private String ts;

        ArrayByteSequence(byte ... bytes) {
            this.bytes = bytes;
        }

        public byte get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.bytes.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return this.bytes[index];
        }

        public int length() {
            return this.bytes.length;
        }

        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (this.bytes.length == 0) {
                return sequence;
            }
            if (sequence.length() == 0) {
                return this;
            }
            return new CompositeByteSequence(this, sequence);
        }

        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.bytes.length || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return new ByteSubSequence(this, fromPosition, toPosition);
        }

        public int indexOf(byte b) {
            for (int i = 0; i < this.bytes.length; ++i) {
                if (this.bytes[i] != b) continue;
                return i;
            }
            return -1;
        }

        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.bytes.length) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            ByteSequenceIterator it = this.getIterator(position);
            while (it.hasNextByte()) {
                int itPosition = it.getPosition();
                byte x = it.getNextByte();
                if (x != b) continue;
                return itPosition;
            }
            return -1;
        }

        public int lastIndexOf(byte b) {
            for (int i = this.bytes.length - 1; i >= 0; --i) {
                if (this.bytes[i] != b) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.bytes.length) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            ByteSequenceIterator it = this.getIterator(position);
            while (it.hasPreviousByte()) {
                byte x = it.getPreviousByte();
                int itPosition = it.getPosition();
                if (x != b) continue;
                return itPosition;
            }
            return -1;
        }

        public boolean isEmpty() {
            return this.bytes.length == 0;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        public ByteSequenceIterator getIterator() {
            return this.getIterator(0);
        }

        public ByteSequenceIterator getIterator(final int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.bytes.length) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return new ByteSequenceIterator(){
                private int pos;
                {
                    this.pos = position;
                }

                public boolean hasNextByte() {
                    return this.pos != ArrayByteSequence.this.bytes.length;
                }

                public byte getNextByte() {
                    if (this.pos == ArrayByteSequence.this.bytes.length) {
                        throw new NoSuchElementException();
                    }
                    return ArrayByteSequence.this.bytes[this.pos++];
                }

                public boolean hasPreviousByte() {
                    return this.pos != 0;
                }

                public byte getPreviousByte() {
                    if (this.pos == 0) {
                        throw new NoSuchElementException();
                    }
                    return ArrayByteSequence.this.bytes[--this.pos];
                }

                public int getPosition() {
                    return this.pos;
                }
            };
        }

        public String toBinaryString() {
            StringBuilder sb = new StringBuilder();
            ByteSequenceIterator it = this.getIterator();
            while (it.hasNextByte()) {
                int i = it.getNextByte();
                if (i < 0) {
                    i += 256;
                }
                String s = Integer.toBinaryString(i);
                for (int j = 0; j < 8 - s.length(); ++j) {
                    sb.append('0');
                }
                sb.append(s);
            }
            return sb.toString();
        }

        public String toOctalString() {
            StringBuilder sb = new StringBuilder();
            ByteSequenceIterator it = this.getIterator();
            while (it.hasNextByte()) {
                int i = it.getNextByte();
                if (i < 0) {
                    i += 256;
                }
                String s = Integer.toOctalString(i);
                for (int j = 0; j < 3 - s.length(); ++j) {
                    sb.append('0');
                }
                sb.append(s);
            }
            return sb.toString();
        }

        public String toHexString() {
            StringBuilder sb = new StringBuilder();
            ByteSequenceIterator it = this.getIterator();
            while (it.hasNextByte()) {
                int i = it.getNextByte();
                if (i < 0) {
                    i += 256;
                }
                String s = Integer.toHexString(i);
                for (int j = 0; j < 2 - s.length(); ++j) {
                    sb.append('0');
                }
                sb.append(s);
            }
            return sb.toString();
        }

        public String toString() {
            if (this.ts == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                int counter = 0;
                for (byte b : this.bytes) {
                    sb.append(b);
                    if (counter++ == this.bytes.length - 1) continue;
                    sb.append("][");
                }
                sb.append("]");
                this.ts = sb.toString();
            }
            return this.ts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ByteSequence)) {
                return false;
            }
            ByteSequence s = (ByteSequence)o;
            if (s.length() != this.bytes.length) {
                return false;
            }
            ByteSequenceIterator it1 = this.getIterator();
            ByteSequenceIterator it2 = s.getIterator();
            while (it1.hasNextByte() && it2.hasNextByte()) {
                Byte e2;
                Byte e1 = it1.getNextByte();
                if (e1 == (e2 = Byte.valueOf(it2.getNextByte()))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (!this.hcCalculated) {
                int oddPrime = 461;
                int result = 73;
                ByteSequenceIterator i = this.getIterator();
                while (i.hasNextByte()) {
                    byte b = i.getNextByte();
                    result = result * 461 + b;
                }
                this.hc = result;
                this.hcCalculated = true;
            }
            return this.hc;
        }
    }
}

