/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.services;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.services.redirector.Redirector;
import com.ibm.CORBA.services.redirector.RedirectorController;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.orbimpl.MessageUtility;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IIOPTunnelServlet
extends HttpServlet {
    private static final long serialVersionUID = 750467456658215023L;
    protected boolean debug = false;
    protected RedirectorController controller;
    private static final int DEFAULT_MAX_OPEN_SOCKETS = 3;
    private static final String MAX_OPEN_SOCKETS_PROPERTY = "com.ibm.ws.orb.services.redirector.MaxOpenSocketsPerEndpoint";
    private static final String TIMEOUT_PROPERTY = "com.ibm.ws.orb.services.redirector.RequestTimeout";
    private static final String thisClassName = IIOPTunnelServlet.class.getName();

    public void init(ServletConfig servletConfig) throws ServletException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "init()");
        }
        super.init(servletConfig);
        this.controller = new RedirectorController();
        ORB oRB = IIOPTunnelServlet.getOrb();
        this.getTunnelProperties(oRB);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "init()");
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Redirector redirector;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "service() queryString=" + httpServletRequest.getQueryString());
        }
        String string = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        httpServletResponse.setContentType("ijavaorb/iiop");
        try {
            String string2 = httpServletRequest.getQueryString();
            n2 = string2.indexOf("debug=true");
            if (n2 != -1 || this.debug) {
                this.debug = true;
                this.log("service(): entered...");
            }
            if ((n2 = string2.indexOf("debug=false")) != -1) {
                this.debug = false;
            }
            if ((n2 = string2.indexOf("host=")) == -1) {
                this.log(MessageUtility.getMessage("IIOPTunnelServlet.parsingHost", string2));
                return;
            }
            n3 = string2.indexOf(38, n2 += 5);
            if (n3 == -1) {
                n3 = string2.length();
            }
            string = string2.substring(n2, n3);
            n2 = string2.indexOf("port=");
            if (n2 == -1) {
                this.log(MessageUtility.getMessage("IIOPTunnelServlet.parsingPort", string2));
                return;
            }
            n3 = string2.indexOf(38, n2 += 5);
            if (n3 == -1) {
                n3 = string2.length();
            }
            n = Integer.parseInt(string2.substring(n2, n3));
            if (this.debug) {
                this.log("service(): target host = " + string + " target port = " + n);
            }
            redirector = this.controller.getRedirector(string, n);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.CORBA.services.IIOPTunnelServlet.service", "188", (Object)this);
            this.log(MessageUtility.getMessage("IIOPTunnelServlet.IOException", iOException.toString()));
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.CORBA.services.IIOPTunnelServlet.service", "194", (Object)this);
            String[] stringArray = new String[]{"service()", exception.toString()};
            this.log(MessageUtility.getMessage("IIOPTunnelServlet.Exception", stringArray));
            return;
        }
        if (httpServletRequest.getMethod().equals("POST")) {
            if (this.debug) {
                this.log("service(): About to call redirector.handle() method");
            }
            try {
                redirector.handle((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.CORBA.services.IIOPTunnelServlet.service", "217", (Object)this);
                this.controller.removeRedirector(redirector.getID());
                redirector = null;
                this.log(MessageUtility.getMessage("IIOPTunnelServlet.IOException", iOException.toString()));
                return;
            }
        } else {
            this.log(MessageUtility.getMessage("IIOPTunnelServlet.unsupported", httpServletRequest.getMethod()));
            return;
        }
        this.controller.checkConnectionTable();
        if (this.debug) {
            this.log("end of service method");
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "service()");
        }
    }

    public String getServletInfo() {
        return MessageUtility.getMessage("IIOPTunnelServlet.servletInfo");
    }

    public static ORB getOrb() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "getOrb()");
        }
        Object var0 = null;
        Object var1_1 = null;
        ORB oRB = null;
        oRB = GlobalORBFactory.globalORB();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "getOrb()");
        }
        return oRB;
    }

    private void getTunnelProperties(ORB oRB) {
        int n;
        block15: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(2064L, thisClassName, "getTunnelProperties()");
            }
            int n2 = 0;
            n = 0;
            String string = oRB.getProperty(MAX_OPEN_SOCKETS_PROPERTY);
            if (string == null || string.length() == 0) {
                n2 = 3;
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelProperties()", "com.ibm.ws.orb.services.redirector.MaxOpenSocketsPerEndpoint is defaulting to 3");
            } else {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelProperties()", "com.ibm.ws.orb.services.redirector.MaxOpenSocketsPerEndpoint = " + string);
                }
                try {
                    n2 = Integer.parseInt(string);
                    if (n2 < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelProperties()", "The property com.ibm.ws.orb.services.redirector.MaxOpenSocketsPerEndpoint has a value of " + string + ".  This is not a valid value.  " + MAX_OPEN_SOCKETS_PROPERTY + " has been reset to the default value of " + 3);
                    }
                    n2 = 3;
                }
            }
            this.controller.setMaxOpenSockets(n2);
            string = oRB.getProperty(TIMEOUT_PROPERTY);
            if (string == null || string.length() == 0) {
                n = oRB.getRequestTimeout();
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelProperties()", "com.ibm.ws.orb.services.redirector.RequestTimeout is defaulting to the value for com.ibm.CORBA.RequestTimeout: " + n / 1000 + " seconds.");
            } else {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelProperties()", "com.ibm.ws.orb.services.redirector.RequestTimeout = " + string + " seconds.");
                }
                try {
                    n = Integer.parseInt(string);
                    if (n < 0) {
                        throw new Exception();
                    }
                    n *= 1000;
                }
                catch (Exception exception) {
                    n = oRB.getRequestTimeout();
                    if (!ORBRas.isTrcLogging) break block15;
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getTunnelProperties()", "The property com.ibm.ws.orb.services.redirector.RequestTimeout has a value of " + string + ".  This is not a valid value.  " + TIMEOUT_PROPERTY + " has been reset to be the same as the value for com.ibm.CORBA.RequestTimeout: " + n / 1000 + " seconds.");
                }
            }
        }
        this.controller.setRequestTimeout(n);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "getTunnelProperties()");
        }
    }
}

