/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.services.redirector;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.services.redirector.RedirectorController;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orbimpl.MessageUtility;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class Redirector {
    private static final String thisClassName = Redirector.class.getName();
    protected InputStream inFromServer;
    protected OutputStream outToServer;
    protected InputStream inFromClient;
    protected OutputStream outToClient;
    protected Socket outputSocket;
    public String my_id;
    public boolean busy = false;
    protected String outServerName;
    protected int outPort;
    protected ServletRequest request;
    protected ServletResponse response;
    protected RedirectorController controller;
    public static final int GIOPBigEndian = 0;
    public static final int GIOPLittleEndian = 1;
    private long _timeStamp = 0L;
    private long timeLastUsed = 0L;
    private long staleSocketThreshold = 0L;
    private long staleSocketThresholdMillis = 0L;
    private boolean connectionTerminated = false;

    public Redirector(String string, int n, long l, RedirectorController redirectorController) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "Redirector(" + string + "," + n + "," + l + ")");
        }
        this._timeStamp = l;
        this.outServerName = string;
        this.outPort = n;
        this.controller = redirectorController;
        this.my_id = Redirector.buildID(string, n, l);
        this.setupServerConnection();
        this.busy = false;
        this.staleSocketThreshold = this.controller.getStaleSocketThreshold();
        this.staleSocketThresholdMillis = this.staleSocketThreshold * 1000L;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "Redirector()");
        }
    }

    public void setupServerConnection() throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "setupServerConnection(" + this.my_id + ")");
        }
        try {
            this.outputSocket = new Socket(this.outServerName, this.outPort);
            this.outputSocket.setSoTimeout(this.controller.getRequestTimeout());
            this.outToServer = this.outputSocket.getOutputStream();
            this.inFromServer = this.outputSocket.getInputStream();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.CORBA.services.redirector.Redirector.setupServerConnection", "129", this);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "setupServerConnection", "Error creating socket " + this.my_id + ": " + iOException);
            }
            throw iOException;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "setupServerConnection()");
        }
    }

    public void reconnect() throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "reconnect()");
        }
        this.outputSocket.close();
        try {
            this.setupServerConnection();
        }
        catch (IOException iOException) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "reconnect", "Error reconnecting to server " + this.my_id);
            }
            throw iOException;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "reconnect()");
        }
    }

    public synchronized void handle(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "handle(" + this.my_id + ")");
        }
        this.busy = true;
        this.request = servletRequest;
        this.response = servletResponse;
        this.inFromClient = servletRequest.getInputStream();
        this.outToClient = servletResponse.getOutputStream();
        this.timeLastUsed = System.currentTimeMillis();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.inFromClient);
        if (this.inFromServer.available() != 0) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "handle", "Stale data exists on inbound stream from the server.  Attempting to reconnect.");
            }
            this.reconnect();
        }
        bufferedInputStream.mark(2048);
        this.handleRequest(bufferedInputStream, this.outToServer);
        if (!this.handleReply(this.inFromServer, this.outToClient, servletResponse, true)) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "handle", "Socket exception received when reading reply from server.  Attempting to reconnect and resend request to the server.");
            }
            this.reconnect();
            try {
                bufferedInputStream.reset();
            }
            catch (IOException iOException) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "handle", "Unable to reset the input buffer from the client back to the beginning because the message is larger than the buffer.  The buffer size is 2048 bytes.  The message cannot be resent to the server.");
                }
                this.busy = false;
                throw iOException;
            }
            this.handleRequest(bufferedInputStream, this.outToServer);
            this.handleReply(this.inFromServer, this.outToClient, servletResponse, false);
        }
        this.busy = false;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "handle()");
        }
    }

    protected void handleRequest(BufferedInputStream bufferedInputStream, OutputStream outputStream) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "handleRequest(" + this.my_id + ")");
        }
        try {
            int n = 0;
            byte[] byArray = new byte[2048];
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                int n2 = n <= 0 ? 0 : n;
                try {
                    outputStream.write(byArray, 0, n2);
                }
                catch (SocketException socketException) {
                    FFDCFilter.processException((Throwable)socketException, "com.ibm.CORBA.services.redirector.Redirector.handleRequest", "276", this);
                    this.reconnect();
                    outputStream = this.outToServer;
                    outputStream.write(byArray, 0, n2);
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.CORBA.services.redirector.Redirector.handleRequest", "284", this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handleRequest", MessageUtility.getMessage("Redirector.RequestIOException", iOException.toString()), (String)null, (Object)iOException);
            }
            throw iOException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.CORBA.services.redirector.Redirector.handleRequest", "299", this);
            if (ORBRas.isMsgLogging) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handleRequest", MessageUtility.getMessage("Redirector.Throwable", throwable.toString()), (String)null, (Object)throwable);
            }
            throw new IOException("Throwable exception caught t=" + throwable.toString());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "handleRequest()");
        }
    }

    protected boolean handleReply(InputStream inputStream, OutputStream outputStream, ServletResponse servletResponse, boolean bl) throws IOException {
        block21: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(2064L, thisClassName, "handleReply(" + this.my_id + ")");
            }
            try {
                int n;
                int n2;
                int n3;
                int n4;
                byte[] byArray = new byte[12];
                try {
                    Redirector.readFully(inputStream, byArray, 0, 12);
                }
                catch (SocketException socketException) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "handleReply", "Error calling readFully: " + socketException);
                    }
                    if (bl) {
                        return false;
                    }
                    throw socketException;
                }
                byte by = (byte)(byArray[6] & 1);
                if (by == 0) {
                    n4 = byArray[8] << 24 & 0xFF000000;
                    n3 = byArray[9] << 16 & 0xFF0000;
                    n2 = byArray[10] << 8 & 0xFF00;
                    n = byArray[11] << 0 & 0xFF;
                } else {
                    n4 = byArray[11] << 24 & 0xFF000000;
                    n3 = byArray[10] << 16 & 0xFF0000;
                    n2 = byArray[9] << 8 & 0xFF00;
                    n = byArray[8] << 0 & 0xFF;
                }
                int n5 = (n4 | n3 | n2 | n) + 12;
                byte[] byArray2 = new byte[n5];
                System.arraycopy(byArray, 0, byArray2, 0, 12);
                Redirector.readFully(inputStream, byArray2, 12, n5 - 12);
                if (servletResponse != null) {
                    servletResponse.setContentLength(n5);
                }
                outputStream.write(byArray2, 0, n5);
                if (this._timeStamp <= (long)this.controller.maxOpenSockets()) break block21;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "handleReply", "Closing temporary socket: " + this.my_id);
                }
                try {
                    if (this.inFromClient != null) {
                        this.inFromClient.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.inFromClient = null;
                try {
                    if (this.outToClient != null) {
                        this.outToClient.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.outToClient = null;
                this.request = null;
                this.response = null;
                this.controller.removeRedirector(this.getID());
                this.controller = null;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.CORBA.services.redirector.Redirector.handleReply", "434", this);
                if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handleReply", MessageUtility.getMessage("Redirector.ReplyIOException", iOException.toString()), (String)null, (Object)iOException);
                }
                throw iOException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.CORBA.services.redirector.Redirector.handleReply", "448", this);
                if (ORBRas.isMsgLogging) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.CORBA.services.redirector.Redirector", "handleReply", MessageUtility.getMessage("Redirector.Throwable", throwable.toString()), (String)null, (Object)throwable);
                }
                throw new IOException("Throwable exception caught t=" + throwable.toString());
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "handleReply()");
        }
        return true;
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = 0;
            int n4 = 0;
            while (true) {
                try {
                    n3 = inputStream.read(byArray, n + i, n2 - i);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    throw socketTimeoutException;
                }
                catch (IOException iOException) {
                    if (n4++ < 5) continue;
                    throw iOException;
                }
                break;
            }
            if (n3 >= 0) continue;
            throw new IOException();
        }
    }

    public String getID() {
        return this.my_id;
    }

    public static String buildID(String string, int n, long l) {
        return string + ":" + n + ":" + l;
    }

    public void finalize() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "finalize(" + this.my_id + ")");
        }
        if (!this.connectionTerminated) {
            this.terminateServerConnection();
        }
        this.busy = false;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "finalize()");
        }
    }

    public synchronized void terminateServerConnection() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "terminateServerConnection(" + this.my_id + ")");
        }
        this.connectionTerminated = true;
        if (this.outToServer != null) {
            try {
                this.outToServer.close();
                this.outToServer = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.inFromServer != null) {
            try {
                this.inFromServer.close();
                this.inFromServer = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.outputSocket != null) {
            try {
                this.outputSocket.close();
                this.outputSocket = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "terminateServerConnection()");
        }
    }

    public boolean cleanupStaleConnection() {
        if (this.busy) {
            return false;
        }
        this.busy = true;
        boolean bl = false;
        boolean bl2 = false;
        if (this.controller.checkDeltaTime(this.timeLastUsed, this.staleSocketThresholdMillis) > 0L) {
            bl2 = true;
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "cleanupStaleConnection", this.my_id, (Object)("Connection was last used over " + this.staleSocketThreshold + " seconds ago.  Removing connection."));
            }
        } else {
            try {
                if (this.inFromServer.available() != 0) {
                    bl2 = true;
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, (Object)this, "cleanupStaleConnection", this.my_id, (Object)"Stale data exists on inbound stream from the server.  Removing connection.");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl2) {
            try {
                this.terminateServerConnection();
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            this.busy = false;
        }
        return bl;
    }
}

