/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedORBInitInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ClientSessionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.connmgmt.ConnectionHandle;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.orbssl.ExtendedSSLConnectionData;
import javax.security.auth.Subject;
import org.omg.CORBA.Object;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.SASContextBody;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.RequestInfo;

public class CSIClientRI
extends CSIClientRIBase {
    public void pre_init(ORBInitInfo oRBInitInfo) {
        super.pre_init(oRBInitInfo);
        String string = "CSIClientRI.pre_init";
        String string2 = "";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        if (ConfigURLProperties.isSecurityEnabled()) {
            SecurityLogger.logAudit(string, "security.ClientCSI");
            try {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Registering client request interceptor.";
                    SecurityLogger.debugMessage(string, string2);
                }
                this.slotid = oRBInitInfo.allocate_slot_id();
                ((ExtendedORBInitInfo)oRBInitInfo).add_client_request_interceptor((ClientRequestInterceptor)this, false);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRI.pre_init", "267", (java.lang.Object)this);
                string2 = "An exception has been thrown registering the interceptor.";
                SecurityLogger.debugMessage(string, string2);
                SecurityLogger.logException(string, exception, 0, 0);
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    public void post_init(ORBInitInfo oRBInitInfo) {
        super.post_init(oRBInitInfo);
    }

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        String string = "";
        String string2 = "CSIClientRI.send_request";
        if (SecurityLogger.debugTraceEnabled) {
            this.entry(clientRequestInfo, string2);
        }
        CurrentImpl currentImpl = this.csiUtil.getCurrent();
        CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy = currentImpl.getEffectivePolicy();
        currentImpl.setEffectivePolicy(null);
        String string3 = "";
        ConnectionData connectionData = null;
        ConnectionInformationImpl connectionInformationImpl = (ConnectionInformationImpl)((ExtendedClientRequestInfo)clientRequestInfo).getConnectionData();
        if (connectionInformationImpl != null) {
            connectionData = (ConnectionData)connectionInformationImpl.getConnectionData();
        }
        boolean bl = false;
        if (connectionData != null) {
            ConnectionHandle connectionHandle;
            if (!(connectionData instanceof ExtendedSSLConnectionData)) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Invalid cdata class: " + connectionData;
                    SecurityLogger.debugMessage(string2, string);
                }
                return;
            }
            string3 = connectionData.getConnectionKey();
            if (string3 == null && (connectionHandle = (ConnectionHandle)connectionData.getConnectionHandle()) != null && connectionHandle.getIsLocalComm()) {
                string3 = connectionHandle.toString();
                connectionData.setConnectionKey(string3);
                bl = true;
            }
            if (cSIv2EffectivePerformPolicy == null) {
                cSIv2EffectivePerformPolicy = ((ExtendedSSLConnectionData)connectionData).getEffectivePolicy();
            }
        }
        this.myVault.put_effective_policy(clientRequestInfo.request_id(), cSIv2EffectivePerformPolicy);
        boolean bl2 = this.qualifyClientRequest(clientRequestInfo, cSIv2EffectivePerformPolicy);
        if (!bl2) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Returning from send_request without authenticating.";
                SecurityLogger.debugMessage(string2, string);
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string2);
            }
            return;
        }
        CSICredentialsManager cSICredentialsManager = new CSICredentialsManager();
        boolean bl3 = cSIv2EffectivePerformPolicy.performClientAuthentication();
        boolean bl4 = cSIv2EffectivePerformPolicy.performIdentityAssertion();
        SessionEntry sessionEntry = null;
        ClientSessionKey clientSessionKey = null;
        long l = 0L;
        if (SecurityLogger.debugTraceEnabled) {
            string = "Identity assertion: " + bl4 + ",  client authentication: " + bl3 + ",  authorization token: " + cSIv2EffectivePerformPolicy.performAuthorizationToken();
            SecurityLogger.debugMessage(string2, string);
        }
        if (bl3 || bl4) {
            java.lang.Object object;
            Subject subject;
            String string4 = cSIv2EffectivePerformPolicy.getTargetHostName();
            String string5 = RealmSecurityName.getRealm(cSIv2EffectivePerformPolicy.getTargetSecurityName());
            if (string5 == null || string5.equals("")) {
                string5 = cSIv2EffectivePerformPolicy.getTargetSecurityName();
            }
            if (SecurityLogger.debugTraceEnabled) {
                string = "Retrieving Subject from thread or login.";
                SecurityLogger.debugMessage(string2, string);
            }
            if ((subject = this.retrieveSubject(string5, cSIv2EffectivePerformPolicy, cSICredentialsManager)) == null) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Subject is null, sending unauthenticated request.";
                    SecurityLogger.debugMessage(string2, string);
                }
                if (SecurityLogger.debugEntryEnabled) {
                    SecurityLogger.debugExit(string2);
                }
                return;
            }
            if (this.secConfig.isRMIOutboundMappingEnabled()) {
                subject = this.unwrapSubject(subject);
            }
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            if (cSIv2EffectivePerformPolicy.isStateful()) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Starting session evaluation.";
                    SecurityLogger.debugMessage(string2, string);
                }
                object = null;
                int n = 0;
                if (bl) {
                    object = "";
                } else {
                    object = connectionData.getLocalHost();
                    n = connectionData.getLocalPort();
                }
                sessionEntry = this.determineStatefulContextID(string5, cSIv2EffectivePerformPolicy, this.sessionMgr, clientRequestInfo, subject, connectionData.getConnectionKey(), (String)object, n);
                if (sessionEntry == null) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "EstablishContext message has been set in the request.";
                        SecurityLogger.debugMessage(string2, string);
                    }
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string2);
                    }
                    return;
                }
                clientSessionKey = sessionEntry.get_client_session_key();
                l = sessionEntry.get_client_context_id();
                if (sessionEntry.get_renegotiate_to_stateless()) {
                    l = 0L;
                    sessionEntry.reset_renegotiate_to_stateless();
                }
            } else if (SecurityLogger.debugTraceEnabled) {
                string = "This is a stateless request.";
                SecurityLogger.debugMessage(string2, string);
            }
            cSIv2EffectivePerformPolicy.setStatefulContextID(l);
            cSIv2EffectivePerformPolicy.setClientSessionKey(clientSessionKey);
            if (cSIv2EffectivePerformPolicy.performAuthorizationToken() || this.secConfig.isRMIOutboundLoginEnabled()) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Calling JAAS login to map or create opaque authorization token.";
                    SecurityLogger.debugMessage(string2, string);
                }
                subject = this.mapOutboundOrCreateOAT(subject, cSIv2EffectivePerformPolicy);
            }
            if (SecurityLogger.debugTraceEnabled) {
                string = "Determining which SecurityContext to use (GSSUP or LTPA).";
                SecurityLogger.debugMessage(string2, string);
            }
            object = this.determineSecurityContextType(subject, cSIv2EffectivePerformPolicy, string3, this.sessionMgr, sessionEntry);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Setting the contents of the identity token.";
                SecurityLogger.debugMessage(string2, string);
            }
            IdentityToken identityToken = new IdentityToken();
            this.setIdentityToken(identityToken, subject, cSIv2EffectivePerformPolicy, this.sessionMgr, sessionEntry);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Setting the contents of the client authentication token and EstablishContext message.";
                SecurityLogger.debugMessage(string2, string);
            }
            this.setSecurityContext(clientRequestInfo, (SecurityContextImpl)object, identityToken, subject, cSIv2EffectivePerformPolicy, this.sessionMgr, sessionEntry, string5);
        } else if (cSIv2EffectivePerformPolicy.performTLClientAuth() && connectionData.getConnectionType() == 1L) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "TLSClientAuth over SSL only, No security service returned.";
                SecurityLogger.debugMessage(string2, string);
            }
        } else if (SecurityLogger.debugTraceEnabled) {
            string = "No security is required at csiv2 message and attribute layers.  No security context will be sent.";
            SecurityLogger.debugMessage(string2, string);
        }
        if (cSIv2EffectivePerformPolicy.isStateful() && sessionEntry != null && l != 0L) {
            this.sessionMgr.csi_client_session_status_update(l, clientSessionKey, 6);
        }
        this.csiUtil.setUnauthenticatedToNullIfNeeded();
        if (SecurityLogger.debugTraceEnabled) {
            string = "*** SENDING REQUEST ***";
            SecurityLogger.debugMessage(string2, string);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
        String string = "";
        String string2 = "CSIClientRI.receive_reply";
        if (SecurityLogger.debugTraceEnabled) {
            this.entry(clientRequestInfo, string2);
        }
        if (this.is_local_client_request(clientRequestInfo)) {
            this.receive_reply_local(clientRequestInfo);
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string2);
            }
            return;
        }
        CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy = this.myVault.get_effective_policy(clientRequestInfo.request_id());
        this.myVault.clear_effective_policy(clientRequestInfo.request_id());
        String string3 = "<unknown>";
        if (clientRequestInfo.effective_target() != null) {
            string3 = clientRequestInfo.effective_target().getClass().getName();
        }
        if (SecurityConnectionInterceptor.isSpecialNamingMethod(clientRequestInfo.operation(), string3) || SecurityConnectionInterceptor.isSpecialSSLRequiredNamingMethod(clientRequestInfo.operation(), string3) || ORB.isSpecialMethod((String)clientRequestInfo.operation()) && !this.csiUtil.isCORBAAuthRequired()) {
            string = "Special naming method or other corba special method. Return from interceptor.";
            SecurityLogger.debugMessage(string2, string);
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string2);
            }
            return;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string = "*** RECEIVING REPLY ***";
            SecurityLogger.debugMessage(string2, string);
        }
        if (cSIv2EffectivePerformPolicy != null) {
            ServiceContext serviceContext = null;
            SASContextBody sASContextBody = null;
            serviceContext = this.csiUtil.get_sc_from_reply((RequestInfo)clientRequestInfo);
            if (serviceContext != null) {
                sASContextBody = this.csiUtil.get_message_from_sc(serviceContext);
            }
            this.sessionMgr.csi_client_session_complete(sASContextBody, cSIv2EffectivePerformPolicy.isStateful(), cSIv2EffectivePerformPolicy.getStatefulContextID(), cSIv2EffectivePerformPolicy.getClientSessionKey());
            if (serviceContext != null && (cSIv2EffectivePerformPolicy.performClientAuthentication() || cSIv2EffectivePerformPolicy.performIdentityAssertion())) {
                com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl securityContextImpl = null;
                securityContextImpl = new com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl(this.myVault, "");
                ((SecurityContextImpl)securityContextImpl).csi_continue_security_context(clientRequestInfo, securityContextImpl);
            }
        } else if (SecurityLogger.debugTraceEnabled) {
            string = "Effective policy is null.";
            SecurityLogger.debugMessage(string2, string);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string = "*** MESSAGE COMPLETED ***";
            SecurityLogger.debugMessage(string2, string);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
    }

    public void receive_reply_local(ClientRequestInfo clientRequestInfo) {
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        java.lang.Object object;
        String string = "";
        String string2 = "CSIClientRI.receive_exception";
        if (SecurityLogger.debugTraceEnabled) {
            this.entry(clientRequestInfo, string2);
        }
        if (this.is_local_client_request(clientRequestInfo)) {
            this.receive_exception_local(clientRequestInfo);
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string2);
            }
            return;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string = "*** RECEIVING EXCEPTION ***";
            SecurityLogger.debugMessage(string2, string);
            object = this.csiUtil.read_detailed_message((RequestInfo)clientRequestInfo);
            if (!((String)object).equals("")) {
                string = "The following exception was received from the server: " + (String)object;
                SecurityLogger.debugMessage(string2, string);
            }
        }
        object = this.myVault.get_effective_policy(clientRequestInfo.request_id());
        this.myVault.clear_effective_policy(clientRequestInfo.request_id());
        if (object != null) {
            ServiceContext serviceContext = null;
            SASContextBody sASContextBody = null;
            serviceContext = this.csiUtil.get_sc_from_reply((RequestInfo)clientRequestInfo);
            if (serviceContext != null) {
                sASContextBody = this.csiUtil.get_message_from_sc(serviceContext);
            }
            this.sessionMgr.csi_client_session_complete_exception(sASContextBody, ((CSIv2EffectivePerformPolicy)object).isStateful(), ((CSIv2EffectivePerformPolicy)object).getClientSessionKey());
            if (clientRequestInfo.reply_status() == 1) {
                this.sessionMgr.retry(clientRequestInfo);
            }
            if (serviceContext != null && (((CSIv2EffectivePerformPolicy)object).performClientAuthentication() || ((CSIv2EffectivePerformPolicy)object).performIdentityAssertion())) {
                com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl securityContextImpl = null;
                securityContextImpl = new com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl(this.myVault, "");
                ((SecurityContextImpl)securityContextImpl).csi_continue_security_context(clientRequestInfo, securityContextImpl);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "*** MESSAGE COMPLETED ***";
                    SecurityLogger.debugMessage(string2, string);
                }
            }
        } else if (SecurityLogger.debugTraceEnabled) {
            string = "Effective policy is null.";
            SecurityLogger.debugMessage(string2, string);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
    }

    public void receive_exception_local(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        String string = "";
        String string2 = "CSIClientRI.receive_other";
        if (SecurityLogger.debugTraceEnabled) {
            this.entry(clientRequestInfo, string2);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string = "*** RECEIVE OTHER ***";
            SecurityLogger.debugMessage(string2, string);
        }
        if (this.is_local_client_request(clientRequestInfo)) {
            this.receive_other_local(clientRequestInfo);
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string2);
            }
            return;
        }
        String string3 = "<unknown>";
        if (clientRequestInfo.effective_target() != null) {
            string3 = clientRequestInfo.effective_target().getClass().getName();
        }
        if (SecurityConnectionInterceptor.isSpecialNamingMethod(clientRequestInfo.operation(), string3) || SecurityConnectionInterceptor.isSpecialSSLRequiredNamingMethod(clientRequestInfo.operation(), string3) || ORB.isSpecialMethod((String)clientRequestInfo.operation()) && !this.csiUtil.isCORBAAuthRequired()) {
            string = "Special naming method or other corba special method. Return from interceptor.";
            SecurityLogger.debugMessage(string2, string);
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string2);
            }
            return;
        }
        CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy = this.myVault.get_effective_policy(clientRequestInfo.request_id());
        switch (clientRequestInfo.reply_status()) {
            case 0: {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "receive_other status: SUCCESSFUL.";
                    SecurityLogger.debugMessage(string2, string);
                }
                this.receive_reply(clientRequestInfo);
                break;
            }
            case 3: {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "receive_other status: LOCATION_FORWARD.";
                    SecurityLogger.debugMessage(string2, string);
                }
                if (this.sessionMgr == null || cSIv2EffectivePerformPolicy == null) break;
                this.sessionMgr.csi_client_session_status_update(cSIv2EffectivePerformPolicy.getStatefulContextID(), cSIv2EffectivePerformPolicy.getClientSessionKey(), 7);
                break;
            }
            default: {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "receive_other status: " + clientRequestInfo.reply_status();
                    SecurityLogger.debugMessage(string2, string);
                }
                if (this.sessionMgr == null || cSIv2EffectivePerformPolicy == null) break;
                this.sessionMgr.csi_client_session_status_update(cSIv2EffectivePerformPolicy.getStatefulContextID(), cSIv2EffectivePerformPolicy.getClientSessionKey(), 7);
            }
        }
        this.myVault.clear_effective_policy(clientRequestInfo.request_id());
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
    }

    public void receive_other_local(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    public void entry(ClientRequestInfo clientRequestInfo, String string) {
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        if (SecurityLogger.debugTraceEnabled) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("Request_id: ").append(clientRequestInfo.request_id()).append(", ");
            Object object = clientRequestInfo.effective_target();
            if (object != null) {
                stringBuffer.append("class: ").append(object.getClass().getName()).append(", ");
            }
            stringBuffer.append("operation: ").append(clientRequestInfo.operation());
            SecurityLogger.debugMessage(string, stringBuffer.toString());
            stringBuffer = null;
        }
    }
}

