/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPConnectionInfo;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ServiceContextList;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSIORBInit;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ClientSessionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SecurityExecutionEnvironment;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.MechanismAmbiguityException;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.ObjectList;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmi.ServiceContext;
import com.ibm.websphere.security.audit.AuditHandler;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.connmgmt.ConnectionHandle;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.iiop.channel.ConnectionStateElement;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import com.ibm.wsspi.security.auth.WSSubjectWrapper;
import com.ibm.wsspi.security.csiv2.CSIv2PerformPolicy;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509CertSelector;
import java.util.Hashtable;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.GSS_NT_ExportedNameHelper;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.MessageInContext;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.X501DistinguishedNameHelper;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.Security.OpaqueHolder;

public class CSIClientRIBase
extends CSIORBInit
implements ClientRequestInterceptor {
    private static final TraceComponent tc = Tr.register(CSIClientRIBase.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static final String ADMIN_CLASS = "adminsec.txt";
    private static ObjectList list = null;
    protected static AuditHandler auditHandler = null;
    protected static J2EEAuditEventFactory auditFactory = null;
    protected static AuditService auditService = null;
    protected ORB orb = null;
    protected Codec codec = null;
    protected VaultImpl myVault = null;
    protected SecurityConnectionInterceptor _securityConnectionInterceptor = null;
    protected SecurityConfiguration secConfig = null;
    protected MechanismFactory _mechanismFactory = null;
    protected int csiClientCertPort = 0;
    protected IntHolder expiry_time_now = new IntHolder(0);
    public int slotid;
    protected CSIUtil csiUtil = new CSIUtil();
    protected SessionManager sessionMgr = null;
    protected CSICredentialsManager credsMgr = new CSICredentialsManager();
    ContextManager contextMgr = null;
    protected Hashtable sessionRequestTable = new Hashtable();
    static /* synthetic */ Class class$com$ibm$wsspi$security$auth$WSSubjectWrapper;

    public void init(ORB oRB) {
        if (ConfigURLProperties.isSecurityEnabled()) {
            String string = "CSIClientRIBase.init";
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugEntry(string);
            }
            this.contextMgr = ContextManagerFactory.getInstance();
            this.myVault = VaultImpl.getInstance();
            if (this.myVault != null) {
                this.sessionMgr = this.myVault.getSessionManager();
                this.orb = this.myVault.getORB();
                this._mechanismFactory = this.myVault.getMechanismFactory();
                CSIClientRIBase cSIClientRIBase = this;
                this.secConfig = cSIClientRIBase.myVault.getSecurityConfiguration();
            } else {
                String string2 = "security.JSAS0010E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
        }
    }

    public void pre_init(ORBInitInfo oRBInitInfo) {
    }

    public void post_init(ORBInitInfo oRBInitInfo) {
        if (ConfigURLProperties.isSecurityEnabled()) {
            String string = "CSIClientRIBase.post_init";
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugEntry(string);
            }
            this.contextMgr = ContextManagerFactory.getInstance();
            this.myVault = VaultImpl.getInstance();
            if (this.myVault != null) {
                this.sessionMgr = this.myVault.getSessionManager();
                this.orb = this.myVault.getORB();
                this._mechanismFactory = this.myVault.getMechanismFactory();
                CSIClientRIBase cSIClientRIBase = this;
                this.secConfig = cSIClientRIBase.myVault.getSecurityConfiguration();
            } else {
                String string2 = "security.JSAS0010E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
        }
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    protected boolean qualifyClientRequest(ClientRequestInfo clientRequestInfo, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy) throws ForwardRequest {
        String string = "CSIClientRIBase.qualifyClientRequest";
        String string2 = "";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        boolean bl = false;
        CurrentImpl currentImpl = this.csiUtil.getCurrent();
        String string3 = "<unknown>";
        if (clientRequestInfo.effective_target() != null) {
            string3 = clientRequestInfo.effective_target().getClass().getName();
        }
        if (this.is_local_client_request(clientRequestInfo)) {
            this.send_request_local(clientRequestInfo);
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
            return false;
        }
        if (cSIv2EffectivePerformPolicy == null) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Effective policy object is null, not a CSIv2 request.";
                SecurityLogger.debugMessage(string, string2);
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
            return false;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Effective policy object instance is: " + cSIv2EffectivePerformPolicy;
            SecurityLogger.debugMessage(string, string2);
        }
        if (!(bl = currentImpl.getServerSecurityEnabled())) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "CSIClientRI: appSecEnabledState = " + bl;
                SecurityLogger.debugMessage(string, string2);
            }
            if (list == null) {
                list = new ObjectList(ADMIN_CLASS);
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "class_name: " + string3 + " method_name: " + clientRequestInfo.operation() + " effective_target: " + clientRequestInfo.effective_target();
                SecurityLogger.debugMessage(string, string2);
            }
            if (!(!SecurityConnectionInterceptor.isSpecialClass(clientRequestInfo.operation(), string3) || this.contextMgr.processIsServer() && list.find(string3))) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Special naming method or other corba special method. Return from interceptor.";
                    SecurityLogger.debugMessage(string, string2);
                }
                if (SecurityLogger.debugEntryEnabled) {
                    SecurityLogger.debugExit(string);
                }
                return false;
            }
        }
        if (!cSIv2EffectivePerformPolicy.getIsInternalRequestPolicy() && (SecurityConnectionInterceptor.isSpecialNamingMethod(clientRequestInfo.operation(), string3) || SecurityConnectionInterceptor.isSpecialSSLRequiredNamingMethod(clientRequestInfo.operation(), string3) || cSIv2EffectivePerformPolicy.getTargetTCPPort() != 0 && !cSIv2EffectivePerformPolicy.claimClientAuthenticationRequired() && ORB.isSpecialMethod((String)clientRequestInfo.operation()) && !this.csiUtil.isCORBAAuthRequired())) {
            string2 = "Special naming method or other corba special method. Return from interceptor.";
            SecurityLogger.debugMessage(string, string2);
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
            return false;
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
        return true;
    }

    protected Subject retrieveSubject(final String string, final CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy, final CSICredentialsManager cSICredentialsManager) {
        Subject subject;
        String string2;
        block29: {
            string2 = "CSIClientRIBase.retrieveSubject";
            String string3 = "";
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugEntry(string2);
            }
            String string4 = cSIv2EffectivePerformPolicy.getTargetHostName();
            CurrentImpl currentImpl = this.csiUtil.getCurrent();
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "Target Realm Name: " + string + ", Target Host: " + string4;
                SecurityLogger.debugMessage(string2, string3);
            }
            subject = null;
            if (cSIv2EffectivePerformPolicy.performIdentityAssertion()) {
                subject = (Subject)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public java.lang.Object run() {
                        return cSICredentialsManager.getInvocationSubject();
                    }
                });
            } else if (string != null && !string.equals("") && cSIv2EffectivePerformPolicy.getTargetHostName() != null && !cSIv2EffectivePerformPolicy.getTargetHostName().equals("")) {
                boolean bl = this.secConfig.validateBasicAuth();
                try {
                    if (cSIv2EffectivePerformPolicy.claimClientAuthenticationRequired()) {
                        this.secConfig.setValidateBasicAuth(false);
                    }
                    subject = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public java.lang.Object run() throws Exception {
                            return cSICredentialsManager.getClientSubject(string, cSIv2EffectivePerformPolicy.getTargetHostName());
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "431", (java.lang.Object)this);
                    Exception exception = privilegedActionException.getException();
                    SecurityLogger.logException(string2, exception, 0, 0);
                    throw new NO_PERMISSION(exception.getMessage(), 1229079296, CompletionStatus.COMPLETED_NO);
                }
                finally {
                    if (cSIv2EffectivePerformPolicy.claimClientAuthenticationRequired()) {
                        this.secConfig.setValidateBasicAuth(bl);
                    }
                }
            }
            if (subject != null) {
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                if (wSCredential.isUnauthenticated()) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "Encountered unauthenticated credential.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    if (!currentImpl.getAllowUnauthCredForAuthenticate() && !cSIv2EffectivePerformPolicy.performIdentityAssertion() && (this.secConfig.getCSIv2PerformClientAuthenticationRequired() || cSIv2EffectivePerformPolicy.claimClientAuthenticationRequired())) {
                        if (SecurityLogger.traceEnabled) {
                            string3 = "ERROR: Unauthenticated credential found, client auth required by client or server, throwing NO_PERMISSION.";
                            SecurityLogger.traceMessage(string2, string3);
                        }
                        throw new NO_PERMISSION(string3, 1229066386, CompletionStatus.COMPLETED_NO);
                    }
                    if (SecurityLogger.traceEnabled) {
                        string3 = "Unauthenticated credential found, client auth not required, sending out unauthenticated.";
                        SecurityLogger.traceMessage(string2, string3);
                    }
                    if (this.secConfig.processIsServer()) {
                        return subject;
                    }
                    return null;
                }
                try {
                    if (this.secConfig.processIsServer() && !ContextManagerFactory.getInstance().getWSCredTokenMapper().checkValidityOfAllTokensAndRefresh(subject)) {
                        if (SecurityLogger.traceEnabled) {
                            string3 = SecurityMessages.getMsgOrUseDefault("JSAS0030W", "JSAS0030W: Credentials are invalid. Trying unauthenticated login.");
                            SecurityLogger.traceMessage(string2, string3);
                        }
                        throw new NO_PERMISSION("Credentials have expired.", 1229079302, CompletionStatus.COMPLETED_NO);
                    }
                    break block29;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "515", (java.lang.Object)this);
                    string3 = "Java runtime exception.";
                    SecurityLogger.debugMessage(string2, string3);
                    SecurityLogger.logException(string2, exception, 0, 0);
                    throw new INTERNAL("Java runtime exception.  Exception = " + exception, 1229066417, CompletionStatus.COMPLETED_NO);
                }
            }
            if (SecurityLogger.traceEnabled) {
                string3 = SecurityMessages.getMsgOrUseDefault("JSAS0020W", "JSAS0020W: Unable to get credentials.");
                SecurityLogger.traceMessage(string2, string3);
            }
            if (this.secConfig.getCSIv2PerformClientAuthenticationRequired() || cSIv2EffectivePerformPolicy.claimClientAuthenticationRequired()) {
                if (SecurityLogger.traceEnabled) {
                    string3 = "ERROR: No credential found, client auth required by client or server, throwing NO_PERMISSION.";
                    SecurityLogger.traceMessage(string2, string3);
                }
                throw new NO_PERMISSION(string3, 1229066386, CompletionStatus.COMPLETED_NO);
            }
            if (SecurityLogger.traceEnabled) {
                string3 = "WARNING: No credential found, client auth not required, sending out unauthenticated.";
                SecurityLogger.traceMessage(string2, string3);
            }
            return null;
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
        return subject;
    }

    protected ClientSessionKey getClientSessionKey(String string, Subject subject, String string2, String string3, int n) {
        String string4 = "CSIClientRIBase.getClientSessionKey";
        String string5 = "";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string4);
        }
        ClientSessionKey clientSessionKey = null;
        try {
            String string6 = "";
            if (string3 != null) {
                string6 = string3 + ":" + n;
                if (SecurityLogger.traceEnabled) {
                    string5 = "localHostPort for client session key: " + string6;
                    SecurityLogger.traceMessage(string4, string5);
                }
            } else if (SecurityLogger.traceEnabled) {
                string5 = "Connection data is null, this may cause a problem with multi-thread stateful clients.";
                SecurityLogger.traceMessage(string4, string5);
            }
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            String string7 = null;
            if (this.secConfig.processIsServer()) {
                string7 = ContextManagerFactory.getInstance().getClientUniqueIDForOutboundRequests(subject);
            }
            if (string7 == null) {
                string7 = wSCredential.getRealmUniqueSecurityName();
            }
            clientSessionKey = new ClientSessionKey(string7, Integer.toString(wSCredential.hashCode()), new Long(wSCredential.getExpiration()).toString(), string, string2, string6);
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string4);
            }
            return clientSessionKey;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "634", (java.lang.Object)this);
            if (SecurityLogger.traceEnabled) {
                string5 = SecurityMessages.getMsgOrUseDefault("JSAS0030W", "JSAS0030W: Credentials are invalid. Trying unauthenticated login.");
                SecurityLogger.traceMessage(string4, string5);
            }
            SecurityLogger.logException(string4, exception, 0, 0);
            throw new NO_PERMISSION("Credentials have expired.  Exception = " + exception, 1229079302, CompletionStatus.COMPLETED_NO);
        }
    }

    protected SessionEntry determineStatefulContextID(String string, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy, SessionManager sessionManager, ClientRequestInfo clientRequestInfo, Subject subject, String string2, String string3, int n) {
        String string4 = "CSIClientRIBase.determineStatefulContextID";
        String string5 = "";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string4);
        }
        int n2 = 5;
        CurrentImpl currentImpl = this.csiUtil.getCurrent();
        ClientSessionKey clientSessionKey = null;
        clientSessionKey = this.getClientSessionKey(string, subject, string2, string3, n);
        cSIv2EffectivePerformPolicy.setClientSessionKey(clientSessionKey);
        SessionEntry sessionEntry = sessionManager.csi_client_session_lookup(clientSessionKey);
        if (sessionEntry != null) {
            long l = sessionEntry.get_client_context_id();
            n2 = sessionEntry.get_session_state();
            switch (n2) {
                case 4: {
                    if (SecurityLogger.debugTraceEnabled) {
                        string5 = "Session state:  SESSION_NEW.  Proceeding to authenticate in stateful mode.";
                        SecurityLogger.debugMessage(string4, string5);
                    }
                    sessionEntry.set_session_state(2);
                    return sessionEntry;
                }
                case 2: {
                    if (SecurityLogger.debugTraceEnabled) {
                        string5 = "Session state:  SESSION_IN_INCOMPLETE_STATE.  Proceeding to authenticate in stateless mode.";
                        SecurityLogger.debugMessage(string4, string5);
                    }
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string4);
                    }
                    sessionEntry.set_renegotiate_to_stateless();
                    return sessionEntry;
                }
                case 6: {
                    EstablishContext establishContext;
                    if (SecurityLogger.debugTraceEnabled) {
                        string5 = "Session state:  SESSION_AUTHENTICATING.  Proceeding to EstablishContext in stateful mode.";
                        SecurityLogger.debugMessage(string4, string5);
                    }
                    if ((establishContext = sessionEntry.get_ec_message()) != null) {
                        this.csiUtil.print_ec_message(establishContext, string4);
                    }
                    org.omg.IOP.ServiceContext serviceContext = null;
                    if (establishContext != null) {
                        serviceContext = this.csiUtil.create_sc_from_ec_message(establishContext);
                    }
                    if (serviceContext != null) {
                        clientRequestInfo.add_request_service_context(serviceContext, true);
                        cSIv2EffectivePerformPolicy.setStatefulContextID(sessionEntry.get_client_context_id());
                        cSIv2EffectivePerformPolicy.setClientSessionKey(clientSessionKey);
                        this.csiUtil.getVault().put_effective_policy(clientRequestInfo.request_id(), cSIv2EffectivePerformPolicy);
                        this.csiUtil.setUnauthenticatedToNullIfNeeded();
                        if (SecurityLogger.debugTraceEnabled) {
                            string5 = "*** SENDING REQUEST ***";
                            SecurityLogger.debugMessage(string4, string5);
                        }
                        if (SecurityLogger.debugEntryEnabled) {
                            SecurityLogger.debugExit(string4);
                        }
                        return null;
                    }
                    if (SecurityLogger.debugTraceEnabled) {
                        string5 = "Service context not available in existing session.  Going out in stateless mode.";
                        SecurityLogger.debugMessage(string4, string5);
                    }
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string4);
                    }
                    sessionEntry.set_renegotiate_to_stateless();
                    return sessionEntry;
                }
                case 1: {
                    if (SecurityLogger.debugTraceEnabled) {
                        string5 = "Session state:  SESSION_IN_COMPLETE_STATE.  Proceeding with MessageInContext.";
                        SecurityLogger.debugMessage(string4, string5);
                    }
                    boolean bl = false;
                    MessageInContext messageInContext = new MessageInContext(sessionEntry.get_client_context_id(), bl);
                    this.csiUtil.print_mic_message(messageInContext, string4);
                    org.omg.IOP.ServiceContext serviceContext = null;
                    if (messageInContext != null) {
                        serviceContext = this.csiUtil.create_sc_from_mic_message(messageInContext);
                    }
                    if (serviceContext != null) {
                        clientRequestInfo.add_request_service_context(serviceContext, true);
                        cSIv2EffectivePerformPolicy.setStatefulContextID(sessionEntry.get_client_context_id());
                        cSIv2EffectivePerformPolicy.setClientSessionKey(clientSessionKey);
                        this.csiUtil.getVault().put_effective_policy(clientRequestInfo.request_id(), cSIv2EffectivePerformPolicy);
                        this.csiUtil.setUnauthenticatedToNullIfNeeded();
                        if (SecurityLogger.debugTraceEnabled) {
                            string5 = "*** SENDING REQUEST ***";
                            SecurityLogger.debugMessage(string4, string5);
                        }
                        if (SecurityLogger.debugEntryEnabled) {
                            SecurityLogger.debugExit(string4);
                        }
                        return null;
                    }
                    if (SecurityLogger.debugTraceEnabled) {
                        string5 = "Service context not available.  Going out in stateless mode.";
                        SecurityLogger.debugMessage(string4, string5);
                    }
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string4);
                    }
                    sessionEntry.set_renegotiate_to_stateless();
                    return sessionEntry;
                }
            }
            if (SecurityLogger.debugTraceEnabled) {
                string5 = "Session state:  INVALID STATE.  Proceeding to authenticate in stateless mode.";
                SecurityLogger.debugMessage(string4, string5);
            }
            sessionEntry.set_session_state(7);
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string4);
            }
            sessionEntry.set_renegotiate_to_stateless();
            return sessionEntry;
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string4);
        }
        sessionEntry.set_client_context_id(0L);
        return sessionEntry;
    }

    protected SessionEntry determineStatefulContextIDForCFW(ClientSessionKey clientSessionKey, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy, GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext) throws ForwardRequest {
        String string = "CSIClientRIBase.determineStatefulContextIDForCFW";
        String string2 = "";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        int n = 5;
        if (this.sessionMgr == null) {
            this.sessionMgr = VaultImpl.getInstance().getSessionManager();
        }
        SessionEntry sessionEntry = null;
        if (cSIv2EffectivePerformPolicy.isStateful()) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Creating a stateful session.";
                SecurityLogger.debugMessage(string, string2);
            }
            sessionEntry = this.sessionMgr.csi_client_session_lookup(clientSessionKey);
        } else {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Creating a stateless session.";
                SecurityLogger.debugMessage(string, string2);
            }
            sessionEntry = new SessionEntry(0L);
        }
        if (sessionEntry != null) {
            sessionEntry.set_effective_policy(cSIv2EffectivePerformPolicy);
            long l = sessionEntry.get_client_context_id();
            n = sessionEntry.get_session_state();
            sessionEntry.set_client_session_key(clientSessionKey);
            switch (n) {
                case 4: {
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Session state:  SESSION_NEW.  Proceeding to authenticate in stateful mode.";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    sessionEntry.set_session_state(2);
                    Object object = null;
                    try {
                        byte[] byArray = sessionEntry.getBytes();
                        ServiceContext serviceContext = new ServiceContext(1229081892, byArray);
                        try {
                            ServiceContextList serviceContextList = gIOPMessageContext.getServiceContexts();
                            if (serviceContextList != null) {
                                serviceContextList.add((com.ibm.CORBA.iiop.ServiceContext)serviceContext, true);
                                gIOPMessageContext.setServiceContexts(serviceContextList);
                            }
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                        object = this.getCurrentObjectFromGIOPMessageContext(gIOPMessageContext);
                    }
                    catch (Exception exception) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "Could not get session bytes to create private service context.";
                            SecurityLogger.debugMessage(string, string2);
                        }
                        SecurityLogger.logException(string, exception, 0, 0);
                        throw new NO_PERMISSION(string2);
                    }
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string);
                    }
                    throw new ForwardRequest(object);
                }
                case 1: {
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Session state:  SESSION_IN_COMPLETE_STATE.  Proceeding with MessageInContext.";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    boolean bl = false;
                    MessageInContext messageInContext = new MessageInContext(sessionEntry.get_client_context_id(), bl);
                    this.csiUtil.print_mic_message(messageInContext, string);
                    org.omg.IOP.ServiceContext serviceContext = null;
                    if (messageInContext != null) {
                        serviceContext = this.csiUtil.create_sc_from_mic_message(messageInContext);
                    }
                    if (serviceContext != null) {
                        ServiceContext serviceContext2 = new ServiceContext(serviceContext.context_id, serviceContext.context_data);
                        try {
                            ServiceContextList serviceContextList = gIOPMessageContext.getServiceContexts();
                            if (serviceContextList != null) {
                                serviceContextList.add((com.ibm.CORBA.iiop.ServiceContext)serviceContext2, true);
                                gIOPMessageContext.setServiceContexts(serviceContextList);
                            }
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "*** SENDING REQUEST ***";
                            SecurityLogger.debugMessage(string, string2);
                        }
                        if (SecurityLogger.debugEntryEnabled) {
                            SecurityLogger.debugExit(string);
                        }
                        return sessionEntry;
                    }
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Service context not available.  Going out in stateless mode.";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string);
                    }
                    sessionEntry = new SessionEntry(0L);
                    sessionEntry.set_renegotiate_to_stateless();
                    sessionEntry.set_client_session_key(clientSessionKey);
                    sessionEntry.set_effective_policy(cSIv2EffectivePerformPolicy);
                    Object object = null;
                    try {
                        byte[] byArray = sessionEntry.getBytes();
                        ServiceContext serviceContext3 = new ServiceContext(1229081892, byArray);
                        try {
                            ServiceContextList serviceContextList = gIOPMessageContext.getServiceContexts();
                            if (serviceContextList != null) {
                                serviceContextList.add((com.ibm.CORBA.iiop.ServiceContext)serviceContext3, true);
                                gIOPMessageContext.setServiceContexts(serviceContextList);
                            }
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                        object = this.getCurrentObjectFromGIOPMessageContext(gIOPMessageContext);
                    }
                    catch (Exception exception) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "Could not get session bytes to create private service context.";
                            SecurityLogger.debugMessage(string, string2);
                            SecurityLogger.logException(string, exception, 0, 0);
                        }
                        throw new NO_PERMISSION(string2);
                    }
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string);
                    }
                    throw new ForwardRequest(object);
                }
                case 6: {
                    EstablishContext establishContext;
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Session state:  SESSION_AUTHENTICATING.  Proceeding to EstablishContext in stateful mode.";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    if ((establishContext = sessionEntry.get_ec_message()) != null) {
                        this.csiUtil.print_ec_message(establishContext, string);
                    }
                    org.omg.IOP.ServiceContext serviceContext = null;
                    if (establishContext != null) {
                        serviceContext = this.csiUtil.create_sc_from_ec_message(establishContext);
                    }
                    if (serviceContext != null) {
                        ServiceContext serviceContext4 = new ServiceContext(serviceContext.context_id, serviceContext.context_data);
                        try {
                            ServiceContextList serviceContextList = gIOPMessageContext.getServiceContexts();
                            if (serviceContextList != null) {
                                serviceContextList.add((com.ibm.CORBA.iiop.ServiceContext)serviceContext4, true);
                                gIOPMessageContext.setServiceContexts(serviceContextList);
                            }
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                    }
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string);
                    }
                    return sessionEntry;
                }
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Session state:  SESSION_IN_INCOMPLETE_STATE, SESSION_AUTHENTICATING, or state unknown -> proceeding to authenticate in stateless mode.";
                SecurityLogger.debugMessage(string, string2);
            }
            sessionEntry = new SessionEntry(0L);
            sessionEntry.set_renegotiate_to_stateless();
            sessionEntry.set_effective_policy(cSIv2EffectivePerformPolicy);
            sessionEntry.set_client_session_key(clientSessionKey);
            sessionEntry.set_session_state(2);
            Object object = null;
            try {
                byte[] byArray = sessionEntry.getBytes();
                ServiceContext serviceContext = new ServiceContext(1229081892, byArray);
                try {
                    ServiceContextList serviceContextList = gIOPMessageContext.getServiceContexts();
                    if (serviceContextList != null) {
                        serviceContextList.add((com.ibm.CORBA.iiop.ServiceContext)serviceContext, true);
                        gIOPMessageContext.setServiceContexts(serviceContextList);
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                object = this.getCurrentObjectFromGIOPMessageContext(gIOPMessageContext);
            }
            catch (Exception exception) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Could not get session bytes to create private service context.";
                    SecurityLogger.debugMessage(string, string2);
                    SecurityLogger.logException(string, exception, 0, 0);
                }
                throw new NO_PERMISSION(string2);
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
            throw new ForwardRequest(object);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "No session available, throw exception.";
            SecurityLogger.debugMessage(string, string2);
        }
        throw new NO_PERMISSION("Cannot generate a client session");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilterSendRequest(GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext, ConnectionStateElement connectionStateElement) throws Exception {
        block21: {
            block22: {
                block23: {
                    java.lang.Object object;
                    com.ibm.CORBA.iiop.ServiceContext serviceContext;
                    SessionEntry sessionEntry;
                    SecurityExecutionEnvironment securityExecutionEnvironment;
                    ClientSessionKey clientSessionKey;
                    CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy;
                    int n;
                    block20: {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "doFilterSendRequest");
                        }
                        n = gIOPMessageContext.getRequestId();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Request ID: " + Integer.toString(n));
                        }
                        cSIv2EffectivePerformPolicy = null;
                        clientSessionKey = null;
                        securityExecutionEnvironment = null;
                        sessionEntry = null;
                        serviceContext = null;
                        com.ibm.CORBA.iiop.ServiceContext serviceContext2 = null;
                        try {
                            serviceContext2 = gIOPMessageContext.getServiceContexts().get(1229081892);
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                        try {
                            serviceContext = gIOPMessageContext.getServiceContexts().get(1229081891);
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                        if (serviceContext2 == null) break block20;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found session context on filter second pass.  Updating session.");
                        }
                        if ((object = new SessionEntry(serviceContext2.getContextData())) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding session to table using request ID: " + n);
                            }
                            this.sessionRequestTable.put(Integer.toString(n), object);
                        }
                        this.updateSessionFromSR((SessionEntry)object, gIOPConnectionContext, gIOPMessageContext);
                        break block21;
                    }
                    if (serviceContext == null) break block22;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found seed context on filter first pass.  Creating session.");
                    }
                    if ((securityExecutionEnvironment = SecurityExecutionEnvironment.createFromBytes(serviceContext.getContextData())) == null) break block23;
                    cSIv2EffectivePerformPolicy = this.getEffectivePolicyFromIOR(gIOPMessageContext);
                    if (cSIv2EffectivePerformPolicy != null) {
                        String string = null;
                        string = gIOPConnectionContext.getLocalHost();
                        GIOPConnectionInfo gIOPConnectionInfo = gIOPConnectionContext.getGIOPConnectionInfo();
                        int n2 = gIOPConnectionInfo.getLocalPort();
                        object = RealmSecurityName.getRealm(cSIv2EffectivePerformPolicy.getTargetSecurityName());
                        ConnectionHandle connectionHandle = connectionStateElement.getConnectionHandle();
                        if (connectionHandle != null && connectionHandle.getIsLocalComm()) {
                            cSIv2EffectivePerformPolicy.setConnectionKey(connectionHandle.toString());
                            string = "";
                            n2 = 0;
                        }
                        String string2 = cSIv2EffectivePerformPolicy.getConnectionKey();
                        String string3 = string + ":" + n2;
                        clientSessionKey = new ClientSessionKey(securityExecutionEnvironment.getClientUniqueId(), "", Long.toString(securityExecutionEnvironment.getCredentialExpiration()), (String)object, string2, string3);
                        sessionEntry = this.determineStatefulContextIDForCFW(clientSessionKey, cSIv2EffectivePerformPolicy, gIOPConnectionContext, gIOPMessageContext);
                        if (sessionEntry != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found a valid session, sending the request.");
                            }
                            this.sessionRequestTable.put(Integer.toString(n), sessionEntry);
                        }
                        break block21;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not get an effective policy from the IOR.  Treating as if NO CSIv2 tags present in IOR (unauthenticated).");
                    }
                    break block21;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not recreate seed.  Throwing NO_PERMISSION.");
                }
                throw new INTERNAL("Error deserializing security execution environment.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This is an unauthenticated request, no session processing needed in filter.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** SENDING REQUEST ***");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doFilterSendRequest");
        }
    }

    CSIv2EffectivePerformPolicy getEffectivePolicyFromIOR(GIOPMessageContext gIOPMessageContext) throws Exception {
        CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEffectivePolicyFromIOR", gIOPMessageContext);
            }
            cSIv2EffectivePerformPolicy = null;
            try {
                IOR iOR = gIOPMessageContext.getCurrentIOR();
                if (iOR == null) {
                    iOR = gIOPMessageContext.getTargetIOR();
                }
                if (iOR == null) {
                    iOR = gIOPMessageContext.getInitialIOR();
                }
                if (iOR != null) {
                    cSIv2EffectivePerformPolicy = this.getEffectivePolicyFromIOR(iOR);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Unable to acquire IOR from GIOP message context", unsupportedOperationException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectivePolicyFromIOR", cSIv2EffectivePerformPolicy);
        }
        return cSIv2EffectivePerformPolicy;
    }

    CSIv2EffectivePerformPolicy getEffectivePolicyFromIOR(IOR iOR) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectivePolicyFromIOR", iOR);
        }
        CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy = null;
        CSIv2TaggedComponent[] cSIv2TaggedComponentArray = CSIv2TaggedComponent.getCSIv2TaggedComponentList(iOR.getProfile(), iOR);
        if (cSIv2TaggedComponentArray != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found CSIv2 tagged component, getting policy from cache or building new one.");
            }
            cSIv2EffectivePerformPolicy = CSIv2EffectivePerformPolicy.getInstance(cSIv2TaggedComponentArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectivePolicyFromIOR", cSIv2EffectivePerformPolicy);
        }
        return cSIv2EffectivePerformPolicy;
    }

    public void doFilterReceiveReply(GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext, ConnectionStateElement connectionStateElement) throws Exception {
        SessionEntry sessionEntry;
        String string = "CSIClientRIForSR.doFilterReceiveReply";
        String string2 = "";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        java.lang.Object var6_6 = null;
        int n = 0;
        n = gIOPMessageContext.getRequestId();
        String string3 = Integer.toString(n);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Request ID: " + string3);
        }
        if ((sessionEntry = (SessionEntry)this.sessionRequestTable.get(string3)) != null) {
            boolean bl;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Session entry for reply: " + sessionEntry);
            }
            this.sessionRequestTable.remove(string3);
            long l = sessionEntry.get_client_context_id();
            boolean bl2 = bl = !sessionEntry.get_renegotiate_to_stateless() && l != 0L;
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Session is stateless, returning without any updates.");
                }
                if (SecurityLogger.debugEntryEnabled) {
                    SecurityLogger.debugExit(string);
                }
                return;
            }
            com.ibm.CORBA.iiop.ServiceContext serviceContext = null;
            SASContextBody sASContextBody = null;
            serviceContext = this.csiUtil.get_sc_from_reply(gIOPMessageContext);
            if (serviceContext != null) {
                sASContextBody = this.csiUtil.get_message_from_sc(serviceContext);
            }
            if (sASContextBody != null && sASContextBody.discriminator() == 1) {
                this.csiUtil.print_cec_message(sASContextBody.complete_msg(), string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Updating stateful session as MTCompleteEstablishContext for ID: " + l);
                }
                this.sessionMgr.csi_client_session_complete(sASContextBody, bl, l, sessionEntry.get_client_session_key());
            } else if (sASContextBody != null && sASContextBody.discriminator() == 4) {
                this.csiUtil.print_ce_message(sASContextBody.error_msg(), string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Updating stateful session as MTContextError for ID: " + l);
                }
                this.sessionMgr.csi_client_session_complete_exception(sASContextBody, bl, sessionEntry.get_client_session_key());
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected message type.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Session is not found for request ID, returning without any updates.");
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    protected void updateSessionFromSR(SessionEntry sessionEntry, GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext) throws ForwardRequest {
        String string = "CSIClientRIBase.updateSessionFromSR";
        String string2 = "";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        if (sessionEntry.get_client_context_id() == 0L || sessionEntry.get_renegotiate_to_stateless()) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Session is stateless, returning without any updates.";
                SecurityLogger.debugMessage(string, string2);
            }
            return;
        }
        int n = 5;
        SessionEntry sessionEntry2 = this.sessionMgr.csi_client_session_lookup(sessionEntry.get_client_session_key());
        if (sessionEntry2 != null) {
            n = sessionEntry.get_session_state();
            switch (n) {
                case 4: {
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Invalid session state:  SESSION_NEW.";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string);
                    }
                    throw new NO_PERMISSION(string2);
                }
                case 2: {
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Invalid session state:  SESSION_IN_INCOMPLETE_STATE.";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string);
                    }
                    throw new NO_PERMISSION(string2);
                }
                case 6: {
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Session state:  SESSION_AUTHENTICATING.  Proceeding to EstablishContext in stateful mode.";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    this.sessionMgr.update_client_session(sessionEntry.get_client_session_key(), sessionEntry);
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string);
                    }
                    return;
                }
                case 1: {
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Session state:  SESSION_IN_COMPLETE_STATE.  Proceeding with MessageInContext.";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    this.sessionMgr.update_client_session(sessionEntry.get_client_session_key(), sessionEntry);
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(string);
                    }
                    return;
                }
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Session state:  INVALID STATE.  Proceeding to authenticate in stateless mode.";
                SecurityLogger.debugMessage(string, string2);
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
            throw new NO_PERMISSION(string2);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Session passed in is null, could be unauthenticated request.";
            SecurityLogger.debugMessage(string, string2);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
    }

    Object getCurrentObjectFromGIOPMessageContext(GIOPMessageContext gIOPMessageContext) {
        String string = "CSIClientRIBase.getCurrentObjectFromGIOPMessageContext";
        String string2 = "";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        IOR iOR = gIOPMessageContext.getCurrentIOR();
        Object object = this.orb.IORToObject(iOR);
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
        return object;
    }

    protected Subject mapOutboundOrCreateOAT(Subject subject, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy) {
        String string = "CSIClientRIBase.mapOutboundOrCreateOAT";
        String string2 = "";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        Subject subject2 = subject;
        try {
            java.lang.Object object;
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Going into outbound login config.  Outbound login: " + this.secConfig.isRMIOutboundLoginEnabled() + ", Authz Token: " + cSIv2EffectivePerformPolicy.performAuthorizationToken();
                SecurityLogger.debugMessage(string, string2);
            }
            CSIv2PerformPolicy cSIv2PerformPolicy = new CSIv2PerformPolicy(cSIv2EffectivePerformPolicy);
            final Subject subject3 = subject2;
            if (this.secConfig.processIsServer() || this.secConfig.isRMIOutboundLoginEnabled()) {
                object = this.secConfig;
                subject2 = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((SecurityConfiguration)object, cSIv2PerformPolicy){
                    private final /* synthetic */ SecurityConfiguration val$secConfigPriv;
                    private final /* synthetic */ CSIv2PerformPolicy val$csiv2PerformPolicy;
                    {
                        this.val$secConfigPriv = securityConfiguration;
                        this.val$csiv2PerformPolicy = cSIv2PerformPolicy;
                    }

                    public java.lang.Object run() throws WSLoginFailedException {
                        Subject subject = SubjectHelper.createNewSubjectFromExisting(subject3);
                        return ContextManagerFactory.getInstance().login(this.val$secConfigPriv.getRMIOutboundLoginConfig(), this.val$csiv2PerformPolicy, subject);
                    }
                });
            } else {
                subject2 = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws WSLoginFailedException {
                        Subject subject = SubjectHelper.createNewSubjectFromExisting(subject3);
                        byte[] byArray = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(subject3);
                        if (byArray != null) {
                            TokenHolder tokenHolder = new TokenHolder(byArray, WSOpaqueTokenHelper.getInstance().getOpaqueTokenName(), WSOpaqueTokenHelper.getInstance().getOpaqueTokenVersion());
                            subject.getPrivateCredentials().add(tokenHolder);
                        }
                        return subject;
                    }
                });
            }
            if (SecurityLogger.debugTraceEnabled) {
                object = subject2;
                string2 = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((Subject)object){
                    private final /* synthetic */ Subject val$newSubjectPriv;
                    {
                        this.val$newSubjectPriv = subject;
                    }

                    public java.lang.Object run() {
                        String string = "Subject with opaque token: " + this.val$newSubjectPriv;
                        return string;
                    }
                });
                SecurityLogger.debugMessage(string, string2);
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "1719", (java.lang.Object)this);
            Exception exception = privilegedActionException.getException();
            SecurityLogger.logException(string, exception, 0, 0);
            throw new NO_PERMISSION("Problem occurred in credential mapping or attribute propagation.  Exception = " + exception.toString(), 1229079296, CompletionStatus.COMPLETED_NO);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "1727", (java.lang.Object)this);
            string2 = "Java runtime exception.";
            SecurityLogger.debugMessage(string, string2);
            SecurityLogger.logException(string, exception, 0, 0);
            throw new INTERNAL("Java runtime exception.  Exception = " + exception.toString(), 1229066417, CompletionStatus.COMPLETED_NO);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
        return subject2;
    }

    protected SecurityContextImpl determineSecurityContextType(Subject subject, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy, String string, SessionManager sessionManager, SessionEntry sessionEntry) {
        String string2 = "CSIClientRIBase.determineSecurityContextType";
        String string3 = "";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string2);
        }
        SecurityContextImpl securityContextImpl = null;
        long l = cSIv2EffectivePerformPolicy.getStatefulContextID();
        ClientSessionKey clientSessionKey = cSIv2EffectivePerformPolicy.getClientSessionKey();
        try {
            String string4 = null;
            String string5 = null;
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            if (wSCredential != null) {
                try {
                    string5 = wSCredential.getOID();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "1781", (java.lang.Object)this);
                    if (SecurityLogger.traceEnabled) {
                        string3 = SecurityMessages.getMsgOrUseDefault("JSAS0030W", "JSAS0030W: Credentials are invalid. Trying unauthenticated login.");
                        SecurityLogger.traceMessage(string2, string3);
                    }
                    SecurityLogger.logException(string2, exception, 0, 0);
                    throw new NO_PERMISSION("Credentials have expired.  Exception = " + exception, 1229079302, CompletionStatus.COMPLETED_NO);
                }
            }
            if (string5 == null) {
                string5 = cSIv2EffectivePerformPolicy.getPerformClientAuthMechOID();
            }
            if (OID.compareOIDs(string5, "oid:2.23.130.1.1.1")) {
                string4 = VaultConstants.GSSUP_MECH_TYPE;
            } else if (OID.compareOIDs(string5, this.secConfig.getWSSecurityContextCustomOID())) {
                string4 = VaultConstants.CUSTOM_MECH_TYPE;
            } else if (OID.compareOIDs(string5, "oid:1.3.18.0.2.30.2")) {
                string4 = VaultConstants.LTPA_MECH_TYPE;
            } else if (OID.compareOIDs(string5, "oid:1.2.840.113554.1.2.2")) {
                string4 = VaultConstants.KRB5_MECH_TYPE;
            } else {
                String[] stringArray = cSIv2EffectivePerformPolicy.getPerformIDANamingMechList();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (OID.compareOIDs(stringArray[i], "oid:2.23.130.1.1.1")) {
                            string4 = VaultConstants.GSSUP_MECH_TYPE;
                            continue;
                        }
                        if (OID.compareOIDs(stringArray[i], this.secConfig.getWSSecurityContextCustomOID())) {
                            string4 = VaultConstants.CUSTOM_MECH_TYPE;
                            continue;
                        }
                        if (OID.compareOIDs(stringArray[i], "oid:1.2.840.113554.1.2.2")) {
                            string4 = VaultConstants.KRB5_MECH_TYPE;
                            continue;
                        }
                        if (!OID.compareOIDs(stringArray[i], "oid:1.3.18.0.2.30.2")) continue;
                        string4 = VaultConstants.LTPA_MECH_TYPE;
                    }
                }
                if (string4 == null) {
                    string4 = VaultConstants.GSSUP_MECH_TYPE;
                }
            }
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "Creating " + string4 + " security context.";
                SecurityLogger.debugMessage(string2, string3);
            }
            securityContextImpl = this._mechanismFactory.getSecurityContext(string4, string);
        }
        catch (MechanismAmbiguityException mechanismAmbiguityException) {
            FFDCFilter.processException((Throwable)mechanismAmbiguityException, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "1841", (java.lang.Object)this);
            string3 = "security.JSAS0120E";
            SecurityLogger.logError(string3, new java.lang.Object[]{string2, mechanismAmbiguityException});
            if (cSIv2EffectivePerformPolicy.isStateful() && sessionEntry != null && l != 0L) {
                sessionManager.csi_client_session_status_update(l, clientSessionKey, 7);
                sessionEntry.set_session_state(7);
            }
            throw new NO_PERMISSION(string3 + "  Original exception = " + mechanismAmbiguityException, 1229066387, CompletionStatus.COMPLETED_NO);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
        return securityContextImpl;
    }

    /*
     * Unable to fully structure code
     */
    protected void setIdentityToken(IdentityToken var1_1, Subject var2_2, CSIv2EffectivePerformPolicy var3_3, SessionManager var4_4, SessionEntry var5_5) {
        block57: {
            block67: {
                block68: {
                    block65: {
                        block66: {
                            block63: {
                                block64: {
                                    block60: {
                                        block62: {
                                            block61: {
                                                block58: {
                                                    block59: {
                                                        block56: {
                                                            var6_6 = "CSIClientRIBase.determineSecurityContextType";
                                                            var7_7 = "";
                                                            if (SecurityLogger.debugEntryEnabled) {
                                                                SecurityLogger.debugEntry(var6_6);
                                                            }
                                                            var8_8 = var3_3.getStatefulContextID();
                                                            var10_9 = var3_3.getClientSessionKey();
                                                            var11_10 = var3_3.performIdentityAssertion();
                                                            var12_11 = SubjectHelper.getWSCredentialFromSubject(var2_2);
                                                            if (var11_10) break block56;
                                                            var1_1.absent(true);
                                                            if (SecurityLogger.debugTraceEnabled) {
                                                                var7_7 = "Identity Assertion set to absent.";
                                                                SecurityLogger.debugMessage(var6_6, var7_7);
                                                            }
                                                            break block57;
                                                        }
                                                        if (!var11_10 || var12_11 != null && !var12_11.isUnauthenticated()) break block58;
                                                        if ((var3_3.getPerformIdentityTokenType() & 1) == 0) break block59;
                                                        if (SecurityLogger.debugTraceEnabled) {
                                                            var7_7 = "Identity Assertion set to anonymous: ";
                                                            SecurityLogger.debugMessage(var6_6, var7_7);
                                                        }
                                                        var1_1.anonymous(true);
                                                        break block57;
                                                    }
                                                    var7_7 = "security.JSAS0489E";
                                                    SecurityLogger.logError(var7_7, new java.lang.Object[]{var6_6});
                                                    throw new NO_PERMISSION(var7_7, 1229066387, CompletionStatus.COMPLETED_NO);
                                                }
                                                if (!var11_10) break block57;
                                                var13_12 = null;
                                                var14_13 = null;
                                                try {
                                                    var15_14 = new PrivilegedExceptionAction(){

                                                        public java.lang.Object run() throws WSLoginFailedException, CredentialDestroyedException, CredentialExpiredException {
                                                            return var12_11.get("wssecurity.identity_name");
                                                        }
                                                    };
                                                    var16_17 = new PrivilegedExceptionAction(){

                                                        public java.lang.Object run() throws WSLoginFailedException, CredentialDestroyedException, CredentialExpiredException {
                                                            return var12_11.get("wssecurity.identity_value");
                                                        }
                                                    };
                                                    try {
                                                        var13_12 = (String)AccessController.doPrivileged((PrivilegedExceptionAction)var15_14);
                                                        var14_13 = (byte[])AccessController.doPrivileged((PrivilegedExceptionAction)var16_17);
                                                        if (var13_12 == null) {
                                                            var13_12 = "ClientAuthenticationToken";
                                                            var14_13 = StringBytesConversion.getConvertedBytes(var12_11.getRealmSecurityName());
                                                        }
                                                    }
                                                    catch (PrivilegedActionException var17_19) {
                                                        if (SecurityLogger.debugTraceEnabled) {
                                                            var7_7 = "Exception occurred: " + var17_19.getException().getMessage();
                                                            SecurityLogger.debugMessage(var6_6, var7_7);
                                                            SecurityLogger.traceException(var6_6, var17_19.getException(), 0, 0);
                                                        }
                                                        FFDCFilter.processException((Throwable)var17_19.getException(), "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "1961", (java.lang.Object)this);
                                                        throw var17_19.getException();
                                                    }
                                                }
                                                catch (Exception var15_15) {
                                                    FFDCFilter.processException((Throwable)var15_15, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "1967", (java.lang.Object)this);
                                                    var7_7 = "Cannot get Identity Values: ";
                                                    SecurityLogger.logActivity(var6_6, 0, var7_7);
                                                    if (var3_3.isStateful() && var5_5 != null && var8_8 != 0L) {
                                                        var4_4.csi_client_session_status_update(var8_8, var10_9, 7);
                                                        var5_5.set_session_state(7);
                                                    }
                                                    throw new NO_PERMISSION(var7_7 + "  Original exception = " + var15_15, 1229066386, CompletionStatus.COMPLETED_NO);
                                                }
                                                var15_16 = false;
                                                var16_18 = false;
                                                var17_20 = false;
                                                var18_21 = var3_3.getPerformIDANamingMechList();
                                                if (var18_21 == null) {
                                                    var16_18 = true;
                                                } else {
                                                    for (var19_22 = 0; var19_22 < var18_21.length; ++var19_22) {
                                                        if (OID.compareOIDs(var18_21[var19_22], "oid:2.23.130.1.1.1")) {
                                                            var16_18 = true;
                                                        }
                                                        if (OID.compareOIDs(var18_21[var19_22], "oid:1.2.840.113554.1.2.2")) {
                                                            var15_16 = true;
                                                        }
                                                        if (OID.compareOIDs(var18_21[var19_22], "oid:1.3.18.0.2.30.2")) {
                                                            var17_20 = true;
                                                        }
                                                        if (!SecurityLogger.debugTraceEnabled) continue;
                                                        var7_7 = "Mechanism available from target: " + var18_21[var19_22];
                                                        SecurityLogger.debugMessage(var6_6, var7_7);
                                                    }
                                                }
                                                if (SecurityLogger.debugTraceEnabled) {
                                                    var7_7 = "Identity Name in Credential: " + var13_12;
                                                    SecurityLogger.debugMessage(var6_6, var7_7);
                                                }
                                                if (!"ClientAuthenticationToken".equals(var13_12) && !"DeserializedSubjectIdentity".equals(var13_12)) break block60;
                                                var19_23 = new StringHolder();
                                                var20_24 = new OpaqueHolder();
                                                var21_25 = StringBytesConversion.getConvertedString(var14_13);
                                                var22_26 = RealmSecurityName.getRealm(var21_25);
                                                var23_27 = RealmSecurityName.getSecurityName(var21_25);
                                                v0 = var24_28 = this.secConfig.assertLDAPShortName() == false && this.secConfig.getActiveUserRegistry().equals("LDAP") != false && (var3_3.getPerformIdentityTokenType() & 8) != 0 && this.secConfig.getIsUseRegistryServerId() != false;
                                                if (SecurityLogger.debugTraceEnabled) {
                                                    var7_7 = "performDNAssertion: " + var24_28;
                                                    SecurityLogger.debugMessage(var6_6, var7_7);
                                                }
                                                if (var24_28 || (var3_3.getPerformIdentityTokenType() & 2) == 0) break block61;
                                                try {
                                                    var25_29 = this.orb.create_any();
                                                    var26_35 = null;
                                                    var27_37 = null;
                                                    if (var16_18) {
                                                        if (var23_27 != null && var23_27.length() > 0 && var23_27.indexOf("@") > -1) {
                                                            var28_39 = var23_27.length();
                                                            var29_41 = new StringBuffer(2 * var28_39);
                                                            var30_42 = ' ';
                                                            for (var31_43 = 0; var31_43 < var28_39; ++var31_43) {
                                                                var30_42 = var23_27.charAt(var31_43);
                                                                if (var30_42 == '@') {
                                                                    var29_41.append("\\").append(var30_42);
                                                                    continue;
                                                                }
                                                                var29_41.append(var30_42);
                                                            }
                                                            var23_27 = var29_41.toString();
                                                        }
                                                        var27_37 = new GSSFactory("oid:2.23.130.1.1.1");
                                                        if ((var22_26 == null || var22_26.equals("")) && var23_27 != null && !var23_27.equals("")) {
                                                            GSS_NT_ExportedNameHelper.insert(var25_29, var27_37.encodeExportedTargetName(var23_27));
                                                        } else if (var22_26 != null && !var22_26.equals("") && (var23_27 == null || var23_27.equals(""))) {
                                                            GSS_NT_ExportedNameHelper.insert(var25_29, var27_37.encodeExportedTargetName("@" + var22_26));
                                                        } else {
                                                            GSS_NT_ExportedNameHelper.insert(var25_29, var27_37.encodeExportedTargetName(var23_27 + "@" + var22_26));
                                                        }
                                                    } else if (!var15_16 && var17_20) {
                                                        var27_37 = new GSSFactory("oid:1.3.18.0.2.30.2");
                                                        GSS_NT_ExportedNameHelper.insert(var25_29, var27_37.encodeExportedTargetName(var21_25));
                                                    }
                                                    var26_35 = this.csiUtil.getCodec().encode_value(var25_29);
                                                    var1_1.principal_name(var26_35);
                                                }
                                                catch (Exception var25_30) {
                                                    FFDCFilter.processException((Throwable)var25_30, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "2094", (java.lang.Object)this);
                                                    var7_7 = "security.JSAS0622E";
                                                    SecurityLogger.logError(var7_7, new java.lang.Object[]{var6_6, var25_30});
                                                    if (var3_3.isStateful() && var5_5 != null && var8_8 != 0L) {
                                                        var4_4.csi_client_session_status_update(var8_8, var10_9, 7);
                                                        var5_5.set_session_state(7);
                                                    }
                                                    throw new NO_PERMISSION(var7_7 + "  Original exception = " + var25_30, 1229066386, CompletionStatus.COMPLETED_NO);
                                                }
                                                if (SecurityLogger.debugTraceEnabled) {
                                                    var7_7 = "Identity Assertion set to principal_name (clientAuthenticationToken): " + var23_27;
                                                    SecurityLogger.debugMessage(var6_6, var7_7);
                                                }
                                                break block57;
                                            }
                                            if (!var24_28) break block62;
                                            try {
                                                var21_25 = var12_11.getUniqueSecurityName();
                                                var23_27 = var12_11.getRealmUniqueSecurityName();
                                            }
                                            catch (Exception var25_31) {
                                                if (SecurityLogger.debugTraceEnabled) {
                                                    var7_7 = "Exception occurred getting unique security name from credential: " + var25_31.getMessage();
                                                    SecurityLogger.debugMessage(var6_6, var7_7);
                                                    SecurityLogger.traceException(var6_6, var25_31, 0, 0);
                                                }
                                                FFDCFilter.processException((Throwable)var25_31, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "2132", (java.lang.Object)this);
                                                throw new NO_PERMISSION(var7_7 + "  Original exception = " + var25_31, 1229066386, CompletionStatus.COMPLETED_NO);
                                            }
                                            try {
                                                var25_32 = this.orb.create_any();
                                                var26_36 = null;
                                                var27_38 = var21_25;
                                                var28_40 = (byte[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                                    public java.lang.Object run() throws Exception {
                                                        X509CertSelector x509CertSelector = new X509CertSelector();
                                                        x509CertSelector.setIssuer(var27_38);
                                                        return x509CertSelector.getIssuerAsBytes();
                                                    }
                                                });
                                                X501DistinguishedNameHelper.insert(var25_32, var28_40);
                                                var26_36 = this.csiUtil.getCodec().encode_value(var25_32);
                                                var1_1.dn(var26_36);
                                            }
                                            catch (PrivilegedActionException var25_33) {
                                                FFDCFilter.processException((Throwable)var25_33, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "2172", (java.lang.Object)this);
                                                var7_7 = "security.JSAS0622E";
                                                SecurityLogger.logError(var7_7, new java.lang.Object[]{var6_6, var25_33.getException()});
                                                if (var3_3.isStateful() && var5_5 != null && var8_8 != 0L) {
                                                    var4_4.csi_client_session_status_update(var8_8, var10_9, 7);
                                                    var5_5.set_session_state(7);
                                                }
                                                throw new NO_PERMISSION(var7_7 + "  Privileged exception = " + var25_33, 1229066386, CompletionStatus.COMPLETED_NO);
                                            }
                                            catch (Exception var25_34) {
                                                FFDCFilter.processException((Throwable)var25_34, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "2188", (java.lang.Object)this);
                                                var7_7 = "security.JSAS0622E";
                                                SecurityLogger.logError(var7_7, new java.lang.Object[]{var6_6, var25_34});
                                                if (var3_3.isStateful() && var5_5 != null && var8_8 != 0L) {
                                                    var4_4.csi_client_session_status_update(var8_8, var10_9, 7);
                                                    var5_5.set_session_state(7);
                                                }
                                                throw new NO_PERMISSION(var7_7 + "  Original exception = " + var25_34, 1229066386, CompletionStatus.COMPLETED_NO);
                                            }
                                            if (SecurityLogger.debugTraceEnabled) {
                                                var7_7 = "Identity Assertion set to DN name (clientAuthenticationToken): " + var21_25;
                                                SecurityLogger.debugMessage(var6_6, var7_7);
                                            }
                                            break block57;
                                        }
                                        var7_7 = "security.JSAS0490E";
                                        SecurityLogger.logError(var7_7, new java.lang.Object[]{var6_6});
                                        if (var3_3.isStateful() && var5_5 != null && var8_8 != 0L) {
                                            var4_4.csi_client_session_status_update(var8_8, var10_9, 7);
                                            var5_5.set_session_state(7);
                                        }
                                        throw new NO_PERMISSION(var7_7, 1229066387, CompletionStatus.COMPLETED_NO);
                                    }
                                    if (!"ClientCertificate".equals(var13_12)) break block63;
                                    if ((var3_3.getPerformIdentityTokenType() & 4) == 0) break block64;
                                    var1_1.certificate_chain(var14_13);
                                    if (SecurityLogger.debugTraceEnabled) {
                                        var7_7 = "Identity Assertion set to certificates (clientCertificate).";
                                        SecurityLogger.debugMessage(var6_6, var7_7);
                                    }
                                    break block57;
                                }
                                var7_7 = "security.JSAS0491E";
                                SecurityLogger.logError(var7_7, new java.lang.Object[]{var6_6});
                                if (var3_3.isStateful() && var5_5 != null && var8_8 != 0L) {
                                    var4_4.csi_client_session_status_update(var8_8, var10_9, 7);
                                    var5_5.set_session_state(7);
                                }
                                throw new NO_PERMISSION(var7_7, 1229066387, CompletionStatus.COMPLETED_NO);
                            }
                            if (!"ITTPrincipalName".equals(var13_12)) break block65;
                            if ((var3_3.getPerformIdentityTokenType() & 2) == 0) break block66;
                            var1_1.principal_name(var14_13);
                            if (SecurityLogger.debugTraceEnabled) {
                                var7_7 = "Identity Assertion set to principal_name (ITTPrincipalName): " + StringBytesConversion.getConvertedString(var14_13);
                                SecurityLogger.debugMessage(var6_6, var7_7);
                            }
                            break block57;
                        }
                        var7_7 = "security.JSAS0492E";
                        SecurityLogger.logError(var7_7, new java.lang.Object[]{var6_6});
                        if (var3_3.isStateful() && var5_5 != null && var8_8 != 0L) {
                            var4_4.csi_client_session_status_update(var8_8, var10_9, 7);
                            var5_5.set_session_state(7);
                        }
                        throw new NO_PERMISSION(var7_7, 1229066387, CompletionStatus.COMPLETED_NO);
                    }
                    if (!"ITTDistinguishedName".equals(var13_12)) break block67;
                    if ((var3_3.getPerformIdentityTokenType() & 8) == 0) break block68;
                    var1_1.dn(var14_13);
                    if (SecurityLogger.debugTraceEnabled) {
                        var7_7 = "Identity Assertion set to distinguished name (ITTDistinguishedName): " + StringBytesConversion.getConvertedString(var14_13);
                        SecurityLogger.debugMessage(var6_6, var7_7);
                    }
                    break block57;
                }
                var7_7 = "security.JSAS0493E";
                SecurityLogger.logError(var7_7, new java.lang.Object[]{var6_6});
                if (var3_3.isStateful() && var5_5 != null && var8_8 != 0L) {
                    var4_4.csi_client_session_status_update(var8_8, var10_9, 7);
                    var5_5.set_session_state(7);
                }
                throw new NO_PERMISSION(var7_7, 1229066387, CompletionStatus.COMPLETED_NO);
            }
            if (!"ITTX509CertChain".equals(var13_12)) ** GOTO lbl259
            if ((var3_3.getPerformIdentityTokenType() & 4) != 0) {
                var1_1.certificate_chain(var14_13);
                if (SecurityLogger.debugTraceEnabled) {
                    var7_7 = "Identity Assertion set to certificates (ITTX509CertChain).";
                    SecurityLogger.debugMessage(var6_6, var7_7);
                }
            } else {
                var7_7 = "security.JSAS0491E";
                SecurityLogger.logError(var7_7, new java.lang.Object[]{var6_6});
                if (var3_3.isStateful() && var5_5 != null && var8_8 != 0L) {
                    var4_4.csi_client_session_status_update(var8_8, var10_9, 7);
                    var5_5.set_session_state(7);
                }
                throw new NO_PERMISSION(var7_7, 1229066387, CompletionStatus.COMPLETED_NO);
lbl259:
                // 1 sources

                if (this.secConfig.getauthenticationTarget() == 4) {
                    var1_1.absent(true);
                    if (SecurityLogger.debugTraceEnabled) {
                        var7_7 = "Identity Assertion set to absent: ";
                        SecurityLogger.debugMessage(var6_6, var7_7);
                    }
                }
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(var6_6);
        }
    }

    protected void setSecurityContext(ClientRequestInfo clientRequestInfo, SecurityContextImpl securityContextImpl, IdentityToken identityToken, Subject subject, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy, SessionManager sessionManager, SessionEntry sessionEntry, String string) {
        String string2 = "CSIClientRIBase.setSecurityContext";
        String string3 = "";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string2);
        }
        long l = cSIv2EffectivePerformPolicy.getStatefulContextID();
        ClientSessionKey clientSessionKey = cSIv2EffectivePerformPolicy.getClientSessionKey();
        boolean bl = cSIv2EffectivePerformPolicy.performIdentityAssertion();
        boolean bl2 = cSIv2EffectivePerformPolicy.performClientAuthentication();
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        if (securityContextImpl != null) {
            if (bl2 && !bl) {
                byte[] byArray;
                try {
                    byArray = wSCredential.getCredentialToken();
                }
                catch (Exception exception) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "Exception occurred getting token from credential: " + exception.getMessage();
                        SecurityLogger.debugMessage(string2, string3);
                        SecurityLogger.traceException(string2, exception, 0, 0);
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase.send_request", "2420", (java.lang.Object)this);
                    throw new NO_PERMISSION(string3 + "  Original exception = " + exception, 1229066386, CompletionStatus.COMPLETED_NO);
                }
                if (byArray == null && this.secConfig.processIsServer()) {
                    string3 = "The WSCredential does not contain a forwardable token. Please enable Identity Assertion for this scenario.";
                    SecurityLogger.debugMessage(string2, string3);
                    throw new NO_PERMISSION(string3, 1229079303, CompletionStatus.COMPLETED_NO);
                }
                securityContextImpl.set_target_host_and_port(cSIv2EffectivePerformPolicy.getTargetHostName());
                securityContextImpl.set_target_realm(string);
                securityContextImpl.setTokenType("ClientAuthOnly");
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "Setting Client Authentication Token in the SecurityContextImpl. ";
                    SecurityLogger.debugMessage(string2, string3);
                }
            } else if (bl && bl2) {
                securityContextImpl.setTokenType("ClientAuthAndIdentityOnly");
            } else if (bl) {
                securityContextImpl.setTokenType("IdentityOnly");
            }
            securityContextImpl.setIdentityToken(identityToken);
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "Setting Identity Token in the SecurityContextImpl. ";
                SecurityLogger.debugMessage(string2, string3);
            }
        } else {
            string3 = "security.JSAS0120E";
            SecurityLogger.logError(string3, new java.lang.Object[]{string2});
            if (cSIv2EffectivePerformPolicy.isStateful() && sessionEntry != null && l != 0L) {
                sessionManager.csi_client_session_status_update(l, clientSessionKey, 7);
                sessionEntry.set_session_state(7);
            }
            throw new NO_PERMISSION(string3, 1229066387, CompletionStatus.COMPLETED_NO);
        }
        securityContextImpl.setClientSubject(subject);
        securityContextImpl.csi_client_preprotect(clientRequestInfo, securityContextImpl);
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
    }

    protected boolean is_local_client_request(ClientRequestInfo clientRequestInfo) {
        if (((ExtendedClientRequestInfo)clientRequestInfo).isLocal()) {
            if (SecurityLogger.debugTraceEnabled) {
                String string = "CSIClientRIBase.is_local_client_request";
                String string2 = "Local ORB request.";
                SecurityLogger.debugMessage(string, string2);
            }
            return true;
        }
        if (SecurityLogger.debugTraceEnabled) {
            String string = "CSIClientRIBase.is_local_client_request";
            String string3 = "Remote ORB request.";
            SecurityLogger.debugMessage(string, string3);
        }
        return false;
    }

    public void send_request_local(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    protected Subject unwrapSubject(final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CSIClientRIBase.unwrapSubject");
        }
        if (subject == null || !this.secConfig.isRMIOutboundMappingEnabled()) {
            return subject;
        }
        Subject subject2 = (Subject)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public java.lang.Object run() {
                Iterator iterator = subject.getPrivateCredentials(class$com$ibm$wsspi$security$auth$WSSubjectWrapper == null ? (class$com$ibm$wsspi$security$auth$WSSubjectWrapper = CSIClientRIBase.class$("com.ibm.wsspi.security.auth.WSSubjectWrapper")) : class$com$ibm$wsspi$security$auth$WSSubjectWrapper).iterator();
                if (iterator != null && iterator.hasNext()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unwrapSubject: found embedded subject");
                    }
                    WSSubjectWrapper wSSubjectWrapper = (WSSubjectWrapper)iterator.next();
                    if (iterator.hasNext()) {
                        Tr.warning(tc, "Embedded subject contains more than one WSSubjectWrapper object");
                    }
                    return wSSubjectWrapper.getSubject();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unwrapSubject: no embedded subject found");
                }
                return subject;
            }
        });
        if (subject2 != null) {
            if (tc.isDebugEnabled()) {
                try {
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject2);
                    if (wSCredential != null) {
                        Tr.debug(tc, "subject security name = " + wSCredential.getSecurityName());
                    } else {
                        Tr.debug(tc, "subject with null WSCredential");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return subject2;
        }
        return subject;
    }
}

