/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

public class CSICredentialsManager {
    static CSICredentialsManager credsMgr = null;

    public static CSICredentialsManager getInstance() {
        if (credsMgr == null) {
            credsMgr = new CSICredentialsManager();
        }
        return credsMgr;
    }

    public synchronized Subject getInvocationSubject() {
        String string = "CSICredentialsManager.getInvocationSubject";
        String string2 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        Subject subject = null;
        WSCredential wSCredential = null;
        CSIUtil cSIUtil = new CSIUtil();
        VaultImpl.getInstance();
        SecurityConfiguration securityConfiguration = VaultImpl.getSecurityConfiguration();
        ContextManager contextManager = ContextManagerFactory.getInstance();
        try {
            subject = contextManager.getInvocationSubject();
            wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            if (subject != null && securityConfiguration.processIsServer() && !ContextManagerFactory.getInstance().getWSCredTokenMapper().checkValidityOfAllTokensAndRefresh(subject)) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "JSAS0030W: Credentials are invalid. Trying unauthenticated login.";
                    SecurityLogger.debugMessage(string, string2);
                }
                string2 = "security.JSAS0030W";
                SecurityLogger.logError(string2, new Object[]{string});
                if (SecurityLogger.debugEntryEnabled) {
                    SecurityLogger.debugExit(string);
                }
                return SubjectHelper.createUnauthenticatedSubject();
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Subject is valid.";
                SecurityLogger.debugMessage(string, string2);
            }
            if (wSCredential == null) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "No invocation subject during Identity Assertion processing.  Return Unauthenticated subject";
                    SecurityLogger.debugMessage(string, string2);
                }
                if (SecurityLogger.debugEntryEnabled) {
                    SecurityLogger.debugExit(string);
                }
                return SubjectHelper.createUnauthenticatedSubject();
            }
            if (wSCredential.isBasicAuth() && !wSCredential.isUnauthenticated() && securityConfiguration.processIsServer()) {
                try {
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "The invocation credential is either BasicAuth or GSSUP.  Getting authentiated subject.";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    subject = contextManager.login(wSCredential);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getInvocationCredentials", "192", this);
                    if (SecurityLogger.traceEnabled) {
                        string2 = "Java runtime exception while trying ContextManager.login. Returning unauthenticated subject";
                        SecurityLogger.debugMessage(string, string2);
                        SecurityLogger.logException(string, exception, 0, 0);
                    }
                    subject = SubjectHelper.createUnauthenticatedSubject();
                }
            }
            if (subject == null) {
                subject = SubjectHelper.createUnauthenticatedSubject();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getInvocationCredentials", "203", this);
            string2 = "Java runtime exception while trying to get Invocation credentials from current.";
            SecurityLogger.debugMessage(string, string2);
            SecurityLogger.logException(string, exception, 0, 0);
            subject = null;
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
        return subject;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Subject getClientSubject(String var1_1, String var2_2) throws Exception {
        block65: {
            var3_3 = "CSICredentialsManager.getClientSubject";
            var4_4 = null;
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugEntry(var3_3);
            }
            var5_5 = null;
            var6_6 = null;
            var7_7 = new CSIUtil();
            VaultImpl.getInstance();
            var8_8 = VaultImpl.getSecurityConfiguration();
            var9_9 = null;
            var10_10 = ContextManagerFactory.getInstance();
            if (!var10_10.processIsServer() && var8_8.getIsRealmHostSubjectLookupEnabled() && (var5_5 = VaultImpl.getInstance().getRealmHostSubject(var1_1 + ":" + var2_2)) != null) {
                if (SecurityLogger.debugTraceEnabled) {
                    var4_4 = "Returning credential from realm/server Subject cache.";
                    SecurityLogger.debugMessage(var3_3, var4_4);
                }
                if (SecurityLogger.debugEntryEnabled) {
                    SecurityLogger.debugExit(var3_3);
                }
                return var5_5;
            }
            try {
                var5_5 = var10_10.getInvocationSubject();
                var6_6 = SubjectHelper.getWSCredentialFromSubject(var5_5);
            }
            catch (Exception var11_11) {
                FFDCFilter.processException((Throwable)var11_11, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "264", this);
                var4_4 = "Java runtime exception while trying to get_credentials from current.";
                SecurityLogger.debugMessage(var3_3, var4_4);
                SecurityLogger.logException(var3_3, var11_11, 0, 0);
            }
            if (var6_6 != null && var6_6.isUnauthenticated()) {
                if (SecurityLogger.debugEntryEnabled) {
                    SecurityLogger.debugExit(var3_3);
                }
                return var5_5;
            }
            if (var6_6 == null) {
                try {
                    var5_5 = var10_10.getOwnSubject();
                    var6_6 = SubjectHelper.getWSCredentialFromSubject(var5_5);
                    if (!var8_8.processIsServer() && var5_5 != null) {
                        var10_10.setInvocationSubject(var5_5);
                    }
                }
                catch (Exception var11_12) {
                    FFDCFilter.processException((Throwable)var11_12, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "301", this);
                    var4_4 = "Java runtime exception while trying to get_credentials from current.";
                    SecurityLogger.debugMessage(var3_3, var4_4);
                    SecurityLogger.logException(var3_3, var11_12, 0, 0);
                }
            }
            if (!(var8_8.processIsServer() || var6_6 != null && ((WSCredentialImpl)var6_6).isForwardable(var1_1))) {
                if (SecurityLogger.debugTraceEnabled) {
                    var4_4 = "There is no invocation subject on the current thread; Login will be performed for " + var1_1 + "/null";
                    SecurityLogger.debugMessage(var3_3, var4_4);
                }
                v0 = VaultImpl.getInstance().getORB();
                VaultImpl.getInstance();
                var9_9 = new LoginHelperImpl(v0, VaultImpl.getSecurityConfiguration());
                if (var9_9 == null) {
                    var4_4 = "security.JSAS0020E";
                    SecurityLogger.logError(var4_4, new Object[]{var3_3});
                    if (SecurityLogger.debugEntryEnabled) {
                        SecurityLogger.debugExit(var3_3);
                    }
                    return null;
                }
                try {
                    var11_14 = false;
                    do {
                        try {
                            var12_22 = var1_1;
                            var13_24 = var9_9;
                            var5_5 = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((LoginHelperImpl)var13_24, (String)var12_22){
                                private final /* synthetic */ LoginHelperImpl val$helper;
                                private final /* synthetic */ String val$realm;
                                {
                                    this.val$helper = loginHelperImpl;
                                    this.val$realm = string;
                                }

                                public Object run() throws WSLoginFailedException {
                                    return this.val$helper.request_login_controlled(null, this.val$realm, null, null, false);
                                }
                            });
                            var11_14 = false;
                            var6_6 = SubjectHelper.getWSCredentialFromSubject(var5_5);
                        }
                        catch (PrivilegedActionException var12_23) {
                            if (!var8_8.authenticationRetryEnabled()) continue;
                            var13_25 = var7_7.getCurrent().get_retry_count();
                            if (SecurityLogger.debugTraceEnabled) {
                                var4_4 = "Retry count is " + var13_25;
                                SecurityLogger.debugMessage(var3_3, var4_4);
                            }
                            if (var13_25 < var8_8.getauthenticationRetryCount()) {
                                if (SecurityLogger.debugTraceEnabled) {
                                    var4_4 = "LOGGING IN AGAIN!!!  Previous login failed but retry count is not above the maximum retries.";
                                    SecurityLogger.debugMessage(var3_3, var4_4);
                                }
                                var7_7.getCurrent().increment_retry_count();
                                var11_14 = true;
                                continue;
                            }
                            var11_14 = false;
                            FFDCFilter.processException((Throwable)var12_23, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "390", this);
                            var4_4 = SecurityMessages.getMsgOrUseDefault("JSAS0240E", "JSAS0240E: Login failed.  Verify the userid/password is correct.  Check the properties file to ensure the login source is valid.  If this error occurs on the server, check the server properties to ensure the principalName has a valid realm and userid.");
                            throw var12_23.getException();
                        }
                    } while (var11_14);
                    if (var5_5 == null) ** GOTO lbl120
                    var10_10.setInvocationSubject(var5_5);
                }
                catch (WSLoginFailedException var11_15) {
                    FFDCFilter.processException((Throwable)var11_15, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "404", this);
                    var4_4 = "security.JSAS0240E";
                    SecurityLogger.logError(var4_4, new Object[]{var3_3, var11_15});
                    var5_5 = null;
                    if (SecurityLogger.debugTraceEnabled) {
                        var4_4 = "Login Failed reason: " + var11_15.getMessage();
                        SecurityLogger.debugMessage(var3_3, var4_4);
                    }
                    throw var11_15;
                }
                catch (Exception var11_16) {
                    FFDCFilter.processException((Throwable)var11_16, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "419", this);
                    var4_4 = "security.JSAS0240E";
                    SecurityLogger.logError(var4_4, new Object[]{var3_3, var11_16});
                    var5_5 = null;
                    throw new WSLoginFailedException(var11_16.getMessage(), var11_16);
                }
            } else if (var6_6 != null && !((WSCredentialImpl)var6_6).isForwardable(var1_1)) {
                if (SecurityLogger.debugTraceEnabled) {
                    var4_4 = "Credential is not forwardable to the target realm. Force to create Unauthenticated subject. target realm:" + var1_1;
                    SecurityLogger.debugMessage(var3_3, var4_4);
                }
                var6_6 = null;
            }
lbl120:
            // 5 sources

            if (var6_6 != null && var6_6.isCurrent() && !var6_6.isForwardable()) {
                block64: {
                    if (SecurityLogger.debugTraceEnabled) {
                        var4_4 = "Resolved credentials is NOT forwardable. The credentials will be mapped.";
                        SecurityLogger.debugMessage(var3_3, var4_4);
                    }
                    if (var6_6.getOID().equalsIgnoreCase("No OID for this mechanism")) {
                        if (SecurityLogger.debugTraceEnabled) {
                            var4_4 = "LocalOS credentials is not forwardable.";
                            SecurityLogger.debugMessage(var3_3, var4_4);
                        }
                        try {
                            var11_17 = var6_6.getRealmSecurityName();
                            if (var11_17 != null && var11_17.length() > 0) {
                                var5_5 = VaultImpl.getInstance().getBasicAuthSubject(var11_17);
                                if (var5_5 != null) {
                                    if (SecurityLogger.debugTraceEnabled) {
                                        var4_4 = "Returned BasicAuth subject.  Security_name: " + var11_17;
                                        SecurityLogger.debugMessage(var3_3, var4_4);
                                    }
                                    if (SecurityLogger.debugEntryEnabled) {
                                        SecurityLogger.debugExit(var3_3);
                                    }
                                    return var5_5;
                                }
                                if (var5_5 == null) {
                                    if (SecurityLogger.debugTraceEnabled) {
                                        var4_4 = "No matched BasicAuth subject for this LocalOS subject.  Return Unauthenticated subject.";
                                        SecurityLogger.debugMessage(var3_3, var4_4);
                                    }
                                    if (SecurityLogger.debugEntryEnabled) {
                                        SecurityLogger.debugExit(var3_3);
                                    }
                                    return SubjectHelper.createUnauthenticatedSubject();
                                }
                                break block64;
                            }
                            if (SecurityLogger.debugTraceEnabled) {
                                var4_4 = "No security name found.  Return unauthenticated subject.";
                                SecurityLogger.debugMessage(var3_3, var4_4);
                            }
                            if (SecurityLogger.debugEntryEnabled) {
                                SecurityLogger.debugExit(var3_3);
                            }
                            return SubjectHelper.createUnauthenticatedSubject();
                        }
                        catch (Exception var11_18) {
                            FFDCFilter.processException((Throwable)var11_18, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientSubject", "515", this);
                            if (SecurityLogger.traceEnabled) {
                                var4_4 = SecurityMessages.getMsgOrUseDefault("TrcMsg405", "Unable to get client security name from credentials.");
                                SecurityLogger.traceMessage(var3_3, var4_4);
                            }
                            SecurityLogger.logException(var3_3, var11_18, 0, 0);
                        }
                    }
                }
                try {
                    if (!var10_10.isServerCred(var6_6)) break block65;
                    if (SecurityLogger.debugTraceEnabled) {
                        var4_4 = "Server invokes downstream request to different target realm: " + var1_1;
                        SecurityLogger.debugMessage(var3_3, var4_4);
                    }
                    if (SecurityLogger.debugTraceEnabled) {
                        var4_4 = "Using key file to map server credential for new target realm.";
                        SecurityLogger.debugMessage(var3_3, var4_4);
                    }
                    try {
                        if (var8_8.getkeyFileName() != null && var8_8.getkeyFileName().length() > 0) {
                            var11_19 = var9_9.getKeyFileObject();
                            var12_22 = var11_19.find(var1_1, var6_6.getRealmSecurityName());
                            if (var12_22 != null) {
                                var13_24 = var12_22.getUserid();
                                var14_26 = var12_22.getPassword();
                                var5_5 = SubjectHelper.createBasicAuthSubject(var1_1, (String)var13_24, var14_26);
                                var6_6 = SubjectHelper.getWSCredentialFromSubject(var5_5);
                            } else {
                                var4_4 = "security.JSAS0480E";
                                SecurityLogger.logError(var4_4, new Object[]{var3_3});
                                var5_5 = SubjectHelper.createUnauthenticatedSubject();
                                var6_6 = SubjectHelper.getWSCredentialFromSubject(var5_5);
                            }
                            break block65;
                        }
                        var4_4 = "security.JSAS0480E";
                        SecurityLogger.logError(var4_4, new Object[]{var3_3});
                        var5_5 = SubjectHelper.createUnauthenticatedSubject();
                        var6_6 = SubjectHelper.getWSCredentialFromSubject(var5_5);
                    }
                    catch (Exception var11_20) {
                        FFDCFilter.processException((Throwable)var11_20, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "589", this);
                        var4_4 = "security.JSAS0480E";
                        SecurityLogger.logError(var4_4, new Object[]{var3_3, var11_20});
                        var5_5 = SubjectHelper.createUnauthenticatedSubject();
                        var6_6 = SubjectHelper.getWSCredentialFromSubject(var5_5);
                    }
                }
                catch (Exception var11_21) {
                    FFDCFilter.processException((Throwable)var11_21, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "599", this);
                    if (SecurityLogger.traceEnabled) {
                        var4_4 = "Java runtime exception while trying to get_mapped_credentials.";
                        SecurityLogger.debugMessage(var3_3, var4_4);
                        SecurityLogger.logException(var3_3, var11_21, 0, 0);
                    }
                    var5_5 = SubjectHelper.createUnauthenticatedSubject();
                    var6_6 = SubjectHelper.getWSCredentialFromSubject(var5_5);
                }
            }
        }
        if (var5_5 != null && var8_8.processIsServer() && !ContextManagerFactory.getInstance().getWSCredTokenMapper().checkValidityOfAllTokensAndRefresh(var5_5)) {
            if (SecurityLogger.debugTraceEnabled) {
                var4_4 = "JSAS0030W: Credentials are invalid. Trying unauthenticated login.";
                SecurityLogger.debugMessage(var3_3, var4_4);
            }
            var4_4 = "security.JSAS0030W";
            SecurityLogger.logError(var4_4, new Object[]{var3_3});
            var5_5 = SubjectHelper.createUnauthenticatedSubject();
        } else if (SecurityLogger.debugTraceEnabled) {
            var4_4 = "Subject is valid.";
            SecurityLogger.debugMessage(var3_3, var4_4);
        }
        if (var6_6 == null) {
            if (SecurityLogger.debugTraceEnabled) {
                var4_4 = "Credentials are null or invalidated by rejection.";
                SecurityLogger.debugMessage(var3_3, var4_4);
            }
            var5_5 = SubjectHelper.createUnauthenticatedSubject();
        }
        if (!var10_10.processIsServer() && var8_8.getIsRealmHostSubjectLookupEnabled() && var5_5 != null) {
            if (SecurityLogger.debugTraceEnabled) {
                var4_4 = "Adding credential to realm/server Subject cache.";
                SecurityLogger.debugMessage(var3_3, var4_4);
            }
            VaultImpl.getInstance().addRealmHostSubject(var1_1 + ":" + var2_2, var5_5);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(var3_3);
        }
        return var5_5;
    }
}

