/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CSIv2Security.CSIv2RequirementsNotSatisfied;
import com.ibm.CSIv2Security.CSIv2RequirementsNotSatisfiedReason;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponentHolder;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ClientSessionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.AS_ContextSecHolder;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.SAS_ContextSecHolder;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.CSIIOP.TLS_SEC_TRANSHolder;

public final class CSIv2EffectivePerformPolicy {
    protected static ORB _orb = null;
    protected static SecurityConfiguration secConfig = null;
    protected String _method = null;
    protected Object _proxy = null;
    protected String _protocol = "csiv2";
    protected boolean _stateful = true;
    protected long _stateful_context_id = 0L;
    protected ClientSessionKey _client_session_key = null;
    protected String _connectionKey = "";
    protected String _mechTypeIdentity = "";
    protected boolean _performTLClientAuth = false;
    protected boolean _performTLServerAuth = false;
    protected boolean _performMsgDetectReplay = false;
    protected boolean _performMsgDetectMisordering = false;
    protected boolean _performMsgIntegrity = false;
    protected boolean _performMsgConfidentiality = false;
    protected boolean _performSSLTLS = false;
    protected boolean _performSECIOP = false;
    protected String _performSECIOPMechOID = "";
    protected String _targetHostName = "";
    protected int _targetTCPPort = 0;
    protected int _targetSSLPort = 0;
    protected boolean _performClientAuth = false;
    protected boolean _claimClientAuthRequired = false;
    protected String _performClientAuthMechOID = "";
    protected String _targetSecurityName = "";
    protected boolean _performIDAssertion = false;
    protected String[] _performIDANamingMechList = null;
    protected int _performIdentityTokenType = 0;
    protected String _performServiceCfgList = null;
    protected boolean _performAuthorizationToken = false;
    protected boolean _performDelegationByClient = false;
    protected boolean _isInternalRequestPolicy = false;
    protected CSIv2TaggedComponentHolder savedCSIv2Tag = null;
    protected static Hashtable csiv2EffectivePolicyCache = new Hashtable();
    protected boolean _disableCache = false;

    public String[] getPerformIDANamingMechList() {
        return this._performIDANamingMechList;
    }

    public int getPerformIdentityTokenType() {
        return this._performIdentityTokenType;
    }

    public boolean performIdentityAssertion() {
        return this._performIDAssertion;
    }

    public boolean performDelegationByClient() {
        return this._performDelegationByClient;
    }

    public boolean performAuthorizationToken() {
        return this._performAuthorizationToken;
    }

    public String getServiceCfgList() {
        return this._performServiceCfgList;
    }

    public String getPerformClientAuthMechOID() {
        return this._performClientAuthMechOID;
    }

    public boolean performClientAuthentication() {
        return this._performClientAuth;
    }

    public boolean claimClientAuthenticationRequired() {
        return this._claimClientAuthRequired;
    }

    public String getTargetSecurityName() {
        return this._targetSecurityName;
    }

    public String getTargetHostName() {
        return this._targetHostName;
    }

    public int getTargetTCPPort() {
        return this._targetTCPPort;
    }

    public int getTargetSSLPort() {
        return this._targetSSLPort;
    }

    public String getMechanismTypeIdentity() {
        if (this._performClientAuth) {
            if (this._performSSLTLS) {
                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:2.23.130.1.1.1")) {
                    return "1.5";
                }
                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2")) {
                    // empty if block
                }
            } else {
                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:2.23.130.1.1.1")) {
                    return "5.7.4";
                }
                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2")) {
                    // empty if block
                }
            }
        }
        return this._mechTypeIdentity;
    }

    public String getPerformSECIOPMechOID() {
        return this._performSECIOPMechOID;
    }

    public boolean performSSLTLS() {
        return this._performSSLTLS;
    }

    public boolean performSECIOP() {
        return this._performSECIOP;
    }

    public boolean performMsgConfidentiality() {
        return this._performMsgConfidentiality;
    }

    public boolean performMsgIntegrity() {
        return this._performMsgIntegrity;
    }

    public boolean performMsgDetectMisordering() {
        return this._performMsgDetectMisordering;
    }

    public boolean performMsgDetectReplay() {
        return this._performMsgDetectReplay;
    }

    public boolean performTLClientAuth() {
        return this._performTLClientAuth;
    }

    public boolean performTLServerAuth() {
        return this._performTLServerAuth;
    }

    private void evaluateStatefulness(boolean bl, Vector vector) throws CSIv2RequirementsNotSatisfied {
        String string = "CSIv2EffectivePerformPolicy.evaluateStatefulness";
        String string2 = null;
        boolean bl2 = this._stateful = bl && secConfig.getCSIv2PerformStateful();
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Stateful request? " + this._stateful;
            SecurityLogger.debugMessage(string, string2);
        }
    }

    private void evaluateTransportLayer(CSIv2TaggedComponent cSIv2TaggedComponent, Vector vector, boolean bl) throws CSIv2RequirementsNotSatisfied {
        String string = "CSIv2EffectivePerformPolicy.evaluateTransportLayer";
        String string2 = null;
        boolean bl2 = false;
        if (cSIv2TaggedComponent == null) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0600E", "JSAS0600E: CSIv2 Tagged Component is NULL.");
            vector.addElement(string2);
            bl2 = true;
        }
        int n = cSIv2TaggedComponent.get_Transport_tagID();
        TLS_SEC_TRANSHolder tLS_SEC_TRANSHolder = null;
        Object var9_9 = null;
        short s = 0;
        short s2 = 0;
        if (n == 36) {
            tLS_SEC_TRANSHolder = cSIv2TaggedComponent.getTLS_SEC_TRANS();
            s = tLS_SEC_TRANSHolder.value.target_supports;
            s2 = tLS_SEC_TRANSHolder.value.target_requires;
            this._targetHostName = tLS_SEC_TRANSHolder.value.addresses[0].host_name;
            this._targetSSLPort = tLS_SEC_TRANSHolder.value.addresses[0].port;
            if (cSIv2TaggedComponent.getIORProfile() != null) {
                this._targetTCPPort = cSIv2TaggedComponent.getIORProfile().getPort();
            }
            this._performSSLTLS = secConfig.getCSIv2PerformTransportAssocSSLTLSSupported() || secConfig.getCSIv2PerformTransportAssocSSLTLSRequired();
        } else {
            if (n == 34) {
                s = 0;
                s2 = 0;
                if (cSIv2TaggedComponent.getIORProfile() != null) {
                    this._targetHostName = cSIv2TaggedComponent.getIORProfile().getHost();
                }
                if (cSIv2TaggedComponent.getIORProfile() != null) {
                    this._targetTCPPort = cSIv2TaggedComponent.getIORProfile().getPort();
                }
                this._performSSLTLS = false;
                this._performTLClientAuth = false;
                this._performMsgIntegrity = false;
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Perform SSL/TLS: " + this._performSSLTLS + ", Perform client auth at transport layer: " + this._performTLClientAuth + ", Perform integrity at transport layer: " + this._performMsgIntegrity + ", Perform confidentiality at transport layer: " + this._performMsgConfidentiality + ", Target Host: " + this._targetHostName + ", Target TCP Port: " + this._targetTCPPort + ", Target SSL Port: " + this._targetSSLPort;
                    SecurityLogger.debugMessage(string, string2);
                }
                if (secConfig.getCSIv2PerformTransportAssocSSLTLSRequired()) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0603E", "JSAS0603E: The server does not support SSL/TLS, but the client is configured to require it.");
                    vector.addElement(string2);
                    bl2 = true;
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0550I", "JSAS0550I: Evaluation of the transport layer failed.");
                    throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByClient, string2);
                }
                return;
            }
            if (n == 35) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0601E", "JSAS0601E: The CSIv2 client configuration does not support SECIOP.");
                vector.addElement(string2);
                bl2 = true;
            } else {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0602E", "JSAS0602E: No valid transport tagged components exist in the IOR.");
                vector.addElement(string2);
                bl2 = true;
            }
        }
        if (s2 == 0 && s == 0 && secConfig.getCSIv2PerformTransportAssocSSLTLSRequired()) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0603E", "JSAS0603E: The server does not support SSL/TLS, but the client is configured to require it.");
            vector.addElement(string2);
            bl2 = true;
        }
        if (!secConfig.getCSIv2PerformTransportAssocSSLTLSSupported() && !secConfig.getCSIv2PerformTransportAssocSSLTLSRequired() && this._targetTCPPort == 0) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0608E", "JSAS0608E: The server requires SSL Confidentiality but the client does not support it.");
            vector.addElement(string2);
            bl2 = true;
        }
        if (secConfig.getCSIv2PerformTLClientAuthenticationRequired() && this._performSSLTLS) {
            if ((s2 & 0x40) == 0 && (s & 0x40) == 0) {
                if (bl) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0604E", "JSAS0604E: The client is configured to require SSL client authentication but the server does not support it.");
                    vector.addElement(string2);
                    bl2 = true;
                } else {
                    this._performTLClientAuth = false;
                }
            } else {
                this._performTLClientAuth = true;
            }
        } else if (secConfig.getCSIv2PerformTLClientAuthenticationSupported() && this._performSSLTLS) {
            if ((s2 & 0x40) == 0 && (s & 0x40) == 0) {
                if (bl) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0605E", "JSAS0605E: The client is configured to support SSL client certificate authentication, however the server does not accept them.");
                    vector.addElement(string2);
                    bl2 = true;
                } else {
                    this._performTLClientAuth = false;
                }
            } else {
                this._performTLClientAuth = true;
            }
        } else {
            if ((s2 & 0x40) != 0) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0606E", "JSAS0606E: The server is configured to require SSL client certificate authentication but the client does not support it.");
                vector.addElement(string2);
                bl2 = true;
            }
            this._performTLClientAuth = false;
        }
        this._performTLServerAuth = true;
        if (secConfig.getCSIv2PerformMessageConfidentialityRequired() && this._performSSLTLS) {
            if ((s2 & 4) == 0 && (s & 4) == 0) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0607E", "JSAS0607E: The client is configured to require SSL Confidentiality but the server does not support it.");
                vector.addElement(string2);
                bl2 = true;
            } else {
                this._performMsgConfidentiality = true;
            }
        } else if (secConfig.getCSIv2PerformMessageConfidentialitySupported() && this._performSSLTLS) {
            this._performMsgConfidentiality = (s2 & 4) != 0 || (s & 4) != 0;
        } else {
            if ((s2 & 4) != 0) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0608E", "JSAS0608E: The server is configured to require Confidentiality but the client does not support it.");
                vector.addElement(string2);
                bl2 = true;
            }
            this._performMsgConfidentiality = false;
        }
        if (secConfig.getCSIv2PerformMessageIntegrityRequired() && this._performSSLTLS) {
            if ((s2 & 2) == 0 && (s & 2) == 0) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0609E", "JSAS0609E: The client is configured to require SSL Integrity but the server does not support it.");
                vector.addElement(string2);
                bl2 = true;
            } else {
                this._performMsgIntegrity = true;
            }
        } else if (secConfig.getCSIv2PerformMessageIntegritySupported() && this._performSSLTLS) {
            this._performMsgIntegrity = (s2 & 2) != 0 || (s & 2) != 0;
        } else {
            if ((s2 & 2) != 0 && this._performSSLTLS) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0610E", "JSAS0610E: The server is configured to require SSL Integrity but the client does not support it.");
                vector.addElement(string2);
                bl2 = true;
            }
            this._performMsgIntegrity = false;
        }
        this._performMsgDetectReplay = true;
        this._performMsgDetectMisordering = true;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Perform SSL/TLS: " + this._performSSLTLS + ", Perform client auth at transport layer: " + this._performTLClientAuth + ", Perform integrity at transport layer: " + this._performMsgIntegrity + ", Perform confidentiality at transport layer: " + this._performMsgConfidentiality + ", Target Host: " + this._targetHostName + ", Target TCP Port: " + this._targetTCPPort + ", Target SSL Port: " + this._targetSSLPort;
            SecurityLogger.debugMessage(string, string2);
        }
        if (bl2) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0550I", "JSAS0550I: Evaluation of the transport layer failed.");
            throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByClient, string2);
        }
    }

    private void evaluateClientAuthLayer(AS_ContextSecHolder aS_ContextSecHolder, Vector vector) throws CSIv2RequirementsNotSatisfied {
        String string = "CSIv2EffectivePerformPolicy.evaluateClientAuthLayer";
        String string2 = null;
        boolean bl = false;
        if (aS_ContextSecHolder == null || aS_ContextSecHolder.value == null) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0611E", "JSAS0611E: No authentication mechanism is defined at client authentication layer.");
            vector.addElement(string2);
            bl = true;
        }
        AS_ContextSec aS_ContextSec = aS_ContextSecHolder.value;
        CSIUtil cSIUtil = new CSIUtil();
        short s = 0;
        short s2 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (aS_ContextSec == null) {
            if (secConfig.getCSIv2PerformClientAuthenticationRequired()) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0611E", "JSAS0611E: No authentication mechanism is defined at client authentication layer.");
                vector.addElement(string2);
                bl = true;
            }
        } else {
            s = aS_ContextSec.target_supports;
            s2 = aS_ContextSec.target_requires;
            byArray = aS_ContextSec.client_authentication_mech;
            byArray2 = aS_ContextSec.target_name;
            if ((s2 & 0x40) != 0) {
                this._claimClientAuthRequired = true;
            }
            if (secConfig.getCSIv2PerformClientAuthenticationRequired()) {
                if ((s & 0x40) == 0 && (s2 & 0x40) == 0) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0612E", "JSAS0612E: The client requires client authentication (e.g., userid/password), but the server does not support it.");
                    vector.addElement(string2);
                    bl = true;
                }
                this._performClientAuth = true;
            } else if (secConfig.getCSIv2PerformClientAuthenticationSupported()) {
                if ((s & 0x40) == 0 && (s2 & 0x40) == 0) {
                    this._performClientAuth = false;
                    if (s == 0) {
                        return;
                    }
                } else {
                    this._performClientAuth = true;
                }
            } else if ((s2 & 0x40) != 0) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0613E", "JSAS0613E: The server requires client authentication (e.g., userid/password), but the client does not support it.");
                vector.addElement(string2);
                bl = true;
            } else if (CSIv2EffectivePerformPolicy.methodRequiresAuthenticationRegardlessOfPolicy(this._method, this._proxy)) {
                this._performClientAuth = true;
                this._disableCache = true;
            } else {
                this._performClientAuth = false;
            }
            if (this._performClientAuth) {
                Object object;
                if (byArray2 == null) {
                    this._performClientAuth = false;
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0618E", "JSAS0618E: The target security name is NULL in CSIv2 tagged component.");
                    vector.addElement(string2);
                    bl = true;
                } else if (this.savedCSIv2Tag != null && this.savedCSIv2Tag.value != null) {
                    this._targetSecurityName = this.savedCSIv2Tag.value.get_targetCompleteName();
                }
                String string3 = secConfig.getSupportedTargetRealms();
                boolean bl2 = true;
                if (string3 != null && !string3.equals("")) {
                    object = new StringTokenizer(string3, "|");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string4 = ((StringTokenizer)object).nextToken();
                        if (!this._targetSecurityName.startsWith(string4)) continue;
                        bl2 = false;
                    }
                }
                object = new GSSFactory(byArray);
                this._performClientAuthMechOID = ((GSSFactory)object).getOIDName();
                if (bl2) {
                    if (byArray == null) {
                        this._performClientAuth = false;
                        string2 = SecurityMessages.getMsgOrUseDefault("JSAS0611E", "JSAS0611E: No authentication mechanism is defined at client authentication layer.");
                        vector.addElement(string2);
                        bl = true;
                    } else if (!(OID.compareOIDs(this._performClientAuthMechOID, "oid:2.23.130.1.1.1") || OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2") || OID.compareOIDs(this._performClientAuthMechOID, "oid:1.3.18.0.2.30.2") || OID.compareOIDs(this._performClientAuthMechOID, secConfig.getWSSecurityContextCustomOID()))) {
                        this._performClientAuth = false;
                        this._performClientAuthMechOID = null;
                        if ((s2 & 0x40) != 0 || secConfig.getCSIv2PerformClientAuthenticationRequired()) {
                            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0614E", "JSAS0614E: The OID supplied by the server is an unsupported OID for this WebSphere release.");
                            vector.addElement(string2);
                            bl = true;
                        }
                    } else if (!this.performIdentityAssertion()) {
                        if (!OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2") && secConfig.getauthenticationTarget() == 6) {
                            if ((s2 & 0x40) != 0 || secConfig.getCSIv2PerformClientAuthenticationRequired()) {
                                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0615E", "JSAS0615E: The client configuration specifies the Kerberos authentication mechanism, but the server does not support it.");
                                vector.addElement(string2);
                                bl = true;
                            } else {
                                this._performClientAuth = false;
                                this._performClientAuthMechOID = null;
                            }
                        } else if (!OID.compareOIDs(this._performClientAuthMechOID, "oid:1.3.18.0.2.30.2") && secConfig.getauthenticationTarget() == 1) {
                            if ((s2 & 0x40) != 0 || secConfig.getCSIv2PerformClientAuthenticationRequired()) {
                                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0616E", "JSAS0616E: The client configuration specifies the LTPA authentication mechanism, but the server does not support it.");
                                vector.addElement(string2);
                                bl = true;
                            } else {
                                this._performClientAuth = false;
                                this._performClientAuthMechOID = null;
                            }
                        } else if (!OID.compareOIDs(this._performClientAuthMechOID, secConfig.getWSSecurityContextCustomOID()) && secConfig.getauthenticationTarget() == 8) {
                            boolean bl3 = secConfig.getLTPASupportedWithKerberos();
                            if (!OID.compareOIDs(this._performClientAuthMechOID, "oid:1.3.18.0.2.30.2") && !bl3) {
                                if ((s2 & 0x40) != 0 || secConfig.getCSIv2PerformClientAuthenticationRequired()) {
                                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0617E", "JSAS0617E: The client configuration specifies the Custom authentication mechanism, but the server does not support it.");
                                    vector.addElement(string2);
                                    bl = true;
                                } else {
                                    this._performClientAuth = false;
                                    this._performClientAuthMechOID = null;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Perform client authentication at message layer: " + this._performClientAuth + ", Perform client auth mechanism: " + this._performClientAuthMechOID + ", Target Name at message layer: " + this._targetSecurityName;
            SecurityLogger.debugMessage(string, string2);
        }
        if (bl) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0551I", "JSAS0551I: Evaluation of the message layer failed.");
            throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByClient, string2);
        }
    }

    private void evaluateAttributeLayer(SAS_ContextSecHolder sAS_ContextSecHolder, Vector vector) throws CSIv2RequirementsNotSatisfied {
        String string = "CSIv2EffectivePerformPolicy.evaluateAttributeLayer";
        String string2 = null;
        boolean bl = false;
        SAS_ContextSec sAS_ContextSec = sAS_ContextSecHolder.value;
        short s = 0;
        short s2 = 0;
        byte[][] byArray = null;
        int n = 0;
        ServiceConfiguration[] serviceConfigurationArray = null;
        if (sAS_ContextSec == null) {
            if (secConfig.getCSIv2PerformIdentityAssertionRequired()) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0619E", "JSAS0619E: The sending server requires Identity Assertion but the receiving server does not support it.");
                vector.addElement(string2);
                bl = true;
            }
        } else {
            Object object;
            Object object2;
            s = sAS_ContextSec.target_supports;
            s2 = sAS_ContextSec.target_requires;
            byArray = sAS_ContextSec.supported_naming_mechanisms;
            n = sAS_ContextSec.supported_identity_types;
            serviceConfigurationArray = sAS_ContextSec.privilege_authorities;
            if (secConfig.getCSIv2PerformIdentityAssertionRequired()) {
                if (byArray == null || byArray.length == 0) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0620E", "JSAS0620E: No supported naming mechanisms are defined in attribute layer for Identity Assertion.");
                    vector.addElement(string2);
                    bl = true;
                }
                if (n == 0) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0621E", "JSAS0621E: The target server does not support any identity token types.");
                    vector.addElement(string2);
                    bl = true;
                }
                if ((s & 0x400) == 0 && (s2 & 0x400) == 0) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0619E", "JSAS0619E: The sending server requires Identity Assertion but the receiving server does not support it.");
                    vector.addElement(string2);
                    bl = true;
                }
                if (!bl) {
                    this._performIDAssertion = true;
                }
            } else if (secConfig.getCSIv2PerformIdentityAssertionSupported() && ((s & 0x400) != 0 || (s2 & 0x400) != 0)) {
                if (n != 0 && byArray != null && byArray.length > 0) {
                    this._performIDAssertion = true;
                } else if (n == 0) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0621E", "JSAS0621E: The target server does not support any identity token types.");
                    vector.addElement(string2);
                    bl = true;
                } else if (byArray == null || byArray.length == 0) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0620E", "JSAS0620E: No supported naming mechanisms are defined in attribute layer for Identity Assertion.");
                    vector.addElement(string2);
                    bl = true;
                }
            }
            if (this._performIDAssertion) {
                int n2;
                Vector<Object> vector2 = new Vector<Object>();
                object2 = null;
                object = null;
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    object = new GSSFactory(byArray[n2]);
                    object2 = ((GSSFactory)object).getOIDName();
                    if (OID.compareOIDs((String)object2, "oid:1.2.840.113554.1.2.2")) {
                        if (secConfig.getCSIv2PerformIdentityAssertionMechanism() != 6) continue;
                        vector2.addElement(object2);
                        continue;
                    }
                    if (OID.compareOIDs((String)object2, "oid:2.23.130.1.1.1")) {
                        if (secConfig.getCSIv2PerformIdentityAssertionMechanism() != 4 && secConfig.getCSIv2PerformIdentityAssertionMechanism() != 6 && secConfig.getCSIv2PerformIdentityAssertionMechanism() != 2 && secConfig.getCSIv2PerformIdentityAssertionMechanism() != 1) continue;
                        vector2.addElement(object2);
                        continue;
                    }
                    if (OID.compareOIDs((String)object2, "oid:1.3.18.0.2.30.2")) {
                        if (secConfig.getCSIv2PerformIdentityAssertionMechanism() != 1) continue;
                        vector2.addElement(object2);
                        continue;
                    }
                    if (OID.compareOIDs((String)object2, secConfig.getWSSecurityContextCustomOID())) {
                        if (secConfig.getCSIv2PerformIdentityAssertionMechanism() != 8) continue;
                        vector2.addElement(object2);
                        continue;
                    }
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0620E", "JSAS0620E: No supported naming mechanisms are defined in attribute layer for Identity Assertion.");
                    vector.addElement(string2);
                    bl = true;
                }
                if (vector2.size() != 0) {
                    this._performIDANamingMechList = new String[vector2.size()];
                    for (n2 = 0; n2 < vector2.size(); ++n2) {
                        this._performIDANamingMechList[n2] = (String)vector2.elementAt(n2);
                    }
                }
                this._performIdentityTokenType = secConfig.getCSIv2PerformIdentityAssertionType() & n;
                this._performIDAssertion = true;
            }
            if (secConfig.isRMIOutboundPropagationEnabled() && serviceConfigurationArray != null) {
                for (int i = 0; i < serviceConfigurationArray.length; ++i) {
                    object2 = serviceConfigurationArray[i];
                    if (((ServiceConfiguration)object2).name == null || ((ServiceConfiguration)object2).name.length <= 0) continue;
                    if (SecurityLogger.debugTraceEnabled) {
                        SecurityLogger.debugMessage(string, "Logging current service config syntax: " + ((ServiceConfiguration)object2).syntax);
                        SecurityLogger.debugMessage(string, "Logging current service config bytes (size=" + ((ServiceConfiguration)object2).name.length + "): ");
                        SecurityLogger.debugMessage(string, ((ServiceConfiguration)object2).name);
                    }
                    object = "";
                    if (((ServiceConfiguration)object2).syntax == 324817) {
                        if (SecurityLogger.debugTraceEnabled) {
                            SecurityLogger.debugMessage(string, "Service config syntax is SCS_GSSExportedName.");
                        }
                        GSSFactory gSSFactory = VaultImpl.getInstance().getGSSFactory("oid:2.23.130.1.1.1");
                        try {
                            object = gSSFactory.decodeExportedTargetName(((ServiceConfiguration)object2).name);
                        }
                        catch (GSSEncodeDecodeException gSSEncodeDecodeException) {
                            FFDCFilter.processException((Throwable)gSSEncodeDecodeException, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.evaluateAttributeLayer", "1241", this);
                            throw new BAD_PARAM(string2 + "  Original exception = " + gSSEncodeDecodeException, 1229066437, CompletionStatus.COMPLETED_NO);
                        }
                    } else if (((ServiceConfiguration)object2).syntax == 1229066446) {
                        if (SecurityLogger.debugTraceEnabled) {
                            SecurityLogger.debugMessage(string, "Service config syntax is CSIV2_PRIV_ATTR_SYNTAX.");
                        }
                        CDRInputStream cDRInputStream = ORB.createCDRInputStream((ORB)_orb, (byte[])((ServiceConfiguration)object2).name, (int)((ServiceConfiguration)object2).name.length);
                        object = cDRInputStream.read_string();
                    }
                    if (ContextManagerFactory.getInstance().processIsServer() && object != null && ((String)object).equals(ContextManagerFactory.getInstance().getDefaultRealm())) {
                        this._performAuthorizationToken = true;
                    } else if (!ContextManagerFactory.getInstance().processIsServer()) {
                        this._performAuthorizationToken = true;
                    } else {
                        String string3 = secConfig.getSupportedTargetRealms();
                        if (string3 != null && !string3.equals("")) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string4 = stringTokenizer.nextToken();
                                if (!string4.equalsIgnoreCase((String)object)) continue;
                                this._performAuthorizationToken = true;
                                break;
                            }
                        }
                        if (!this._performAuthorizationToken) {
                            string2 = "security.JSAS1479W";
                            SecurityLogger.logWarning(string2, new Object[]{object, ContextManagerFactory.getInstance().getDefaultRealm()});
                        }
                    }
                    this._performServiceCfgList = i == 0 ? object : this._performServiceCfgList + "|" + (String)object;
                }
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Perform identity assertion at attribute layer: " + this._performIDAssertion + ", Perform authorization token at attribute layer: " + this._performAuthorizationToken + ", Authorization service configuration names: " + this._performServiceCfgList;
            SecurityLogger.debugMessage(string, string2);
        }
        if (bl) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0552I", "JSAS0552I: Evaluation of the attribute layer failed.");
            throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByClient, string2);
        }
    }

    public final synchronized CSIv2EffectivePerformPolicy getEffectivePolicy(CSIv2TaggedComponent[] cSIv2TaggedComponentArray, String string, Object object) throws CSIv2RequirementsNotSatisfied {
        String string2 = "";
        String string3 = "CSIv2EffectivePerformPolicy.getEffectivePolicy";
        this._method = string;
        this._proxy = object;
        Object var6_6 = null;
        CSIv2TaggedComponent cSIv2TaggedComponent = null;
        CSIv2TaggedComponentHolder cSIv2TaggedComponentHolder = null;
        string2 = "Enter getEffectivePolicy.";
        SecurityLogger.debugMessage(string3, string2);
        if (cSIv2TaggedComponentArray.length > 0) {
            int n;
            Vector vector = null;
            boolean bl = true;
            for (int i = 0; i < 2; ++i) {
                bl = i == 0;
                for (n = 0; n < cSIv2TaggedComponentArray.length; ++n) {
                    boolean bl2 = true;
                    cSIv2TaggedComponent = cSIv2TaggedComponentArray[n];
                    cSIv2TaggedComponentHolder = new CSIv2TaggedComponentHolder(cSIv2TaggedComponent);
                    vector = new Vector();
                    try {
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "Evaluating CSIv2 tag " + (n + 1) + " of " + cSIv2TaggedComponentArray.length + " validate CertAuth:" + bl;
                            SecurityLogger.debugMessage(string3, string2);
                        }
                        bl2 = this.evaluate(cSIv2TaggedComponentHolder, this, vector, bl);
                    }
                    catch (CSIv2RequirementsNotSatisfied cSIv2RequirementsNotSatisfied) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "CSIv2 tag " + n + " failed evaluation.";
                            SecurityLogger.debugMessage(string3, string2);
                        }
                        FFDCFilter.processException((Throwable)((Object)cSIv2RequirementsNotSatisfied), "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.getEffectivePolicy", "1296");
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "CSIv2 tag " + (n + 1) + " evaluation succeeded.";
                        SecurityLogger.debugMessage(string3, string2);
                    }
                    if (!this._disableCache) {
                        if (csiv2EffectivePolicyCache.size() > 50) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string2 = "Clearing effective policy cache, size > 50";
                                SecurityLogger.debugMessage(string3, string2);
                            }
                            csiv2EffectivePolicyCache.clear();
                        }
                        if (this._performClientAuth || !this._performClientAuth && this._method != null && !this._method.equals("")) {
                            csiv2EffectivePolicyCache.put(cSIv2TaggedComponentArray, this);
                        }
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "Size of effective policy cache = " + csiv2EffectivePolicyCache.size();
                            SecurityLogger.debugMessage(string3, string2);
                        }
                    } else if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Skip inserting this into effective policy cache.";
                        SecurityLogger.debugMessage(string3, string2);
                    }
                    return this;
                }
            }
            if (vector == null) {
                throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByTarget, "SECURITY CLIENT/SERVER CONFIG MISMATCH:  The server does not support the client configuration.");
            }
            if (vector.isEmpty()) {
                throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByTarget, "SECURITY CLIENT/SERVER CONFIG MISMATCH:  The server does not support the client configuration.");
            }
            StringBuffer stringBuffer = new StringBuffer(500);
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(SecurityMessages.getMsgOrUseDefault("JSAS1477W", "JSAS1477W: SECURITY CLIENT/SERVER CONFIG MISMATCH:  The client security configuration (sas.client.props or outbound settings in GUI) does not support the server security configuration for the following reasons: "));
            n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("     ");
                stringBuffer.append(SecurityMessages.getMsgOrUseDefault("Error", "ERROR "));
                stringBuffer.append(++n);
                stringBuffer.append(": ");
                stringBuffer.append(string4);
            }
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(System.getProperty("line.separator"));
            string2 = stringBuffer.toString();
            SecurityLogger.logWarning(string3, string2);
            throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByTarget, stringBuffer.toString());
        }
        throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByTarget, "There are no CSIv2 Tagged Components in the List.");
    }

    private final boolean evaluate(CSIv2TaggedComponentHolder cSIv2TaggedComponentHolder, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy, Vector vector, boolean bl) throws CSIv2RequirementsNotSatisfied {
        block13: {
            String string = "";
            String string2 = "CSIv2EffectivePerformPolicy.evaluate";
            try {
                if (secConfig == null) {
                    VaultImpl.getInstance();
                    secConfig = VaultImpl.getSecurityConfiguration();
                }
                if (cSIv2TaggedComponentHolder != null && cSIv2TaggedComponentHolder.value != null) {
                    CSIv2TaggedComponent cSIv2TaggedComponent = cSIv2TaggedComponentHolder.value;
                    this.savedCSIv2Tag = cSIv2TaggedComponentHolder;
                    if (cSIv2EffectivePerformPolicy != null) {
                        boolean bl2 = false;
                        try {
                            cSIv2EffectivePerformPolicy.evaluateStatefulness(cSIv2TaggedComponent.isStateFul(), vector);
                        }
                        catch (CSIv2RequirementsNotSatisfied cSIv2RequirementsNotSatisfied) {
                            bl2 = true;
                        }
                        try {
                            cSIv2EffectivePerformPolicy.evaluateAttributeLayer(cSIv2TaggedComponent.getSAS_context_mech_holder(), vector);
                        }
                        catch (CSIv2RequirementsNotSatisfied cSIv2RequirementsNotSatisfied) {
                            FFDCFilter.processException((Throwable)((Object)cSIv2RequirementsNotSatisfied), "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.evaluate", "1423");
                            bl2 = true;
                        }
                        try {
                            cSIv2EffectivePerformPolicy.evaluateClientAuthLayer(cSIv2TaggedComponent.getAS_context_mech_holder(), vector);
                        }
                        catch (CSIv2RequirementsNotSatisfied cSIv2RequirementsNotSatisfied) {
                            bl2 = true;
                        }
                        try {
                            cSIv2EffectivePerformPolicy.evaluateTransportLayer(cSIv2TaggedComponent, vector, bl);
                        }
                        catch (CSIv2RequirementsNotSatisfied cSIv2RequirementsNotSatisfied) {
                            bl2 = true;
                        }
                        return !bl2;
                    }
                    string = "Effective policy object is null.";
                    SecurityLogger.debugMessage(string2, string);
                    vector.addElement(string);
                    break block13;
                }
                string = "CSIv2TagHolder is null or the value inside is null.";
                SecurityLogger.debugMessage(string2, string);
                vector.addElement(string);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.evaluate", "1467");
                string = "Exception in getEffectivePolicy, probably CSIv2RequirementsNotSatisfied.";
                SecurityLogger.debugMessage(string2, string);
                SecurityLogger.logException(string2, exception, 0, 0);
            }
        }
        return false;
    }

    public boolean isStateful() {
        return this._stateful;
    }

    public void setStateful(boolean bl) {
        this._stateful = bl;
    }

    public long getStatefulContextID() {
        return this._stateful_context_id;
    }

    public void setStatefulContextID(long l) {
        this._stateful_context_id = l;
    }

    public ClientSessionKey getClientSessionKey() {
        return this._client_session_key;
    }

    public void setClientSessionKey(ClientSessionKey clientSessionKey) {
        this._client_session_key = clientSessionKey;
    }

    public String getConnectionKey() {
        return this._connectionKey;
    }

    public void setConnectionKey(String string) {
        this._connectionKey = string;
    }

    public boolean getIsInternalRequestPolicy() {
        return this._isInternalRequestPolicy;
    }

    private CSIv2EffectivePerformPolicy() {
    }

    public static CSIv2EffectivePerformPolicy getInstance(CSIv2TaggedComponent[] cSIv2TaggedComponentArray) throws CSIv2RequirementsNotSatisfied {
        return CSIv2EffectivePerformPolicy.getInstance(cSIv2TaggedComponentArray, null, null);
    }

    public static CSIv2EffectivePerformPolicy getInstance(CSIv2TaggedComponent[] cSIv2TaggedComponentArray, String string, Object object) throws CSIv2RequirementsNotSatisfied {
        String string2 = null;
        String string3 = "CSIv2EffectivePerformPolicy.getInstance";
        try {
            CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy = null;
            if (!CSIv2EffectivePerformPolicy.methodRequiresAuthenticationRegardlessOfPolicy(string, object)) {
                cSIv2EffectivePerformPolicy = (CSIv2EffectivePerformPolicy)csiv2EffectivePolicyCache.get(cSIv2TaggedComponentArray);
            }
            if (cSIv2EffectivePerformPolicy != null) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Returning policy from cache for CSIv2TagList: " + cSIv2TaggedComponentArray;
                    SecurityLogger.debugMessage(string3, string2);
                }
                return (CSIv2EffectivePerformPolicy)cSIv2EffectivePerformPolicy.clone();
            }
            cSIv2EffectivePerformPolicy = CSIv2EffectivePerformPolicy.getInstance();
            cSIv2EffectivePerformPolicy.getEffectivePolicy(cSIv2TaggedComponentArray, string, object);
            return cSIv2EffectivePerformPolicy;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.getInstance", "1761");
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Exception creating effective policy.";
                SecurityLogger.debugMessage(string3, string2);
            }
            SecurityLogger.logException(string3, exception, 0, 0);
            return null;
        }
    }

    public static CSIv2EffectivePerformPolicy getInternalRequestPolicyInstance() {
        CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy = new CSIv2EffectivePerformPolicy();
        String string = "csiv2";
        cSIv2EffectivePerformPolicy._stateful = false;
        cSIv2EffectivePerformPolicy._stateful_context_id = 0L;
        cSIv2EffectivePerformPolicy._client_session_key = null;
        cSIv2EffectivePerformPolicy._connectionKey = "";
        cSIv2EffectivePerformPolicy._mechTypeIdentity = "";
        cSIv2EffectivePerformPolicy._performTLClientAuth = true;
        cSIv2EffectivePerformPolicy._performTLServerAuth = false;
        cSIv2EffectivePerformPolicy._performMsgDetectReplay = false;
        cSIv2EffectivePerformPolicy._performMsgDetectMisordering = false;
        cSIv2EffectivePerformPolicy._performMsgIntegrity = false;
        cSIv2EffectivePerformPolicy._performMsgConfidentiality = false;
        cSIv2EffectivePerformPolicy._performSSLTLS = false;
        cSIv2EffectivePerformPolicy._performSECIOP = false;
        cSIv2EffectivePerformPolicy._performSECIOPMechOID = "";
        cSIv2EffectivePerformPolicy._targetHostName = "INTERNAL_SERVER_REQUEST";
        cSIv2EffectivePerformPolicy._targetTCPPort = 0;
        cSIv2EffectivePerformPolicy._targetSSLPort = 0;
        cSIv2EffectivePerformPolicy._performClientAuth = false;
        cSIv2EffectivePerformPolicy._claimClientAuthRequired = false;
        cSIv2EffectivePerformPolicy._performClientAuthMechOID = "oid:2.23.130.1.1.1";
        cSIv2EffectivePerformPolicy._targetSecurityName = "";
        cSIv2EffectivePerformPolicy._performIDAssertion = true;
        cSIv2EffectivePerformPolicy._performServiceCfgList = "";
        cSIv2EffectivePerformPolicy._performAuthorizationToken = false;
        cSIv2EffectivePerformPolicy._performIDANamingMechList = new String[]{"oid:2.23.130.1.1.1"};
        cSIv2EffectivePerformPolicy._performIdentityTokenType = 15;
        cSIv2EffectivePerformPolicy._performDelegationByClient = false;
        cSIv2EffectivePerformPolicy._isInternalRequestPolicy = true;
        if (SecurityLogger.debugTraceEnabled) {
            String string2 = "Returning local policy created for internal: " + cSIv2EffectivePerformPolicy;
            SecurityLogger.debugMessage("getInternalRequestPolicyInstance", string2);
        }
        return cSIv2EffectivePerformPolicy;
    }

    public static CSIv2EffectivePerformPolicy getInstance() {
        return new CSIv2EffectivePerformPolicy();
    }

    public CSIv2TaggedComponentHolder getCSIv2TaggedComponent() {
        return this.savedCSIv2Tag;
    }

    protected Object clone() {
        CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy = new CSIv2EffectivePerformPolicy();
        cSIv2EffectivePerformPolicy._client_session_key = null;
        cSIv2EffectivePerformPolicy._stateful_context_id = 0L;
        cSIv2EffectivePerformPolicy._connectionKey = this._connectionKey;
        cSIv2EffectivePerformPolicy._claimClientAuthRequired = this._claimClientAuthRequired;
        cSIv2EffectivePerformPolicy._mechTypeIdentity = this._mechTypeIdentity;
        cSIv2EffectivePerformPolicy._performAuthorizationToken = this._performAuthorizationToken;
        cSIv2EffectivePerformPolicy._performClientAuth = this._performClientAuth;
        cSIv2EffectivePerformPolicy._performClientAuthMechOID = this._performClientAuthMechOID;
        cSIv2EffectivePerformPolicy._performDelegationByClient = this._performDelegationByClient;
        cSIv2EffectivePerformPolicy._performIDANamingMechList = this._performIDANamingMechList;
        cSIv2EffectivePerformPolicy._performIDAssertion = this._performIDAssertion;
        cSIv2EffectivePerformPolicy._performIdentityTokenType = this._performIdentityTokenType;
        cSIv2EffectivePerformPolicy._performMsgConfidentiality = this._performMsgConfidentiality;
        cSIv2EffectivePerformPolicy._performMsgDetectMisordering = this._performMsgDetectMisordering;
        cSIv2EffectivePerformPolicy._performMsgDetectReplay = this._performMsgDetectReplay;
        cSIv2EffectivePerformPolicy._performMsgIntegrity = this._performMsgIntegrity;
        cSIv2EffectivePerformPolicy._performSECIOP = this._performSECIOP;
        cSIv2EffectivePerformPolicy._performSECIOPMechOID = this._performSECIOPMechOID;
        cSIv2EffectivePerformPolicy._performServiceCfgList = this._performServiceCfgList;
        cSIv2EffectivePerformPolicy._performSSLTLS = this._performSSLTLS;
        cSIv2EffectivePerformPolicy._performTLClientAuth = this._performTLClientAuth;
        cSIv2EffectivePerformPolicy._performTLServerAuth = this._performTLServerAuth;
        cSIv2EffectivePerformPolicy._protocol = this._protocol;
        cSIv2EffectivePerformPolicy._stateful = this._stateful;
        cSIv2EffectivePerformPolicy._targetHostName = this._targetHostName;
        cSIv2EffectivePerformPolicy._targetSecurityName = this._targetSecurityName;
        cSIv2EffectivePerformPolicy._targetSSLPort = this._targetSSLPort;
        cSIv2EffectivePerformPolicy._targetTCPPort = this._targetTCPPort;
        cSIv2EffectivePerformPolicy.savedCSIv2Tag = this.savedCSIv2Tag;
        cSIv2EffectivePerformPolicy._isInternalRequestPolicy = this._isInternalRequestPolicy;
        return cSIv2EffectivePerformPolicy;
    }

    public CSIv2EffectivePerformPolicy(byte[] byArray) throws Exception {
        this.deserializeVariables(byArray);
    }

    public byte[] getBytes() throws Exception {
        String string = "";
        String string2 = "CSIv2EffectivePerformPolicy.getBytes";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string2);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string = "Session contents prior to serialization: " + this.toString();
            SecurityLogger.debugMessage(string2, string);
        }
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(300);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeBoolean(this._stateful);
            dataOutputStream.writeBoolean(this._performTLClientAuth);
            dataOutputStream.writeBoolean(this._performTLServerAuth);
            dataOutputStream.writeBoolean(this._performMsgDetectReplay);
            dataOutputStream.writeBoolean(this._performMsgDetectMisordering);
            dataOutputStream.writeBoolean(this._performMsgIntegrity);
            dataOutputStream.writeBoolean(this._performMsgConfidentiality);
            dataOutputStream.writeBoolean(this._performSSLTLS);
            dataOutputStream.writeBoolean(this._performSECIOP);
            dataOutputStream.writeBoolean(this._performClientAuth);
            dataOutputStream.writeBoolean(this._claimClientAuthRequired);
            dataOutputStream.writeBoolean(this._performIDAssertion);
            dataOutputStream.writeBoolean(this._performAuthorizationToken);
            dataOutputStream.writeBoolean(this._performDelegationByClient);
            dataOutputStream.writeLong(this._stateful_context_id);
            dataOutputStream.writeInt(this._targetTCPPort);
            dataOutputStream.writeInt(this._targetSSLPort);
            dataOutputStream.writeInt(this._performIdentityTokenType);
            if (this._connectionKey != null && this._connectionKey.length() > 0) {
                dataOutputStream.writeInt(this._connectionKey.length());
                dataOutputStream.write(this._connectionKey.getBytes(), 0, this._connectionKey.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this._mechTypeIdentity != null && this._mechTypeIdentity.length() > 0) {
                dataOutputStream.writeInt(this._mechTypeIdentity.length());
                dataOutputStream.write(this._mechTypeIdentity.getBytes(), 0, this._mechTypeIdentity.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this._performSECIOPMechOID != null && this._performSECIOPMechOID.length() > 0) {
                dataOutputStream.writeInt(this._performSECIOPMechOID.length());
                dataOutputStream.write(this._performSECIOPMechOID.getBytes(), 0, this._performSECIOPMechOID.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this._targetHostName != null && this._targetHostName.length() > 0) {
                dataOutputStream.writeInt(this._targetHostName.length());
                dataOutputStream.write(this._targetHostName.getBytes(), 0, this._targetHostName.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this._performClientAuthMechOID != null && this._performClientAuthMechOID.length() > 0) {
                dataOutputStream.writeInt(this._performClientAuthMechOID.length());
                dataOutputStream.write(this._performClientAuthMechOID.getBytes(), 0, this._performClientAuthMechOID.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this._targetSecurityName != null && this._targetSecurityName.length() > 0) {
                dataOutputStream.writeInt(this._targetSecurityName.length());
                dataOutputStream.write(this._targetSecurityName.getBytes(), 0, this._targetSecurityName.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this._performServiceCfgList != null && this._performServiceCfgList.length() > 0) {
                dataOutputStream.writeInt(this._performServiceCfgList.length());
                dataOutputStream.write(this._performServiceCfgList.getBytes(), 0, this._performServiceCfgList.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this._performIDANamingMechList != null) {
                dataOutputStream.writeInt(this._performIDANamingMechList.length);
                for (int i = 0; i < this._performIDANamingMechList.length; ++i) {
                    if (this._performIDANamingMechList[i] != null && this._performIDANamingMechList[i].length() > 0) {
                        dataOutputStream.writeInt(this._performIDANamingMechList[i].length());
                        dataOutputStream.write(this._performIDANamingMechList[i].getBytes(), 0, this._performIDANamingMechList[i].length());
                        continue;
                    }
                    dataOutputStream.writeInt(0);
                }
            } else {
                dataOutputStream.writeInt(0);
            }
            dataOutputStream.writeBoolean(this._isInternalRequestPolicy);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.getBytes", "2040", this);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exception serializing native variables.";
                SecurityLogger.debugMessage(string2, string);
            }
            SecurityLogger.logException(string2, exception, 0, 0);
            throw exception;
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (dataOutputStream != null) {
                dataOutputStream.close();
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
        return byArray;
    }

    private void deserializeVariables(byte[] byArray) throws Exception {
        String string = "";
        String string2 = "ExtendedSSLConnectionData.deserializeVariables";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string2);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            byte[] byArray2;
            this._stateful = dataInputStream.readBoolean();
            this._performTLClientAuth = dataInputStream.readBoolean();
            this._performTLServerAuth = dataInputStream.readBoolean();
            this._performMsgDetectReplay = dataInputStream.readBoolean();
            this._performMsgDetectMisordering = dataInputStream.readBoolean();
            this._performMsgIntegrity = dataInputStream.readBoolean();
            this._performMsgConfidentiality = dataInputStream.readBoolean();
            this._performSSLTLS = dataInputStream.readBoolean();
            this._performSECIOP = dataInputStream.readBoolean();
            this._performClientAuth = dataInputStream.readBoolean();
            this._claimClientAuthRequired = dataInputStream.readBoolean();
            this._performIDAssertion = dataInputStream.readBoolean();
            this._performAuthorizationToken = dataInputStream.readBoolean();
            this._performDelegationByClient = dataInputStream.readBoolean();
            this._stateful_context_id = dataInputStream.readLong();
            this._targetTCPPort = dataInputStream.readInt();
            this._targetSSLPort = dataInputStream.readInt();
            this._performIdentityTokenType = dataInputStream.readInt();
            int n = dataInputStream.readInt();
            if (n > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this._connectionKey = new String(byArray2);
            }
            if ((n = dataInputStream.readInt()) > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this._mechTypeIdentity = new String(byArray2);
            }
            if ((n = dataInputStream.readInt()) > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this._performSECIOPMechOID = new String(byArray2);
            }
            if ((n = dataInputStream.readInt()) > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this._targetHostName = new String(byArray2);
            }
            if ((n = dataInputStream.readInt()) > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this._performClientAuthMechOID = new String(byArray2);
            }
            if ((n = dataInputStream.readInt()) > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this._targetSecurityName = new String(byArray2);
            }
            if ((n = dataInputStream.readInt()) > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this._performServiceCfgList = new String(byArray2);
            }
            int n2 = dataInputStream.readInt();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < n2; ++i) {
                n = dataInputStream.readInt();
                if (n <= 0) continue;
                byte[] byArray3 = new byte[n];
                dataInputStream.read(byArray3, 0, n);
                arrayList.add(new String(byArray3));
            }
            if (arrayList.size() > 0) {
                this._performIDANamingMechList = arrayList.toArray(new String[0]);
            }
            this._isInternalRequestPolicy = dataInputStream.readBoolean();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.orbssl.ExtendedSSLConnectionData.deserializeVariables", "2187", this);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exception de-serializing native variables.";
                SecurityLogger.debugMessage(string2, string);
            }
            SecurityLogger.logException(string2, exception, 0, 0);
            throw exception;
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            string = "Session after deserialization: " + this.toString();
            SecurityLogger.debugMessage(string2, string);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n_stateful: " + this._stateful);
        stringBuffer.append("\n_performTLClientAuth: " + this._performTLClientAuth);
        stringBuffer.append("\n_performTLServerAuth: " + this._performTLServerAuth);
        stringBuffer.append("\n_performMsgDetectReplay: " + this._performMsgDetectReplay);
        stringBuffer.append("\n_performMsgDetectMisordering: " + this._performMsgDetectMisordering);
        stringBuffer.append("\n_performMsgIntegrity: " + this._performMsgIntegrity);
        stringBuffer.append("\n_performMsgConfidentiality: " + this._performMsgConfidentiality);
        stringBuffer.append("\n_performSSLTLS: " + this._performSSLTLS);
        stringBuffer.append("\n_performSECIOP: " + this._performSECIOP);
        stringBuffer.append("\n_performClientAuth: " + this._performClientAuth);
        stringBuffer.append("\n_claimClientAuthRequired: " + this._claimClientAuthRequired);
        stringBuffer.append("\n_performIDAssertion: " + this._performIDAssertion);
        stringBuffer.append("\n_performAuthorizationToken: " + this._performAuthorizationToken);
        stringBuffer.append("\n_performDelegationByClient: " + this._performDelegationByClient);
        stringBuffer.append("\n_stateful_context_id: " + this._stateful_context_id);
        stringBuffer.append("\n_targetTCPPort: " + this._targetTCPPort);
        stringBuffer.append("\n_targetSSLPort: " + this._targetSSLPort);
        stringBuffer.append("\n_performIdentityTokenType: " + this._performIdentityTokenType);
        stringBuffer.append("\n_mechTypeIdentity: " + this._mechTypeIdentity);
        stringBuffer.append("\n_performSECIOPMechOID: " + this._performSECIOPMechOID);
        stringBuffer.append("\n_targetHostName: " + this._targetHostName);
        stringBuffer.append("\n_performClientAuthMechOID: " + this._performClientAuthMechOID);
        stringBuffer.append("\n_targetSecurityName: " + this._targetSecurityName);
        stringBuffer.append("\n_performServiceCfgList: " + this._performServiceCfgList);
        stringBuffer.append("\n_performIDANamingMechList length: " + (this._performIDANamingMechList == null ? "0" : Integer.toString(this._performIDANamingMechList.length)));
        stringBuffer.append("\n_internalRequestPolicy: " + this._isInternalRequestPolicy);
        stringBuffer.append("\n_connectionKey: " + this._connectionKey);
        return stringBuffer.toString();
    }

    private static boolean methodRequiresAuthenticationRegardlessOfPolicy(String string, Object object) {
        String string2 = "CSIv2EffectivePerformPolicy.methodRequiresAuthenticationRegardlessOfPolicy";
        String string3 = null;
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "Method: " + string + ", interfaceName: " + (object == null ? "null" : object.getClass().getName());
            SecurityLogger.debugMessage(string2, string3);
        }
        if (object == null || string == null) {
            return false;
        }
        boolean bl = false;
        String string4 = object.getClass().getName();
        if ((string4.equals("com.ibm.ws.orb.services.lsd._LocationServiceStub") || string4.equals("com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl") || string4.equals("com.ibm.org.omg.CORBA._ObjectStub")) && (string.equals("register_server") || string.equals("unregister_server") || string.equals("register_object_adapters") || string.equals("usregister_object_adapters"))) {
            bl = true;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "methodRequiresAuthenticationRegardlessOfPolicy: returned " + bl + ".";
            SecurityLogger.debugMessage(string2, string3);
        }
        return bl;
    }
}

