/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.MechanismAmbiguityException;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import java.util.Hashtable;

public class AuthenticationTarget {
    public static final int Unknown = 0;
    public static final String UnknownString = "unknown";
    public static final int LTPA = 1;
    public static final String LTPAString = "ltpa";
    public static final int LocalOS = 2;
    public static final String LocalOSString = "localos";
    public static final int DCE = 3;
    public static final String DCEString = "dce";
    public static final int BasicAuth = 4;
    public static final String BasicAuthString = "basicauth";
    public static final int DigitalCerts = 5;
    public static final String DigitalCertsString = "digitalcerts";
    public static final int KRB5 = 6;
    public static final String KRB5String = "kerberos";
    public static final int SWAM = 7;
    public static final String SWAMString = "swam";
    public static final int Custom = 8;
    public static final String CustomString = "custom";
    public static final int ICSF = 9;
    public static final String ICSFString = "icsf";
    private SecurityConfiguration secConfig = VaultImpl.getSecurityConfiguration();
    public static Hashtable strings = new Hashtable();
    public static Hashtable ids = new Hashtable();

    public final String authTargetToOid(int n) {
        String string = null;
        if (n == 8) {
            string = this.secConfig.getWSSecurityContextCustomOID();
        } else if (n == 4) {
            string = "oid:2.23.130.1.1.1";
        } else if (n == 1) {
            string = "oid:1.3.18.0.2.30.2";
        } else if (n == 6) {
            string = "oid:1.2.840.113554.1.2.2";
        } else if (n == 2) {
            string = "No OID for this mechanism";
        } else {
            switch (this.secConfig.getauthenticationTarget()) {
                case 8: {
                    string = this.secConfig.getWSSecurityContextCustomOID();
                    break;
                }
                case 4: {
                    string = "oid:2.23.130.1.1.1";
                    break;
                }
                case 1: {
                    string = "oid:1.3.18.0.2.30.2";
                    break;
                }
                case 6: {
                    string = "oid:1.2.840.113554.1.2.2";
                    break;
                }
                case 2: {
                    string = "No OID for this mechanism";
                    break;
                }
                default: {
                    string = "oid:2.23.130.1.1.1";
                }
            }
        }
        return string;
    }

    public final int oidToAuthTarget(String string) {
        int n = 0;
        if (string != null && string.length() != 0) {
            if (OID.compareOIDs(string, this.secConfig.getWSSecurityContextCustomOID())) {
                n = 8;
            } else if (OID.compareOIDs(string, "oid:2.23.130.1.1.1")) {
                n = 4;
            } else if (OID.compareOIDs(string, "oid:1.3.18.0.2.30.2")) {
                n = 1;
            } else if (OID.compareOIDs(string, "oid:1.2.840.113554.1.2.2")) {
                n = 6;
            } else if (OID.compareOIDs(string, "No OID for this mechanism")) {
                n = 2;
            }
        } else {
            n = this.secConfig.getauthenticationTarget();
        }
        return n;
    }

    public final int mechtypeToAuthTarget(String string) throws MechanismAmbiguityException {
        String string2 = "SecurityContextImpl.mechtypeToAuthTarget";
        String string3 = null;
        if (string != null && string.length() != 0) {
            if (string.equals(VaultConstants.CLIENT_CERT_MECH_TYPE)) {
                VaultImpl.getInstance();
                SecurityConfiguration securityConfiguration = VaultImpl.getSecurityConfiguration();
                if (securityConfiguration == null) {
                    string3 = "Unable to access security configuration.";
                    SecurityLogger.debugMessage(string2, string3);
                    throw new MechanismAmbiguityException();
                }
                return securityConfiguration.getauthenticationTarget();
            }
            if (string.equals(VaultConstants.LTPA_MECH_TYPE)) {
                return 1;
            }
            if (string.equals("1.3")) {
                return 1;
            }
            if (string.equals("5.1")) {
                return 1;
            }
            if (string.equals(VaultConstants.CUSTOM_MECH_TYPE)) {
                return 8;
            }
            if (string.equals("1.7")) {
                return 8;
            }
            if (string.equals("5.9")) {
                return 8;
            }
            if (string.equals(VaultConstants.LOCAL_OS_MECH_TYPE)) {
                return 2;
            }
            if (string.equals("1.4")) {
                return 2;
            }
            if (string.equals("5.2")) {
                return 2;
            }
            if (string.equals(VaultConstants.KRB5_MECH_TYPE)) {
                return 6;
            }
            if (string.equals("1.6")) {
                return 6;
            }
            if (string.equals("5.8")) {
                return 6;
            }
            if (string.equals("4.1")) {
                return 6;
            }
            if (string.equals(VaultConstants.GSSUP_MECH_TYPE)) {
                return 4;
            }
            if (string.equals("1.5")) {
                return 4;
            }
            if (string.equals("1.5.1")) {
                return 4;
            }
            if (string.equals("1.5.2")) {
                return 4;
            }
            if (string.equals("1.5.4")) {
                return 4;
            }
            if (string.equals("5.7.4")) {
                return 4;
            }
            if (string.equals("5.7.1")) {
                return 4;
            }
            if (string.equals("5.7.2")) {
                return 4;
            }
            if (string.equals("5.7.5")) {
                return 4;
            }
            if (string.equals("1.1")) {
                return 4;
            }
            if (string.equals("1.1.1")) {
                return 4;
            }
            if (string.equals("1.1.2")) {
                return 4;
            }
            if (string.equals("5.6")) {
                return 4;
            }
            if (string.equals("5.3")) {
                return 4;
            }
            if (string.equals("5.4")) {
                return 4;
            }
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "Unknown security mechanism type.";
                SecurityLogger.debugMessage(string2, string3);
            }
            throw new MechanismAmbiguityException();
        }
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "Unknown security mechanism type.";
            SecurityLogger.debugMessage(string2, string3);
        }
        throw new MechanismAmbiguityException();
    }

    static {
        strings.put(new Integer(0), UnknownString);
        strings.put(new Integer(1), LTPAString);
        strings.put(new Integer(2), LocalOSString);
        strings.put(new Integer(3), DCEString);
        strings.put(new Integer(4), BasicAuthString);
        strings.put(new Integer(5), DigitalCertsString);
        strings.put(new Integer(6), KRB5String);
        strings.put(new Integer(7), SWAMString);
        strings.put(new Integer(8), CustomString);
        strings.put(new Integer(9), ICSFString);
        ids.put(UnknownString, new Integer(0));
        ids.put(LTPAString, new Integer(1));
        ids.put(LocalOSString, new Integer(2));
        ids.put(DCEString, new Integer(3));
        ids.put(BasicAuthString, new Integer(4));
        ids.put(DigitalCertsString, new Integer(5));
        ids.put(KRB5String, new Integer(6));
        ids.put(SWAMString, new Integer(7));
        ids.put(CustomString, new Integer(8));
        ids.put(ICSFString, new Integer(9));
    }
}

