/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import [Ljava.security.cert.X509Certificate;;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.BasicAuthWithRealm;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.MechanismAmbiguityException;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.csiv2.TrustedIDEvaluatorFactory;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import javax.security.auth.Subject;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.MARSHAL;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.MessageInContext;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.RequestInfo;
import org.omg.Security.OpaqueHelper;
import org.omg.Security.OpaqueHolder;

public class CSIUtil {
    private Codec codec = null;
    private ORB orb = null;
    private VaultImpl vault = null;
    private CurrentImpl current = null;
    private CSICredentialsManager credsMgr = null;
    private MechanismFactory mechFactory = null;
    private ContextManager contextManager = null;
    private byte[] nullByteArray = new byte[0];
    private static CSIUtil csiUtil = null;

    public static CSIUtil getInstance() {
        if (csiUtil == null) {
            csiUtil = new CSIUtil();
        }
        return csiUtil;
    }

    public CSIUtil() {
        if (ConfigURLProperties.isSecurityEnabled()) {
            this.getORB();
            this.vault = VaultImpl.getInstance();
            if (this.vault != null) {
                this.mechFactory = this.vault.getMechanismFactory();
            }
        }
    }

    public SASContextBody get_message_from_sc(ServiceContext serviceContext) {
        return this.get_message_from_sc(serviceContext.context_data);
    }

    public SASContextBody get_message_from_sc(com.ibm.CORBA.iiop.ServiceContext serviceContext) {
        return this.get_message_from_sc(serviceContext.getContextData());
    }

    public SASContextBody get_message_from_sc(byte[] byArray) {
        String string = "";
        String string2 = "CSIUtil.get_message_from_sc";
        Any any = null;
        SASContextBody sASContextBody = null;
        try {
            if (byArray != null) {
                any = this.getCodec().decode_value(byArray, SASContextBodyHelper.type());
            } else if (SecurityLogger.debugTraceEnabled) {
                string = "The context_data in the service_context is null.";
                SecurityLogger.debugMessage(string2, string);
            }
            if (any != null) {
                sASContextBody = SASContextBodyHelper.extract(any);
            } else if (SecurityLogger.debugTraceEnabled) {
                string = "The any object from the service context was null.";
                SecurityLogger.debugMessage(string2, string);
            }
        }
        catch (MARSHAL mARSHAL) {
            FFDCFilter.processException((Throwable)mARSHAL, "com.ibm.ISecurityUtilityImpl.CSIUtil.get_message_from_sc", "242", this);
            SecurityLogger.logException(string2, (Exception)((Object)mARSHAL), 0, 0);
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            FFDCFilter.processException((Throwable)bAD_OPERATION, "com.ibm.ISecurityUtilityImpl.CSIUtil.get_message_from_sc", "247", this);
            SecurityLogger.logException(string2, (Exception)((Object)bAD_OPERATION), 0, 0);
        }
        catch (FormatMismatch formatMismatch) {
            FFDCFilter.processException((Throwable)formatMismatch, "com.ibm.ISecurityUtilityImpl.CSIUtil.get_message_from_sc", "252", this);
            SecurityLogger.logException(string2, (Exception)((Object)formatMismatch), 0, 0);
        }
        catch (TypeMismatch typeMismatch) {
            FFDCFilter.processException((Throwable)typeMismatch, "com.ibm.ISecurityUtilityImpl.CSIUtil.get_message_from_sc", "257", this);
            SecurityLogger.logException(string2, (Exception)((Object)typeMismatch), 0, 0);
        }
        return sASContextBody;
    }

    public ServiceContext get_sc_from_request(RequestInfo requestInfo) {
        ServiceContext serviceContext = null;
        serviceContext = ((ExtendedServerRequestInfo)requestInfo).getRequestServiceContext(15);
        return serviceContext;
    }

    public ServiceContext get_sc_from_reply(RequestInfo requestInfo) {
        String string = "";
        String string2 = "CSIUtil.get_sc_from_reply";
        ServiceContext serviceContext = null;
        serviceContext = ((ExtendedClientRequestInfo)requestInfo).getReplyServiceContext(15);
        return serviceContext;
    }

    public com.ibm.CORBA.iiop.ServiceContext get_sc_from_request(GIOPMessageContext gIOPMessageContext) {
        com.ibm.CORBA.iiop.ServiceContext serviceContext = null;
        try {
            serviceContext = gIOPMessageContext.getServiceContexts().get(15);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return serviceContext;
    }

    public com.ibm.CORBA.iiop.ServiceContext get_sc_from_reply(GIOPMessageContext gIOPMessageContext) {
        String string = "";
        String string2 = "CSIUtil.get_sc_from_reply";
        com.ibm.CORBA.iiop.ServiceContext serviceContext = null;
        try {
            serviceContext = gIOPMessageContext.getServiceContexts().get(15);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return serviceContext;
    }

    public ServiceContext create_sc_from_ec_message(EstablishContext establishContext) {
        String string = "";
        String string2 = "CSIUtil.create_sc_from_ec_message";
        ServiceContext serviceContext = null;
        if (this.orb != null) {
            SASContextBody sASContextBody = new SASContextBody();
            sASContextBody.establish_msg(establishContext);
            Any any = this.orb.create_any();
            SASContextBodyHelper.insert(any, sASContextBody);
            byte[] byArray = null;
            try {
                byArray = this.getCodec().encode_value(any);
            }
            catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                FFDCFilter.processException((Throwable)invalidTypeForEncoding, "com.ibm.ISecurityUtilityImpl.CSIUtil.create_sc_from_ec_message", "373", this);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "An InvalidTypeForEncoding exception occurred.";
                    SecurityLogger.debugMessage(string2, string);
                }
                SecurityLogger.logException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
            }
            if (byArray != null) {
                serviceContext = new ServiceContext(15, byArray);
            } else if (SecurityLogger.debugTraceEnabled) {
                string = "The service context data is null.";
                SecurityLogger.debugMessage(string2, string);
            }
        } else if (SecurityLogger.debugTraceEnabled) {
            string = "The service context data is null.";
            SecurityLogger.debugMessage(string2, string);
        }
        return serviceContext;
    }

    public ServiceContext create_sc_from_mic_message(MessageInContext messageInContext) {
        String string = "";
        String string2 = "CSIUtil.create_sc_from_mic_message";
        ServiceContext serviceContext = null;
        if (this.orb != null) {
            SASContextBody sASContextBody = new SASContextBody();
            sASContextBody.in_context_msg(messageInContext);
            Any any = this.orb.create_any();
            SASContextBodyHelper.insert(any, sASContextBody);
            byte[] byArray = null;
            try {
                byArray = this.getCodec().encode_value(any);
            }
            catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                FFDCFilter.processException((Throwable)invalidTypeForEncoding, "com.ibm.ISecurityUtilityImpl.CSIUtil.create_sc_from_mic_message", "440", this);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "An InvalidTypeForEncoding exception occurred.";
                    SecurityLogger.debugMessage(string2, string);
                }
                SecurityLogger.logException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
            }
            if (byArray != null) {
                serviceContext = new ServiceContext(15, byArray);
            } else if (SecurityLogger.debugTraceEnabled) {
                string = "The service context data is null.";
                SecurityLogger.debugMessage(string2, string);
            }
        } else if (SecurityLogger.debugTraceEnabled) {
            string = "The service context data is null.";
            SecurityLogger.debugMessage(string2, string);
        }
        return serviceContext;
    }

    public ServiceContext create_sc_from_ce_message(ContextError contextError) {
        String string = "";
        String string2 = "CSIUtil.create_sc_from_ce_message";
        ServiceContext serviceContext = null;
        if (this.orb != null) {
            SASContextBody sASContextBody = new SASContextBody();
            sASContextBody.error_msg(contextError);
            Any any = this.orb.create_any();
            SASContextBodyHelper.insert(any, sASContextBody);
            byte[] byArray = null;
            try {
                byArray = this.getCodec().encode_value(any);
            }
            catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                FFDCFilter.processException((Throwable)invalidTypeForEncoding, "com.ibm.ISecurityUtilityImpl.CSIUtil.create_sc_from_ce_message", "506", this);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "An InvalidTypeForEncoding exception occurred.";
                    SecurityLogger.debugMessage(string2, string);
                }
                SecurityLogger.logException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
            }
            if (byArray != null) {
                serviceContext = new ServiceContext(15, byArray);
            } else if (SecurityLogger.debugTraceEnabled) {
                string = "The service context data is null.";
                SecurityLogger.debugMessage(string2, string);
            }
        } else if (SecurityLogger.debugTraceEnabled) {
            string = "The orb is null.";
            SecurityLogger.debugMessage(string2, string);
        }
        return serviceContext;
    }

    public ServiceContext create_sc_from_cec_message(CompleteEstablishContext completeEstablishContext) {
        String string = "";
        String string2 = "CSIUtil.create_sc_from_cec_message";
        ServiceContext serviceContext = null;
        if (this.orb != null) {
            SASContextBody sASContextBody = new SASContextBody();
            sASContextBody.complete_msg(completeEstablishContext);
            Any any = this.orb.create_any();
            SASContextBodyHelper.insert(any, sASContextBody);
            byte[] byArray = null;
            try {
                byArray = this.getCodec().encode_value(any);
            }
            catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                FFDCFilter.processException((Throwable)invalidTypeForEncoding, "com.ibm.ISecurityUtilityImpl.CSIUtil.create_sc_from_cec_message", "572", this);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "InvalidTypeForEncoding exception.";
                    SecurityLogger.debugMessage(string2, string);
                }
                SecurityLogger.traceException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
            }
            if (byArray != null) {
                serviceContext = new ServiceContext(15, byArray);
            } else if (SecurityLogger.debugTraceEnabled) {
                string = "The service context data is null.";
                SecurityLogger.debugMessage(string2, string);
            }
        } else if (SecurityLogger.debugTraceEnabled) {
            string = "The orb is null.";
            SecurityLogger.debugMessage(string2, string);
        }
        return serviceContext;
    }

    public void print_ec_message(EstablishContext establishContext, String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Message type is ASSOC_ESTABLISH_CONTEXT - client_context_id: ").append(establishContext.client_context_id);
        if (establishContext.identity_token != null) {
            if (establishContext.identity_token.discriminator() == 0) {
                stringBuffer.append(", identity_token: ITTAbsent");
            } else if (establishContext.identity_token.discriminator() == 1) {
                stringBuffer.append(", identity_token: ITTAnonymous");
            } else if (establishContext.identity_token.discriminator() == 8) {
                stringBuffer.append(", identity_token: ITTDistinguishedName");
            } else if (establishContext.identity_token.discriminator() == 2) {
                stringBuffer.append(", identity_token: ITTPrincipalName");
            } else if (establishContext.identity_token.discriminator() == 4) {
                stringBuffer.append(", identity_token: ITTX509CertChain");
            } else {
                stringBuffer.append(", identity_token: unknown type");
            }
        }
        if (establishContext.client_authentication_token != null) {
            stringBuffer.append(", client_authentication_token length: ").append(establishContext.client_authentication_token.length);
        }
        SecurityLogger.debugMessage(string, stringBuffer.toString());
    }

    public void print_cec_message(CompleteEstablishContext completeEstablishContext, String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Message type is ASSOC_COMPLETE_ESTABLISH_CONTEXT - client_context_id: ").append(completeEstablishContext.client_context_id).append(", context_stateful: ").append(completeEstablishContext.context_stateful);
        if (completeEstablishContext.final_context_token != null) {
            stringBuffer.append(", final_context_token length: ").append(completeEstablishContext.final_context_token.length);
        }
        SecurityLogger.debugMessage(string, stringBuffer.toString());
    }

    public void print_ce_message(ContextError contextError, String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Message type is ASSOC_CONTEXT_ERROR - client_context_id: ").append(contextError.client_context_id).append(", major_status: ").append(contextError.major_status).append(", minor_status: ").append(contextError.minor_status);
        if (contextError.error_token != null) {
            stringBuffer.append(", error_token length: ").append(contextError.error_token.length);
        }
        SecurityLogger.debugMessage(string, stringBuffer.toString());
    }

    public void print_mic_message(MessageInContext messageInContext, String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Message type is ASSOC_MESSAGE_IN_CONTEXT - client_context_id: ").append(messageInContext.client_context_id).append(", discard_context: ").append(messageInContext.discard_context);
        SecurityLogger.debugMessage(string, stringBuffer.toString());
    }

    public ORB getORB() {
        if (this.orb == null) {
            this.vault = VaultImpl.getInstance();
            if (this.vault != null) {
                this.orb = this.vault.getORB();
            }
        }
        return this.orb;
    }

    public VaultImpl getVault() {
        if (this.vault == null) {
            this.vault = VaultImpl.getInstance();
        }
        return this.vault;
    }

    public Codec getCodec() {
        String string = "";
        String string2 = "CSIUtil.getCodec";
        if (this.codec == null) {
            this.codec = this.getVault().getCodec();
        }
        return this.codec;
    }

    public CurrentImpl getCurrent() {
        String string = "CSIUtil.getCurrent";
        Object var2_2 = null;
        if (this.current == null) {
            this.current = this.getVault().getCurrent();
        }
        return this.current;
    }

    public SecurityContextImpl get_security_context_impl(String string, String string2) {
        String string3 = "CSIUtil.get_security_context_impl";
        String string4 = null;
        SecurityContextImpl securityContextImpl = null;
        this.vault = this.getVault();
        MechanismFactory mechanismFactory = this.vault.getMechanismFactory();
        try {
            securityContextImpl = mechanismFactory.getSecurityContext(string, string2);
        }
        catch (MechanismAmbiguityException mechanismAmbiguityException) {
            FFDCFilter.processException((Throwable)mechanismAmbiguityException, "com.ibm.ISecurityUtilityImpl.CSIUtil.get_security_context_impl", "797", this);
            securityContextImpl = null;
            string4 = "MechanismAmbiguityException trying to get security context.";
            SecurityLogger.debugMessage(string3, string4);
            SecurityLogger.logException(string3, mechanismAmbiguityException, 0, 0);
        }
        return securityContextImpl;
    }

    public String parseCert(java.security.cert.X509Certificate[] x509CertificateArray) throws AuthenticationFailedException {
        String string;
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.security.core.UserMappingImpl");
            Method method2 = clazz.getMethod("mapCertificateToName", X509Certificate;.class);
            Object object = method2.invoke(clazz.newInstance(), new Object[]{x509CertificateArray});
            string = (String)object;
        }
        catch (Exception exception) {
            throw new AuthenticationFailedException(exception.getMessage());
        }
        return string;
    }

    public String parseDN(String string) throws AuthenticationFailedException {
        String string2;
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.security.core.UserMappingImpl");
            Method method2 = clazz.getMethod("mapDNToName", String.class);
            Object object = method2.invoke(clazz.newInstance(), string);
            string2 = (String)object;
        }
        catch (Exception exception) {
            throw new AuthenticationFailedException(exception.getMessage());
        }
        return string2;
    }

    public String parsePrincipal(String string) throws AuthenticationFailedException {
        String string2;
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.security.core.UserMappingImpl");
            Method method2 = clazz.getMethod("mapPrincipalToName", String.class);
            Object object = method2.invoke(clazz.newInstance(), string);
            string2 = (String)object;
        }
        catch (Exception exception) {
            throw new AuthenticationFailedException(exception.getMessage());
        }
        return string2;
    }

    public static java.security.cert.X509Certificate convert(X509Certificate x509Certificate) {
        try {
            byte[] byArray = x509Certificate.getEncoded();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (java.security.cert.X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
        }
        catch (java.security.cert.CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    public static X509Certificate convert(java.security.cert.X509Certificate x509Certificate) {
        try {
            byte[] byArray = x509Certificate.getEncoded();
            return X509Certificate.getInstance(byArray);
        }
        catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    public boolean isTrusted(java.security.cert.X509Certificate[] x509CertificateArray) {
        String string = "CSIUtil.isTrusted";
        String string2 = null;
        boolean bl = false;
        TrustedIDEvaluator trustedIDEvaluator = TrustedIDEvaluatorFactory.getInstance();
        if (trustedIDEvaluator != null) {
            bl = trustedIDEvaluator.isTrusted(x509CertificateArray);
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Check for user associated with cert returning " + bl;
                SecurityLogger.debugMessage(string, string2);
            }
        }
        return bl;
    }

    public boolean isTrusted(String string, String string2) {
        String string3 = "CSIUtil.isTrusted";
        String string4 = null;
        boolean bl = false;
        TrustedIDEvaluator trustedIDEvaluator = TrustedIDEvaluatorFactory.getInstance();
        if (trustedIDEvaluator != null) {
            bl = trustedIDEvaluator.isTrusted(string, string2);
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Check for " + string + " with password returning " + bl;
                SecurityLogger.debugMessage(string3, string4);
            }
        }
        return bl;
    }

    public boolean isTrusted(String string) {
        String string2 = "CSIUtil.isTrusted";
        String string3 = null;
        boolean bl = false;
        TrustedIDEvaluator trustedIDEvaluator = TrustedIDEvaluatorFactory.getInstance();
        if (trustedIDEvaluator != null) {
            bl = trustedIDEvaluator.isTrusted(string);
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "Check for " + string + " returning " + bl;
                SecurityLogger.debugMessage(string2, string3);
            }
        }
        return bl;
    }

    public String get_server_session_hash(ConnectionInformationImpl connectionInformationImpl, int n) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(connectionInformationImpl.getRemoteHost()).append(":").append(connectionInformationImpl.getRemotePort()).append(":").append(connectionInformationImpl.getConnectionCreationTime()).append(":").append(n);
        return stringBuffer.toString();
    }

    public String read_detailed_message(RequestInfo requestInfo) {
        String string;
        String string2 = "CSIUtil.read_system_exception";
        Object var3_3 = null;
        ServiceContext serviceContext = null;
        try {
            serviceContext = requestInfo.get_reply_service_context(14);
        }
        catch (BAD_PARAM bAD_PARAM) {
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.CSIUtil.read_detailed_message", "981", this);
        }
        if (serviceContext == null) {
            string = "";
        } else {
            CDRInputStream cDRInputStream = ORB.createCDRInputStream((ORB)this.orb, (byte[])serviceContext.context_data, (int)serviceContext.context_data.length);
            cDRInputStream.consumeEndian();
            string = cDRInputStream.read_wstring();
        }
        return string;
    }

    public short get_message_type(RequestInfo requestInfo) {
        ServiceContext serviceContext = null;
        SASContextBody sASContextBody = null;
        serviceContext = ((ExtendedServerRequestInfo)requestInfo).getRequestServiceContext(15);
        if (serviceContext != null && (sASContextBody = this.get_message_from_sc(serviceContext)) != null) {
            return sASContextBody.discriminator();
        }
        return -1;
    }

    public byte[] create_gss_initial_context_token(String string, OpaqueHolder opaqueHolder) throws WSSecurityContextException {
        String string2 = "";
        String string3 = "CSIUtil.create_gss_initial_context_token";
        try {
            Any any;
            CSIUtil cSIUtil = new CSIUtil();
            if (OID.compareOIDs(string, "oid:2.23.130.1.1.1")) {
                string2 = "Unexpected GSSUP mechanism mapped in token base Security Context ";
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string3, string2);
                }
                int n = 18;
                int n2 = 0;
                throw new WSSecurityContextException(n, n2, string3 + ": " + string2);
            }
            GSSFactory gSSFactory = this.vault.getGSSFactory(string);
            byte[] byArray = opaqueHolder.value;
            if (this.orb == null && cSIUtil.getVault() != null) {
                this.orb = cSIUtil.getVault().getORB();
                if (this.orb == null) {
                    string2 = "Orb is null.";
                    if (SecurityLogger.debugTraceEnabled) {
                        SecurityLogger.debugMessage(string3, string2);
                    }
                    int n = 15;
                    int n3 = 0;
                    throw new WSSecurityContextException(n, n3, string3 + ": " + string2);
                }
            }
            if ((any = this.orb.create_any()) == null) {
                string2 = "Any is null.";
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string3, string2);
                }
                int n = 15;
                int n4 = 0;
                throw new WSSecurityContextException(n, n4, string3 + ": " + string2);
            }
            OpaqueHelper.insert(any, byArray);
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            try {
                byArray2 = this.getCodec().encode_value(any);
                byArray3 = gSSFactory.encodeGSSToken(byArray2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.CSIUtil.create_gss_initial_context_token", "1109", this);
                string2 = "Orb is null.";
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string3, string2);
                }
                int n = 18;
                int n5 = 0;
                throw new WSSecurityContextException(n, n5, string3 + ": " + string2);
            }
            return byArray3;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.CSIUtil.create_gss_initial_context_token", "1128", this);
            string2 = "Java exception: " + exception.toString();
            if (SecurityLogger.debugTraceEnabled) {
                SecurityLogger.debugMessage(string3, string2);
            }
            int n = 15;
            int n6 = 0;
            throw new WSSecurityContextException(n, n6, string3 + ": " + string2);
        }
    }

    public void parse_gss_initial_context_token(byte[] byArray, OpaqueHolder opaqueHolder) throws WSSecurityContextException {
        String string = "";
        String string2 = "CSIUtil.parse_gss_initial_context_token";
        try {
            String string3 = GSSFactory.getMechOIDFromGSSToken(byArray);
            String string4 = null;
            if (this.mechFactory == null) {
                string = "MechanismFactory is null.";
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 15;
                int n2 = 0;
                throw new WSSecurityContextException(n, n2, string);
            }
            string4 = this.mechFactory.getMechanismTypeIdentity(string3);
            String string5 = GSSFactory.mapMechTypeToOid(string4);
            if (OID.compareOIDs(string5, "oid:2.23.130.1.1.1")) {
                string = "Unexpected GSSUP mechanism mapped in token base Security Context ";
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 12;
                int n3 = 0;
                throw new WSSecurityContextException(n, n3, string2 + ": " + string);
            }
            if (SecurityLogger.debugTraceEnabled) {
                string = "OID from receiving GSS token: " + string3 + ", OID mapped from Security Context: " + string5;
                SecurityLogger.debugMessage(string2, string);
            }
            if (!OID.compareOIDs(string3, string5)) {
                string = "Mismatched OID from receiving GSS token with respect to token-base Security Context";
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 12;
                int n4 = 0;
                throw new WSSecurityContextException(n, n4, string2 + ": " + string);
            }
            GSSFactory gSSFactory = this.vault.getGSSFactory(string5);
            byte[] byArray2 = null;
            try {
                byArray2 = gSSFactory.decodeGSSToken(byArray);
            }
            catch (GSSEncodeDecodeException gSSEncodeDecodeException) {
                FFDCFilter.processException((Throwable)gSSEncodeDecodeException, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gss_initial_context_token", "1226", this);
                string = "GSSEncodeDecodeException: " + gSSEncodeDecodeException.toString();
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 18;
                int n5 = 0;
                throw new WSSecurityContextException(n, n5, string2 + ": " + string);
            }
            Any any = null;
            try {
                any = this.getCodec().decode_value(byArray2, OpaqueHelper.type());
            }
            catch (TypeMismatch typeMismatch) {
                FFDCFilter.processException((Throwable)typeMismatch, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gss_initial_context_token", "1248", this);
                SecurityLogger.logException(string2, (Exception)((Object)typeMismatch), 0, 0);
                string = "org.omg.IOP.CodecPackage.TypeMismatch exception: " + typeMismatch.toString();
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 18;
                int n6 = 0;
                throw new WSSecurityContextException(n, n6, string2 + ": " + string);
            }
            catch (FormatMismatch formatMismatch) {
                FFDCFilter.processException((Throwable)formatMismatch, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gss_initial_context_token", "1266", this);
                SecurityLogger.logException(string2, (Exception)((Object)formatMismatch), 0, 0);
                string = "org.omg.IOP.CodecPackage.FormatMismatch exception: " + formatMismatch.toString();
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 18;
                int n7 = 0;
                throw new WSSecurityContextException(n, n7, string2 + ": " + string);
            }
            try {
                opaqueHolder.value = OpaqueHelper.extract(any);
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                FFDCFilter.processException((Throwable)bAD_OPERATION, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gss_initial_context_token", "1288", this);
                SecurityLogger.logException(string2, (Exception)((Object)bAD_OPERATION), 0, 0);
                string = "org.omg.CORBA.BAD_OPERATION exception extracting token from Any: " + bAD_OPERATION.toString();
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 18;
                int n8 = 0;
                throw new WSSecurityContextException(n, n8, string2 + ": " + string);
            }
            if (opaqueHolder.value == null) {
                string = "Could not extract token from Any.";
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 18;
                int n9 = 0;
                throw new WSSecurityContextException(n, n9, string2 + ": " + string);
            }
            return;
        }
        catch (MechanismAmbiguityException mechanismAmbiguityException) {
            FFDCFilter.processException((Throwable)mechanismAmbiguityException, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gss_initial_context_token", "1324", this);
            if (SecurityLogger.debugTraceEnabled) {
                string = "MechanismAmbiguityException occurred in getMechanismTypeIdentity.";
                SecurityLogger.debugMessage(string2, string);
                SecurityLogger.traceException(string2, mechanismAmbiguityException, 0, 0);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gss_initial_context_token", "1335", this);
            SecurityLogger.logException(string2, exception, 0, 0);
            string = "java.lang.Exception: " + exception.toString();
            if (SecurityLogger.debugTraceEnabled) {
                SecurityLogger.debugMessage(string2, string);
            }
            int n = 13;
            int n10 = 0;
            throw new WSSecurityContextException(n, n10, string2 + ": " + string);
        }
    }

    public void parse_gssup_initial_context_token(byte[] byArray, BasicAuthWithRealm basicAuthWithRealm) throws WSSecurityContextException {
        String string = "";
        String string2 = "CSIUtil.parse_gssup_initial_context_token";
        try {
            GSSFactory gSSFactory = this.vault.getGSSFactory("oid:2.23.130.1.1.1");
            byte[] byArray2 = null;
            try {
                byArray2 = gSSFactory.decodeGSSToken(byArray);
            }
            catch (GSSEncodeDecodeException gSSEncodeDecodeException) {
                FFDCFilter.processException((Throwable)gSSEncodeDecodeException, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1373", this);
                string = "GSSEncodeDecodeException: " + gSSEncodeDecodeException.toString();
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 18;
                int n2 = 0;
                throw new WSSecurityContextException(n, n2, string2 + ": " + string);
            }
            Any any = null;
            try {
                any = this.getCodec().decode_value(byArray2, InitialContextTokenHelper.type());
            }
            catch (TypeMismatch typeMismatch) {
                FFDCFilter.processException((Throwable)typeMismatch, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1394", this);
                SecurityLogger.logException(string2, (Exception)((Object)typeMismatch), 0, 0);
                string = "org.omg.IOP.CodecPackage.TypeMismatch exception: " + typeMismatch.toString();
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 18;
                int n3 = 0;
                throw new WSSecurityContextException(n, n3, string2 + ": " + string);
            }
            catch (FormatMismatch formatMismatch) {
                FFDCFilter.processException((Throwable)formatMismatch, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1411", this);
                SecurityLogger.logException(string2, (Exception)((Object)formatMismatch), 0, 0);
                string = "org.omg.IOP.CodecPackage.FormatMismatch exception: " + formatMismatch.toString();
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 18;
                int n4 = 0;
                throw new WSSecurityContextException(n, n4, string2 + ": " + string);
            }
            InitialContextToken initialContextToken = null;
            try {
                initialContextToken = InitialContextTokenHelper.extract(any);
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                FFDCFilter.processException((Throwable)bAD_OPERATION, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1434", this);
                SecurityLogger.logException(string2, (Exception)((Object)bAD_OPERATION), 0, 0);
                string = "org.omg.CORBA.BAD_OPERATION exception extracting token from Any: " + bAD_OPERATION.toString();
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 18;
                int n5 = 0;
                throw new WSSecurityContextException(n, n5, string2 + ": " + string);
            }
            String string3 = null;
            try {
                string3 = gSSFactory.decodeExportedTargetName(initialContextToken.target_name);
            }
            catch (GSSEncodeDecodeException gSSEncodeDecodeException) {
                FFDCFilter.processException((Throwable)gSSEncodeDecodeException, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1458", this);
                string = "GSSEncodeDecodeException: " + gSSEncodeDecodeException.toString();
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 18;
                int n6 = 0;
                throw new WSSecurityContextException(n, n6, string2 + ": " + string);
            }
            try {
                String string4 = new String(initialContextToken.username, "UTF8");
                String string5 = new String(initialContextToken.password, "UTF8");
                String string6 = "";
                String string7 = "";
                Object var14_35 = null;
                if (string4 != null && !string4.equals("")) {
                    int n = string4.lastIndexOf("@");
                    if (n < 0) {
                        string6 = string4;
                        string7 = string3;
                    } else {
                        string6 = string4.substring(0, n);
                        string7 = string4.substring(n + 1);
                    }
                }
                basicAuthWithRealm.setUserid(string6);
                basicAuthWithRealm.setPassword(string5);
                basicAuthWithRealm.setRealm(string3);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Security name from GSS token: " + basicAuthWithRealm.getUserid() + "@" + basicAuthWithRealm.getRealm() + ", password: " + SecurityConfiguration.mask(basicAuthWithRealm.getPassword());
                    SecurityLogger.debugMessage(string2, string);
                }
                return;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1512", this);
                SecurityLogger.logException(string2, exception, 0, 0);
                string = "java.lang.Exception: " + exception.toString();
                if (SecurityLogger.debugTraceEnabled) {
                    SecurityLogger.debugMessage(string2, string);
                }
                int n = 13;
                int n7 = 0;
                throw new WSSecurityContextException(n, n7, string2 + ": " + string);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1530", this);
            SecurityLogger.logException(string2, exception, 0, 0);
            string = "java.lang.Exception: " + exception.toString();
            if (SecurityLogger.debugTraceEnabled) {
                SecurityLogger.debugMessage(string2, string);
            }
            int n = 13;
            int n8 = 0;
            throw new WSSecurityContextException(n, n8, string2 + ": " + string);
        }
    }

    public static String clean(String string) {
        String string2 = null;
        if (string != null && ((string2 = string.trim()).startsWith("\"") && string2.endsWith("\"") || string2.startsWith("'") && string2.endsWith("'"))) {
            string2 = string2.substring(1, string2.length() - 1).trim();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializeRootException() {
        Object object;
        String string = "CSIUtil.serializeRootException";
        String string2 = null;
        byte[] byArray = this.nullByteArray;
        Object object2 = this.getCurrent().getRootException();
        SecurityLogger.traceException(string, (Throwable)object2, 0, 0);
        if (object2 != null) {
            object = object2;
            int n = 0;
            while (object != null) {
                while (object != null && object instanceof WSLoginFailedException) {
                    if (SecurityLogger.traceEnabled) {
                        string2 = "instanceof WSLoginFailedException";
                        SecurityLogger.traceMessage(string, string2);
                    }
                    if ((object = ((WSLoginFailedException)object).getCause()) != null) {
                        object2 = object;
                    }
                    if (n++ <= 10) continue;
                }
                while (object != null && object instanceof RemoteException) {
                    if (SecurityLogger.traceEnabled) {
                        string2 = "instanceof java.rmi.RemoteException";
                        SecurityLogger.traceMessage(string, string2);
                    }
                    if ((object = ((RemoteException)object).detail) != null) {
                        object2 = object;
                    }
                    if (n++ <= 10) continue;
                }
                while (object != null && object instanceof WSSecurityException) {
                    ArrayList arrayList;
                    if (SecurityLogger.traceEnabled) {
                        string2 = "instanceof WSSecurityException";
                        SecurityLogger.traceMessage(string, string2);
                    }
                    if ((arrayList = ((WSSecurityException)object).getExceptions()) != null && arrayList.size() > 0 && (object = (Throwable)arrayList.get(0)) != null) {
                        object2 = object;
                    }
                    if (n++ <= 10) continue;
                    break;
                }
                if (n++ <= 10) continue;
            }
        }
        if (object2 != null) {
            object = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                object = new ByteArrayOutputStream();
                objectOutputStream = new ObjectOutputStream((OutputStream)object);
                objectOutputStream.writeObject(object2);
                objectOutputStream.flush();
                byArray = ((ByteArrayOutputStream)object).toByteArray();
                if (SecurityLogger.traceEnabled) {
                    string2 = byArray != null ? "Serializing root cause exception, byte array size: " + byArray.length : "Error serializing root cause exception, byte array = 0";
                    SecurityLogger.traceMessage(string, string2);
                    SecurityLogger.traceException(string, (Throwable)object2, 0, 0);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.CSIUtil.serializeRootException", "1669", this);
                if (SecurityLogger.traceEnabled) {
                    string2 = "Exception serializing the root cause exception: " + exception.getMessage();
                    SecurityLogger.traceMessage(string, string2);
                    SecurityLogger.traceException(string, exception, 0, 0);
                }
            }
            finally {
                try {
                    if (object != null) {
                        ((ByteArrayOutputStream)object).close();
                    }
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeRootException(byte[] byArray) {
        String string = "CSIUtil.deserializeRootException";
        String string2 = null;
        Throwable throwable = null;
        if (byArray != null && !Arrays.equals(byArray, this.nullByteArray)) {
            ByteArrayInputStream byteArrayInputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
                throwable = (Throwable)objectInputStream.readObject();
                if (SecurityLogger.traceEnabled) {
                    string2 = throwable != null ? "Deserializing root cause exception, exception = " + throwable.getMessage() : "Error deserializing root cause exception, t = null";
                    SecurityLogger.traceMessage(string, string2);
                    SecurityLogger.traceException(string, throwable, 0, 0);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.CSIUtil.deserializeRootException", "1728", this);
                if (SecurityLogger.traceEnabled) {
                    string2 = "Exception serializing the root cause exception: " + exception.getMessage();
                    SecurityLogger.traceMessage(string, string2);
                    SecurityLogger.traceException(string, exception, 0, 0);
                }
            }
            finally {
                try {
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
            this.getCurrent().setRootException(throwable);
        }
    }

    public ContextManager getContextManager() {
        if (this.contextManager == null) {
            this.contextManager = ContextManagerFactory.getInstance();
        }
        return this.contextManager;
    }

    public void setUnauthenticatedToNullIfNeeded() {
        String string = "CSIUtil.setUnauthenticatedToNullIfNeeded";
        String string2 = null;
        CSIUtil cSIUtil = this;
        SecurityConfiguration securityConfiguration = cSIUtil.vault.getSecurityConfiguration();
        if (securityConfiguration.processIsServer()) {
            try {
                Subject subject = this.getContextManager().getInvocationSubject();
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                if (wSCredential != null && wSCredential.isUnauthenticated()) {
                    if (SecurityLogger.traceEnabled) {
                        string2 = "Setting invocation cred to NULL.";
                        SecurityLogger.traceMessage(string, string2);
                    }
                    this.getContextManager().setInvocationSubject(null);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.CSIUtil.setUnauthenticatedToNullIfNeeded", "1804", this);
            }
        }
    }

    public java.security.cert.X509Certificate[] convertJavaxToJavaCerts(X509Certificate[] x509CertificateArray) {
        String string = "CSIUtil.convertJavaxToJavaCerts";
        String string2 = null;
        java.security.cert.X509Certificate[] x509CertificateArray2 = null;
        if (x509CertificateArray != null) {
            int n;
            x509CertificateArray2 = new java.security.cert.X509Certificate[x509CertificateArray.length];
            for (n = 0; n < x509CertificateArray.length; ++n) {
                x509CertificateArray2[n] = CSIUtil.convert(x509CertificateArray[n]);
            }
            if (SecurityLogger.debugTraceEnabled && x509CertificateArray2 != null) {
                string2 = "Transport layer certificate chain found.";
                SecurityLogger.debugMessage(string, string2);
            }
            if (SecurityLogger.debugTraceEnabled && x509CertificateArray2 != null) {
                for (n = 0; n < x509CertificateArray2.length; ++n) {
                    string2 = "   Certificate[" + n + "]: " + x509CertificateArray2[n].toString();
                    SecurityLogger.debugMessage(string, string2);
                }
            }
        }
        return x509CertificateArray2;
    }

    public boolean isCORBAAuthRequired() {
        return this.getContextManager().isAuthenticateSpecialMethodsEnabled() && this.getContextManager().isSecurityServiceStarted();
    }
}

