/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ws.ffdc.FFDCFilter;
import org.omg.CORBA.ORB;

public class CSIv2Configuration {
    protected static final String DefaultRealmName = "";
    protected static final String DefaultPrincipalName = "";
    protected static final boolean DefaultConfigurationInitialized = false;
    protected static final int DefaultVerificationLevel = 2;
    protected static final String DefaultVerificationLevelString = "consistency";
    public static final boolean DefaultClaimStateful = true;
    public static final boolean DefaultClaimTransportAssocSSLTLSRequired = false;
    public static final boolean DefaultClaimTransportAssocSSLTLSSupported = false;
    public static final boolean DefaultClaimTransportAssocSECIOP = false;
    public static final boolean DefaultClaimMessageConfidentialityRequired = false;
    public static final boolean DefaultClaimMessageConfidentialitySupported = true;
    public static final boolean DefaultClaimMessageIntegrityRequired = true;
    public static final boolean DefaultClaimMessageIntegritySupported = true;
    public static final boolean DefaultClaimMessageMisorderingDetectionRequired = false;
    public static final boolean DefaultClaimMessageMisorderingDetectionSupported = false;
    public static final boolean DefaultClaimMessageReplayDetectionRequired = false;
    public static final boolean DefaultClaimMessageReplayDetectionSupported = false;
    public static final boolean DefaultClaimTLClientAuthenticationRequired = false;
    public static final boolean DefaultClaimTLClientAuthenticationSupported = false;
    public static final boolean DefaultClaimTLServerAuthenticationSupported = true;
    public static final boolean DefaultClaimClientAuthenticationRequired = false;
    public static final boolean DefaultClaimClientAuthenticationSupported = true;
    public static final boolean DefaultneverUseClientCertificateForCallerLogin = false;
    public static final boolean DefaultClaimServerAuthenticationRequired = false;
    public static final boolean DefaultClaimServerAuthenticationSupported = false;
    public static final boolean DefaultClaimIdentityAssertionSupported = false;
    public static final boolean DefaultClaimDelegationByClientRequired = false;
    public static final boolean DefaultClaimDelegationByClientSupported = false;
    public static final boolean DefaultPerformStateful = true;
    public static final boolean DefaultPerformTransportAssocSSLTLSRequired = false;
    public static final boolean DefaultPerformTransportAssocSSLTLSSupported = true;
    public static final boolean DefaultPerformTransportAssocSECIOPRequired = false;
    public static final boolean DefaultPerformTransportAssocSECIOPSupported = false;
    public static final boolean DefaultPerformMessageConfidentialityRequired = false;
    public static final boolean DefaultPerformMessageConfidentialitySupported = true;
    public static final boolean DefaultPerformMessageIntegrityRequired = true;
    public static final boolean DefaultPerformMessageIntegritySupported = true;
    public static final boolean DefaultPerformMessageMisorderingDetectionRequired = false;
    public static final boolean DefaultPerformMessageMisorderingDetectionSupported = false;
    public static final boolean DefaultPerformMessageReplayDetectionRequired = false;
    public static final boolean DefaultPerformMessageReplayDetectionSupported = false;
    public static final boolean DefaultPerformTLClientAuthenticationRequired = false;
    public static final boolean DefaultPerformTLClientAuthenticationSupported = false;
    public static final boolean DefaultPerformTLServerAuthenticationRequired = true;
    public static final boolean DefaultPerformTLServerAuthenticationSupported = true;
    public static final boolean DefaultPerformClientAuthenticationRequired = false;
    public static final boolean DefaultPerformClientAuthenticationSupported = true;
    public static final boolean DefaultPerformServerAuthenticationRequired = false;
    public static final boolean DefaultPerformServerAuthenticationSupported = true;
    public static final boolean DefaultPerformIdentityAssertionRequired = false;
    public static final boolean DefaultPerformIdentityAssertionSupported = false;
    public static final int DefaultPerformIdentityAssertionType = 15;
    public static final int DefaultPerformIdentityAssertionMechanism = 2;
    public static final boolean DefaultPerformDelegationByClientRequired = false;
    public static final boolean DefaultPerformDelegationByClientSupported = false;
    public static final boolean DefaultKerberosClientAssociationRequired = false;
    public static final boolean DefaultKerberosServerAssociationRequired = false;
    public static final boolean DefaultKerberosClientAssociationSupported = false;
    public static final boolean DefaultKerberosServerAssociationSupported = false;
    public static final boolean DefaultLocalOSClientAssociationRequired = false;
    public static final boolean DefaultLocalOSServerAssociationRequired = false;
    public static final boolean DefaultLocalOSClientAssociationSupported = true;
    public static final boolean DefaultLocalOSServerAssociationSupported = false;
    public static final boolean DefaultLTPAClientAssociationRequired = false;
    public static final boolean DefaultLTPAServerAssociationRequired = false;
    public static final boolean DefaultLTPAClientAssociationSupported = false;
    public static final boolean DefaultLTPAServerAssociationSupported = false;
    public static final int DefaultStandardClaimQOPModels = 3;
    public static final int DefaultStandardPerformQOPModels = 3;
    public static final String DefaultStandardClaimQOPModelsString = "authenticity";
    public static final String DefaultStandardPerformQOPModelsString = "authenticity";
    public static final String DefaultTrustedPrincipalList = "";
    private static com.ibm.CORBA.iiop.ORB _orb = null;
    private static String componentLabel = "Configuration component ";
    private static SecurityConnectionInterceptor securityConnectionInterceptor = null;
    private static MechanismFactory mechFactory = null;
    private static ConfigURLProperties securityProps = null;
    private static SecurityConfiguration _secConfig = null;
    private static String realmName = "";
    private static String principalName = "";
    private static boolean configurationInitialized = false;
    private static int verificationLevel = 2;
    private static boolean claimStateful = true;
    private static boolean claimTransportAssocSSLTLSRequired = false;
    private static boolean claimTransportAssocSSLTLSSupported = false;
    private static boolean claimTransportAssocSECIOP = false;
    private static boolean claimMessageConfidentialityRequired = false;
    private static boolean claimMessageConfidentialitySupported = true;
    private static boolean claimMessageIntegrityRequired = true;
    private static boolean claimMessageIntegritySupported = true;
    private static boolean claimMessageMisorderingDetectionRequired = false;
    private static boolean claimMessageMisorderingDetectionSupported = false;
    private static boolean claimMessageReplayDetectionRequired = false;
    private static boolean claimMessageReplayDetectionSupported = false;
    private static boolean claimTLClientAuthenticationRequired = false;
    private static boolean claimTLClientAuthenticationSupported = false;
    private static boolean claimTLServerAuthenticationSupported = true;
    private static boolean claimClientAuthenticationRequired = false;
    private static boolean claimClientAuthenticationSupported = true;
    private static boolean neverUseClientCertificateForCallerLogin = false;
    private static boolean claimServerAuthenticationRequired = false;
    private static boolean claimServerAuthenticationSupported = false;
    private static boolean KerberosClientAssociationRequired = false;
    private static boolean KerberosClientAssociationSupported = false;
    private static boolean KerberosServerAssociationRequired = false;
    private static boolean KerberosServerAssociationSupported = false;
    private static boolean LocalOSClientAssociationRequired = false;
    private static boolean LocalOSClientAssociationSupported = true;
    private static boolean LocalOSServerAssociationRequired = false;
    private static boolean LocalOSServerAssociationSupported = false;
    private static boolean LTPAClientAssociationRequired = false;
    private static boolean LTPAClientAssociationSupported = false;
    private static boolean LTPAServerAssociationRequired = false;
    private static boolean LTPAServerAssociationSupported = false;
    private static boolean claimIdentityAssertionSupported = false;
    private static boolean claimDelegationByClientRequired = false;
    private static boolean claimDelegationByClientSupported = false;
    private static boolean performStateful = true;
    private static boolean performTransportAssocSSLTLSRequired = false;
    private static boolean performTransportAssocSSLTLSSupported = true;
    private static boolean performTransportAssocSECIOPRequired = false;
    private static boolean performTransportAssocSECIOPSupported = false;
    private static boolean performMessageConfidentialityRequired = false;
    private static boolean performMessageConfidentialitySupported = true;
    private static boolean performMessageIntegrityRequired = true;
    private static boolean performMessageIntegritySupported = true;
    private static boolean performMessageMisorderingDetectionRequired = false;
    private static boolean performMessageMisorderingDetectionSupported = false;
    private static boolean performMessageReplayDetectionRequired = false;
    private static boolean performMessageReplayDetectionSupported = false;
    private static boolean performTLClientAuthenticationRequired = false;
    private static boolean performTLClientAuthenticationSupported = false;
    private static boolean performTLServerAuthenticationRequired = true;
    private static boolean performTLServerAuthenticationSupported = true;
    private static boolean performClientAuthenticationRequired = false;
    private static boolean performClientAuthenticationSupported = true;
    private static boolean performServerAuthenticationRequired = false;
    private static boolean performServerAuthenticationSupported = true;
    private static boolean performIdentityAssertionRequired = false;
    private static boolean performIdentityAssertionSupported = false;
    private static int performIdentityAssertionType = 15;
    private static int performIdentityAssertionMechanism = 2;
    private static boolean performDelegationByClientRequired = false;
    private static boolean performDelegationByClientSupported = false;
    private static int standardClaimQOPModels = 3;
    private static int standardPerformQOPModels = 3;
    private static String TrustedPrincipalList = "";
    private static String alternatePerformTrustedId = null;
    private static String alternatePerformTrustedPassword = null;
    private static boolean serverConfigured = true;
    public static final int VerifyReportSev_Error = 1;
    public static final int VerifyReportSev_Observation = 0;
    public static final int VerifyResult_ConfigIncomplete = 1;
    public static final int VerifyResult_ConfigInconsistent = 2;
    public static final int VerifyResult_ConfigWrong = 3;
    public static final int VerifyResult_Success = 0;
    public static final int VerifyResult_Unknown = -1;

    private CSIv2Configuration() {
    }

    protected CSIv2Configuration(ORB oRB, ConfigURLProperties configURLProperties, boolean bl) {
        serverConfigured = bl;
        securityProps = configURLProperties;
        componentLabel = SecurityMessages.getMsgOrUseDefault("CompLabel", "Configuration component ");
        if (oRB instanceof com.ibm.CORBA.iiop.ORB) {
            _orb = (com.ibm.CORBA.iiop.ORB)oRB;
            this.reinitializeConfiguration();
        } else if (SecurityLogger.debugTraceEnabled) {
            String string = "Unexpected ORB instance.";
            SecurityLogger.debugMessage("CSIv2Configuration", string);
        }
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return _secConfig;
    }

    public static String mask(String string) {
        String string2 = null;
        if (string != null) {
            char[] cArray = new char[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                cArray[i] = 42;
            }
            string2 = new String(cArray);
        }
        return string2;
    }

    private synchronized boolean reinitializeConfiguration() {
        String string = "CSIv2Configuration.reinitializeConfiguration";
        String string2 = null;
        try {
            this.initializeLoginInfo();
            this.initializeStateful();
            this.initializeAttributeLayer();
            this.initializeMessageLayer();
            this.initializeTransportLayer();
            this.initializeVerificationLevel();
            configurationInitialized = true;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.CSIv2Configuration.reinitializeConfiguration", "463", this);
            string2 = "security.JSAS0413E";
            SecurityLogger.logError(string2, new Object[]{string, exception});
        }
        if (this.verifyConfiguration(verificationLevel) != 0) {
            string2 = "security.JSAS0414E";
            SecurityLogger.logError(string2, new Object[]{string});
        }
        return configurationInitialized;
    }

    private void initializeLoginInfo() {
        String string = "CSIv2Configuration.initializeLoginInfo";
        Object var2_2 = null;
        String string2 = null;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CORBA.realmName"));
        if (string2 != null && string2.length() > 0) {
            realmName = string2;
        }
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CORBA.principalName"));
        if (string2 != null && string2.length() > 0) {
            principalName = string2;
        }
    }

    private void initializeStateful() {
        String string = "CSIv2Configuration.initializeStateful";
        Object var2_2 = null;
        String string2 = null;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimStateful"));
        claimStateful = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : true;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performStateful"));
        performStateful = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : true;
    }

    private void initializeMessageLayer() {
        String string = "CSIv2Configuration.initializeMessageLayer";
        Object var2_2 = null;
        String string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performClientAuthenticationRequired"));
        performClientAuthenticationRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performClientAuthenticationSupported"));
        performClientAuthenticationSupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : true;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimClientAuthenticationRequired"));
        claimClientAuthenticationRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimClientAuthenticationSupported"));
        claimClientAuthenticationSupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : true;
    }

    private void initializeAttributeLayer() {
        String string = "CSIv2Configuration.initializeAttributeLayer";
        Object var2_2 = null;
        String string2 = null;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.trustedPrincipalList"));
        TrustedPrincipalList = string2 != null && string2.length() > 0 ? string2 : "";
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.alternateIdentityAssertionPerformTrustedId"));
        if (string2 != null && string2.length() > 0) {
            alternatePerformTrustedId = string2;
        }
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.alternateIdentityAssertionPerformTrustedPassword"));
        if (string2 != null && string2.length() > 0) {
            alternatePerformTrustedPassword = string2;
        }
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimIdentityAssertionSupported"));
        claimIdentityAssertionSupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performIdentityAssertionRequired"));
        performIdentityAssertionRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performIdentityAssertionSupported"));
        performIdentityAssertionSupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performDelegationByClientRequired"));
        performDelegationByClientRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performDelegationByClientSupported"));
        performDelegationByClientSupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
    }

    private void initializeTransportLayer() {
        String string = "CSIv2Configuration.initializeTransportLayer";
        Object var2_2 = null;
        String string2 = null;
        this.initializeClaimQOP();
        this.initializePerformQOP();
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performTLClientAuthenticationRequired"));
        performTLClientAuthenticationRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performTLClientAuthenticationSupported"));
        performTLClientAuthenticationSupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimTLClientAuthenticationRequired"));
        claimTLClientAuthenticationRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimTLClientAuthenticationSupported"));
        claimTLClientAuthenticationSupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimTransportAssocSSLTLSRequired"));
        claimTransportAssocSSLTLSRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimTransportAssocSSLTLSSupported"));
        claimTransportAssocSSLTLSSupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimTransportAssocSECIOP"));
        claimTransportAssocSECIOP = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.neverUseClientCertificateForCallerLogin"));
        neverUseClientCertificateForCallerLogin = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performTransportAssocSSLTLSRequired"));
        performTransportAssocSSLTLSRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performTransportAssocSSLTLSSupported"));
        performTransportAssocSSLTLSSupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : true;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performTransportAssocSECIOPRequired"));
        performTransportAssocSECIOPRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performTransportAssocSECIOPSupported"));
        performTransportAssocSECIOPSupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
    }

    private synchronized void initializeClaimQOP() {
        String string = "CSIv2Configuration.initializeClaimQOP";
        Object var2_2 = null;
        String string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimMessageConfidentialityRequired"));
        claimMessageConfidentialityRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimMessageConfidentialitySupported"));
        claimMessageConfidentialitySupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : true;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimMessageIntegrityRequired"));
        claimMessageIntegrityRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : true;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.claimMessageIntegritySupported"));
        claimMessageIntegritySupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : true;
    }

    private synchronized void initializePerformQOP() {
        String string = "CSIv2Configuration.initializePerformQOP";
        Object var2_2 = null;
        String string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performMessageConfidentialityRequired"));
        performMessageConfidentialityRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : false;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performMessageConfidentialitySupported"));
        performMessageConfidentialitySupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : true;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performMessageIntegrityRequired"));
        performMessageIntegrityRequired = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : true;
        string2 = null;
        string2 = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CSI.performMessageIntegritySupported"));
        performMessageIntegritySupported = string2 != null && string2.length() > 0 ? this.checkTrueOrYes(string2) : true;
    }

    private static String booleanString(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        return bl2.toString();
    }

    private boolean checkTrueOrYes(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    private static String clean(String string) {
        String string2 = null;
        if (string != null && ((string2 = string.trim()).startsWith("\"") && string2.endsWith("\"") || string2.startsWith("'") && string2.endsWith("'"))) {
            string2 = string2.substring(1, string2.length() - 1).trim();
        }
        return string2;
    }

    private void printConfig() {
        String string = "";
        String string2 = "CSIv2Configuration.printConfig";
        if (SecurityLogger.debugTraceEnabled) {
            string = "performStateful: " + performStateful;
            SecurityLogger.debugMessage(string2, string);
            string = "performTransportAssocSSLTLSRequired: " + performTransportAssocSSLTLSRequired;
            SecurityLogger.debugMessage(string2, string);
            string = "performTransportAssocSSLTLSSupported: " + performTransportAssocSSLTLSSupported;
            SecurityLogger.debugMessage(string2, string);
            string = "performMessageConfidentialityRequired: " + performMessageConfidentialityRequired;
            SecurityLogger.debugMessage(string2, string);
            string = "performMessageConfidentialitySupported: " + performMessageConfidentialitySupported;
            SecurityLogger.debugMessage(string2, string);
            string = "performMessageIntegrityRequired: " + performMessageIntegrityRequired;
            SecurityLogger.debugMessage(string2, string);
            string = "performMessageIntegritySupported: " + performMessageIntegritySupported;
            SecurityLogger.debugMessage(string2, string);
            string = "performTLClientAuthenticationRequired: " + performTLClientAuthenticationRequired;
            SecurityLogger.debugMessage(string2, string);
            string = "performTLClientAuthenticationSupported: " + performTLClientAuthenticationSupported;
            SecurityLogger.debugMessage(string2, string);
            string = "performClientAuthenticationRequired: " + performClientAuthenticationRequired;
            SecurityLogger.debugMessage(string2, string);
            string = "performClientAuthenticationSupported: " + performClientAuthenticationSupported;
            SecurityLogger.debugMessage(string2, string);
            string = "performIdentityAssertionRequired: " + performIdentityAssertionRequired;
            SecurityLogger.debugMessage(string2, string);
            string = "performIdentityAssertionSupported: " + performIdentityAssertionSupported;
            SecurityLogger.debugMessage(string2, string);
            string = "standardPerformQOPModels: " + standardPerformQOPModels;
            SecurityLogger.debugMessage(string2, string);
            string = "claimStateful: " + claimStateful;
            SecurityLogger.debugMessage(string2, string);
            string = "claimTransportAssocSSLTLSRequired: " + claimTransportAssocSSLTLSRequired;
            SecurityLogger.debugMessage(string2, string);
            string = "claimTransportAssocSSLTLSSupported: " + claimTransportAssocSSLTLSSupported;
            SecurityLogger.debugMessage(string2, string);
            string = "claimMessageConfidentialityRequired: " + claimMessageConfidentialityRequired;
            SecurityLogger.debugMessage(string2, string);
            string = "claimMessageConfidentialitySupported: " + claimMessageConfidentialitySupported;
            SecurityLogger.debugMessage(string2, string);
            string = "claimMessageIntegrityRequired: " + claimMessageIntegrityRequired;
            SecurityLogger.debugMessage(string2, string);
            string = "claimMessageIntegritySupported: " + claimMessageIntegritySupported;
            SecurityLogger.debugMessage(string2, string);
            string = "claimTLClientAuthenticationRequired: " + claimTLClientAuthenticationRequired;
            SecurityLogger.debugMessage(string2, string);
            string = "claimTLClientAuthenticationSupported: " + claimTLClientAuthenticationSupported;
            SecurityLogger.debugMessage(string2, string);
            string = "claimClientAuthenticationRequired: " + claimClientAuthenticationRequired;
            SecurityLogger.debugMessage(string2, string);
            string = "claimClientAuthenticationSupported: " + claimClientAuthenticationSupported;
            SecurityLogger.debugMessage(string2, string);
            string = "claimIdentityAssertionSupported: " + claimIdentityAssertionSupported;
            SecurityLogger.debugMessage(string2, string);
            string = "standardClaimQOPModels: " + standardClaimQOPModels;
        }
    }

    private int verifyConfiguration(int n) {
        int n2 = -1;
        if (n >= 1 && n2 <= 0) {
            n2 = this.verifyConfigurationCompleteness(n2);
        }
        if (n >= 2 && n2 <= 0) {
            n2 = this.verifyConfigurationConsistency(n2);
        }
        if (n >= 3 && n2 <= 0) {
            n2 = this.verifyConfigurationPassiveCorrectness(n2);
        }
        if (n >= 4 && n2 <= 0) {
            n2 = this.verifyConfigurationActiveCorrectness(n2);
        }
        return n2;
    }

    private synchronized void initializeVerificationLevel() {
        String string = null;
        string = CSIv2Configuration.clean(securityProps.getProperty("com.ibm.CORBA.verificationLevel"));
        if (string != null && string.length() > 0) {
            if ((string = string.toLowerCase()).equals("activelycorrect")) {
                verificationLevel = 4;
            } else if (string.equals("completeness")) {
                verificationLevel = 1;
            } else if (string.equals(DefaultVerificationLevelString)) {
                verificationLevel = 2;
            } else if (string.equals("passivelycorrect")) {
                verificationLevel = 3;
            } else {
                String string2 = "CSIv2Configuration.initializeVerificationLevel";
                String string3 = "security.JSAS0623E";
                SecurityLogger.logError(string3, new Object[]{string2});
            }
        }
    }

    private boolean isValidClaimQOP() {
        return true;
    }

    private boolean isValidPerformQOP() {
        return true;
    }

    private void reportVerificationAnalysis(String string, String string2, String string3, int n) {
        if (SecurityLogger.debugTraceEnabled) {
            String string4 = "CSIv2Configuration.reportVerificationAnalysis";
            String string5 = null;
            switch (n) {
                case 0: {
                    string5 = SecurityMessages.getMsgOrUseDefault(string, string2) + string3;
                    SecurityLogger.logActivity(string4, 0, string5);
                    break;
                }
                case 1: {
                    string5 = "security." + string;
                    SecurityLogger.logError(string5, new Object[]{string4, string3});
                }
            }
        }
    }

    private void reportVerificationAnalysis(String string, String string2, int n) {
        if (SecurityLogger.debugTraceEnabled) {
            String string3 = "CSIv2Configuration.reportVerificationAnalysis";
            String string4 = null;
            switch (n) {
                case 0: {
                    string4 = SecurityMessages.getMsgOrUseDefault(string, string2);
                    SecurityLogger.logActivity(string3, 0, string4);
                    break;
                }
                case 1: {
                    string4 = "security." + string;
                    SecurityLogger.logError(string4, new Object[]{string3});
                }
            }
        }
    }

    private void reportVerificationAnalysis(String string, String string2, String string3, String string4, int n) {
        if (SecurityLogger.debugTraceEnabled) {
            String string5 = "CSIv2Configuration.reportVerificationAnalysis";
            String string6 = null;
            switch (n) {
                case 0: {
                    string6 = componentLabel + ": " + string3 + " == " + string4;
                    SecurityLogger.logActivity(string5, 0, string6);
                    break;
                }
                case 1: {
                    string6 = "security." + string;
                    SecurityLogger.logError(string6, new Object[]{string5});
                    string6 = componentLabel + string3 + " == " + string4;
                    SecurityLogger.debugMessage(string5, string6);
                }
            }
        }
    }

    private int verifyConfigurationActiveCorrectness(int n) {
        String string = "CSIv2Configuration.verifyConfigurationActiveCorrectness";
        String string2 = null;
        int n2 = -1;
        n2 = n == -1 ? 0 : n;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Verifying the configuration for active correctness.";
            SecurityLogger.debugMessage(string, string2);
        }
        if (n2 == 0) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS1400I", "JSAS1400I: The configuration appears to be actively correct.");
            SecurityLogger.logActivity(string, 0, string2);
        } else if (n2 == 3) {
            string2 = "security.JSAS0415E";
            SecurityLogger.logError(string2, new Object[]{string});
        } else if (n2 == -1) {
            string2 = "security.JSAS0416E";
            SecurityLogger.logError(string2, new Object[]{string});
        } else {
            string2 = "security.JSAS0417E";
            SecurityLogger.logError(string2, new Object[]{string, new Integer(n2).toString()});
        }
        return n2;
    }

    private int verifyConfigurationCompleteness(int n) {
        String string = "CSIv2Configuration.verifyConfigurationCompleteness";
        String string2 = null;
        int n2 = -1;
        n2 = n == -1 ? 0 : n;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Verifying the configuration for completeness.";
            SecurityLogger.debugMessage(string, string2);
        }
        if (configurationInitialized) {
            this.reportVerificationAnalysis("JSAS1401I", "JSAS1401I: The configuration has been initialized.", 0);
            this.reportVerificationAnalysis("JSAS0500I", "JSAS0500I: CSI protocol has been enabled.", 0);
            if (realmName.length() > 0) {
                this.reportVerificationAnalysis("JSAS0501I", "JSAS0501I: Realm name has been set:", "realmName", realmName, 0);
            } else {
                this.reportVerificationAnalysis("JSAS0502I", "JSAS0502I: Realm name has not been set.", 0);
            }
            if (principalName.length() > 0) {
                this.reportVerificationAnalysis("JSAS1409I", "JSAS1409I: The principal has been set:", "principalName", principalName, 0);
            } else if (serverConfigured) {
                this.reportVerificationAnalysis("JSAS1410I", "JSAS1410I: The principal was not set:", 0);
            }
            if (serverConfigured) {
                if (claimStateful) {
                    this.reportVerificationAnalysis("JSAS0503I", "JSAS0503I: Claim stateful has been enabled.", 0);
                } else {
                    this.reportVerificationAnalysis("JSAS0504I", "JSAS0504I: Claim stateless has been enabled.", 0);
                }
                if (claimTransportAssocSSLTLSRequired) {
                    this.reportVerificationAnalysis("JSAS0505I", "JSAS0505I: Claim secure transport layer with SSL/TLS required has been set. <claimTransportAssocSSLTLSRequired>: " + CSIv2Configuration.booleanString(claimTransportAssocSSLTLSRequired), 0);
                } else if (claimTransportAssocSSLTLSSupported) {
                    this.reportVerificationAnalysis("JSAS0506I", "JSAS0506I: Claim secure transport layer  with SSL/TLS supported has been set. <claimTransportAssocSSLTLSSupported>: " + CSIv2Configuration.booleanString(claimTransportAssocSSLTLSSupported), 0);
                } else {
                    this.reportVerificationAnalysis("JSAS0507I", "JSAS0507I: No claim secure transport layer has been set.", 0);
                }
                if (claimTLClientAuthenticationRequired) {
                    this.reportVerificationAnalysis("JSAS0508I", "JSAS0508I: Claim client authentication at transport layer required has been set. <claimTLClientAuthenticationRequired>: " + CSIv2Configuration.booleanString(claimTLClientAuthenticationRequired), 0);
                } else if (claimTLClientAuthenticationSupported) {
                    this.reportVerificationAnalysis("JSAS0509I", "JSAS0509I: Claim client authentication at transport layer supported has been set. <claimTLClientAuthenticationSupported>: " + CSIv2Configuration.booleanString(claimTLClientAuthenticationSupported), 0);
                } else {
                    this.reportVerificationAnalysis("JSAS0510I", "JSAS0510I: No claim client authentication at transport layer has been set.", 0);
                }
                if (claimMessageConfidentialityRequired) {
                    this.reportVerificationAnalysis("JSAS0511I", "JSAS0511I: Claim message 128-bit SSL/TLS cipher suites required has been set. <claimMessageConfidentialityRequired>: " + CSIv2Configuration.booleanString(claimMessageConfidentialityRequired), 0);
                } else if (claimMessageConfidentialitySupported) {
                    this.reportVerificationAnalysis("JSAS0512I", "JSAS0512I: Claim message 128-bit SSL/TLS cipher suites supported has been set. <claimMessageConfidentialitySupported>: " + CSIv2Configuration.booleanString(claimMessageConfidentialitySupported), 0);
                } else {
                    this.reportVerificationAnalysis("JSAS0513I", "JSAS0513I: No claim message 128-bit SSL/TLS cipher suites has been set.", 0);
                }
                if (claimMessageIntegrityRequired) {
                    this.reportVerificationAnalysis("JSAS0514I", "JSAS0514I: Claim message 40-bit SSL/TLS cipher suites required has been set. <claimMessageIntegrityRequired>: " + CSIv2Configuration.booleanString(claimMessageIntegrityRequired), 0);
                } else if (claimMessageIntegritySupported) {
                    this.reportVerificationAnalysis("JSAS0515I", "JSAS0515I: Claim message 40-bit SSL/TLS cipher suites supported has been set. <claimMessageIntegritySupported>: " + CSIv2Configuration.booleanString(claimMessageIntegritySupported), 0);
                } else {
                    this.reportVerificationAnalysis("JSAS0516I", "JSAS0516I: No claim message 40-bit SSL/TLS cipher suites has been set.", 0);
                }
                if (claimClientAuthenticationRequired) {
                    this.reportVerificationAnalysis("JSAS0517I", "JSAS0517I: Claim client authentication required has been set. <claimClientAuthenticationRequired>: " + CSIv2Configuration.booleanString(claimClientAuthenticationRequired), 0);
                } else if (claimClientAuthenticationSupported) {
                    this.reportVerificationAnalysis("JSAS0518I", "JSAS0518I: Claim client authentication supported has been set. <claimClientAuthenticationSupported>: " + CSIv2Configuration.booleanString(claimClientAuthenticationSupported), 0);
                } else {
                    this.reportVerificationAnalysis("JSAS0519I", "JSAS0519I: No claim client authentication has been set.", 0);
                }
                if (claimIdentityAssertionSupported) {
                    this.reportVerificationAnalysis("JSAS0520I", "JSAS0520I: Claim identity assertion supported has been set. <claimIdentityAssertionSupported>: " + CSIv2Configuration.booleanString(claimIdentityAssertionSupported), 0);
                } else {
                    this.reportVerificationAnalysis("JSAS0521I", "JSAS0521I: No claim identity assertion has been set.", 0);
                }
            }
            if (performStateful) {
                this.reportVerificationAnalysis("JSAS0522I", "JSAS0522I: Perform stateful has been enabled.", 0);
            } else {
                this.reportVerificationAnalysis("JSAS0523I", "JSAS0523I: Perform stateless has been enabled.", 0);
            }
            if (performTransportAssocSSLTLSRequired) {
                this.reportVerificationAnalysis("JSAS0524I", "JSAS0524I: Perform secure transport layer with SSL/TLS required has been set. <performTransportAssocSSLTLSRequired>: " + CSIv2Configuration.booleanString(performTransportAssocSSLTLSRequired), 0);
            } else if (performTransportAssocSSLTLSSupported) {
                this.reportVerificationAnalysis("JSAS0525I", "JSAS0525I: Perform secure transport layer  with SSL/TLS supported has been set. <performTransportAssocSSLTLSSupported>: " + CSIv2Configuration.booleanString(performTransportAssocSSLTLSSupported), 0);
            } else {
                this.reportVerificationAnalysis("JSAS0526I", "JSAS0526I: No perform secure transport layer has been set.", 0);
            }
            if (performTLClientAuthenticationRequired) {
                this.reportVerificationAnalysis("JSAS0527I", "JSAS0527I: Perform client authentication at transport layer required has been set. <performTLClientAuthenticationRequired>: " + CSIv2Configuration.booleanString(performTLClientAuthenticationRequired), 0);
            } else if (performTLClientAuthenticationSupported) {
                this.reportVerificationAnalysis("JSAS0528I", "JSAS0528I: Perform client authentication at transport layer supported has been set. <performTLClientAuthenticationSupported>: " + CSIv2Configuration.booleanString(performTLClientAuthenticationSupported), 0);
            } else {
                this.reportVerificationAnalysis("JSAS0529I", "JSAS0529I: No perform client authentication at transport layer has been set.", 0);
            }
            if (performMessageConfidentialityRequired) {
                this.reportVerificationAnalysis("JSAS0530I", "JSAS0530I: Perform message 128-bit SSL/TLS cipher suites required has been set. <performMessageConfidentialityRequired>: " + CSIv2Configuration.booleanString(performMessageConfidentialityRequired), 0);
            } else if (performMessageConfidentialitySupported) {
                this.reportVerificationAnalysis("JSAS0531I", "JSAS0531I: Perform message 128-bit SSL/TLS cipher suites supported has been set. <performMessageConfidentialitySupported>: " + CSIv2Configuration.booleanString(performMessageConfidentialitySupported), 0);
            } else {
                this.reportVerificationAnalysis("JSAS0532I", "JSAS0532I: No perform message 128-bit SSL/TLS cipher suites has been set.", 0);
            }
            if (performMessageIntegrityRequired) {
                this.reportVerificationAnalysis("JSAS0533I", "JSAS0533I: Perform message 40-bit SSL/TLS cipher suites required has been set. <performMessageIntegrityRequired>: " + CSIv2Configuration.booleanString(performMessageIntegrityRequired), 0);
            } else if (performMessageIntegritySupported) {
                this.reportVerificationAnalysis("JSAS0534I", "JSAS0534I: Perform message 40-bit SSL/TLS cipher suites supported has been set. <performMessageIntegritySupported>: " + CSIv2Configuration.booleanString(performMessageIntegritySupported), 0);
            } else {
                this.reportVerificationAnalysis("JSAS0535I", "JSAS0535I: No perform message 40-bit SSL/TLS cipher suites has been set.", 0);
            }
            if (performClientAuthenticationRequired) {
                this.reportVerificationAnalysis("JSAS0536I", "JSAS0536I: Perform client authentication required has been set. <performClientAuthenticationRequired>: " + CSIv2Configuration.booleanString(performClientAuthenticationRequired), 0);
            } else if (performClientAuthenticationSupported) {
                this.reportVerificationAnalysis("JSAS0537I", "JSAS0537I: Perform client authentication supported has been set. <performClientAuthenticationSupported>: " + CSIv2Configuration.booleanString(performClientAuthenticationSupported), 0);
            } else {
                this.reportVerificationAnalysis("JSAS0538I", "JSAS0538I: No perform client authentication has been set.", 0);
            }
            if (performIdentityAssertionSupported) {
                this.reportVerificationAnalysis("JSAS0539I", "JSAS0539I: Perform identity assertion supported has been set. <performIdentityAssertionSupported>: " + CSIv2Configuration.booleanString(performIdentityAssertionSupported), 0);
            } else {
                this.reportVerificationAnalysis("JSAS0540I", "JSAS0540I: No perform identity assertion has been set.", 0);
            }
        } else {
            n2 = 1;
            string2 = "security.JSAS0418E";
            SecurityLogger.logError(string2, new Object[]{string});
        }
        if (SecurityLogger.debugTraceEnabled) {
            if (n2 == 0) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS1449I", "JSAS1449I: The configuration appears to be complete.");
                SecurityLogger.logActivity(string, 0, string2);
            } else if (n2 == 1) {
                string2 = "security.JSAS0422E";
                SecurityLogger.logError(string2, new Object[]{string});
            } else if (n2 == -1) {
                string2 = "security.JSAS0416E";
                SecurityLogger.logError(string2, new Object[]{string});
            } else {
                string2 = "security.JSAS0423E";
                SecurityLogger.logError(string2, new Object[]{string, new Integer(n2).toString()});
            }
        }
        return n2;
    }

    private int verifyConfigurationConsistency(int n) {
        String string = "CSIv2Configuration.verifyConfigurationConsistency";
        String string2 = null;
        int n2 = -1;
        n2 = n == -1 ? 0 : n;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Verifying the configuration for consistency.";
            SecurityLogger.debugMessage(string, string2);
        }
        if (serverConfigured) {
            if (claimIdentityAssertionSupported && (TrustedPrincipalList == null || TrustedPrincipalList.length() == 0)) {
                n2 = 2;
                string2 = "security.JSAS0541I";
                SecurityLogger.logError(string2, new Object[]{string, new Boolean(claimIdentityAssertionSupported)});
            }
        } else {
            if (claimIdentityAssertionSupported) {
                n2 = 2;
                string2 = "security.JSAS0544I";
                SecurityLogger.logError(string2, new Object[]{string});
                claimIdentityAssertionSupported = false;
            }
            if (performIdentityAssertionSupported) {
                n2 = 2;
                string2 = "security.JSAS0545I";
                SecurityLogger.logError(string2, new Object[]{string});
                performIdentityAssertionSupported = false;
            }
            if (performIdentityAssertionRequired) {
                n2 = 2;
                string2 = "security.JSAS0546I";
                SecurityLogger.logError(string2, new Object[]{string});
                performIdentityAssertionRequired = false;
            }
        }
        return n2;
    }

    private int verifyConfigurationPassiveCorrectness(int n) {
        String string = "CSIv2Configuration.verifyConfigurationPassiveCorrectness";
        String string2 = null;
        int n2 = -1;
        n2 = n == -1 ? 0 : n;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Verifying the configuration for passive correctness.";
            SecurityLogger.debugMessage(string, string2);
        }
        if (n2 == 0) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS1451I", "JSAS1451I: The configuration appears to be passively correct.");
            SecurityLogger.logActivity(string, 0, string2);
        } else if (n2 == 3) {
            string2 = "security.JSAS0415E";
            SecurityLogger.logError(string2, new Object[]{string});
        } else if (n2 == -1) {
            string2 = "security.JSAS0416E";
            SecurityLogger.logError(string2, new Object[]{string});
        } else {
            string2 = "security.JSAS0431E";
            SecurityLogger.logError(string2, new Object[]{string, new Integer(n2).toString()});
        }
        return n2;
    }

    protected static final String getRealmName() {
        return realmName;
    }

    protected static final boolean getCSIv2ClaimStateful() {
        return claimStateful;
    }

    protected static final String getCSIv2TrustedPrincipalList() {
        return TrustedPrincipalList;
    }

    protected static final boolean getCSIv2ClaimTransportAssocSSLTLSRequired() {
        return claimTransportAssocSSLTLSRequired;
    }

    protected static final boolean getCSIv2ClaimTransportAssocSSLTLSSupported() {
        return claimTransportAssocSSLTLSSupported;
    }

    protected static final boolean getCSIv2ClaimMessageConfidentialityRequired() {
        return claimMessageConfidentialityRequired;
    }

    protected static final boolean getCSIv2ClaimMessageConfidentialitySupported() {
        return claimMessageConfidentialitySupported;
    }

    protected static final boolean getCSIv2ClaimMessageIntegrityRequired() {
        return claimMessageIntegrityRequired;
    }

    protected static final boolean getCSIv2ClaimMessageIntegritySupported() {
        return claimMessageIntegritySupported;
    }

    protected static final boolean getCSIv2ClaimTLClientAuthenticationRequired() {
        return claimTLClientAuthenticationRequired;
    }

    protected static final boolean getCSIv2ClaimTLClientAuthenticationSupported() {
        return claimTLClientAuthenticationSupported;
    }

    protected static final boolean getCSIv2ClaimClientAuthenticationRequired() {
        return claimClientAuthenticationRequired;
    }

    protected static final boolean getCSIv2ClaimClientAuthenticationSupported() {
        return claimClientAuthenticationSupported;
    }

    protected static final boolean getCSIv2ClaimIdentityAssertionSupported() {
        return claimIdentityAssertionSupported;
    }

    protected static final boolean getneverUseClientCertificateForCallerLogin() {
        return neverUseClientCertificateForCallerLogin;
    }

    protected static final boolean getCSIv2PerformStateful() {
        return performStateful;
    }

    protected static final boolean getCSIv2PerformTransportAssocSSLTLSRequired() {
        return performTransportAssocSSLTLSRequired;
    }

    protected static final boolean getCSIv2PerformTransportAssocSSLTLSSupported() {
        return performTransportAssocSSLTLSSupported;
    }

    protected static final boolean getCSIv2PerformMessageConfidentialityRequired() {
        return performMessageConfidentialityRequired;
    }

    protected static final boolean getCSIv2PerformMessageConfidentialitySupported() {
        return performMessageConfidentialitySupported;
    }

    protected static final boolean getCSIv2PerformMessageIntegrityRequired() {
        return performMessageIntegrityRequired;
    }

    protected static final boolean getCSIv2PerformMessageIntegritySupported() {
        return performMessageIntegritySupported;
    }

    protected static final boolean getCSIv2PerformTLClientAuthenticationRequired() {
        return performTLClientAuthenticationRequired;
    }

    protected static final boolean getCSIv2PerformTLClientAuthenticationSupported() {
        return performTLClientAuthenticationSupported;
    }

    protected static final boolean getCSIv2PerformClientAuthenticationRequired() {
        return performClientAuthenticationRequired;
    }

    protected static final boolean getCSIv2PerformClientAuthenticationSupported() {
        return performClientAuthenticationSupported;
    }

    protected static final boolean getCSIv2PerformIdentityAssertionRequired() {
        return performIdentityAssertionRequired;
    }

    protected static final boolean getCSIv2PerformIdentityAssertionSupported() {
        return performIdentityAssertionSupported;
    }

    protected static final int getCSIv2StandardClaimQOPModels() {
        return standardClaimQOPModels;
    }

    protected static final int getCSIv2StandardPerformQOPModels() {
        return standardPerformQOPModels;
    }

    protected static final boolean getCSIv2PerformTransportAssocSECIOPRequired() {
        return performTransportAssocSECIOPRequired;
    }

    protected static final boolean getCSIv2PerformTransportAssocSECIOPSupported() {
        return performTransportAssocSECIOPSupported;
    }

    protected static final boolean getCSIv2ClaimTransportAssocSECIOP() {
        return claimTransportAssocSECIOP;
    }

    protected static final boolean getCSIv2ClaimMessageMisorderingDetectionRequired() {
        return claimMessageMisorderingDetectionRequired;
    }

    protected static final boolean getCSIv2ClaimMessageMisorderingDetectionSupported() {
        return claimMessageMisorderingDetectionSupported;
    }

    protected static final boolean getCSIv2ClaimMessageReplayDetectionRequired() {
        return claimMessageReplayDetectionRequired;
    }

    protected static final boolean getCSIv2ClaimMessageReplayDetectionSupported() {
        return claimMessageReplayDetectionSupported;
    }

    protected static final boolean getCSIv2ClaimTLServerAuthenticationSupported() {
        return claimTLServerAuthenticationSupported;
    }

    protected static final boolean getCSIv2ClaimServerAuthenticationRequired() {
        return claimServerAuthenticationRequired;
    }

    protected static final boolean getCSIv2ClaimServerAuthenticationSupported() {
        return claimServerAuthenticationSupported;
    }

    protected static final boolean getCSIv2ClaimDelegationByClientRequired() {
        return claimDelegationByClientRequired;
    }

    protected static final boolean getCSIv2ClaimDelegationByClientSupported() {
        return claimDelegationByClientSupported;
    }

    protected static final boolean getCSIv2PerformMessageMisorderingDetectionRequired() {
        return performMessageMisorderingDetectionRequired;
    }

    protected static final boolean getCSIv2PerformMessageMisorderingDetectionSupported() {
        return performMessageMisorderingDetectionSupported;
    }

    protected static final boolean getCSIv2PerformMessageReplayDetectionRequired() {
        return performMessageReplayDetectionRequired;
    }

    protected static final boolean getCSIv2PerformMessageReplayDetectionSupported() {
        return performMessageReplayDetectionSupported;
    }

    protected static final boolean getCSIv2PerformTLServerAuthenticationRequired() {
        return performTLServerAuthenticationRequired;
    }

    protected static final boolean getCSIv2PerformTLServerAuthenticationSupported() {
        return performTLServerAuthenticationSupported;
    }

    protected static final int getCSIv2PerformIdentityAssertionType() {
        return performIdentityAssertionType;
    }

    protected static final int getCSIv2PerformIdentityAssertionMechanism() {
        return performIdentityAssertionMechanism;
    }

    protected static final boolean getCSIv2PerformDelegationByClientRequired() {
        return performDelegationByClientRequired;
    }

    protected static final boolean getCSIv2PerformDelegationByClientSupported() {
        return performDelegationByClientSupported;
    }

    protected static final boolean getCSIv2KerberosClientAssociationRequired() {
        return KerberosClientAssociationRequired;
    }

    protected static final boolean getCSIv2KerberosServerAssociationRequired() {
        return KerberosServerAssociationRequired;
    }

    protected static final boolean getCSIv2KerberosClientAssociationSupported() {
        return KerberosClientAssociationSupported;
    }

    protected static final boolean getCSIv2KerberosServerAssociationSupported() {
        return KerberosServerAssociationSupported;
    }

    protected static final boolean getCSIv2LocalOSClientAssociationRequired() {
        return LocalOSClientAssociationRequired;
    }

    protected static final boolean getCSIv2LocalOSServerAssociationRequired() {
        return LocalOSServerAssociationRequired;
    }

    protected static final boolean getCSIv2LocalOSClientAssociationSupported() {
        return LocalOSClientAssociationSupported;
    }

    protected static final boolean getCSIv2LocalOSServerAssociationSupported() {
        return LocalOSServerAssociationSupported;
    }

    protected static final boolean getCSIv2LTPAClientAssociationRequired() {
        return LTPAClientAssociationRequired;
    }

    protected static final boolean getCSIv2LTPAServerAssociationRequired() {
        return LTPAServerAssociationRequired;
    }

    protected static final boolean getCSIv2LTPAClientAssociationSupported() {
        return LTPAClientAssociationSupported;
    }

    protected static final boolean getCSIv2LTPAServerAssociationSupported() {
        return LTPAServerAssociationSupported;
    }

    protected static final String getCSIv2AlternateIdentityAssertionPerformTrustedId() {
        return alternatePerformTrustedId;
    }

    protected static final String getCSIv2AlternateIdentityAssertionPerformTrustedPassword() {
        return alternatePerformTrustedPassword;
    }
}

