/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl;
import com.ibm.ISecurityUtilityImpl.MechanismAmbiguityException;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;

public class MechanismFactory {
    private SecurityConfiguration secConfig = null;
    private VaultImpl vault = null;
    public static final String BasicAuthOverSSL = "1.1";
    public static final String BasicAuthOverSSLtoLTPA = "1.1.1";
    public static final String BasicAuthOverSSLtoLocalOS = "1.1.2";
    public static final String BasicAuthOverSSLtoDCE = "1.1.3";
    public static final String BasicAuthOverSSLtoCustom = "1.1.4";
    public static final String MutualSSL = "1.2";
    public static final String LTPAoverSSL = "1.3";
    public static final String LocalOSoverSSL = "1.4";
    public static final String GSSUPOverSSL = "1.5";
    public static final String GSSUPOverSSLtoLTPA = "1.5.1";
    public static final String GSSUPOverSSLtoLocalOS = "1.5.2";
    public static final String GSSUPOverSSLtoDCE = "1.5.3";
    public static final String GSSUPOverSSLtoCustom = "1.5.4";
    public static final String GSSUPOverSSLtoKRB5 = "1.5.5";
    public static final String Kerberos5overSSL = "1.6";
    public static final String CustomoverSSL = "1.7";
    public static final String BasicAuthOverIPSec = "2.1";
    public static final String MutualIPSec = "2.2";
    public static final String DCEKerberos = "3.1";
    public static final String ClientCerttoDCEKerberos = "3.2";
    public static final String Kerberos5 = "4.1";
    public static final String ClientCerttoKerberos5 = "4.2";
    public static final String ClientCerttoCustom = "4.3";
    public static final String LTPAoverTCP = "5.1";
    public static final String LocalOSoverTCP = "5.2";
    public static final String BasicAuthOverTCPtoLTPA = "5.3";
    public static final String BasicAuthOverTCPtoLocalOS = "5.4";
    public static final String BasicAuthOverTCPtoDCE = "5.5";
    public static final String BasicAuthOverTCP = "5.6";
    public static final String GSSUPOverTCPtoLTPA = "5.7.1";
    public static final String GSSUPOverTCPtoLocalOS = "5.7.2";
    public static final String GSSUPOverTCPtoDCE = "5.7.3";
    public static final String GSSUPOverTCP = "5.7.4";
    public static final String GSSUPOverTCPtoCustom = "5.7.5";
    public static final String GSSUPOverTCPtoKRB5 = "5.7.6";
    public static final String Kerberos5overTCP = "5.8";
    public static final String CustomoverTCP = "5.9";
    public static final String UnauthenticatedOverSSL = "6.1";

    protected MechanismFactory() {
    }

    public MechanismFactory(SecurityConfiguration securityConfiguration) {
        this.secConfig = securityConfiguration;
    }

    public VaultImpl getVault() {
        if (this.vault == null) {
            this.vault = VaultImpl.getInstance();
        }
        return this.vault;
    }

    public String getMechanismTypeIdentity() throws MechanismAmbiguityException {
        String string = "MechanismFactory.getMechanismTypeIdentity";
        Object var2_2 = null;
        return this.getMechanismTypeIdentity("oid:2.23.130.1.1.1");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMechanismTypeIdentity(String string) throws MechanismAmbiguityException {
        String string2 = "MechanismFactory.getMechanismTypeIdentity";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (this.secConfig.getCSIv2ClaimTransportAssocSSLTLSRequired() || this.secConfig.getCSIv2ClaimTransportAssocSSLTLSSupported()) {
            if (this.secConfig.getauthenticationTarget() == 1 && string.compareTo("oid:1.3.18.0.2.30.2") == 0) {
                string4 = LTPAoverSSL;
                string5 = "LTPAoverSSL";
            } else if (this.secConfig.getauthenticationTarget() == 1 && string.compareTo("oid:2.23.130.1.1.1") == 0) {
                string4 = GSSUPOverSSLtoLTPA;
                string5 = "GSSUPOverSSLtoLTPA";
            } else if (this.secConfig.getauthenticationTarget() == 2) {
                string4 = GSSUPOverSSLtoLocalOS;
                string5 = "GSSUPOverSSLtoLocalOS";
            } else if (this.secConfig.getauthenticationTarget() == 4) {
                string4 = GSSUPOverSSL;
                string5 = "GSSUPOverSSL";
            } else if (this.secConfig.getauthenticationTarget() == 8) {
                string4 = GSSUPOverSSLtoCustom;
                string5 = "GSSUPOverSSLtoCustom";
            } else if (this.secConfig.getauthenticationTarget() == 6) {
                string4 = GSSUPOverSSLtoKRB5;
                string5 = "GSSUPOverSSLtoKRB5";
            } else {
                if (this.secConfig.getauthenticationTarget() != 9) throw new MechanismAmbiguityException();
                string4 = CustomoverSSL;
                string5 = "CustomoverSSL";
            }
        } else if (this.secConfig.getauthenticationTarget() == 1 && string.compareTo("oid:1.3.18.0.2.30.2") == 0) {
            string4 = LTPAoverTCP;
            string5 = "LTPAoverTCP";
        } else if (this.secConfig.getauthenticationTarget() == 1 && string.compareTo("oid:2.23.130.1.1.1") == 0) {
            string4 = GSSUPOverTCPtoLTPA;
            string5 = "GSSUPOverTCPtoLTPA";
        } else if (this.secConfig.getauthenticationTarget() == 2) {
            string4 = GSSUPOverTCPtoLocalOS;
            string5 = "GSSUPOverTCPtoLocalOS";
        } else if (this.secConfig.getauthenticationTarget() == 4) {
            string4 = GSSUPOverTCP;
            string5 = "GSSUPOverTCP";
        } else if (this.secConfig.getauthenticationTarget() == 8) {
            string4 = GSSUPOverTCPtoCustom;
            string5 = "GSSUPOverTCPtoCustom";
        } else {
            if (this.secConfig.getauthenticationTarget() != 6) throw new MechanismAmbiguityException();
            string4 = GSSUPOverTCPtoKRB5;
            string5 = "GSSUPOverTCPtoKRB5";
        }
        if (!SecurityLogger.debugTraceEnabled) return string4;
        string3 = "Returning mechanism type: " + string5;
        SecurityLogger.debugMessage(string2, string3);
        return string4;
    }

    public com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl getSecurityContext(VaultImpl vaultImpl, WSCredential wSCredential, String string) throws MechanismAmbiguityException {
        com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl securityContextImpl;
        block6: {
            String string2 = "MechanismFactory.getSecurityContext";
            String string3 = null;
            securityContextImpl = null;
            try {
                if (wSCredential.isBasicAuth()) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "Returning GSSUP SecurityContext.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    securityContextImpl = OID.compareOIDs(wSCredential.getOID(), "oid:2.23.130.1.1.1") ? new com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl(this.getVault(), string) : new SecurityContextImpl(this.getVault(), string);
                    break block6;
                }
                if (wSCredential.isForwardable()) {
                    string3 = "Returning TokenBase SecurityContext.";
                    SecurityLogger.debugMessage(string2, string3);
                    securityContextImpl = new SecurityContextImpl(this.getVault(), string);
                    break block6;
                }
                throw new MechanismAmbiguityException("Non-forwardable credentials cannot establish a SecurityContext.");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.MechanismFactory.getSecurityContext", "340", this);
                if (exception instanceof MechanismAmbiguityException) {
                    throw (MechanismAmbiguityException)exception;
                }
                securityContextImpl = new SecurityContextImpl(this.getVault(), string);
            }
        }
        return securityContextImpl;
    }

    public com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl getSecurityContext(VaultImpl vaultImpl, String string, String string2) throws MechanismAmbiguityException {
        return this.getSecurityContext(string, string2);
    }

    public com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl getSecurityContext(String string, String string2) throws MechanismAmbiguityException {
        String string3 = "MechanismFactory.getSecurityContext";
        String string4 = null;
        com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl securityContextImpl = null;
        if (string.equals(VaultConstants.LTPA_MECH_TYPE)) {
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Returning Token Base SecurityContext.";
                SecurityLogger.debugMessage(string3, string4);
            }
            securityContextImpl = new SecurityContextImpl(this.getVault(), string2, string);
        } else if (string.equals(VaultConstants.CUSTOM_MECH_TYPE)) {
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Returning Token Base SecurityContext.";
                SecurityLogger.debugMessage(string3, string4);
            }
            securityContextImpl = new SecurityContextImpl(this.getVault(), string2, string);
        } else if (string.equals(VaultConstants.KRB5_MECH_TYPE)) {
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Returning Token Base SecurityContext.";
                SecurityLogger.debugMessage(string3, string4);
            }
            securityContextImpl = new SecurityContextImpl(this.getVault(), string2, string);
        } else if (string.equals(VaultConstants.CLIENT_CERT_MECH_TYPE)) {
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Returning TokenBase SecurityContext.";
                SecurityLogger.debugMessage(string3, string4);
            }
            securityContextImpl = new SecurityContextImpl(this.getVault(), string2, string);
        } else {
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Returning GSSUP SecurityContext.";
                SecurityLogger.debugMessage(string3, string4);
            }
            securityContextImpl = new com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl(this.getVault(), string2);
        }
        return securityContextImpl;
    }
}

