/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.BagEnumerator;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.DictionaryEnumerator;
import com.ibm.ObjectQuery.crud.util.DictionaryKeyEnumerator;
import com.ibm.ObjectQuery.crud.util.SetEnumerator;
import com.ibm.ObjectQuery.crud.util.StCollection;
import com.ibm.ObjectQuery.crud.util.StDictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class Bag
extends StCollection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private StDictionary occurrenceDictionary;

    public Bag() {
        this.initialize(Bag.minimumSize());
    }

    public Bag(int n) {
        this.initialize(Math.max(n + n, Bag.minimumSize()));
    }

    public Bag add(char c) {
        this.add(new Character(c), 1);
        return this;
    }

    public boolean add(char c, int n) {
        return this.add(new Character(c), n);
    }

    public Bag add(int n) {
        this.add(new Integer(n), 1);
        return this;
    }

    public boolean add(int n, int n2) {
        return this.add(new Integer(n), n2);
    }

    public boolean add(Object object) {
        return this.add(object, 1);
    }

    public boolean add(Object object, int n) {
        Object object2 = this.getOccurrenceDictionary().get(object);
        int n2 = this.unwrapInteger(object2);
        this.getOccurrenceDictionary().put(object, n2 + n);
        return true;
    }

    public Bag add(boolean bl) {
        this.add(new Boolean(bl), 1);
        return this;
    }

    public int[] asIntArray() {
        int n = this.numberOfElements();
        int[] nArray = new int[n];
        int n2 = 0;
        Enumeration enumeration = this.occurrenceElements();
        while (enumeration.hasMoreElements()) {
            nArray[n2] = (Integer)enumeration.nextElement();
            ++n2;
        }
        return nArray;
    }

    public Enumeration associationElements() {
        return new SetEnumerator(this.getOccurrenceDictionary());
    }

    public Vector asVector() {
        Vector vector = new Vector(this.numberOfElements());
        Enumeration enumeration = this.occurrenceElements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public float avg() {
        return this.sum() / this.numberOfElements();
    }

    public void clear() {
        this.occurrenceDictionary.clear();
    }

    public Enumeration elements() {
        return new BagEnumerator(this);
    }

    public StDictionary getOccurrenceDictionary() {
        return this.occurrenceDictionary;
    }

    public boolean includes(char c) {
        return this.getOccurrenceDictionary().includesKey(c);
    }

    public boolean includes(int n) {
        return this.getOccurrenceDictionary().includesKey(n);
    }

    public boolean includes(Object object) {
        return this.getOccurrenceDictionary().includesKey(object);
    }

    public boolean includes(boolean bl) {
        return this.getOccurrenceDictionary().includesKey(bl);
    }

    public void initialize(int n) {
        super.initialize(n);
        this.occurrenceDictionary = new StDictionary(n);
    }

    public boolean isEmpty() {
        return this.getOccurrenceDictionary().isEmpty();
    }

    public Iterator iterator() {
        return new BagEnumerator(this);
    }

    public Enumeration keyElements() {
        return new DictionaryKeyEnumerator(this.getOccurrenceDictionary());
    }

    public int max() {
        int n = 0;
        Enumeration enumeration = this.occurrenceElements();
        while (enumeration.hasMoreElements()) {
            n = Math.max(n, (Integer)enumeration.nextElement());
        }
        return n;
    }

    public int min() {
        int n = 0;
        Enumeration enumeration = this.occurrenceElements();
        if (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
        }
        while (enumeration.hasMoreElements()) {
            n = Math.min(n, (Integer)enumeration.nextElement());
        }
        return n;
    }

    public static int minimumSize() {
        return 11;
    }

    public int numberOfElements() {
        return this.occurrenceDictionary.size();
    }

    public Enumeration occurrenceElements() {
        return new DictionaryEnumerator(this.getOccurrenceDictionary());
    }

    public int occurrencesOf(char c) {
        Object object = this.getOccurrenceDictionary().get(c);
        return this.unwrapInteger(object);
    }

    public int occurrencesOf(int n) {
        Object object = this.getOccurrenceDictionary().get(n);
        return this.unwrapInteger(object);
    }

    public int occurrencesOf(Object object) {
        Object object2 = this.getOccurrenceDictionary().get(object);
        return this.unwrapInteger(object2);
    }

    public int occurrencesOf(boolean bl) {
        Object object = this.getOccurrenceDictionary().get(bl);
        return this.unwrapInteger(object);
    }

    public void rehash() {
        this.getOccurrenceDictionary().rehash();
    }

    public boolean remove(Object object) {
        int n = this.occurrencesOf(object);
        if (n > 1) {
            this.getOccurrenceDictionary().put(object, n--);
            return false;
        }
        this.getOccurrenceDictionary().removeKey(object);
        return true;
    }

    private void setOccurenceDictionary(StDictionary stDictionary) {
        this.occurrenceDictionary = stDictionary;
    }

    public int size() {
        int n = 0;
        Enumeration enumeration = this.getOccurrenceDictionary().elements();
        while (enumeration.hasMoreElements()) {
            n += ((Integer)enumeration.nextElement()).intValue();
        }
        return n;
    }

    public int sum() {
        int n = 0;
        Enumeration enumeration = this.occurrenceElements();
        while (enumeration.hasMoreElements()) {
            n += ((Integer)enumeration.nextElement()).intValue();
        }
        return n;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassShortName.name(this));
        if (this.numberOfElements() - 1 < 100) {
            this.occurrenceDictionary.toStringForSmallOn(stringBuffer);
        } else {
            this.occurrenceDictionary.toStringForLargeOn(stringBuffer);
        }
        return stringBuffer.toString();
    }

    private int unwrapInteger(Object object) {
        return object == null ? 0 : (Integer)object;
    }
}

