/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.Trace;
import com.ibm.ObjectQuery.crud.util.TreeNode;
import com.ibm.ObjectQuery.crud.util.VapStringReader;
import java.util.Iterator;

public class GenericTreeNode
extends TreeNode {
    private static final long serialVersionUID = 3257564010101684528L;
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Object contextIvar;

    public GenericTreeNode() {
    }

    public GenericTreeNode(Object object) {
        this.context(object);
    }

    public Object context() {
        return this.contextIvar;
    }

    public void context(Object object) {
        this.contextIvar = object;
    }

    public static TreeNode example() {
        String string = "(Collection (Bag) (CompositeCollection) (EpHashDictionary) (EpLargeDictionary) (EpLargeIdentitySet) (EsLargeSymbolSet) (EsMultipleSets) (EsWeakSet (AbtWeakSet) (EsWeakIdentitySet) (SdgWeakSet)) (FastStack) (KeyedCollection (Dictionary (EsPoolDictionary) (EsSmalltalkDictionary) (SdgPersistentDictionary) (VapLocalImagePersistedInstancesCache)) (EsIndexedDictionary (AbtEsWeakDictionary) (AbtIndexedDictionary (AbtIndexedIdentityDictionary)) (EsIndexedIdentityDictionary) (EsOrderedDictionary (AbtOrderedDictionary (AbtOrderedIdentityDictionary) (SdgOrderedDictionary)) (EsOrderedIdentityDictionary)) (EsWeakDictionary (EsWeakIdentityDictionary) (SdgWeakDictionary))) (EsSmalltalkNamespace) (LookupTable (AbtWeakKeyLookupTable (AbtWeakKeyIdentityDictionary)) (AbtWeakValueLookupTable) (FixedSizeLookupTable) (IdentityDictionary (EpIdentityDictionary)))) (SequenceableCollection (AdditiveSequenceableCollection (OrderedCollection (EpUnorderedCollection) (KSCOrderedSet) (SdgOrderedSetSimple (SdgOrderedSet)) (SdgPrimaryKeyCollection) (Stack) (VapDataRow) (VapLiteCollection (VapPacketingLiteCollection)) (VapOrderedSetSimple (VapOrderedSet))) (SortedCollection)) (ArrayedCollection (Array (AbtPersistencyGroup) (ArrayAssociation (Range (RangeWithExclusions))) (EpAnnotationEntry) (EpLeafComponentAnnotationsEntry (EpComponentAnnotationsEntry)) (EsMethodArray) (EsWeakArray) (EswPrivateArray (EswInstVarNamesArray) (EswRootArray)) (GbLinkedArray) (SdgRelationalTuple)) (ByteArray (EsLeadEncodedBytes (HptLeadEncodedPSZ))) (EsLongArray) (EsString (DBString) (String (EswPrivateString) (HptStringPSZ) (Symbol)))) (GbLinkedCollection) (Interval)) (Set (EsIdentitySet) (EsSymbolSet (EsAtomSet)) (SdgDefineableEquivalenceSet) (VapEquivalenceSet)) (VapStack))";
        return GenericTreeNode.fromLispString(string);
    }

    public static void example2() {
        Iterator iterator = GenericTreeNode.example().iterator();
        Trace.traceOn();
        while (iterator.hasNext()) {
            Trace.show((TreeNode)iterator.next());
        }
    }

    public static void example3() {
        TreeNode treeNode = GenericTreeNode.example();
        Trace.traceOn();
        Iterator iterator = treeNode.leaves().iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode2 = (TreeNode)iterator.next();
            Iterator iterator2 = treeNode2.toRootIterator();
            while (iterator2.hasNext()) {
                Trace.show((TreeNode)iterator2.next());
            }
        }
    }

    public static void example4() {
        TreeNode treeNode = GenericTreeNode.example();
        Trace.traceOn();
        Iterator iterator = treeNode.breadthFirstIterator();
        while (iterator.hasNext()) {
            Trace.show((TreeNode)iterator.next());
        }
    }

    public static void example5() {
        TreeNode treeNode = GenericTreeNode.example();
        Trace.traceOn();
        Iterator iterator = treeNode.postOrderIterator();
        while (iterator.hasNext()) {
            Trace.show((TreeNode)iterator.next());
        }
    }

    public static int example6() {
        return GenericTreeNode.example().size();
    }

    public static TreeNode example7() {
        String string = "((VapCurrency (DELETE FROM CURRENCY  WHERE TYPE = ?))(VapAddress (DELETE FROM ADDRESS  WHERE ADDRNO = ?))(VapBankBranch (DELETE FROM BRANCH  WHERE BRANCHNO = ?))(VapAccount (DELETE FROM ACCOUNT  WHERE ACCNTNO = ?))(VapBankTransaction (DELETE FROM BANKXACT  WHERE TRANSNO = ?))(VapCustomer ((DELETE FROM CUSTOMER  WHERE CUSNO = ?)(DELETE FROM CUSTDATA  WHERE CUSNO = ?)))(VapBranchToCurrency (DELETE FROM BRNCHCURR  WHERE BRANCH = ? AND TYPE = ?))(VapDeposit (DELETE FROM BANKXACT  WHERE TRANSNO = ?))(VapSavingsAccount (DELETE FROM ACCOUNT  WHERE ACCNTNO = ?))(VapWithdrawal (DELETE FROM BANKXACT  WHERE TRANSNO = ?)) (VapCheckingAccount (DELETE FROM ACCOUNT  WHERE ACCNTNO = ?)))";
        return GenericTreeNode.fromLispString(string);
    }

    public static TreeNode fromLispString(String string) {
        return GenericTreeNode.fromLispStringOn(new VapStringReader(string));
    }

    public static TreeNode fromLispStringOn(VapStringReader vapStringReader) {
        if (vapStringReader.atEnd()) {
            return null;
        }
        vapStringReader.skipSpaces();
        if (vapStringReader.peek() == '(') {
            vapStringReader.next();
            GenericTreeNode genericTreeNode = new GenericTreeNode(GenericTreeNode.nextNameFrom(vapStringReader));
            vapStringReader.skipSpaces();
            while (vapStringReader.peek() != ')') {
                genericTreeNode.addChild(GenericTreeNode.fromLispStringOn(GenericTreeNode.nextBalancedChunkFrom(vapStringReader)));
                vapStringReader.skipSpaces();
            }
            vapStringReader.next();
            return genericTreeNode;
        }
        throw new RuntimeException("not well-formed");
    }

    public static VapStringReader nextBalancedChunkFrom(VapStringReader vapStringReader) {
        return new VapStringReader(vapStringReader.nextBalancedChunkFrom('(', ')'));
    }

    private static String nextNameFrom(VapStringReader vapStringReader) {
        StringBuffer stringBuffer = new StringBuffer();
        while (!vapStringReader.atEnd()) {
            char c = vapStringReader.peek();
            if (Character.isSpaceChar(c) || c == ')') {
                return stringBuffer.toString();
            }
            stringBuffer.append(vapStringReader.next());
        }
        return stringBuffer.toString();
    }

    public void printOn(StringBuffer stringBuffer) {
        stringBuffer.append(ClassShortName.name(this));
        stringBuffer.append("(");
        stringBuffer.append(this.context());
        stringBuffer.append(", ");
        int[] nArray = this.levelId();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
    }
}

