/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.ClassName;
import com.ibm.ObjectQuery.crud.util.GenericNameFunction;
import com.ibm.ObjectQuery.crud.util.InclusionFunction;
import com.ibm.ObjectQuery.crud.util.NameFunction;
import com.ibm.ObjectQuery.crud.util.ObjectCollectionWrapper;
import com.ibm.ObjectQuery.crud.util.StDictionary;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ObjectQuery.crud.util.VapHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HashedNamedCollection
implements Collection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private String nameString;
    private VapHashMap collectionValue;
    private NameFunction nameFunctionObj;

    public HashedNamedCollection() {
    }

    public HashedNamedCollection(NameFunction nameFunction) {
        this.nameFunction(nameFunction);
    }

    public HashedNamedCollection(String string) {
        this.name(string);
    }

    public HashedNamedCollection(String string, NameFunction nameFunction) {
        this.name(string);
        this.nameFunction(nameFunction);
    }

    public boolean add(Object object) {
        this.collection().put(this.nameFor(object), object);
        return true;
    }

    public boolean addAll(Object[] objectArray) {
        return this.basicAddAll(new ArrayIterator(objectArray));
    }

    public boolean addAll(Collection collection) {
        return this.basicAddAll(collection.iterator());
    }

    public boolean addIfAbsent(Object object) {
        if (!this.includes(object)) {
            return this.add(object);
        }
        return false;
    }

    public Object any() {
        return this.first();
    }

    public boolean basicAddAll(Iterator iterator) {
        boolean bl = true;
        while (iterator.hasNext()) {
            bl = bl && this.add(iterator.next());
        }
        return bl;
    }

    public void clear() {
        this.collectionValue = null;
    }

    public HashMap collection() {
        if (this.collectionValue == null) {
            this.collectionValue = new VapHashMap();
        }
        return this.collectionValue;
    }

    public boolean contains(Object object) {
        return this.includes(object);
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public NameFunction defaultNameFunction() {
        return new GenericNameFunction();
    }

    public Object first() {
        if (this.collection().size() == 0) {
            throw new RuntimeException("index out of bounds");
        }
        Iterator iterator = this.iterator();
        return iterator.next();
    }

    public Object get(String string) {
        return this.named(string);
    }

    public ObjectCollectionWrapper getWrapper() {
        return new ObjectCollectionWrapper();
    }

    public boolean hasName() {
        return this.nameString != null;
    }

    public boolean hasNameFunction() {
        return this.nameFunctionObj != null;
    }

    public boolean includes(Object object) {
        if (object == null) {
            return false;
        }
        return this.includesName(this.nameFor(object));
    }

    public boolean includesName(Object object) {
        if (object == null) {
            return false;
        }
        return this.includesName(this.nameFor(object));
    }

    public boolean includesName(String string) {
        return this.named(string) != null;
    }

    public boolean includesObject(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != object) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.collection().isEmpty();
    }

    public Iterator iterator() {
        return this.collection().values().iterator();
    }

    public String name() {
        if (this.nameString == null) {
            return "";
        }
        return this.nameString;
    }

    public void name(String string) {
        this.nameString = string;
    }

    public Object named(String string) {
        return this.collection().get(string);
    }

    public String nameFor(Object object) {
        return this.nameFunction().nameof(object);
    }

    public NameFunction nameFunction() {
        if (this.nameFunctionObj == null) {
            this.nameFunctionObj = this.defaultNameFunction();
        }
        return this.nameFunctionObj;
    }

    public void nameFunction(NameFunction nameFunction) {
        this.nameFunctionObj = nameFunction;
    }

    public Iterator nameIterator() {
        return this.collection().keySet().iterator();
    }

    public List names() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.nameFor(iterator.next()));
        }
        return arrayList;
    }

    public List reject(InclusionFunction inclusionFunction) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (inclusionFunction.value(e2)) continue;
            arrayList.add(e2);
        }
        return arrayList;
    }

    public boolean remove(Object object) {
        return this.removeNamed(this.nameFor(object));
    }

    public boolean removeAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            bl = bl && this.remove(iterator.next());
        }
        return bl;
    }

    public boolean removeNamed(Object object) {
        this.collection().remove(this.nameFor(object));
        return true;
    }

    public boolean removeNamed(String string) {
        this.collection().remove(string);
        return true;
    }

    public boolean retainAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (collection.contains(e2)) continue;
            bl = bl && this.remove(e2);
        }
        return bl;
    }

    public int size() {
        return this.collection().size();
    }

    public Object[] toArray() {
        return this.collection().values().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.collection().values().toArray(objectArray);
    }

    public Map toHashMap() {
        Iterator iterator = this.iterator();
        HashMap hashMap = new HashMap();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            hashMap.put(this.nameFor(e2), e2);
        }
        return hashMap;
    }

    public List toList() {
        Iterator iterator = this.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public StDictionary toStDictionary() {
        Iterator iterator = this.iterator();
        StDictionary stDictionary = new StDictionary();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            stDictionary.put((Object)this.nameFor(e2), e2);
        }
        return stDictionary;
    }

    public String toString() {
        Iterator iterator = this.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasName()) {
            stringBuffer.append(this.name());
        } else {
            stringBuffer.append(ClassName.name(this));
        }
        stringBuffer.append("[");
        while (iterator.hasNext()) {
            stringBuffer.append(this.nameFor(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public StSet toStSet() {
        Iterator iterator = this.iterator();
        StSet stSet = new StSet();
        while (iterator.hasNext()) {
            stSet.add(iterator.next());
        }
        return stSet;
    }
}

