/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.LListEnumerator;
import com.ibm.ObjectQuery.crud.util.ReverseArrayEnumerator;
import com.ibm.ObjectQuery.crud.util.ReverseVectorEnumerator;
import com.ibm.ObjectQuery.crud.util.Trace;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class LList
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4049643407754408500L;
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Object firstPart;
    private LList restPart;

    public LList() {
    }

    public LList(Object object) {
        this.replaceFirst(object);
    }

    public LList(Object object, Object object2) {
        this.replaceFirst(object);
        this.replaceRest(new LList(object2));
    }

    public LList(Object object, Object object2, Object object3) {
        this.replaceFirst(object);
        LList lList = new LList(object2);
        this.replaceRest(lList);
        lList.replaceRest(new LList(object3));
    }

    public LList(Object object, Object object2, Object object3, Object object4) {
        this.replaceFirst(object);
        LList lList = new LList(object2);
        this.replaceRest(lList);
        LList lList2 = new LList(object3);
        lList.replaceRest(lList2);
        lList2.replaceRest(new LList(object4));
    }

    public LList allButLast() {
        if (this.isEmpty()) {
            throw new RuntimeException("allButLast is not legal on empty lists");
        }
        return this.rest().allButLast().precede(this.first());
    }

    public LList append(LList lList) {
        if (!this.isList(lList)) {
            throw new RuntimeException("cannot append a non-list to a list");
        }
        if (this.isEmpty()) {
            return lList;
        }
        if (this.hasTail()) {
            return this.rest().append(lList).precede(this.first());
        }
        return lList.precede(this.first());
    }

    public LList copy() {
        if (this.isEmpty()) {
            return this.emptyCopy();
        }
        return this.rest().copy().precede(this.first());
    }

    public Object element(int n) {
        if (this.isEmpty() || n <= 0) {
            new RuntimeException("index out of range");
        }
        if (n == 1) {
            return this.first();
        }
        return this.rest().element(n - 1);
    }

    public Enumeration elements() {
        return new LListEnumerator(this);
    }

    public LList emptyCopy() {
        return new LList();
    }

    public boolean equal(LList lList) {
        if (this == lList) {
            return true;
        }
        if (lList == null) {
            return false;
        }
        if (this.isEmpty() && lList.isEmpty()) {
            return true;
        }
        return this.equalHeads(this.first(), lList.first()) && this.equalTails(this.rest(), lList.rest());
    }

    public boolean equalHeads(Object object, Object object2) {
        if (this.isList(object) && this.isList(object2)) {
            return ((LList)object).equal((LList)object2);
        }
        if (!this.isList(object) && !this.isList(object2)) {
            return object == object2;
        }
        return false;
    }

    public boolean equalTails(LList lList, LList lList2) {
        if (lList == null && lList2 == null) {
            return true;
        }
        return lList.equal(lList2);
    }

    public static LList example() {
        return new LList("1").append(new LList(new LList("a", "b", "c", "d")));
    }

    public static LList example2() {
        Object[] objectArray = new String[]{"a", "b", "c", "d"};
        return LList.from(objectArray);
    }

    public static void example3() {
        Trace.traceOn();
        LList lList = new LList(new LList(new LList("a1", "a2", "a3")), new LList("b1", "b2", "b3"), "c", "d");
        Enumeration enumeration = lList.elements();
        while (enumeration.hasMoreElements()) {
            Trace.show(enumeration.nextElement());
        }
    }

    public static LList example4() {
        return new LList(new LList(new LList("a1", "a2", "a3")), new LList("b1", "b2", "b3"), "c", "d");
    }

    public Object first() {
        return this.firstPart;
    }

    public LList follow(LList lList) {
        if (this.rest() == null) {
            return new LList().precede(lList);
        }
        LList lList2 = this.rest().follow(lList);
        return lList2.precede(this.first());
    }

    public static LList from(Object[] objectArray) {
        ReverseArrayEnumerator reverseArrayEnumerator = new ReverseArrayEnumerator(objectArray);
        LList lList = new LList();
        while (reverseArrayEnumerator.hasMoreElements()) {
            lList = lList.precede(reverseArrayEnumerator.nextElement());
        }
        return lList;
    }

    public static LList from(Vector vector) {
        ReverseVectorEnumerator reverseVectorEnumerator = new ReverseVectorEnumerator(vector);
        LList lList = new LList();
        while (reverseVectorEnumerator.hasMoreElements()) {
            lList = lList.precede(reverseVectorEnumerator.nextElement());
        }
        return lList;
    }

    public boolean hasTail() {
        return this.restPart != null;
    }

    public boolean isEmpty() {
        return this.firstPart == null && this.restPart == null;
    }

    public boolean isFirstList() {
        return this.isList(this.first());
    }

    public boolean isList(Object object) {
        return object instanceof LList;
    }

    public Object last() {
        if (this.isEmpty()) {
            throw new RuntimeException("last is not legal on empty lists");
        }
        if (this.rest() == null) {
            return this.first();
        }
        return this.rest().last();
    }

    public int length() {
        return 1 + this.rest().length();
    }

    public LList precede(Object object) {
        LList lList = new LList();
        lList.replaceFirst(object);
        lList.replaceRest(this);
        return lList;
    }

    public LList prefix(int n) {
        if (n <= 0) {
            return this.emptyCopy();
        }
        return this.rest().prefix(n - 1).precede(this.first());
    }

    public void printEmptyListOn(StringBuffer stringBuffer) {
        stringBuffer.append("()");
    }

    public void printOn(StringBuffer stringBuffer) {
        if (!this.isEmpty()) {
            stringBuffer.append('(');
            if (this.isFirstList()) {
                ((LList)this.first()).printOn(stringBuffer);
            } else {
                stringBuffer.append(this.first().toString());
            }
            if (this.hasTail()) {
                stringBuffer.append(" ");
                this.rest().printTailOn(stringBuffer);
            }
            stringBuffer.append(')');
        } else {
            this.printEmptyListOn(stringBuffer);
        }
    }

    public void printTailOn(StringBuffer stringBuffer) {
        if (this.isFirstList()) {
            ((LList)this.first()).printOn(stringBuffer);
        } else {
            stringBuffer.append(this.first().toString());
        }
        if (!this.isEmpty() && this.hasTail()) {
            stringBuffer.append(" ");
            this.rest().printTailOn(stringBuffer);
        }
    }

    public void replaceFirst(Object object) {
        this.firstPart = object;
    }

    public void replaceRest(LList lList) {
        if (!lList.isEmpty()) {
            this.restPart = lList;
        }
    }

    public LList rest() {
        return this.restPart;
    }

    public int size() {
        return this.length();
    }

    public LList sublistFor(int n, int n2) {
        return this.suffix(this.length() - n + 1).prefix(n2);
    }

    public LList sublistTo(int n, int n2) {
        return this.suffix(this.length() - n + 1).prefix(n2 - n + 1);
    }

    public LList suffix(int n) {
        if (this.isEmpty()) {
            if (n == 0) {
                return this;
            }
            throw new RuntimeException("illegal suffix length");
        }
        LList lList = this;
        int n2 = this.length();
        if (n < 0 || n > this.length()) {
            throw new RuntimeException("illegal suffix length");
        }
        for (int i = 1; i < n2 - n; ++i) {
            lList = lList.rest();
        }
        return lList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printOn(stringBuffer);
        return stringBuffer.toString();
    }
}

