/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ObjectQuery.crud.util.VapStringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SelectTokenizer {
    public static final String SELECT = "select";
    public static final String DISTINCT = "distinct";
    public static final String INTO = "into";
    public static final char OPEN_PAREN = '(';
    public static final char CLOSE_PAREN = ')';
    public static final char COMMA = ',';
    public static final char SPACE = ' ';
    public static final String DELIMITERS = " ,.(";
    public static final char QUOTE = '\"';
    public static final String PAREN_SPACE = "( ";
    private VapStringReader fReader;

    public SelectTokenizer(String string) {
        this.reader(new VapStringReader(string));
    }

    public int selectClauseSize(String string) {
        String string2 = this.readSelect();
        if (string2 == null) {
            return -1;
        }
        return this.selectClauseElements().size();
    }

    public VapStringReader reader() {
        return this.fReader;
    }

    public void reader(VapStringReader vapStringReader) {
        this.fReader = vapStringReader;
    }

    public ListWrapper tokenize() {
        ListWrapper listWrapper = new ListWrapper();
        String string = this.readSelect();
        if (string == null) {
            return null;
        }
        listWrapper.add(string);
        listWrapper.addIfNotNull(this.readDistinct());
        listWrapper.addAll((Collection)this.selectClauseElements());
        listWrapper.add(this.readIntoOrFrom());
        return listWrapper;
    }

    public boolean isSelect() {
        return this.readSelect() != null;
    }

    public boolean isDistinct() {
        String string = this.readSelect();
        if (string == null) {
            return false;
        }
        return this.readDistinct() != null;
    }

    public boolean isSelectInto() {
        return ((String)this.tokenize().last()).equalsIgnoreCase(INTO);
    }

    public String readSelect() {
        this.reader().skipChar(PAREN_SPACE);
        String string = this.reader().next(6);
        if (!string.equalsIgnoreCase(SELECT)) {
            return null;
        }
        return string;
    }

    public String readDistinct() {
        this.reader().skipSpaces();
        String string = this.reader().peek(8);
        if (string.equalsIgnoreCase(DISTINCT)) {
            this.reader().next(8);
            return string;
        }
        return null;
    }

    public String readIntoOrFrom() {
        this.reader().skipSpaces();
        return this.reader().next(4);
    }

    public List selectClauseElements() {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (!this.reader().atEnd()) {
            this.reader().skipSpaces();
            arrayList.add(this.nextSelectClauseElement());
            this.reader().skipSpaces();
            if (this.reader().peek() != ',') {
                return arrayList;
            }
            this.reader().next();
        }
        return arrayList;
    }

    public String nextSelectClauseElement() {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            this.nextDottedNameChunkOn(stringBuffer);
            char c = this.reader().peek();
            if (c == ',' || c == ' ') {
                return stringBuffer.toString();
            }
            stringBuffer.append(this.reader().next());
        }
    }

    public void nextDottedNameChunkOn(StringBuffer stringBuffer) {
        if (this.reader().peek() == '\"') {
            stringBuffer.append(this.reader().nextDoubleQuotedChunk());
        } else {
            stringBuffer.append(this.reader().gatherUntil(DELIMITERS));
            if (this.reader().peek() == '(') {
                stringBuffer.append(this.reader().nextBalancedChunkFrom('(', ')'));
            }
        }
    }
}

