/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.DictionaryEnumerator;
import com.ibm.ObjectQuery.crud.util.DictionaryKeyEnumerator;
import com.ibm.ObjectQuery.crud.util.EqualityRelation;
import com.ibm.ObjectQuery.crud.util.HashFunction;
import com.ibm.ObjectQuery.crud.util.SetEnumerator;
import com.ibm.ObjectQuery.crud.util.StCollection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class StDictionary
extends StCollection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private int elementCount;
    private Association[] elementsArray;

    public StDictionary() {
        this.initialize(StDictionary.minimumSize());
    }

    public StDictionary(int n) {
        this.initialize(n + Math.max(n, StDictionary.minimumSize()));
    }

    public StDictionary(EqualityRelation equalityRelation) {
        super(equalityRelation);
    }

    public StDictionary(HashFunction hashFunction) {
        this.hashFunction(hashFunction);
    }

    public StDictionary(HashFunction hashFunction, EqualityRelation equalityRelation) {
        super(hashFunction, equalityRelation);
    }

    private void aboutToAdd(int n) {
        if (n * 2 > this.elementsArray.length) {
            this.rehash(n * 2);
        }
    }

    public boolean add(Association association) {
        Association association2;
        int n;
        int n2;
        int n3 = this.elementsArray.length;
        Object object = association.key();
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            association2 = this.elementsArray[n2];
            if (association2 == null) {
                this.elementsArray[n2] = association;
                if (this.elementCount++ > n3 / 2) {
                    this.expand();
                }
                return true;
            }
            if (!this.eq(association2.key(), object)) continue;
            association2.value(association.value());
            return true;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            association2 = this.elementsArray[n2];
            if (association2 == null) {
                this.elementsArray[n2] = association;
                if (this.elementCount++ > n3 / 2) {
                    this.expand();
                }
                return true;
            }
            if (!this.eq(association2.key(), object)) continue;
            association2.value(association.value());
            return true;
        }
        this.expand().add(association);
        return true;
    }

    public boolean add(Object object) {
        return this.add((Association)object);
    }

    public Dictionary addAll(Dictionary dictionary) {
        this.aboutToAdd(dictionary.size());
        return dictionary;
    }

    public Object associationAt(Object object) {
        Association association;
        int n;
        int n2;
        int n3 = this.elementsArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            association = this.elementsArray[n2];
            if (association == null) {
                return null;
            }
            if (!this.eq(association.key(), object)) continue;
            return association;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            association = this.elementsArray[n2];
            if (association == null) {
                return null;
            }
            if (!this.eq(association.key(), object)) continue;
            return association;
        }
        return null;
    }

    public Enumeration associationElements() {
        return new SetEnumerator(this);
    }

    private Object atUnique(int n, Object object) {
        return this.atUnique(new Integer(n), object);
    }

    private Object atUnique(Object object, Object object2) {
        int n;
        int n2;
        int n3 = this.elementsArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            if (this.elementsArray[n2] != null) continue;
            this.elementsArray[n2] = new Association(object, object2);
            ++this.elementCount;
            if (this.elementCount > n3 / 2) {
                this.expand();
            }
            return object2;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            if (this.elementsArray[n2] != null) continue;
            this.elementsArray[n2] = new Association(object, object2);
            ++this.elementCount;
            if (this.elementCount > n3 / 2) {
                this.expand();
            }
            return object2;
        }
        return this.expand().atUnique(object, object2);
    }

    public void clear() {
        for (int i = 0; i < this.elementsArray.length; ++i) {
            this.elementsArray[i] = null;
        }
        this.elementCount = 0;
    }

    public Enumeration elements() {
        return new DictionaryEnumerator(this);
    }

    private StDictionary expand() {
        return this.rehash(this.elementsArray.length + this.elementsArray.length);
    }

    public Object get(char c) {
        return this.get(new Character(c));
    }

    public Object get(int n) {
        return this.get(new Integer(n));
    }

    public Object get(Object object) {
        Association association;
        int n;
        int n2;
        int n3 = this.elementsArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            association = this.elementsArray[n2];
            if (association == null) {
                return null;
            }
            if (!this.eq(association.key(), object)) continue;
            return association.value();
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            association = this.elementsArray[n2];
            if (association == null) {
                return null;
            }
            if (!this.eq(association.key(), object)) continue;
            return association.value();
        }
        return null;
    }

    public Object get(boolean bl) {
        return this.get(new Boolean(bl));
    }

    protected Association[] getElementsArray() {
        return this.elementsArray;
    }

    private int hashIndex(Object object) {
        return this.hashIndex(object, this.elementsArray.length);
    }

    private int hashIndex(Object object, int n) {
        return (this.hashFunction().hashValue(object) & Integer.MAX_VALUE) % n;
    }

    public boolean includes(Object object) {
        for (int i = 0; i < this.elementsArray.length; ++i) {
            if (this.elementsArray[i] == null || !this.valueEq(this.elementsArray[i].value(), object)) continue;
            return true;
        }
        return false;
    }

    public boolean includesKey(char c) {
        return this.includesKey(new Character(c));
    }

    public boolean includesKey(int n) {
        return this.includesKey(new Integer(n));
    }

    public boolean includesKey(Object object) {
        Association association;
        int n;
        int n2;
        int n3 = this.elementsArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            association = this.elementsArray[n2];
            if (association == null) {
                return false;
            }
            if (!this.eq(association.key(), object)) continue;
            return true;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            association = this.elementsArray[n2];
            if (association == null) {
                return false;
            }
            if (!this.eq(association.key(), object)) continue;
            return true;
        }
        return false;
    }

    public boolean includesKey(boolean bl) {
        return this.includesKey(new Boolean(bl));
    }

    public void initialize(int n) {
        super.initialize(n);
        this.elementCount = 0;
        this.elementsArray = new Association[n];
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Iterator iterator() {
        return new DictionaryEnumerator(this);
    }

    public Enumeration keyElements() {
        return new DictionaryKeyEnumerator(this);
    }

    public Vector keys() {
        Enumeration enumeration = this.associationElements();
        Vector<Object> vector = new Vector<Object>(this.size());
        while (enumeration.hasMoreElements()) {
            vector.addElement(((Association)enumeration.nextElement()).key());
        }
        return vector;
    }

    public boolean notEmpty() {
        return this.elementCount != 0;
    }

    private void primRemoveAllKeys(Iterator iterator) {
        int n = this.elementsArray.length;
        while (iterator.hasNext()) {
            Object object = ((Association)iterator.next()).key();
            int n2 = this.hashIndex(object);
            boolean bl = false;
            while (!bl) {
                Association association;
                if (n2 >= n) {
                    n2 = 0;
                }
                if ((association = this.elementsArray[n2]) == null) {
                    bl = true;
                    continue;
                }
                if (association.key() == this || !this.eq(association.key(), object)) continue;
                this.rehashTo(n2);
                --this.elementCount;
                bl = true;
            }
        }
    }

    public Object put(char[] cArray, Object object) {
        return this.put((Object)new String(cArray), object);
    }

    public Object put(char c, Object object) {
        return this.put((Object)new Character(c), object);
    }

    public Object put(int n, int n2) {
        return this.put((Object)new Integer(n), (Object)new Integer(n2));
    }

    public Object put(int n, Object object) {
        return this.put((Object)new Integer(n), object);
    }

    public Object put(Object object, char c) {
        return this.put(object, (Object)new Character(c));
    }

    public Object put(Object object, int n) {
        return this.put(object, (Object)new Integer(n));
    }

    public Object put(Object object, Object object2) {
        Association association;
        int n;
        int n2;
        int n3 = this.elementsArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            association = this.elementsArray[n2];
            if (association == null) {
                this.elementsArray[n2] = new Association(object, object2);
                ++this.elementCount;
                if (this.elementCount > n3 / 2) {
                    this.expand();
                }
                return object2;
            }
            if (!this.eq(association.key(), object)) continue;
            association.value(object2);
            return object2;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            association = this.elementsArray[n2];
            if (association == null) {
                this.elementsArray[n2] = new Association(object, object2);
                ++this.elementCount;
                if (this.elementCount > n3 / 2) {
                    this.expand();
                }
                return object2;
            }
            if (!this.eq(association.key(), object)) continue;
            association.value(object2);
            return object2;
        }
        return this.expand().put(object, object2);
    }

    public Object put(Object object, boolean bl) {
        return this.put(object, (Object)new Boolean(bl));
    }

    public Object put(boolean bl, Object object) {
        return this.put((Object)new Boolean(bl), object);
    }

    public Object putIfAbsent(Object object, Object object2) {
        Association association;
        int n;
        int n2;
        int n3 = this.elementsArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            association = this.elementsArray[n2];
            if (association == null) {
                this.elementsArray[n2] = new Association(object, object2);
                ++this.elementCount;
                if (this.elementCount > n3 / 2) {
                    this.expand();
                }
                return object2;
            }
            if (!this.eq(association.key(), object)) continue;
            return object2;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            association = this.elementsArray[n2];
            if (association == null) {
                this.elementsArray[n2] = new Association(object, object2);
                ++this.elementCount;
                if (this.elementCount > n3 / 2) {
                    this.expand();
                }
                return object2;
            }
            if (!this.eq(association.key(), object)) continue;
            return object2;
        }
        return this.expand().put(object, object2);
    }

    public StDictionary rehash() {
        return this.rehash(this.elementsArray.length);
    }

    private StDictionary rehash(int n) {
        Association[] associationArray = new Association[n];
        if (this.elementCount > 0) {
            for (int i = 0; i < this.elementsArray.length; ++i) {
                Association association = this.elementsArray[i];
                if (association == null) continue;
                int n2 = this.hashIndex(association.key(), n);
                if (n2 > n - 1) {
                    n2 = 0;
                }
                while (associationArray[n2] != null) {
                    if (++n2 <= n - 1) continue;
                    n2 = 0;
                }
                associationArray[n2] = association;
            }
        }
        this.elementsArray = associationArray;
        return this;
    }

    private void rehashTo(int n) {
        int n2 = n;
        int n3 = n;
        int n4 = this.elementsArray.length;
        if (++n2 > n4) {
            n2 = 0;
        }
        Association association = this.elementsArray[n2];
        while (association != null) {
            int n5 = this.hashIndex(association.key());
            if (!(n2 >= n3 ? n5 > n3 && n5 <= n2 : n5 > n3 || n5 <= n2)) {
                this.elementsArray[n3] = association;
                n3 = n2;
            }
            if (++n2 > n4) {
                n2 = 0;
            }
            association = this.elementsArray[n2];
        }
        this.elementsArray[n3] = null;
    }

    public boolean remove(Object object) {
        throw new RuntimeException("Objects are removed from Dictionaries based on their keys!");
    }

    public void removeAllKeys(Object[] objectArray) {
        this.primRemoveAllKeys(new ArrayIterator(objectArray));
    }

    public void removeAllKeys(List list) {
        this.primRemoveAllKeys(list.iterator());
    }

    public Object removeKey(char c) {
        return this.removeKey(new Character(c));
    }

    public Object removeKey(int n) {
        return this.removeKey(new Integer(n));
    }

    public Object removeKey(Object object) {
        Association association;
        int n;
        int n2;
        int n3 = this.elementsArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            association = this.elementsArray[n2];
            if (association == null) {
                return null;
            }
            if (!this.eq(association.key(), object)) continue;
            this.rehashTo(n2);
            --this.elementCount;
            return association.value();
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            association = this.elementsArray[n2];
            if (association == null) {
                return null;
            }
            if (!this.eq(association.key(), object)) continue;
            this.rehashTo(n2);
            --this.elementCount;
            return association.value();
        }
        return null;
    }

    public Object removeKey(boolean bl) {
        return this.removeKey(new Boolean(bl));
    }

    public int size() {
        return this.elementCount;
    }

    public void toStringForLargeOn(StringBuffer stringBuffer) {
        int n = this.size() - 1;
        int n2 = 0;
        Enumeration enumeration = this.associationElements();
        stringBuffer.append("{");
        while (enumeration.hasMoreElements()) {
            ((Association)enumeration.nextElement()).assocToStringOn(stringBuffer);
            if (n2++ >= 30) continue;
            stringBuffer.append(this.getNewLine());
        }
        stringBuffer.append("}");
        stringBuffer.append("......etc......");
        stringBuffer.append(this.getNewLine());
        while (enumeration.hasMoreElements()) {
            ((Association)enumeration.nextElement()).assocToStringOn(stringBuffer);
            if (n2++ >= n) continue;
            stringBuffer.append(this.getNewLine());
        }
        stringBuffer.append("}");
    }

    public void toStringForSmallOn(StringBuffer stringBuffer) {
        int n = this.size() - 1;
        int n2 = 0;
        Enumeration enumeration = this.associationElements();
        stringBuffer.append("{");
        while (enumeration.hasMoreElements()) {
            ((Association)enumeration.nextElement()).assocToStringOn(stringBuffer);
            if (n2++ >= n) continue;
            stringBuffer.append(this.getNewLine());
        }
        stringBuffer.append("}");
    }

    public boolean valueEq(Object object, Object object2) {
        return object.equals(object2);
    }

    public Vector values() {
        return this.asVector();
    }
}

