/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.GenericTreeNode;
import com.ibm.ObjectQuery.crud.util.Trace;
import java.util.Iterator;
import java.util.List;

public class Stack {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Object[] elementsIvar;
    private int index;
    private int last;

    public Stack() {
        this.initialize(Stack.minimumSize());
    }

    public Stack(int n) {
        this.initialize(n);
    }

    public void clear() {
        this.initialize(Stack.minimumSize());
    }

    public boolean contains(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(object)) continue;
            return true;
        }
        return false;
    }

    private void copyAndGrowBy(int n) {
        int n2 = this.getElements().length;
        Object[] objectArray = this.getElements();
        this.setElements(new Object[n + n2]);
        System.arraycopy(objectArray, 0, this.getElements(), 0, this.index + 1);
    }

    public static void example() {
        Stack stack = new Stack();
        Trace.traceOn();
        for (int i = 0; i < 5; ++i) {
            stack.push(new GenericTreeNode(new Integer(i).toString()));
            stack.push(null);
            Trace.show(stack);
        }
        while (!stack.isEmpty()) {
            Trace.show(stack.pop());
            Trace.show(stack);
        }
    }

    private Object[] getElements() {
        return this.elementsIvar;
    }

    public void initialize(int n) {
        this.setElements(new Object[n]);
        this.index = -1;
        this.last = n - 1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new ArrayIterator(this.getElements());
    }

    public static int minimumSize() {
        return 16;
    }

    public Object peek() {
        return this.getElements()[this.index];
    }

    public Object pop() {
        Object object = this.getElements()[this.index];
        this.getElements()[this.index] = null;
        --this.index;
        return object;
    }

    public Object push(Object object) {
        if (this.index == this.last) {
            this.copyAndGrowBy(Math.max(this.last / 2, 8));
            this.last = this.getElements().length - 1;
        }
        this.getElements()[++this.index] = object;
        return object;
    }

    public void pushAll(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.push(iterator.next());
        }
    }

    private void setElements(Object[] objectArray) {
        this.elementsIvar = objectArray;
    }

    public int size() {
        return this.index + 1;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.getElements().length];
        System.arraycopy(this.getElements(), 0, objectArray, 0, this.getElements().length);
        return objectArray;
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        stringBuffer.append(ClassShortName.name(this));
        stringBuffer.append("[");
        for (int i = 0; i <= n; ++i) {
            Object e2 = iterator.next();
            String string = e2 == null ? "null" : e2.toString();
            stringBuffer.append(string);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

