/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.PairwiseIterator;
import com.ibm.ObjectQuery.crud.util.StLookupTable;
import com.ibm.ObjectQuery.crud.util.VapStringReader;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class SymbolLookup {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private StLookupTable table;

    public SymbolLookup(Object[] objectArray) {
        this.initialize(new PairwiseIterator(objectArray));
    }

    public SymbolLookup(String string) {
        List list = new VapStringReader(string).asBlankDelimitedSubstrings();
        this.initialize(new PairwiseIterator(list));
    }

    public SymbolLookup(List list) {
        this.initialize(new PairwiseIterator(list));
    }

    public String asString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getTable().associationElements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            stringBuffer.append(" ");
            stringBuffer.append((String)association.key());
            stringBuffer.append(" ");
            stringBuffer.append((String)association.value());
        }
        return stringBuffer.toString();
    }

    public String get(String string) {
        return (String)this.getTable().get(string);
    }

    protected StLookupTable getTable() {
        if (this.table == null) {
            this.table = new StLookupTable();
        }
        return this.table;
    }

    public void initialize(PairwiseIterator pairwiseIterator) {
        while (pairwiseIterator.hasNext()) {
            Association association = (Association)pairwiseIterator.next();
            this.getTable().put(association.first(), association.second());
        }
    }

    public void put(String string, String string2) {
        this.getTable().put((Object)string, (Object)string2);
    }

    public Vector symbols() {
        return this.getTable().keys().asVector();
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassShortName.name(this));
        if (this.getTable().size() - 1 < 100) {
            this.getTable().toStringForSmallOn(stringBuffer);
        } else {
            this.getTable().toStringForLargeOn(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public Vector values() {
        return this.getTable().values();
    }
}

