/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.OutputDevice;
import com.ibm.ObjectQuery.crud.util.Printable;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class TraceBuffer
implements Printable {
    Vector strings;
    OutputDevice out;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999";

    public TraceBuffer() {
    }

    public TraceBuffer(FileOutputStream fileOutputStream) {
        this.setOut(fileOutputStream);
    }

    public TraceBuffer(PrintStream printStream) {
        this.setOut(printStream);
    }

    public TraceBuffer(StringBuffer stringBuffer) {
        this.setOut(stringBuffer);
    }

    public void addString(String string) {
        this.getStrings().addElement(string);
    }

    public void clear() {
        this.strings = null;
    }

    public void close() {
        this.flush();
    }

    public void flush() {
        Enumeration enumeration = this.getStrings().elements();
        OutputDevice outputDevice = this.getOut();
        while (enumeration.hasMoreElements()) {
            outputDevice.print((String)enumeration.nextElement());
            outputDevice.newLine();
        }
        this.clear();
    }

    public OutputDevice getOut() {
        if (this.out == null) {
            this.out = new OutputDevice();
        }
        return this.out;
    }

    public Vector getStrings() {
        if (this.strings == null) {
            this.strings = new Vector(10);
        }
        return this.strings;
    }

    public boolean isUsingSystemOut() {
        return this.getOut().isUsingSystemOut();
    }

    public void newLine() {
        this.addString("");
    }

    public void print(char[] cArray) {
        this.addString(String.valueOf(cArray));
    }

    public void print(char c) {
        this.addString(String.valueOf(c));
    }

    public void print(double d) {
        this.addString(String.valueOf(d));
    }

    public void print(float f) {
        this.addString(String.valueOf(f));
    }

    public void print(int n) {
        this.addString(String.valueOf(n));
    }

    public void print(long l) {
        this.addString(String.valueOf(l));
    }

    public void print(Object object) {
        this.addString(String.valueOf(object));
    }

    public void print(boolean bl) {
        this.addString(new Boolean(bl).toString());
    }

    public void println() {
        this.addString("");
    }

    public void println(char[] cArray) {
        this.print(cArray);
    }

    public void println(char c) {
        this.print(c);
    }

    public void println(double d) {
        this.print(d);
    }

    public void println(float f) {
        this.print(f);
    }

    public void println(int n) {
        this.print(n);
    }

    public void println(long l) {
        this.print(l);
    }

    public void println(Object object) {
        this.print(object);
    }

    public void println(boolean bl) {
        this.print(bl);
    }

    public void setOut(FileOutputStream fileOutputStream) {
        this.out = new OutputDevice(fileOutputStream);
    }

    public void setOut(PrintStream printStream) {
        this.out = new OutputDevice(printStream);
    }

    public void setOut(StringBuffer stringBuffer) {
        this.out = new OutputDevice(stringBuffer);
    }

    public int size() {
        return this.getStrings().size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassShortName.name(this));
        stringBuffer.append("(");
        stringBuffer.append(this.size());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

