/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.engine;

import com.ibm.ObjectQuery.IObjectQueryServiceImpl;
import com.ibm.ObjectQuery.IQueryLogger;
import com.ibm.ObjectQuery.engine.InternalCollection;
import com.ibm.ObjectQuery.engine.InternalHashCollection;
import com.ibm.ObjectQuery.engine.OSQLCatalogCMPAAlias;
import com.ibm.ObjectQuery.engine.OSQLCatalogEntry;
import com.ibm.ObjectQuery.engine.OSQLCatalogRDBAlias;
import com.ibm.ObjectQuery.engine.OSQLCatalogType;
import com.ibm.ObjectQuery.engine.OSQLCatalogView;
import com.ibm.ObjectQuery.engine.OSQLColumnDef;
import com.ibm.ObjectQuery.engine.OSQLLexer;
import com.ibm.ObjectQuery.engine.OSQLSymbolTable;
import com.ibm.ObjectQuery.engine.OSQLTypeMapper;
import com.ibm.ObjectQuery.engine.OqgmCore;
import com.ibm.ObjectQuery.engine.OqgmPtex;
import com.ibm.ObjectQuery.engine.OqgmPtte;
import com.ibm.ObjectQuery.engine.OqgmQnc;
import com.ibm.ObjectQuery.engine.QurContext;
import com.ibm.ObjectQuery.engine.TSDVars;
import com.ibm.ObjectQuery.metadata.OSQLExternalCatalogCMPAAlias;
import com.ibm.ObjectQuery.metadata.OSQLExternalCatalogEntry;
import com.ibm.ObjectQuery.metadata.OSQLExternalCatalogRDBAlias;
import com.ibm.ObjectQuery.metadata.OSQLExternalCatalogType;
import com.ibm.ObjectQuery.metadata.OSQLExternalCatalogView;
import com.ibm.ObjectQuery.metadata.OSQLExternalColumnDef;
import com.ibm.ObjectQuery.metadata.OSQLExternalMethodDef;
import com.ibm.ObjectQuery.metadata.OSQLExternalSysApplOptions;
import com.ibm.websphere.ejbquery.QueryException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class OSQLCatalog
extends InternalHashCollection {
    OSQLSymbolTable symtab;
    private static String theClassName = OSQLCatalog.class.getName();
    private static IQueryLogger queryLogger = null;

    OSQLCatalog() {
        this.symtab = null;
    }

    OSQLCatalog(OSQLSymbolTable oSQLSymbolTable) {
        this.symtab = oSQLSymbolTable;
    }

    private void buildOSQLColumnDef(OSQLCatalogEntry oSQLCatalogEntry, Method method2) throws QueryException {
        Class<?>[] classArray;
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "buildOSQLColumnDef", new Object[]{oSQLCatalogEntry, method2});
        }
        OSQLColumnDef oSQLColumnDef = new OSQLColumnDef(oSQLCatalogEntry);
        oSQLColumnDef.id = method2.getName();
        oSQLColumnDef.setAttributeName(method2.getName());
        oSQLColumnDef.setIsMethod(1);
        String string = null;
        String string2 = null;
        try {
            string = method2.getReturnType().getName();
            if (string.equals("void")) {
                oSQLColumnDef.setBaseType(95);
            } else {
                string2 = (String)OSQLTypeMapper.osqlTypeMappingTable.get(string);
                if (string2 == null) {
                    oSQLColumnDef.setBaseType(132);
                } else {
                    if (string2.equals("_varchar")) {
                        string2 = "_character";
                    }
                    classArray = new TSDVars();
                    classArray.sql_in_text = string2;
                    oSQLColumnDef.setBaseType(new OSQLLexer((TSDVars)classArray).next_token().sym);
                }
            }
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "buildOSQLColumnDef", exception);
                queryLogger.text(4L, theClassName, "buildOSQLColumnDef", "buildOSQLColumnDef>Exception while getting the OSQLLexer token for java type=" + string + " and osqlType=" + string2);
            }
            String string3 = "buildOSQLColumnDef>Exception while getting the OSQLLexer token for java type=" + string + " and osqlType=" + string2;
            throw new QueryException(string3, exception, new Object[]{theClassName, "buildOSQLColumnDef"});
        }
        if (method2.getReturnType().isPrimitive()) {
            oSQLColumnDef.setNotNullIndicator(true);
        } else {
            oSQLColumnDef.setNotNullIndicator(false);
        }
        oSQLColumnDef.setIsReference(false);
        oSQLColumnDef.setMaxSize(0);
        oSQLColumnDef.setScale(-1);
        oSQLColumnDef.setPrecision(0);
        oSQLColumnDef.setPos((int)oSQLCatalogEntry.getAttList().numberOfElements() + 1);
        oSQLColumnDef.setMolecType(500);
        oSQLColumnDef.setIdOfCatalogType(new String());
        oSQLColumnDef.setCvtrName(new String());
        oSQLColumnDef.setClassName(new String());
        oSQLColumnDef.setTypeIndicator(0);
        oSQLCatalogEntry.getAttList().addAsLast(oSQLColumnDef);
        classArray = method2.getParameterTypes();
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            OSQLColumnDef oSQLColumnDef2 = new OSQLColumnDef();
            oSQLColumnDef2.id = new String("arg").concat(String.valueOf(i));
            oSQLColumnDef2.setIsMethod(0);
            String string4 = null;
            try {
                string4 = classArray[i].getName();
                string2 = (String)OSQLTypeMapper.osqlTypeMappingTable.get(string4);
                if (string2.equals("_varchar")) {
                    string2 = "_character";
                }
                if (string2 == null) {
                    oSQLColumnDef2.setBaseType(132);
                } else {
                    TSDVars tSDVars = new TSDVars();
                    tSDVars.sql_in_text = string2;
                    oSQLColumnDef2.setBaseType(new OSQLLexer((TSDVars)tSDVars).next_token().sym);
                }
            }
            catch (Exception exception) {
                if (queryLogger.isLogging()) {
                    queryLogger.exception(512L, theClassName, "buildOSQLColumnDef", exception);
                    queryLogger.text(4L, theClassName, "buildOSQLColumnDef", "buildOSQLColumnDef>Exception while getting the OSQLLexer token for java type=" + string + " and osqlType=" + string2);
                }
                String string5 = "buildOSQLColumnDef>Exception while getting the OSQLLexer token for java type=" + string + " and osqlType=" + string2;
                throw new QueryException(string5, exception, new Object[]{theClassName, "buildOSQLColumnDef"});
            }
            oSQLColumnDef2.setNotNullIndicator(false);
            oSQLColumnDef2.setIsReference(false);
            oSQLColumnDef2.setMaxSize(0);
            oSQLColumnDef2.setScale(-1);
            oSQLColumnDef2.setPrecision(0);
            oSQLColumnDef2.setMolecType(500);
            oSQLColumnDef2.setIdOfCatalogType(new String());
            oSQLColumnDef2.setCvtrName(new String());
            oSQLColumnDef2.setClassName(new String());
            oSQLColumnDef2.setTypeIndicator(0);
            oSQLColumnDef.getArgList().addAsLast(oSQLColumnDef2);
        }
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "buildOSQLColumnDef");
        }
    }

    public void populateCatalog(String string) {
        int n;
        int n2;
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "populateCatalog", new Object[]{string});
        }
        OSQLCatalogView oSQLCatalogView = null;
        OSQLCatalogType oSQLCatalogType = null;
        OSQLCatalogRDBAlias oSQLCatalogRDBAlias = null;
        OSQLCatalogEntry oSQLCatalogEntry = null;
        OSQLExternalCatalogEntry[] oSQLExternalCatalogEntryArray = null;
        TSDVars tSDVars = QurContext.getQurContext().gVars;
        if (tSDVars.ejbDQHelper == null) {
            try {
                tSDVars.ejbDQHelper = IObjectQueryServiceImpl.getConfiguration().getQueryHelper(tSDVars.firstASNName, null);
            }
            catch (QueryException queryException) {
                queryLogger.text(512L, theClassName, "populateCatalog", " Could not obtain Dynamic Query Helper Object");
                queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
                tSDVars.sql_rc = -1;
                if (queryException.getMessage() != null) {
                    tSDVars.errorMsgs.append(queryException.getMessage()).append("\n");
                }
                return;
            }
        }
        try {
            oSQLExternalCatalogEntryArray = (OSQLExternalCatalogEntry[])IObjectQueryServiceImpl.getConfiguration().getMetadata(string, null, tSDVars.ejbDQHelper);
        }
        catch (QueryException queryException) {
            queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
            return;
        }
        if (oSQLExternalCatalogEntryArray == null) {
            return;
        }
        tSDVars = QurContext.getQurContext().gVars;
        if (tSDVars.j2eeVersionNum == 0) {
            n2 = -1;
            for (n = 0; n < oSQLExternalCatalogEntryArray.length; ++n) {
                if (!(oSQLExternalCatalogEntryArray[n] instanceof OSQLExternalSysApplOptions)) continue;
                n2 = n;
                break;
            }
            if (n2 == -1) {
                tSDVars.isOuter = true;
                tSDVars.j2eeVersionNum = 13;
            } else {
                tSDVars.isOuter = ((OSQLExternalSysApplOptions)oSQLExternalCatalogEntryArray[n2]).getIsOuter();
                tSDVars.j2eeVersionNum = ((OSQLExternalSysApplOptions)oSQLExternalCatalogEntryArray[n2]).getJ2eeVersionNum();
            }
        }
        n2 = -1;
        n = -1;
        for (int i = 0; i < oSQLExternalCatalogEntryArray.length; ++i) {
            if (!(oSQLExternalCatalogEntryArray[i] instanceof OSQLExternalCatalogView)) continue;
            n2 = i;
            break;
        }
        if (n2 == -1 && queryLogger.isLogging()) {
            queryLogger.text(4L, theClassName, "populateCatalog", "Error: Metadata for " + string + " does not have a View entry");
        }
        String string2 = ((OSQLExternalCatalogView)oSQLExternalCatalogEntryArray[n2]).getIdForCatalogType();
        for (int i = 0; i < oSQLExternalCatalogEntryArray.length; ++i) {
            if (!string2.equals(oSQLExternalCatalogEntryArray[i].getFullyQualifiedId())) continue;
            oSQLCatalogType = new OSQLCatalogType(oSQLExternalCatalogEntryArray[i].getAsnName(), oSQLExternalCatalogEntryArray[i].getId(), (OSQLExternalCatalogType)oSQLExternalCatalogEntryArray[i]);
            break;
        }
        if (oSQLCatalogType == null && queryLogger.isLogging()) {
            queryLogger.text(4L, theClassName, "populateCatalog", "Error: Metadata for " + string + " does not have a View Type entry " + string2);
        }
        if (!tSDVars.osqlCatTable.containsElementWithKey((oSQLCatalogView = new OSQLCatalogView(oSQLExternalCatalogEntryArray[n2].getAsnName(), (OSQLExternalCatalogView)oSQLExternalCatalogEntryArray[n2], oSQLCatalogType)).getFullyQualifiedId())) {
            tSDVars.osqlCatTable.add(oSQLCatalogView);
        }
        oSQLCatalogView.populateSuperHomes();
        oSQLCatalogView.populateSubHomes();
        if (!tSDVars.osqlCatTable.containsElementWithKey(oSQLCatalogType.getFullyQualifiedId())) {
            tSDVars.osqlCatTable.add(oSQLCatalogType);
        }
        n = -1;
        String string3 = null;
        for (int i = 0; i < oSQLExternalCatalogEntryArray.length; ++i) {
            if (!(oSQLExternalCatalogEntryArray[i] instanceof OSQLExternalCatalogRDBAlias)) continue;
            n = i;
            string3 = oSQLExternalCatalogEntryArray[i].getFullyQualifiedId();
            String string4 = ((OSQLExternalCatalogRDBAlias)oSQLExternalCatalogEntryArray[n]).getIdOfCatalogType();
            for (int j = 0; j < oSQLExternalCatalogEntryArray.length; ++j) {
                if (!string4.equals(oSQLExternalCatalogEntryArray[j].getFullyQualifiedId())) continue;
                oSQLCatalogEntry = new OSQLCatalogType(oSQLExternalCatalogEntryArray[j].getAsnName(), oSQLExternalCatalogEntryArray[j].getId(), (OSQLExternalCatalogType)oSQLExternalCatalogEntryArray[j]);
                break;
            }
            if (oSQLCatalogEntry == null && queryLogger.isLogging()) {
                queryLogger.text(4L, theClassName, "populateCatalog", "Error: Metadata for " + string + " does not have an Alias Type entry " + string4);
            }
            if (!tSDVars.osqlCatTable.containsElementWithKey(oSQLCatalogEntry.getFullyQualifiedId())) {
                tSDVars.osqlCatTable.add(oSQLCatalogEntry);
            }
            if (tSDVars.osqlCatTable.containsElementWithKey((oSQLCatalogRDBAlias = new OSQLCatalogRDBAlias(oSQLExternalCatalogEntryArray[n].getAsnName(), oSQLExternalCatalogEntryArray[n].getId(), (OSQLExternalCatalogRDBAlias)oSQLExternalCatalogEntryArray[n])).getFullyQualifiedId())) continue;
            tSDVars.osqlCatTable.add(oSQLCatalogRDBAlias);
        }
        if (n == -1 && queryLogger.isLogging()) {
            queryLogger.text(4L, theClassName, "populateCatalog", "Error: Metadata for " + string + " does not have an Alias entry " + string3);
        }
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "populateCatalog");
        }
    }

    public void populateCatalog(String string, String string2) {
        int n;
        int n2;
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "populateCatalog", new Object[]{string});
        }
        OSQLCatalogView oSQLCatalogView = null;
        OSQLCatalogType oSQLCatalogType = null;
        OSQLCatalogRDBAlias oSQLCatalogRDBAlias = null;
        OSQLCatalogEntry oSQLCatalogEntry = null;
        OSQLExternalCatalogEntry[] oSQLExternalCatalogEntryArray = null;
        TSDVars tSDVars = QurContext.getQurContext().gVars;
        if (tSDVars.ejbDQHelper == null) {
            try {
                tSDVars.ejbDQHelper = IObjectQueryServiceImpl.getConfiguration().getQueryHelper(tSDVars.firstASNName, null);
            }
            catch (QueryException queryException) {
                queryLogger.text(512L, theClassName, "populateCatalog", " Could not obtain Dynamic Query Helper Object");
                queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
                return;
            }
        }
        try {
            oSQLExternalCatalogEntryArray = (OSQLExternalCatalogEntry[])IObjectQueryServiceImpl.getConfiguration().getMetadata(string, null, tSDVars.ejbDQHelper);
        }
        catch (QueryException queryException) {
            queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
            return;
        }
        if (oSQLExternalCatalogEntryArray == null) {
            return;
        }
        tSDVars = QurContext.getQurContext().gVars;
        if (tSDVars.j2eeVersionNum == 0) {
            n2 = -1;
            for (n = 0; n < oSQLExternalCatalogEntryArray.length; ++n) {
                if (!(oSQLExternalCatalogEntryArray[n] instanceof OSQLExternalSysApplOptions)) continue;
                n2 = n;
                break;
            }
            if (n2 == -1) {
                tSDVars.isOuter = true;
                tSDVars.j2eeVersionNum = 13;
            } else {
                tSDVars.isOuter = ((OSQLExternalSysApplOptions)oSQLExternalCatalogEntryArray[n2]).getIsOuter();
                tSDVars.j2eeVersionNum = ((OSQLExternalSysApplOptions)oSQLExternalCatalogEntryArray[n2]).getJ2eeVersionNum();
            }
        }
        n2 = -1;
        n = -1;
        for (int i = 0; i < oSQLExternalCatalogEntryArray.length; ++i) {
            if (!(oSQLExternalCatalogEntryArray[i] instanceof OSQLExternalCatalogView)) continue;
            n2 = i;
            break;
        }
        if (n2 == -1 && queryLogger.isLogging()) {
            queryLogger.text(4L, theClassName, "populateCatalog", "Error: Metadata for " + string + " does not have a View entry");
        }
        String string3 = ((OSQLExternalCatalogView)oSQLExternalCatalogEntryArray[n2]).getIdForCatalogType();
        for (int i = 0; i < oSQLExternalCatalogEntryArray.length; ++i) {
            if (!string3.equals(oSQLExternalCatalogEntryArray[i].getFullyQualifiedId())) continue;
            oSQLCatalogType = new OSQLCatalogType(oSQLExternalCatalogEntryArray[i].getAsnName(), oSQLExternalCatalogEntryArray[i].getId(), (OSQLExternalCatalogType)oSQLExternalCatalogEntryArray[i]);
            break;
        }
        if (oSQLCatalogType == null && queryLogger.isLogging()) {
            queryLogger.text(4L, theClassName, "populateCatalog", "Error: Metadata for " + string + " does not have a View Type entry " + string3);
        }
        oSQLCatalogView = new OSQLCatalogView(oSQLExternalCatalogEntryArray[n2].getAsnName(), (OSQLExternalCatalogView)oSQLExternalCatalogEntryArray[n2], oSQLCatalogType);
        oSQLCatalogView.setId(string2);
        if (!tSDVars.osqlCatTable.containsElementWithKey(string2)) {
            tSDVars.osqlCatTable.add(oSQLCatalogView);
        }
        oSQLCatalogView.populateSuperHomes();
        oSQLCatalogView.populateSubHomes();
        if (!tSDVars.osqlCatTable.containsElementWithKey(oSQLCatalogType.getFullyQualifiedId())) {
            tSDVars.osqlCatTable.add(oSQLCatalogType);
        }
        n = -1;
        String string4 = null;
        for (int i = 0; i < oSQLExternalCatalogEntryArray.length; ++i) {
            if (!(oSQLExternalCatalogEntryArray[i] instanceof OSQLExternalCatalogRDBAlias)) continue;
            n = i;
            string4 = oSQLExternalCatalogEntryArray[i].getFullyQualifiedId();
            String string5 = ((OSQLExternalCatalogRDBAlias)oSQLExternalCatalogEntryArray[n]).getIdOfCatalogType();
            for (int j = 0; j < oSQLExternalCatalogEntryArray.length; ++j) {
                if (!string5.equals(oSQLExternalCatalogEntryArray[j].getFullyQualifiedId())) continue;
                oSQLCatalogEntry = new OSQLCatalogType(oSQLExternalCatalogEntryArray[j].getAsnName(), oSQLExternalCatalogEntryArray[j].getId(), (OSQLExternalCatalogType)oSQLExternalCatalogEntryArray[j]);
                break;
            }
            if (oSQLCatalogEntry == null && queryLogger.isLogging()) {
                queryLogger.text(4L, theClassName, "populateCatalog", "Error: Metadata for " + string + " does not have an Alias Type entry " + string5);
            }
            if (!tSDVars.osqlCatTable.containsElementWithKey(oSQLCatalogEntry.getFullyQualifiedId())) {
                tSDVars.osqlCatTable.add(oSQLCatalogEntry);
            }
            if (tSDVars.osqlCatTable.containsElementWithKey((oSQLCatalogRDBAlias = new OSQLCatalogRDBAlias(oSQLExternalCatalogEntryArray[n].getAsnName(), oSQLExternalCatalogEntryArray[n].getId(), (OSQLExternalCatalogRDBAlias)oSQLExternalCatalogEntryArray[n])).getFullyQualifiedId())) continue;
            tSDVars.osqlCatTable.add(oSQLCatalogRDBAlias);
        }
        if (n == -1 && queryLogger.isLogging()) {
            queryLogger.text(4L, theClassName, "populateCatalog", "Error: Metadata for " + string + " does not have an Alias entry " + string4);
        }
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "populateCatalog");
        }
    }

    public void populateMethodMD(OSQLCatalogEntry oSQLCatalogEntry, OqgmQnc oqgmQnc, String string) {
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "populateMethodMD", new Object[]{oSQLCatalogEntry, oqgmQnc, string});
        }
        TSDVars tSDVars = QurContext.getQurContext().gVars;
        try {
            String string2 = new String(oqgmQnc.id);
            Object var7_7 = null;
            Method method2 = null;
            Method[] methodArray = null;
            final String string3 = string;
            final String string4 = oSQLCatalogEntry.getAsnName();
            try {
                methodArray = (Method[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException, QueryException {
                        if (IObjectQueryServiceImpl.getConfiguration().getConfigType() == 3) {
                            TSDVars tSDVars = QurContext.getQurContext().gVars;
                            ClassLoader classLoader = (ClassLoader)IObjectQueryServiceImpl.getConfiguration().getClassLoader(string4, null, tSDVars.ejbDQHelper);
                            return classLoader.loadClass(string3).getMethods();
                        }
                        return Thread.currentThread().getContextClassLoader().loadClass(string3).getMethods();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (queryLogger.isLogging()) {
                    queryLogger.exception(512L, theClassName, "populateMethodMD", privilegedActionException);
                    queryLogger.text(4L, theClassName, "populateMethodMD", " ClassNotFoundException wrapped in PrivilegedActionException encountered while doing getMethods() - unknown class: " + string);
                }
                String string5 = " ClassNotFoundException wrapped in PrivilegedActionException encountered while doing getMethods()";
                throw new QueryException(string5, privilegedActionException, new Object[]{theClassName, "populateMethodMD"});
            }
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(string2) || methodArray[i].getParameterTypes().length != oqgmQnc.method_args.numberOfElements()) continue;
                if (method2 == null) {
                    method2 = methodArray[i];
                } else {
                    tSDVars.sql_rc = -1;
                    OqgmCore.sql_yerror(theClassName, "populateMethodMD", "OVMWSNOP", new Object[]{method2.getName(), string4});
                }
                this.buildOSQLColumnDef(oSQLCatalogEntry, method2);
            }
        }
        catch (QueryException queryException) {
            queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
        }
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "populateMethodMD");
        }
    }

    private void buildOSQLColumnDef4UnmapAttr(OSQLCatalogEntry oSQLCatalogEntry, Field field) throws QueryException {
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "buildOSQLColumnDef", new Object[]{oSQLCatalogEntry, field});
        }
        OSQLColumnDef oSQLColumnDef = new OSQLColumnDef(oSQLCatalogEntry);
        oSQLColumnDef.id = field.getName();
        oSQLColumnDef.setAttributeName(field.getName());
        String string = null;
        String string2 = null;
        try {
            string = field.getType().getName();
            if (string.equals("void")) {
                oSQLColumnDef.setBaseType(95);
            } else {
                string2 = (String)OSQLTypeMapper.osqlTypeMappingTable.get(string);
                if (string2 == null) {
                    oSQLColumnDef.setBaseType(132);
                } else {
                    if (string2.equals("_varchar")) {
                        string2 = "_character";
                    }
                    TSDVars tSDVars = new TSDVars();
                    tSDVars.sql_in_text = string2;
                    oSQLColumnDef.setBaseType(new OSQLLexer((TSDVars)tSDVars).next_token().sym);
                }
            }
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "buildOSQLColumnDef", exception);
                queryLogger.text(4L, theClassName, "buildOSQLColumnDef", "buildOSQLColumnDef>Exception while getting the OSQLLexer token for java type=" + string + " and osqlType=" + string2);
            }
            String string3 = "buildOSQLColumnDef>Exception while getting the OSQLLexer token for java type=" + string + " and osqlType=" + string2;
            throw new QueryException(string3, exception, new Object[]{theClassName, "buildOSQLColumnDef"});
        }
        oSQLColumnDef.setNotNullIndicator(false);
        oSQLColumnDef.setIsReference(false);
        oSQLColumnDef.setIsMethod(0);
        oSQLColumnDef.setMaxSize(0);
        oSQLColumnDef.setScale(-1);
        oSQLColumnDef.setPrecision(0);
        oSQLColumnDef.setPos((int)oSQLCatalogEntry.getAttList().numberOfElements() + 1);
        oSQLColumnDef.setMolecType(500);
        oSQLColumnDef.setIdOfCatalogType(new String());
        oSQLColumnDef.setCvtrName(new String());
        oSQLColumnDef.setClassName(new String());
        oSQLColumnDef.setTypeIndicator(2468);
        oSQLCatalogEntry.getAttList().addAsLast(oSQLColumnDef);
    }

    public void populatePublicAttributes(OSQLCatalogEntry oSQLCatalogEntry, OqgmQnc oqgmQnc, String string) {
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "populatePublicAttriutes", new Object[]{oSQLCatalogEntry, oqgmQnc, string});
        }
        try {
            String string2 = new String(oqgmQnc.id);
            Object var6_6 = null;
            Field field = null;
            Field[] fieldArray = null;
            final String string3 = string;
            try {
                fieldArray = (Field[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return Thread.currentThread().getContextClassLoader().loadClass(string3).getFields();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (queryLogger.isLogging()) {
                    queryLogger.exception(512L, theClassName, "populatePublicAttriutes", privilegedActionException);
                    queryLogger.text(4L, theClassName, "populatePublicAttriutes", " ClassNotFoundException wrapped in PrivilegedActionException encountered while doing getFields() - unknown class: " + string);
                }
                String string4 = " ClassNotFoundException wrapped in PrivilegedActionException encountered while doing getFileds()";
                throw new QueryException(string4, privilegedActionException, new Object[]{theClassName, "populatePublicAttriutes"});
            }
            for (int i = 0; i < fieldArray.length; ++i) {
                if (!fieldArray[i].getName().equals(string2)) continue;
                field = fieldArray[i];
                this.buildOSQLColumnDef4UnmapAttr(oSQLCatalogEntry, field);
            }
        }
        catch (QueryException queryException) {
            queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
        }
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "populatePublicAttriutes");
        }
    }

    static boolean exprChck(StringBuffer stringBuffer, OqgmPtex oqgmPtex, OSQLExternalColumnDef oSQLExternalColumnDef) {
        boolean bl = true;
        if (oqgmPtex.termx != null) {
            OqgmPtte oqgmPtte = oqgmPtex.termx;
            block0 : switch (oqgmPtte.termType) {
                case 530: {
                    switch (oqgmPtte.ptatom.atomType) {
                        case 710: {
                            OSQLColumnDef oSQLColumnDef = oqgmPtte.ptatom.parmp.fetcolrecpp;
                            if (oSQLColumnDef == null) {
                                OqgmCore.sql_yerror(theClassName, "exprChck", "ND", new Object[]{oqgmPtte.ptatom.parmp.id});
                                bl = false;
                                break;
                            }
                            oqgmPtex.isMultivalued = oSQLColumnDef.is_multivalued() ? 1 : 0;
                            oqgmPtex.exprType = oSQLColumnDef.getBaseType();
                            oqgmPtex.referenceTo = oSQLColumnDef.getReferenceTo();
                            if (oSQLColumnDef.getBaseType() != 25 || oSQLColumnDef.getBaseTypeSize() != 0) break block0;
                            oqgmPtex.char_pointer = 1;
                            break;
                        }
                        case 520: {
                            switch (oqgmPtte.ptatom.cconst.constType) {
                                case 25: 
                                case 142: 
                                case 156: {
                                    if (oSQLExternalColumnDef.getBaseType() == 25 || oSQLExternalColumnDef.getBaseType() == 156 || oSQLExternalColumnDef.getBaseType() == 142) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    if (oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                        break;
                                    }
                                    stringBuffer.append("'").append(oqgmPtte.ptatom.cconst.st).append("'");
                                    break;
                                }
                                case 18: 
                                case 71: 
                                case 129: {
                                    oqgmPtex.exprType = 71;
                                    if (oSQLExternalColumnDef.getBaseType() == 71 || oSQLExternalColumnDef.getBaseType() == 129 || oSQLExternalColumnDef.getBaseType() == 18 || oSQLExternalColumnDef.getBaseType() == 59 || oSQLExternalColumnDef.getBaseType() == 19 || oSQLExternalColumnDef.getBaseType() == 41 || oSQLExternalColumnDef.getBaseType() == 51 || oSQLExternalColumnDef.getBaseType() == 114) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    if (oqgmPtte.ptatom.cconst.st != null && oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                        break;
                                    }
                                    stringBuffer.append(oqgmPtte.ptatom.cconst.i);
                                    break;
                                }
                                case 15: {
                                    if (oqgmPtte.ptatom.cconst.st == null || !oqgmPtte.ptatom.cconst.st.equals("?")) break block0;
                                    OqgmCore.sql_yerror(theClassName, "exprChck", "NS", new Object[]{new String("java.math.BigInteger")});
                                    bl = false;
                                    break;
                                }
                                case 14: {
                                    oqgmPtex.exprType = 14;
                                    if (oqgmPtte.ptatom.cconst.st != null && oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                    }
                                    if (oSQLExternalColumnDef.getBaseType() == 14) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    if (oqgmPtte.ptatom.cconst.st != null && oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                        break;
                                    }
                                    stringBuffer.append(oqgmPtte.ptatom.cconst.b);
                                    break;
                                }
                                case 20: {
                                    oqgmPtex.exprType = 20;
                                    if (oqgmPtte.ptatom.cconst.st != null && oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                    }
                                    bl = oSQLExternalColumnDef.getBaseType() == 20;
                                    stringBuffer.append(oqgmPtte.ptatom.cconst.bol);
                                    break;
                                }
                                case 152: {
                                    if (oSQLExternalColumnDef.getBaseType() == 152) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    if (oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                        break;
                                    }
                                    stringBuffer.append("'").append(oqgmPtte.ptatom.cconst.st).append("'");
                                    break;
                                }
                                case 19: 
                                case 41: {
                                    if (oqgmPtte.ptatom.cconst.st != null && oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                    }
                                    if (oSQLExternalColumnDef.getBaseType() == 19 || oSQLExternalColumnDef.getBaseType() == 41 || oSQLExternalColumnDef.getBaseType() == 114 || oSQLExternalColumnDef.getBaseType() == 59) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    if (oqgmPtte.ptatom.cconst.st != null && oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                        break;
                                    }
                                    stringBuffer.append(oqgmPtte.ptatom.cconst.f);
                                    break;
                                }
                                case 114: {
                                    if (oSQLExternalColumnDef.getBaseType() == 114 || oSQLExternalColumnDef.getBaseType() == 41 || oSQLExternalColumnDef.getBaseType() == 59) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    if (oqgmPtte.ptatom.cconst.st != null && oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                        break;
                                    }
                                    stringBuffer.append(oqgmPtte.ptatom.cconst.f);
                                    break;
                                }
                                case 51: {
                                    if (oSQLExternalColumnDef.getBaseType() == 51) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    if (oqgmPtte.ptatom.cconst.st != null && oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                        break;
                                    }
                                    stringBuffer.append(oqgmPtte.ptatom.cconst.f);
                                    break;
                                }
                                case 111: {
                                    if (oqgmPtte.ptatom.cconst.st == null || !oqgmPtte.ptatom.cconst.st.equals("?")) break block0;
                                    oqgmPtex.exprType = oqgmPtte.ptatom.cconst.constType;
                                    stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                    break;
                                }
                                case 37: {
                                    if (oSQLExternalColumnDef.getBaseType() == 37) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    if (oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                        break;
                                    }
                                    stringBuffer.append("'").append(oqgmPtte.ptatom.cconst.st).append("'");
                                    break;
                                }
                                case 149: {
                                    if (oSQLExternalColumnDef.getBaseType() == 149) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    if (oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                        break;
                                    }
                                    stringBuffer.append("'").append(oqgmPtte.ptatom.cconst.st).append("'");
                                    break;
                                }
                                case 151: {
                                    if (oSQLExternalColumnDef.getBaseType() == 151) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    if (oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                        break;
                                    }
                                    stringBuffer.append("'").append(oqgmPtte.ptatom.cconst.st).append("'");
                                    break;
                                }
                                default: {
                                    bl = false;
                                    if (oqgmPtte.ptatom.cconst.st.equals("?")) {
                                        stringBuffer.append(oqgmPtte.ptatom.cconst.st).append(oqgmPtte.ptatom.cconst.i);
                                        break;
                                    }
                                    stringBuffer.append("'").append(oqgmPtte.ptatom.cconst.st).append("'");
                                    break;
                                }
                            }
                            break block0;
                        }
                        default: {
                            bl = false;
                            break;
                        }
                    }
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public void populateCMPACatalog(String string) throws QueryException {
        int n;
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "populateCMPACatalog", new Object[]{string});
        }
        OSQLCatalogView oSQLCatalogView = null;
        OSQLCatalogEntry oSQLCatalogEntry = null;
        OSQLCatalogEntry oSQLCatalogEntry2 = null;
        OSQLExternalCatalogEntry[] oSQLExternalCatalogEntryArray = null;
        OSQLCatalogCMPAAlias oSQLCatalogCMPAAlias = null;
        OSQLExternalCatalogCMPAAlias oSQLExternalCatalogCMPAAlias = null;
        boolean bl = false;
        Object var10_9 = null;
        TSDVars tSDVars = QurContext.getQurContext().gVars;
        if (tSDVars.ejbDQHelper == null) {
            try {
                tSDVars.ejbDQHelper = IObjectQueryServiceImpl.getConfiguration().getQueryHelper(tSDVars.firstASNName, null);
            }
            catch (QueryException queryException) {
                queryLogger.text(512L, theClassName, "populateCMPACatalog", " Could not obtain Dynamic Query Helper Object");
                queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
                tSDVars.sql_rc = -1;
                if (queryException.getMessage() != null) {
                    tSDVars.errorMsgs.append(queryException.getMessage()).append("\n");
                }
                return;
            }
        }
        try {
            oSQLExternalCatalogEntryArray = (OSQLExternalCatalogEntry[])IObjectQueryServiceImpl.getConfiguration().getMetadata(string, null, tSDVars.ejbDQHelper);
        }
        catch (QueryException queryException) {
            queryLogger.text(512L, theClassName, "populateCMPACatalog", " Could not obtain cmpa meta data");
            queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
            return;
        }
        if (oSQLExternalCatalogEntryArray == null) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < oSQLExternalCatalogEntryArray.length; ++n) {
            if (!(oSQLExternalCatalogEntryArray[n] instanceof OSQLExternalCatalogCMPAAlias) || !oSQLExternalCatalogEntryArray[n].getAsnName().equals(string)) continue;
            n2 = n;
            oSQLExternalCatalogCMPAAlias = (OSQLExternalCatalogCMPAAlias)oSQLExternalCatalogEntryArray[n];
            break;
        }
        if (oSQLExternalCatalogCMPAAlias == null) {
            if (queryLogger.isLogging()) {
                String string2 = queryLogger.message(4L, theClassName, "populateCMPACatalog", "CMPAMSG40", new Object[]{string});
                throw new QueryException(string2);
            }
            OqgmCore.sql_yerror(theClassName, "populateCMPACatalog", "CMPAMSG40", new Object[]{string});
            tSDVars.sql_rc = -1;
            throw new QueryException();
        }
        tSDVars = QurContext.getQurContext().gVars;
        if (n2 == -1) {
            if (queryLogger.isLogging()) {
                String string3 = queryLogger.message(4L, theClassName, "populateCMPACatalog", "CMPAMSG1", new Object[]{string});
                throw new QueryException(string3);
            }
            OqgmCore.sql_yerror(theClassName, "populateCMPACatalog", "CMPAMSG1", new Object[]{string});
            tSDVars.sql_rc = -1;
            throw new QueryException();
        }
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < oSQLExternalCatalogEntryArray.length; ++i) {
            if (!(oSQLExternalCatalogEntryArray[i] instanceof OSQLExternalCatalogView)) continue;
            n3 = i;
            break;
        }
        if (n3 == -1 && queryLogger.isLogging()) {
            queryLogger.text(4L, theClassName, "populateCMPACatalog", "Error: Metadata for " + string + " does not have a View entry");
        }
        String string4 = ((OSQLExternalCatalogView)oSQLExternalCatalogEntryArray[n3]).getIdForCatalogType();
        for (int i = 0; i < oSQLExternalCatalogEntryArray.length; ++i) {
            if (!string4.equals(oSQLExternalCatalogEntryArray[i].getFullyQualifiedId())) continue;
            oSQLExternalCatalogCMPAAlias.setFields(((OSQLExternalCatalogType)oSQLExternalCatalogEntryArray[i]).getAttributes());
            oSQLCatalogEntry = new OSQLCatalogType(oSQLExternalCatalogEntryArray[i].getAsnName(), oSQLExternalCatalogEntryArray[i].getId(), (OSQLExternalCatalogType)oSQLExternalCatalogEntryArray[i], 501);
            break;
        }
        if (oSQLCatalogEntry == null && queryLogger.isLogging()) {
            queryLogger.text(4L, theClassName, "populateCMPACatalog", "Error: Metadata for " + string + " does not have a View Type entry " + string4);
        }
        if (!tSDVars.osqlCatTable.containsElementWithKey((oSQLCatalogView = new OSQLCatalogView(oSQLExternalCatalogEntryArray[n3].getAsnName(), (OSQLExternalCatalogView)oSQLExternalCatalogEntryArray[n3], oSQLCatalogEntry)).getFullyQualifiedId())) {
            tSDVars.osqlCatTable.add(oSQLCatalogView);
        }
        oSQLCatalogView.populateSuperHomes();
        oSQLCatalogView.populateSubHomes();
        if (!tSDVars.osqlCatTable.containsElementWithKey(oSQLCatalogEntry.getFullyQualifiedId())) {
            tSDVars.osqlCatTable.add(oSQLCatalogEntry);
        }
        n4 = -1;
        String string5 = null;
        for (int i = 0; i < oSQLExternalCatalogEntryArray.length; ++i) {
            if (!(oSQLExternalCatalogEntryArray[i] instanceof OSQLExternalCatalogCMPAAlias)) continue;
            n4 = i;
            string5 = oSQLExternalCatalogEntryArray[i].getFullyQualifiedId();
            String string6 = ((OSQLExternalCatalogCMPAAlias)oSQLExternalCatalogEntryArray[n4]).getIdOfCatalogType();
            for (n = 0; n < oSQLExternalCatalogEntryArray.length; ++n) {
                if (!string6.equals(oSQLExternalCatalogEntryArray[n].getFullyQualifiedId())) continue;
                oSQLCatalogEntry2 = new OSQLCatalogType(oSQLExternalCatalogEntryArray[n].getAsnName(), oSQLExternalCatalogEntryArray[n].getId(), (OSQLExternalCatalogType)oSQLExternalCatalogEntryArray[n], 501);
                break;
            }
            if (oSQLCatalogEntry2 == null && queryLogger.isLogging()) {
                queryLogger.text(4L, theClassName, "populateCMPACatalog", "Error: Metadata for " + string + " does not have an Alias Type entry " + string6);
            }
            if (!tSDVars.osqlCatTable.containsElementWithKey(oSQLCatalogEntry2.getFullyQualifiedId())) {
                tSDVars.osqlCatTable.add(oSQLCatalogEntry2);
            }
            if (tSDVars.osqlCatTable.containsElementWithKey((oSQLCatalogCMPAAlias = new OSQLCatalogCMPAAlias(oSQLExternalCatalogEntryArray[n4].getAsnName(), oSQLExternalCatalogEntryArray[n4].getId(), (OSQLExternalCatalogCMPAAlias)oSQLExternalCatalogEntryArray[n4])).getFullyQualifiedId())) continue;
            tSDVars.osqlCatTable.add(oSQLCatalogCMPAAlias);
        }
        if (n4 == -1 && queryLogger.isLogging()) {
            queryLogger.text(4L, theClassName, "populateCMPACatalog", "Error: Metadata for " + string + " does not have an Alias entry " + string5);
        }
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "populateCMPACatalog");
        }
    }

    public static boolean validateMethodArguments(InternalCollection internalCollection, OSQLExternalMethodDef oSQLExternalMethodDef, TSDVars tSDVars) throws QueryException {
        OSQLExternalColumnDef[] oSQLExternalColumnDefArray;
        boolean bl = true;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "validateMethodArguments", new Object[]{oSQLExternalMethodDef.getMethodName()});
        }
        if ((oSQLExternalColumnDefArray = oSQLExternalMethodDef.getArgList()).length > 0) {
            internalCollection.setToFirst();
            while (internalCollection.isValid()) {
                OqgmPtex oqgmPtex = (OqgmPtex)internalCollection.elementAtCursor();
                if (oqgmPtex.termx == null) {
                    bl = false;
                    break;
                }
                OqgmPtte oqgmPtte = oqgmPtex.termx;
                if (oqgmPtte.termType != 530 && oqgmPtte.termType != 111) {
                    if (queryLogger.isLogging()) {
                        String string = queryLogger.message(4L, theClassName, "validateMethodArguments", "CMPAMSG10", new Object[]{oqgmPtte.ptcol.id});
                        throw new QueryException(string);
                    }
                    OqgmCore.sql_yerror(theClassName, "validateMethodArguments", "CMPAMSG10", new Object[]{oqgmPtte.ptcol.id});
                    tSDVars.sql_rc = -1;
                    throw new QueryException();
                }
                boolean bl2 = true;
                bl2 = OSQLCatalog.exprChck(stringBuffer, oqgmPtex, oSQLExternalColumnDefArray[n]);
                if (!bl2) {
                    if (queryLogger.isLogging()) {
                        String string = queryLogger.message(4L, theClassName, "validateMethodArguments", "CMPAMSG15", new Object[]{oqgmPtte.ptcol.id});
                        throw new QueryException(string);
                    }
                    OqgmCore.sql_yerror(theClassName, "validateMethodArguments", "CMPAMSG15", new Object[]{stringBuffer});
                    tSDVars.sql_rc = -1;
                    throw new QueryException();
                }
                ++n;
                internalCollection.setToNext();
            }
        }
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "validateMethodArguments");
        }
        return bl;
    }

    static {
        try {
            queryLogger = IObjectQueryServiceImpl.getConfiguration().getLogger();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

