/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.engine;

import com.ibm.ObjectQuery.IObjectQueryServiceImpl;
import com.ibm.ObjectQuery.IQueryLogger;
import com.ibm.ObjectQuery.engine.DatabaseSpec;
import com.ibm.ObjectQuery.engine.InternalCollection;
import com.ibm.ObjectQuery.engine.OSQLCatalog;
import com.ibm.ObjectQuery.engine.OSQLParser;
import com.ibm.ObjectQuery.engine.OSQLSymbolTable;
import com.ibm.ObjectQuery.engine.Opt;
import com.ibm.ObjectQuery.engine.OptTable;
import com.ibm.ObjectQuery.engine.OqgmCore;
import com.ibm.ObjectQuery.engine.OqgmFull;
import com.ibm.ObjectQuery.engine.OqgmHxp;
import com.ibm.ObjectQuery.engine.OqgmOpr;
import com.ibm.ObjectQuery.engine.OqgmQun;
import com.ibm.ObjectQuery.engine.OqgmQur;
import com.ibm.ObjectQuery.engine.QueryRewrite;
import com.ibm.ObjectQuery.engine.QurContext;
import com.ibm.ObjectQuery.engine.QurTemplateCache;
import com.ibm.ObjectQuery.engine.TSDVars;
import com.ibm.ObjectQuery.engine.TypeCheck;
import com.ibm.websphere.ejbquery.QueryException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class OSQLMain {
    private static String theClassName = OSQLMain.class.getName();
    private static IQueryLogger queryLogger = null;
    static final String[] dfmtstr_ = new String[]{"yyyy-MM-dd", "MM/dd/yyyy", "dd.MM.yyyy"};
    static final String[] tfmtstrsp_ = new String[]{"hh:mm a", "hh a"};
    static final String[] tfmtstrnsp_ = new String[]{"HH.mm.ss", "HH.mm", "HH:mm:ss", "HH:mm"};
    static final String[] tsfmtstrsp_ = new String[]{"yyyy-MM-dd HH:mm:ss.SSSSSS", "yyyy-MM-dd HH:mm:ss"};
    static final String[] tsfmtstrnsp_ = new String[]{"yyyy-MM-dd-HH.mm.ss.SSSSSS", "yyyy-MM-dd-HH.mm.ss"};

    static int deinit_query_global_vars(QurContext qurContext) {
        int n = 0;
        TSDVars tSDVars = qurContext.gVars;
        tSDVars.oprStkTop = 0;
        tSDVars.osqlqur = null;
        tSDVars.oprStk = null;
        tSDVars.osqlLineNo = 0;
        tSDVars.oprp = null;
        tSDVars.ccout = null;
        tSDVars.osSetCnt = 0;
        tSDVars.qes_tuple_set_cnt = 0;
        tSDVars.mark = 0;
        return n;
    }

    static int init_query_global_vars(QurContext qurContext) {
        int n = 0;
        TSDVars tSDVars = qurContext.gVars;
        tSDVars.osqlTokenpos = 0;
        tSDVars.osqlLineNo = 1;
        tSDVars.qes_tuple_set_cnt = 1;
        if (tSDVars.osqlqur == null) {
            tSDVars.osqlqur = new OqgmQur();
        }
        if (tSDVars.osqlCatTable == null) {
            tSDVars.osqlCatTable = new OSQLCatalog();
        }
        if (tSDVars.symTable == null) {
            tSDVars.symTable = new OSQLSymbolTable();
        }
        if (tSDVars.oprStk == null) {
            tSDVars.oprStk = new Object[100];
        }
        return n;
    }

    static boolean optimize_the_query(OqgmQur oqgmQur, QurContext qurContext) {
        TSDVars tSDVars = QurContext.getQurContext().gVars;
        boolean bl = false;
        bl = Opt.optimizeOsql(oqgmQur, qurContext);
        if (tSDVars.sql_rc == -1) {
            bl = true;
        }
        return bl;
    }

    static boolean parse_the_query(QurContext qurContext) throws Exception {
        boolean bl = false;
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "parse_the_query", null);
        }
        if (qurContext == null) {
            if (queryLogger.isLogging()) {
                queryLogger.text(4L, theClassName, "parse_the_query", "Error: context == null");
            }
            return true;
        }
        if (QurTemplateCache.getInstance() != null && QurTemplateCache.getInstance().isServiceEnabled() || qurContext.gVars.returnwdo) {
            qurContext.setUserQuery(true);
        }
        TSDVars tSDVars = qurContext.gVars;
        OSQLParser oSQLParser = new OSQLParser(tSDVars);
        String string = OSQLParser.class.getName();
        String string2 = "parse";
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, string, string2, null);
        }
        oSQLParser.parse();
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, string, string2);
        }
        OqgmQur oqgmQur = (OqgmQur)tSDVars.osqlqur;
        boolean bl2 = tSDVars.was_view_type_def;
        Object object = tSDVars.oprp;
        qurContext.setUserQuery(false);
        if (tSDVars.sql_rc == -1) {
            bl = true;
        }
        if (!(oqgmQur.quropr.isEmpty() || bl2 || bl)) {
            oqgmQur.set_top_opr((OqgmOpr)object);
            bl = TypeCheck.typeChck(oqgmQur);
            if (!(bl || (bl = OqgmCore.prep_result_headings((OqgmOpr)object)) || (bl = OqgmFull.manage_views(oqgmQur, qurContext.gVars)))) {
                bl = TypeCheck.typeChck(oqgmQur);
            }
        }
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "parse_the_query");
        }
        return bl;
    }

    static boolean rewrite_the_query(OqgmQur oqgmQur, QurContext qurContext) throws QueryException {
        TSDVars tSDVars = QurContext.getQurContext().gVars;
        boolean bl = false;
        QueryRewrite.rewrite(oqgmQur, qurContext);
        if (tSDVars.sql_rc == -1) {
            bl = true;
        }
        return bl;
    }

    static String sqlParser(String string, boolean bl, QurContext qurContext) throws QueryException {
        String string2;
        TSDVars tSDVars = qurContext.gVars;
        boolean bl2 = false;
        tSDVars.sql_in_text = string2 = new String(string);
        tSDVars.osqlTokenpos = 0;
        tSDVars.osqlLineNo = 1;
        tSDVars.qes_tuple_set_cnt = 1;
        if (tSDVars.osqlqur == null) {
            tSDVars.osqlqur = new OqgmQur();
        }
        OqgmQur oqgmQur = (OqgmQur)tSDVars.osqlqur;
        if (tSDVars.osqlCatTable == null) {
            tSDVars.osqlCatTable = new OSQLCatalog();
        }
        if (tSDVars.symTable == null) {
            tSDVars.symTable = new OSQLSymbolTable();
        }
        if (tSDVars.oprStk == null) {
            tSDVars.oprStk = new Object[100];
        }
        tSDVars.oprStkTop = 0;
        tSDVars.was_view_type_def = false;
        tSDVars.this_tab = null;
        tSDVars.oprp = null;
        tSDVars.oprStk[0] = null;
        try {
            bl2 = OSQLMain.parse_the_query(qurContext);
            if (!(bl2 || oqgmQur.quropr.isEmpty() || tSDVars.was_view_type_def)) {
                bl2 = OSQLMain.rewrite_the_query(oqgmQur, qurContext);
                oqgmQur.getBeanNamesInQry(tSDVars.ejbBeanUsedInQry);
                if (!bl2) {
                    oqgmQur.lazy_evaluation = bl;
                    if (IObjectQueryServiceImpl.getConfiguration().getConfigType() == 3) {
                        if (tSDVars.ejbDQHelper == null) {
                            tSDVars.ejbDQHelper = IObjectQueryServiceImpl.getConfiguration().getQueryHelper(tSDVars.firstASNName, null);
                        }
                        tSDVars.lockType = IObjectQueryServiceImpl.getConfiguration().getLockType(tSDVars.firstASNName, null, tSDVars.ejbDQHelper);
                        tSDVars.accessIntent = tSDVars.lockType == 1 ? 0 : 1;
                    }
                    if (tSDVars.accessIntent != 0) {
                        tSDVars.accessIntent = OSQLMain.notForPessimisticLocking(oqgmQur, tSDVars) ? 0 : tSDVars.accessIntent;
                    }
                    bl2 = OSQLMain.optimize_the_query(oqgmQur, qurContext);
                }
            }
            if (bl2) {
                tSDVars.sql_in_text = null;
            }
            tSDVars.oprStkTop = 0;
            if (bl2) {
                if (tSDVars.errorMsgs.toString().equals("")) {
                    throw new QueryException();
                }
                throw new QueryException(tSDVars.errorMsgs.toString(), tSDVars.embexp_, new Object[]{theClassName, "sqlParser"});
            }
            return tSDVars.ccout;
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "sqlParser", exception);
            }
            if (tSDVars.errorMsgs.toString().equals("")) {
                throw new QueryException(exception.toString(), exception, new Object[]{theClassName, "sqlParser"});
            }
            throw new QueryException(tSDVars.errorMsgs.toString(), exception, new Object[]{theClassName, "sqlParser"});
        }
    }

    public static Object char2Date(StringBuffer stringBuffer) throws QueryException {
        if (stringBuffer == null) {
            return null;
        }
        String string = OSQLMain.removeblanks(stringBuffer);
        int n = string.length();
        Object object = null;
        if (n >= 16) {
            int n2;
            object = OSQLMain.str2DTTS(tsfmtstrsp_, string, 0);
            if (object == null && (n2 = string.indexOf(" ")) == -1) {
                object = OSQLMain.str2DTTS(tsfmtstrnsp_, string, 0);
            }
        } else if (n >= 8) {
            int n3 = string.indexOf(" ");
            if (n3 == -1) {
                object = OSQLMain.str2DTTS(dfmtstr_, string, 0);
            }
        } else if (n == 7) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyDDD");
            ParsePosition parsePosition = new ParsePosition(0);
            object = ((DateFormat)simpleDateFormat).parse(string, parsePosition);
        }
        if (object == null) {
            String string2 = queryLogger.message(4L, theClassName, "char2Date", "RTINVDF", new Object[]{stringBuffer.toString()});
            throw new QueryException(string2);
        }
        return new Date(((java.util.Date)object).getTime());
    }

    public static Object char2Time(StringBuffer stringBuffer) throws QueryException {
        int n;
        if (stringBuffer == null) {
            return null;
        }
        String string = OSQLMain.removeblanks(stringBuffer);
        int n2 = string.length();
        Object object = null;
        if (n2 >= 16 || n2 == 14) {
            if (n2 >= 16) {
                object = OSQLMain.str2DTTS(tsfmtstrsp_, string, 0);
                if (object == null && (n = string.indexOf(" ")) == -1) {
                    object = OSQLMain.str2DTTS(tsfmtstrnsp_, string, 0);
                }
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                ParsePosition parsePosition = new ParsePosition(0);
                object = ((DateFormat)simpleDateFormat).parse(string, parsePosition);
            }
            if (object != null) {
                object = OSQLMain.newTimeFromTimestamp(object);
            }
        } else if (n2 >= 4) {
            object = OSQLMain.str2DTTS(tfmtstrsp_, string, 0);
            if (object == null && (n = string.indexOf(" ")) == -1) {
                object = OSQLMain.str2DTTS(tfmtstrnsp_, string, 0);
            }
            if (object != null) {
                object = new Time(((java.util.Date)object).getTime());
            }
        }
        if (object == null) {
            String string2 = queryLogger.message(4L, theClassName, "char2Time", "RTINVDF", new Object[]{stringBuffer.toString()});
            throw new QueryException(string2);
        }
        return object;
    }

    public static Object char2Timestamp(StringBuffer stringBuffer) throws QueryException {
        if (stringBuffer == null) {
            return null;
        }
        String string = OSQLMain.removeblanks(stringBuffer);
        int n = string.length();
        Object object = null;
        if (n >= 16) {
            int n2;
            object = OSQLMain.str2DTTS(tsfmtstrsp_, string, 0);
            if (object == null && (n2 = string.indexOf(" ")) == -1) {
                object = OSQLMain.str2DTTS(tsfmtstrnsp_, string, 0);
            }
        } else if (n == 14) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            ParsePosition parsePosition = new ParsePosition(0);
            object = ((DateFormat)simpleDateFormat).parse(string, parsePosition);
        }
        if (object == null) {
            String string2 = queryLogger.message(4L, theClassName, "char2Timestamp", "RTINVDF", new Object[]{stringBuffer.toString()});
            throw new QueryException(string2);
        }
        return new Timestamp(((java.util.Date)object).getTime());
    }

    public static Date createDateFromString(StringBuffer stringBuffer) throws QueryException {
        return (Date)OSQLMain.char2Date(stringBuffer);
    }

    public static Time createTimeFromString(StringBuffer stringBuffer) throws QueryException {
        return (Time)OSQLMain.char2Time(stringBuffer);
    }

    public static Timestamp createTimestampFromString(StringBuffer stringBuffer) throws QueryException {
        return (Timestamp)OSQLMain.char2Timestamp(stringBuffer);
    }

    static Object newTimeFromTimestamp(Object object) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime((java.util.Date)object);
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(14, 0);
        return new Time(calendar.getTime().getTime());
    }

    public static Object str2DTTS(String[] stringArray, String string, int n) {
        if (n >= stringArray.length) {
            return null;
        }
        Object object = null;
        String string2 = stringArray[n];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        simpleDateFormat.setLenient(false);
        ParsePosition parsePosition = new ParsePosition(0);
        object = ((DateFormat)simpleDateFormat).parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            object = OSQLMain.str2DTTS(stringArray, string, n + 1);
        }
        return object;
    }

    private static boolean notForPessimisticLocking(OqgmQur oqgmQur, TSDVars tSDVars) {
        boolean bl = false;
        DatabaseSpec databaseSpec = OSQLMain.gimmeDBObj(oqgmQur);
        OqgmQun oqgmQun = (OqgmQun)oqgmQur.qurqun.firstElement();
        if (oqgmQur.top_oprp.sub_oprs.numberOfElements() != 0 && !databaseSpec.isDBUpdateSubQueries(oqgmQun)) {
            return true;
        }
        if (oqgmQur.top_oprp.opt_group_by_clause != null && !databaseSpec.isDBUpdateGroupBy(oqgmQun)) {
            return true;
        }
        if (oqgmQur.top_oprp.has_aggs && !databaseSpec.isDBUpdateAggFunc(oqgmQun)) {
            return true;
        }
        if (!oqgmQur.top_oprp.order_by.isEmpty() && !databaseSpec.isDBUpdateOrderBy(oqgmQun)) {
            return true;
        }
        if (!tSDVars.returnwdo && (oqgmQur.top_oprp.distinct == 48 || oqgmQur.top_oprp.distinct == 12345 && !databaseSpec.isDBUpdateDistinct(oqgmQun))) {
            return true;
        }
        if (!(oqgmQur.top_oprp.oprqun.numberOfElements() <= 1 || oqgmQun.qtbqunpp != null && oqgmQun.qtbqunpp.fettabpp != null && databaseSpec.isDBUpdateJoin(oqgmQun))) {
            return true;
        }
        if (tSDVars.starns == 1) {
            return false;
        }
        if (tSDVars.starns == 2) {
            return true;
        }
        InternalCollection internalCollection = oqgmQur.top_oprp.oprhxp;
        boolean bl2 = false;
        internalCollection.setToFirst();
        while (internalCollection.isValid()) {
            OqgmHxp oqgmHxp = (OqgmHxp)internalCollection.elementAtCursor();
            if (oqgmHxp.exprp.ptp.termx == null) {
                return true;
            }
            if (oqgmHxp.exprp.ptp.termx.ptfunc != null && oqgmHxp.exprp.ptp.termx.ptfunc.funcName != 640) {
                return true;
            }
            if (oqgmHxp.exprp.ptp.termx.ptfunc != null && oqgmHxp.exprp.ptp.termx.ptfunc.funcName == 640) {
                if (bl2) {
                    return true;
                }
                bl2 = true;
            }
            if (oqgmHxp.exprp.ptp.termx.ptcol != null && oqgmHxp.hxpqnc != null && oqgmHxp.hxpqnc.oby != 1) {
                return true;
            }
            internalCollection.setToNext();
        }
        return bl;
    }

    private static DatabaseSpec gimmeDBObj(OqgmQur oqgmQur) {
        QurContext qurContext = QurContext.getQurContext();
        TSDVars tSDVars = qurContext.gVars;
        if (tSDVars.dbobj != null) {
            return tSDVars.dbobj;
        }
        InternalCollection internalCollection = oqgmQur.qurqun;
        short s = OptTable.get_dbtype(internalCollection);
        tSDVars.dbobj = OptTable.createdbobj(s);
        return tSDVars.dbobj;
    }

    private static String removeblanks(StringBuffer stringBuffer) {
        int n;
        String string = stringBuffer.toString();
        if (string == null) {
            return string;
        }
        int n2 = 0;
        char[] cArray = string.toCharArray();
        for (n = string.length(); n2 < n && cArray[n - 1] <= ' '; --n) {
        }
        return n < string.length() ? string.substring(n2, n) : string;
    }

    static {
        try {
            queryLogger = IObjectQueryServiceImpl.getConfiguration().getLogger();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

