/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.engine;

import com.ibm.ObjectQuery.EjbQuery;
import com.ibm.ObjectQuery.IObjectQueryServiceImpl;
import com.ibm.ObjectQuery.IQueryLogger;
import com.ibm.ObjectQuery.WDOQuery;
import com.ibm.ObjectQuery.engine.InternalCollection;
import com.ibm.ObjectQuery.engine.InverseConvObject;
import com.ibm.ObjectQuery.engine.OSQLColumnDef;
import com.ibm.ObjectQuery.engine.OSQLMain;
import com.ibm.ObjectQuery.engine.OSQLParser;
import com.ibm.ObjectQuery.engine.OqgmLopr;
import com.ibm.ObjectQuery.engine.OqgmOpr;
import com.ibm.ObjectQuery.engine.OqgmQur;
import com.ibm.ObjectQuery.engine.QurContext;
import com.ibm.ObjectQuery.engine.QurTemplate;
import com.ibm.ObjectQuery.engine.QurTemplateCache;
import com.ibm.ObjectQuery.engine.TSDVars;
import com.ibm.ObjectQuery.engine.TypeCheck;
import com.ibm.ObjectQuery.engine.WDOChangeEventHandler;
import com.ibm.ObjectQuery.engine.WDOChgHashMap;
import com.ibm.websphere.ejbquery.QueryException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class QueryProcessor {
    private static final String DEFAULT_QUERY_HEADER = "SELECT REF x from thisCollection x where ";
    private static String theClassName = QueryProcessor.class.getName();
    private static IQueryLogger queryLogger = null;
    private boolean isCompletePushdown = true;
    private boolean explainOn = false;
    private String queryPlanText = null;
    private Vector pushdownSQLs = new Vector();
    private QurTemplateCache plancache_ = QurTemplateCache.getInstance();
    private QurTemplate cache_entry_ = null;
    public static HashMap parmMap;

    void addSQLStatement(String string) {
        string.trim();
        this.pushdownSQLs.addElement(string);
    }

    public boolean getExplainOn() {
        return this.explainOn;
    }

    public String[] getExtWarningMsgs() {
        Vector vector = QurContext.getQurContext().gVars.extWarningMsgs;
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Vector getParmMarkerList() {
        return QurContext.getQurContext().gVars.parmMarkerList;
    }

    public String getPlan() {
        return this.queryPlanText;
    }

    public String getSelectedCMP() {
        if (QurContext.getQurContext().gVars.selectedCMP == null) {
            return null;
        }
        return new String(QurContext.getQurContext().gVars.selectedCMP);
    }

    public String[] getSQLStatements() throws QueryException {
        return this.getSQLStatements(true);
    }

    public String[] getSQLStatements(boolean bl) throws QueryException {
        int n = this.pushdownSQLs.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string;
            stringArray[i] = string = (String)this.pushdownSQLs.elementAt(i);
        }
        return stringArray;
    }

    public void initContext(Properties properties, Properties properties2) throws Exception {
        QurContext qurContext = null;
        qurContext = new QurContext(properties, properties2);
        qurContext.setQueryProcessor(this);
        QurContext.setQurContext(qurContext);
        qurContext.setPlanGenSuccess(false);
        OSQLMain.init_query_global_vars(qurContext);
    }

    public boolean isCompletePushdown() {
        return this.isCompletePushdown;
    }

    public boolean isSortedResult() {
        return QurContext.getQurContext().gVars.used4Distinct;
    }

    public void processQuery(EjbQuery ejbQuery) throws QueryException {
        String string;
        ArrayList<String> arrayList;
        Object object;
        String string2 = ejbQuery.getEjbQryStmt();
        Properties properties = null;
        Properties properties2 = null;
        if (queryLogger.isLogging()) {
            object = ejbQuery.getParmTypes();
            arrayList = null;
            string = null;
            if (object != null) {
                arrayList = new ArrayList<String>(((String[])object).length);
                for (int i = 0; i < ((String[])object).length; ++i) {
                    string = object[i] != null ? object[i] : " NULL ";
                    arrayList.add(string);
                }
            }
            string = arrayList == null ? " parameter types: NULL " : ((Object)arrayList).toString();
            Object[] objectArray = new Object[]{string2, properties2, properties, string};
            queryLogger.entry(128L, theClassName, "processQuery", objectArray);
        }
        try {
            try {
                this.initContext(properties, properties2);
            }
            catch (Exception exception) {
                queryLogger.stackTrace(exception, 4L, theClassName, "processQuery");
                throw new QueryException(exception.getMessage());
            }
            object = null;
            arrayList = null;
            string = null;
            object = QurContext.getQurContext();
            boolean bl = true;
            ((QurContext)object).changeQurContext(string2, bl);
            QurTemplate qurTemplate = null;
            QurTemplate qurTemplate2 = this.findCached(string2, (QurContext)object);
            if (qurTemplate2 != null) {
                qurTemplate = this.getSamelocktype(qurTemplate2);
            }
            if (qurTemplate != null) {
                qurTemplate2.settimestamp(this.plancache_.gettime());
                this.queryPlanText = qurTemplate.getPlantext();
                ((QurContext)object).gVars.lockType = qurTemplate.getlocktype();
                int n = ((QurContext)object).gVars.accessIntent = ((QurContext)object).gVars.lockType == 1 ? 0 : 1;
                if (qurTemplate.getwdomap() != null) {
                    ((WDOQuery)ejbQuery).setChgHandlers(this.dup_wdochghandlermap(qurTemplate.getwdomap()));
                }
                if (queryLogger.isLogging()) {
                    queryLogger.text(1024L, theClassName, "processQuery", "QUERY_CACHE_TRACE Query_plan_text_Found in cache:" + this.queryPlanText + " cache KEY: " + string2 + " QUERY_CACHE_TRACE cache THRESHOLD: " + this.plancache_.getthreshold() + " cache CAPACITY: " + this.plancache_.getcapacity() + " cache ENTRIES: " + this.plancache_.size());
                }
            } else {
                ((QurContext)object).gVars.parmTypeList = this.convtypes(ejbQuery.getParmTypes());
                ((QurContext)object).gVars.single4sqlj = ejbQuery.getReturnInSet() == null;
                ((QurContext)object).gVars.used4Distinct = ejbQuery.getReturnInSet() != null && ejbQuery.getReturnInSet() != false;
                ((QurContext)object).gVars.accessIntent = ejbQuery.getAccessIntent();
                ((QurContext)object).gVars.returnwdo = ejbQuery.getReturnwdo();
                this.queryPlanText = OSQLMain.sqlParser(string2, bl, (QurContext)object);
                if (((QurContext)object).gVars.returnwdo) {
                    OqgmQur oqgmQur = (OqgmQur)((QurContext)object).gVars.osqlqur;
                    WDOChgHashMap wDOChgHashMap = new WDOChgHashMap();
                    ((WDOQuery)ejbQuery).setChgHandlers(wDOChgHashMap);
                    wDOChgHashMap.setAsnToSDONameMap(((WDOQuery)ejbQuery).getNameMap());
                    QueryProcessor.prepare_wdoupdate(oqgmQur.top_oprp, (QurContext)object, wDOChgHashMap);
                }
                if (queryLogger.isLogging()) {
                    queryLogger.text(1024L, theClassName, "processQuery", "QUERY_CACHE_TRACE Query plan text NotFound in cache, OSQL parser called to generate the plan:\n\n" + this.queryPlanText);
                }
                if (qurTemplate2 != null) {
                    qurTemplate2.settimestamp(this.plancache_.gettime());
                    qurTemplate2.setNext(string2, this.queryPlanText, ((QurContext)object).gVars.lockType, ((QurContext)object).gVars.firstASNName, this.dup_wdochghandlermap(ejbQuery, ((QurContext)object).gVars));
                    if (queryLogger.isLogging()) {
                        queryLogger.text(1024L, theClassName, "processQuery", "QUERY_CACHE_TRACE Query plan text with the same lock type NOT FOUND in cache");
                    }
                } else {
                    if (QurContext.getQurContext().gVars.lockType != 1 && this.getForUpdateFlag()) {
                        this.cachePlanText(string2, this.queryPlanText, 1, ((QurContext)object).gVars.firstASNName, (QurContext)object, this.dup_wdochghandlermap(ejbQuery, ((QurContext)object).gVars));
                    } else {
                        this.cachePlanText(string2, this.queryPlanText, ((QurContext)object).gVars.lockType, ((QurContext)object).gVars.firstASNName, (QurContext)object, this.dup_wdochghandlermap(ejbQuery, ((QurContext)object).gVars));
                    }
                    if (queryLogger.isLogging()) {
                        if (this.plancache_ != null && this.plancache_.isServiceEnabled()) {
                            queryLogger.text(1024L, theClassName, "processQuery", "QUERY_CACHE_TRACE cache_ENABLED_plan_text_ADDED_to_cache; cache threshold: " + this.plancache_.getthreshold() + " cache CAPACITY: " + this.plancache_.getcapacity() + " cache ENTRIES: " + this.plancache_.size() + " cache KEY: " + string2);
                        } else {
                            queryLogger.text(1024L, theClassName, "processQuery", "QUERY_CACHE_TRACE cache NOT ENABLED");
                        }
                    }
                }
            }
        }
        catch (QueryException queryException) {
            if (queryException.getException() != null) {
                queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
            }
            throw queryException;
        }
        if (IObjectQueryServiceImpl.getConfiguration().getConfigType() == 3 && QurContext.getQurContext().gVars.lockType != 1 && this.getForUpdateFlag()) {
            object = queryLogger.message(4L, theClassName, "processQuery", "UTOPLSTQ", null);
            throw new QueryException((String)object);
        }
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "processQuery");
        }
    }

    void setCompletePushdown(boolean bl) {
        this.isCompletePushdown = bl;
    }

    public void setExplainOn(boolean bl) {
        this.explainOn = bl;
    }

    public void setSQLStatements(String[] stringArray) {
        this.pushdownSQLs.removeAllElements();
        for (int i = 0; i < stringArray.length; ++i) {
            this.pushdownSQLs.addElement(stringArray[i]);
        }
    }

    public boolean validateQuery(String string, Properties properties, String[] stringArray) throws QueryException {
        boolean bl;
        block18: {
            Object[] objectArray;
            bl = false;
            if (queryLogger.isLogging()) {
                objectArray = new Object[]{string, properties, stringArray};
                queryLogger.entry(128L, theClassName, "validQuery", objectArray);
            }
            try {
                try {
                    this.initContext(null, properties);
                }
                catch (Exception exception) {
                    queryLogger.stackTrace(exception, 4L, theClassName, "validQuery");
                    throw new QueryException(exception.getMessage());
                }
                objectArray = null;
                Object var7_8 = null;
                Object var8_9 = null;
                objectArray = QurContext.getQurContext();
                boolean bl2 = true;
                objectArray.changeQurContext(string, bl2);
                QurTemplate qurTemplate = null;
                if (qurTemplate != null) {
                    this.queryPlanText = qurTemplate.getPlantext();
                    if (queryLogger.isLogging()) {
                        queryLogger.text(1024L, theClassName, "validQuery", "Query plan text found in cache:\n\n" + this.queryPlanText + "\n\ncache threshold: " + this.plancache_.getthreshold() + "        number of entries in the cache: " + this.plancache_.size());
                    }
                    bl = true;
                    break block18;
                }
                OSQLMain.init_query_global_vars((QurContext)objectArray);
                TSDVars tSDVars = objectArray.gVars;
                tSDVars.sql_in_text = string;
                tSDVars.oprStkTop = 0;
                tSDVars.was_view_type_def = false;
                tSDVars.this_tab = null;
                tSDVars.oprp = null;
                tSDVars.oprStk[0] = null;
                tSDVars.parmTypeList = stringArray;
                if (this.plancache_ != null && this.plancache_.isServiceEnabled()) {
                    objectArray.setUserQuery(true);
                }
                OSQLParser oSQLParser = new OSQLParser(tSDVars);
                try {
                    String string2 = OSQLParser.class.getName();
                    String string3 = "parse";
                    if (queryLogger.isLogging()) {
                        queryLogger.text(1024L, theClassName, "validQuery", "Query plan text not found in cache, OSQL parser called to generate the plan:\n\n" + this.queryPlanText);
                    }
                    oSQLParser.parse();
                    if (queryLogger.isLogging()) {
                        queryLogger.exit(256L, string2, string3);
                    }
                    OqgmQur oqgmQur = (OqgmQur)tSDVars.osqlqur;
                    boolean bl3 = tSDVars.was_view_type_def;
                    Object object = tSDVars.oprp;
                    objectArray.setUserQuery(false);
                    if (!oqgmQur.quropr.isEmpty() && !bl3) {
                        oqgmQur.set_top_opr((OqgmOpr)object);
                        boolean bl4 = TypeCheck.typeChck(oqgmQur);
                        if (!bl4) {
                            bl = true;
                        } else {
                            tSDVars.sql_in_text = null;
                            bl = false;
                        }
                    }
                    tSDVars.oprStkTop = 0;
                    if (!bl) {
                        throw new QueryException();
                    }
                }
                catch (Exception exception) {
                    queryLogger.stackTrace(exception, 4L, theClassName, "validQuery");
                    throw new QueryException(tSDVars.errorMsgs.append(exception.getMessage()).toString());
                }
            }
            catch (QueryException queryException) {
                if (queryException.getException() != null) {
                    queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
                }
                throw queryException;
            }
        }
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "validQuery");
        }
        return bl;
    }

    public String getASN4selected() {
        if (QurContext.getQurContext().gVars.ASN4selected == null) {
            return null;
        }
        return new String(QurContext.getQurContext().gVars.ASN4selected);
    }

    public int getAggFunc() {
        return QurContext.getQurContext().gVars.selectedAggFunc;
    }

    public String getConverterUsed() {
        if (QurContext.getQurContext().gVars.converterUsed == null) {
            return null;
        }
        return new String(QurContext.getQurContext().gVars.converterUsed);
    }

    public Vector getBeanNamesInQry() {
        if (QurContext.getQurContext().gVars.ejbBeanUsedInQry == null) {
            return null;
        }
        return QurContext.getQurContext().gVars.ejbBeanUsedInQry;
    }

    public boolean getForUpdateFlag() {
        return QurContext.getQurContext().gVars.accessIntent == 0;
    }

    public Object getCacheEntry() {
        return this.cache_entry_;
    }

    public Hashtable getConverters4InputParm() {
        Hashtable hashtable = null;
        Hashtable<Integer, String> hashtable2 = null;
        boolean bl = false;
        Integer n = null;
        String string = null;
        hashtable = QurContext.getQurContext().gVars.InverseConverterList;
        if (hashtable != null) {
            hashtable2 = new Hashtable<Integer, String>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                n = (Integer)enumeration.nextElement();
                string = ((InverseConvObject)hashtable.get(n)).getCvtrName();
                hashtable2.put(n, string);
            }
        }
        return hashtable2;
    }

    private void cachePlanText(String string, String string2, int n, String string3, QurContext qurContext, WDOChgHashMap wDOChgHashMap) throws QueryException {
        if (this.plancache_ == null || !this.plancache_.isServiceEnabled()) {
            return;
        }
        try {
            QurTemplate qurTemplate = qurContext.getQurTemplate();
            qurTemplate.setPlanText(string2);
            qurTemplate.setlocktype(n);
            qurTemplate.setFirstAsnName(string3);
            qurTemplate.setWdoChgMap(wDOChgHashMap);
            this.plancache_.cacheQuery(string, qurTemplate);
            this.cache_entry_ = qurTemplate;
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "cachePlanText", exception);
            }
            qurContext.gVars.errorMsgs.append(exception.getMessage()).append("\n");
            throw new QueryException(exception.getMessage(), exception, new Object[]{theClassName, "cachePlanText"});
        }
    }

    private QurTemplate findCached(String string, QurContext qurContext) throws QueryException {
        if (this.plancache_ == null || !this.plancache_.isServiceEnabled()) {
            return null;
        }
        try {
            QurTemplate qurTemplate;
            this.cache_entry_ = qurTemplate = (QurTemplate)this.plancache_.getTemplateFromCache(string);
            if (qurTemplate != null) {
                return qurTemplate;
            }
            return null;
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "findCached", exception);
            }
            qurContext.gVars.errorMsgs.append(exception.getMessage()).append("\n");
            throw new QueryException(exception.getMessage(), exception, new Object[]{theClassName, "findCached"});
        }
    }

    private QurTemplate getSamelocktype(QurTemplate qurTemplate) throws QueryException {
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "getSamelocktype", new Object[]{qurTemplate});
        }
        String string = qurTemplate.getFirstAsnName();
        int n = qurTemplate.getlocktype();
        TSDVars tSDVars = QurContext.getQurContext().gVars;
        if (tSDVars.ejbDQHelper == null) {
            tSDVars.ejbDQHelper = IObjectQueryServiceImpl.getConfiguration().getQueryHelper(string, null);
        }
        int n2 = IObjectQueryServiceImpl.getConfiguration().getLockType(string, null, tSDVars.ejbDQHelper);
        QurTemplate qurTemplate2 = qurTemplate;
        while (n != n2) {
            if ((qurTemplate2 = qurTemplate2.getNext()) == null) {
                return null;
            }
            n = qurTemplate2.getlocktype();
        }
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "getSamelocktype", new Object[]{qurTemplate2});
        }
        return qurTemplate2;
    }

    private String[] convtypes(String[] stringArray) {
        if (stringArray != null) {
            int n = stringArray.length;
            String[] stringArray2 = new String[n];
            String string = null;
            for (int i = 0; i < n; ++i) {
                string = (String)parmMap.get(stringArray[i]);
                stringArray2[i] = string != null ? string : stringArray[i];
            }
            return stringArray2;
        }
        return stringArray;
    }

    private static void prepare_oneRel(TSDVars tSDVars, WDOChgHashMap wDOChgHashMap, OqgmLopr oqgmLopr) throws QueryException {
        WDOChangeEventHandler wDOChangeEventHandler = new WDOChangeEventHandler(oqgmLopr);
        if (wDOChgHashMap.getAsnToSDONameMap() != null) {
            String string = (String)wDOChgHashMap.getAsnToSDONameMap().get(wDOChangeEventHandler.getid());
            wDOChangeEventHandler.setName_defby_user(string);
        }
        wDOChgHashMap.putChangeEventHandlerObj(wDOChangeEventHandler);
        wDOChangeEventHandler.connectcmpattrtocolattr();
        if (oqgmLopr.getXrel() != null) {
            QueryProcessor.prepare_oneRel(tSDVars, wDOChgHashMap, oqgmLopr.getXrel());
        }
    }

    private static void prepare_wdoupdate(OqgmOpr oqgmOpr, QurContext qurContext, WDOChgHashMap wDOChgHashMap) throws QueryException {
        TSDVars tSDVars = qurContext.gVars;
        if (oqgmOpr.hasLINK()) {
            QueryProcessor.prepare_oneRel(tSDVars, wDOChgHashMap, oqgmOpr.getOpr2link());
            if (!QueryProcessor.sameOrder(oqgmOpr.getOpr2link())) {
                QueryProcessor.orderpks(oqgmOpr.getOpr2link());
            }
            oqgmOpr.setOpr2link(null);
        }
        InternalCollection internalCollection = new InternalCollection();
        internalCollection.copy(oqgmOpr.sub_oprs);
        internalCollection.setToFirst();
        while (internalCollection.isValid()) {
            OqgmOpr oqgmOpr2 = (OqgmOpr)internalCollection.elementAtCursor();
            QueryProcessor.prepare_wdoupdate(oqgmOpr2, qurContext, wDOChgHashMap);
            internalCollection.setToNext();
        }
    }

    private static boolean sameOrder(OqgmLopr oqgmLopr) {
        int n;
        Object e2 = null;
        for (int i = 0; i < oqgmLopr.pks_bo_.size() && oqgmLopr.pks_bo_.get(i) instanceof OSQLColumnDef; ++i) {
            oqgmLopr.pks_bo_.set(i, ((OSQLColumnDef)oqgmLopr.pks_bo_.get((int)i)).id);
            if (oqgmLopr.getM2u_map() != null) {
                e2 = oqgmLopr.getM2u_map().get(oqgmLopr.pks_bo_.get(i));
            }
            if (e2 == null) continue;
            oqgmLopr.pks_bo_.set(i, e2);
        }
        if (oqgmLopr.getppks() == null) {
            return true;
        }
        if (oqgmLopr.getppks().numberOfElements() <= 1) {
            return true;
        }
        if (oqgmLopr.getParent() == null) {
            return true;
        }
        OqgmLopr oqgmLopr2 = oqgmLopr.getParent();
        if (oqgmLopr2.pks_bo_.size() < oqgmLopr2.getPrimaryKeyList().size()) {
            return true;
        }
        List list = oqgmLopr.getppks().toList();
        Object[] objectArray = list.toArray();
        Object[] objectArray2 = oqgmLopr2.pks_column_.toArray();
        if (list.size() != objectArray2.length) {
            return true;
        }
        for (n = 0; n < list.size() && objectArray[n].equals(objectArray2[n]); ++n) {
        }
        return n == list.size();
    }

    private static void orderpks(OqgmLopr oqgmLopr) {
        if (oqgmLopr.getppks() == null) {
            return;
        }
        if (oqgmLopr.getppks().numberOfElements() <= 1) {
            return;
        }
        if (oqgmLopr.getParent() == null) {
            return;
        }
        OqgmLopr oqgmLopr2 = oqgmLopr.getParent();
        List list = oqgmLopr.getppks().toList();
        ArrayList arrayList = new ArrayList(oqgmLopr2.pks_column_);
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            n = list.indexOf(oqgmLopr2.pks_column_.get(i));
            arrayList.set(n, oqgmLopr2.pks_bo_.get(i));
        }
        oqgmLopr2.pks_bo_ = arrayList;
    }

    private WDOChgHashMap dup_wdochghandlermap(WDOChgHashMap wDOChgHashMap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(wDOChgHashMap);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return (WDOChgHashMap)object;
        }
        catch (IOException iOException) {
            System.out.println("Exception occured in Plan dup_a_plan" + iOException.toString());
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Exception occured in Plan dup_a_plan" + classNotFoundException.toString());
            classNotFoundException.printStackTrace();
        }
        return null;
    }

    private WDOChgHashMap dup_wdochghandlermap(EjbQuery ejbQuery, TSDVars tSDVars) {
        if (!tSDVars.returnwdo) {
            return null;
        }
        if (this.plancache_ == null || !this.plancache_.isServiceEnabled()) {
            return null;
        }
        WDOChgHashMap wDOChgHashMap = ((WDOQuery)ejbQuery).getChgHandlers();
        return this.dup_wdochghandlermap(wDOChgHashMap);
    }

    static {
        try {
            queryLogger = IObjectQueryServiceImpl.getConfiguration().getLogger();
        }
        catch (Exception exception) {
            // empty catch block
        }
        parmMap = new HashMap();
        parmMap.put("_char1", "_varchar");
    }
}

