/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.engine;

import com.ibm.ObjectQuery.IObjectQueryServiceImpl;
import com.ibm.ObjectQuery.engine.QurTemplate;
import com.ibm.ObjectQuery.engine.QurTemplateComparator;
import com.ibm.ejs.util.FastHashtable;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;

public class QurTemplateCache
extends FastHashtable {
    private static int cachesize = 0;
    private static boolean isEEX;
    private static float roomi;
    private static float cachethreshold;
    private long timecounter = 0L;
    private static QurTemplateCache instance;

    private QurTemplateCache(int n) {
        super(n);
        isEEX = true;
    }

    private QurTemplateCache() {
        super(11);
        isEEX = false;
    }

    public void cacheQuery(String string, QurTemplate qurTemplate) {
        if (!this.isServiceEnabled()) {
            return;
        }
        if (this.isCacheFull()) {
            this.removelruentries();
        }
        qurTemplate.settimestamp(this.timecounter++);
        this.put(string, qurTemplate);
    }

    private static int getcachesize() {
        int n = 149;
        Properties properties = new Properties();
        String string = "dynamicQuery.properties";
        InputStream inputStream = null;
        try {
            inputStream = QurTemplateCache.getResourceAsStream(string);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return n;
        }
        if (inputStream == null) {
            return n;
        }
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            return n;
        }
        String string2 = properties.getProperty("CACHE_SIZE");
        int n2 = 0;
        try {
            n2 = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return n2 > 10 || n2 == 0 ? n2 : n;
    }

    public static QurTemplateCache getInstance() {
        return instance;
    }

    private static InputStream getResourceAsStream(String string) throws PrivilegedActionException {
        final String string2 = string;
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(string2);
            }
        });
        return inputStream;
    }

    public Object getTemplateFromCache(String string) {
        if (!this.isServiceEnabled()) {
            return null;
        }
        return this.get(string);
    }

    private boolean isCacheFull() {
        return (float)(this.size() + 1) > cachethreshold;
    }

    public boolean isServiceEnabled() {
        return isEEX;
    }

    private void removelruentries() {
        int n;
        QurTemplate[] qurTemplateArray = new QurTemplate[this.size()];
        int n2 = qurTemplateArray.length;
        Enumeration enumeration = this.elements();
        float f = cachethreshold * 0.2f;
        for (n = 0; enumeration.hasMoreElements() && n < n2; ++n) {
            qurTemplateArray[n] = (QurTemplate)enumeration.nextElement();
        }
        if (n2 > n) {
            QurTemplate[] qurTemplateArray2 = new QurTemplate[n];
            System.arraycopy(qurTemplateArray, 0, qurTemplateArray2, 0, n);
            Arrays.sort(qurTemplateArray2, new QurTemplateComparator());
            for (int i = 0; (float)i < f && i < n; ++i) {
                this.remove(qurTemplateArray2[i].getStringQuery());
            }
        } else {
            Arrays.sort(qurTemplateArray, new QurTemplateComparator());
            for (int i = 0; (float)i < f && i < n2; ++i) {
                this.remove(qurTemplateArray[i].getStringQuery());
            }
        }
    }

    public synchronized long gettime() {
        return this.timecounter++;
    }

    public int getcapacity() {
        return cachesize;
    }

    public float getthreshold() {
        return cachethreshold;
    }

    static {
        roomi = 0.75f;
        cachethreshold = 0.0f;
        instance = null;
        if (IObjectQueryServiceImpl.getConfiguration() == null || IObjectQueryServiceImpl.getConfiguration().getConfigType() != 3) {
            isEEX = false;
        } else {
            cachesize = QurTemplateCache.getcachesize();
            if (cachesize != 0) {
                cachethreshold = (float)cachesize * roomi;
                instance = new QurTemplateCache(cachesize);
            }
        }
    }
}

