/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.eval;

import com.ibm.ObjectQuery.IObjectQueryServiceImpl;
import com.ibm.ObjectQuery.IQueryLogger;
import com.ibm.ObjectQuery.eval.ConstantBigDecimal;
import com.ibm.ObjectQuery.eval.ConstantBoolean;
import com.ibm.ObjectQuery.eval.ConstantByte;
import com.ibm.ObjectQuery.eval.ConstantBytes;
import com.ibm.ObjectQuery.eval.ConstantCalendar;
import com.ibm.ObjectQuery.eval.ConstantCharacter;
import com.ibm.ObjectQuery.eval.ConstantDate;
import com.ibm.ObjectQuery.eval.ConstantDouble;
import com.ibm.ObjectQuery.eval.ConstantDuration;
import com.ibm.ObjectQuery.eval.ConstantFloat;
import com.ibm.ObjectQuery.eval.ConstantInt;
import com.ibm.ObjectQuery.eval.ConstantLong;
import com.ibm.ObjectQuery.eval.ConstantRef;
import com.ibm.ObjectQuery.eval.ConstantSerializableObject;
import com.ibm.ObjectQuery.eval.ConstantShort;
import com.ibm.ObjectQuery.eval.ConstantString;
import com.ibm.ObjectQuery.eval.ConstantTime;
import com.ibm.ObjectQuery.eval.ConstantTimestamp;
import com.ibm.ObjectQuery.eval.Expression;
import com.ibm.ObjectQuery.eval.Plan;
import com.ibm.websphere.ejbquery.QueryException;
import java.io.Serializable;
import java.util.HashMap;

abstract class Constant
implements Comparable,
Serializable {
    private int sqlType_;
    private static String theClassName = Constant.class.getName();
    private boolean isPrimitiveType = false;
    private static HashMap classToSQLTypeMap__ = new HashMap();
    static final int OOSQL_CALENDAR = 3000;
    protected static IQueryLogger queryLogger = null;
    boolean isNull_ = false;

    Constant(int n) {
        this.sqlType_ = n;
    }

    abstract void assign(Constant var1) throws QueryException;

    public Object clone() {
        return null;
    }

    abstract int compareTo(Constant var1);

    public int compareTo(Object object) {
        return this.compareTo((Constant)object);
    }

    int compareUnknowns(Constant constant) {
        if (constant.isNull_ && this.isNull_) {
            return 0;
        }
        if (this.isNull_) {
            return -1;
        }
        return 1;
    }

    boolean comparingUnknowns(Constant constant) {
        return constant.isNull_ || this.isNull_;
    }

    abstract Object getObject();

    int getType() {
        return this.sqlType_;
    }

    static Constant makeEmptyConstant(int n) throws QueryException {
        switch (n) {
            case -7: {
                return new ConstantBoolean();
            }
            case -6: {
                return new ConstantByte();
            }
            case 5: {
                return new ConstantShort();
            }
            case 4: {
                return new ConstantInt();
            }
            case -5: {
                return new ConstantLong();
            }
            case 7: {
                return new ConstantFloat();
            }
            case 6: 
            case 8: {
                return new ConstantDouble();
            }
            case 1: {
                return new ConstantString();
            }
            case 3: {
                return new ConstantBigDecimal();
            }
            case 91: {
                return new ConstantDate();
            }
            case 92: {
                return new ConstantTime();
            }
            case 93: {
                return new ConstantTimestamp();
            }
            case 2000: {
                return new ConstantSerializableObject(2000);
            }
            case 1118: {
                return new ConstantCharacter();
            }
            case -3: 
            case -2: {
                return new ConstantBytes();
            }
            case -4: {
                return new ConstantBytes();
            }
            case -1: {
                return new ConstantSerializableObject(-1);
            }
            case 2004: {
                return new ConstantBytes();
            }
            case 2005: {
                return new ConstantBytes();
            }
            case 2002: {
                return new ConstantDuration();
            }
            case 2006: {
                return new ConstantRef();
            }
            case 3000: {
                return new ConstantCalendar();
            }
        }
        return new ConstantSerializableObject(2000);
    }

    static Constant makeNullConstant(int n) throws QueryException {
        Constant constant = Constant.makeEmptyConstant(n);
        constant.isNull_ = true;
        return constant;
    }

    static int mapClassToSQLType(Class clazz) {
        if (clazz.getComponentType() != null && clazz.getComponentType().getName().equals("byte")) {
            return -2;
        }
        Integer n = (Integer)classToSQLTypeMap__.get(clazz);
        if (n == null) {
            return 2000;
        }
        return n;
    }

    abstract void setObject(Object var1);

    void superAssign(Constant constant) throws QueryException {
        this.isNull_ = constant.isNull_;
    }

    void setisPrimitiveType(boolean bl) {
        this.isPrimitiveType = bl;
    }

    boolean getisPrimitiveType() {
        return this.isPrimitiveType;
    }

    public void evaluate(Expression expression, Plan plan) throws QueryException {
    }

    static {
        try {
            queryLogger = IObjectQueryServiceImpl.getConfiguration().getLogger();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            classToSQLTypeMap__.put(Class.forName("java.lang.Boolean"), new Integer(-7));
            classToSQLTypeMap__.put(Class.forName("java.lang.Byte"), new Integer(-6));
            classToSQLTypeMap__.put(Class.forName("java.lang.Short"), new Integer(5));
            classToSQLTypeMap__.put(Class.forName("java.lang.Integer"), new Integer(4));
            classToSQLTypeMap__.put(Class.forName("java.lang.Long"), new Integer(-5));
            classToSQLTypeMap__.put(Class.forName("java.lang.Float"), new Integer(7));
            classToSQLTypeMap__.put(Class.forName("java.lang.Double"), new Integer(8));
            classToSQLTypeMap__.put(Class.forName("java.lang.String"), new Integer(1));
            classToSQLTypeMap__.put(Class.forName("java.lang.Character"), new Integer(1118));
            classToSQLTypeMap__.put(Class.forName("java.math.BigDecimal"), new Integer(3));
            classToSQLTypeMap__.put(Class.forName("java.sql.Date"), new Integer(91));
            classToSQLTypeMap__.put(Class.forName("java.sql.Time"), new Integer(92));
            classToSQLTypeMap__.put(Class.forName("java.sql.Timestamp"), new Integer(93));
            classToSQLTypeMap__.put(Class.forName("java.sql.Ref"), new Integer(2006));
            classToSQLTypeMap__.put(Class.forName("java.util.GregorianCalendar"), new Integer(3000));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

