/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.eval;

import com.ibm.ObjectQuery.eval.Arithmetic;
import com.ibm.ObjectQuery.eval.Constant;
import com.ibm.ObjectQuery.eval.ConstantDateTime;
import com.ibm.ObjectQuery.eval.ConstantDuration;
import com.ibm.ObjectQuery.eval.ConstantNumber;
import com.ibm.ObjectQuery.eval.Expression;
import com.ibm.ObjectQuery.eval.ExpressionOperation;
import com.ibm.ObjectQuery.eval.Operands;
import com.ibm.ObjectQuery.eval.Plan;
import com.ibm.websphere.ejbquery.QueryException;

class ExpressionArithmetic
extends ExpressionOperation {
    private static String theClassName1 = ExpressionArithmetic.class.getName();
    static final int UNARY_MINUS = 201;
    static final int UNARY_PLUS = 202;
    static final int BINARY_MINUS = 203;
    static final int BINARY_PLUS = 204;
    static final int BINARY_STAR = 205;
    static final int BINARY_SLASH = 206;
    private boolean isBinary_;

    ExpressionArithmetic(int n, Expression expression) throws QueryException {
        this.leftExpression_ = expression;
        this.rightExpression_ = null;
        this.operation_ = n;
        this.isBinary_ = false;
        if (this.leftExpression_.result_ == null) {
            this.leftExpression_.result_ = Constant.makeEmptyConstant(0);
        }
        this.result_ = Constant.makeEmptyConstant(this.leftExpression_.result_.getType());
    }

    ExpressionArithmetic(Expression expression, int n, Expression expression2) throws QueryException {
        this.leftExpression_ = expression;
        this.rightExpression_ = expression2;
        this.operation_ = n;
        this.isBinary_ = true;
        if (this.leftExpression_.result_ == null) {
            this.leftExpression_.result_ = Constant.makeEmptyConstant(0);
        }
        if (this.rightExpression_.result_ == null) {
            this.rightExpression_.result_ = Constant.makeEmptyConstant(0);
        }
        this.result_ = Constant.makeEmptyConstant(Operands.inferResultType(this.leftExpression_.result_.getType(), this.rightExpression_.result_.getType()));
    }

    void evaluate(Plan plan) throws QueryException {
        this.result_.isNull_ = false;
        int n = 0;
        Constant constant = null;
        if (this.leftExpression_ != null && this.leftExpression_.result_ != null && this.leftExpression_.result_.getType() == 2000) {
            this.leftExpression_.evaluate(plan);
            if (this.leftExpression_.result_.getObject() instanceof Comparable) {
                n = Constant.mapClassToSQLType(this.leftExpression_.result_.getObject().getClass());
                this.result_ = constant = Constant.makeEmptyConstant(n);
                constant.setObject(this.leftExpression_.result_.getObject());
                this.leftExpression_.result_ = constant;
            }
        } else if (this.rightExpression_ != null && this.rightExpression_.result_ != null && this.rightExpression_.result_.getType() == 2000) {
            this.rightExpression_.evaluate(plan);
            if (this.rightExpression_.result_.getObject() instanceof Comparable) {
                n = Constant.mapClassToSQLType(this.rightExpression_.result_.getObject().getClass());
                this.result_ = constant = Constant.makeEmptyConstant(n);
                constant.setObject(this.leftExpression_.result_.getObject());
                this.rightExpression_.result_ = constant;
            }
        } else {
            this.leftExpression_.evaluate(plan);
        }
        if (this.isBinary_) {
            this.rightExpression_.evaluate(plan);
            this.evaluateBinaryOperation(this.operation_, plan);
        } else {
            this.evaluateUnaryOperation(this.operation_, plan);
        }
    }

    private void evaluateBinaryOperation(int n, Plan plan) throws QueryException {
        if (this.result_ instanceof ConstantNumber || this.result_ instanceof ConstantDateTime || this.result_ instanceof ConstantDuration) {
            if (plan.getEjbflag() != 0) {
                this.result_ = Constant.makeEmptyConstant(Operands.inferResultType(this.leftExpression_.result_.getType(), this.rightExpression_.result_.getType()));
            }
        } else {
            String string = queryLogger.message(4L, theClassName1, "evaluateBinaryOperation", "RTICTBO", new Object[]{this.leftExpression_.result_.getObject(), this.rightExpression_.result_.getObject()});
            throw new QueryException(string);
        }
        Arithmetic.evaluateBinaryOperation(n, this.leftExpression_.result_, this.rightExpression_.result_, this.result_);
    }

    private void evaluateUnaryOperation(int n, Plan plan) throws QueryException {
        if (!(this.result_ instanceof ConstantNumber)) {
            if (this.result_ instanceof ConstantDateTime) {
                String string = queryLogger.message(4L, theClassName1, "evaluateUnaryOperation", "RTDTANS", null);
                throw new QueryException(string);
            }
            String string = queryLogger.message(4L, theClassName1, "evaluateUnaryOperation", "RTUSTUO", new Object[]{this.leftExpression_.result_.getObject()});
            throw new QueryException(string);
        }
        Arithmetic.evaluateUnaryOperation(n, this.leftExpression_.result_, this.result_);
    }
}

