/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.eval;

import com.ibm.ObjectQuery.IObjectQueryServiceImpl;
import com.ibm.ObjectQuery.IQueryLogger;
import com.ibm.ObjectQuery.eval.ConstantBoolean;
import com.ibm.ObjectQuery.eval.ConstantCharacter;
import com.ibm.ObjectQuery.eval.ConstantString;
import com.ibm.ObjectQuery.eval.Expression;
import com.ibm.ObjectQuery.eval.ExpressionOperation;
import com.ibm.ObjectQuery.eval.ExpressionTerm;
import com.ibm.ObjectQuery.eval.FunctionScalarMakeBO;
import com.ibm.ObjectQuery.eval.Plan;
import com.ibm.ObjectQuery.eval.Statement;
import com.ibm.ObjectQuery.eval.TermExistsPredicate;
import com.ibm.ObjectQuery.eval.TermFunctionScalar;
import com.ibm.websphere.ejbquery.QueryException;

class ExpressionPredicate
extends ExpressionOperation {
    static final int EXISTS = 1;
    static final int LIKE = 2;
    static final int NOT_LIKE = 3;
    static final int IS_NOT_NULL = 4;
    static final int IS_NULL = 5;
    static final int GE = 6;
    static final int GT = 7;
    static final int NE = 8;
    static final int LE = 9;
    static final int LT = 10;
    static final int EQ = 11;
    static final int OR = 12;
    static final int AND = 13;
    static final int NOT = 14;
    ConstantBoolean result_ = new ConstantBoolean();
    private static IQueryLogger queryLogger = null;
    private static String theClassName = ExpressionOperation.class.getName();

    ExpressionPredicate(int n, Expression expression) {
        ((ExpressionOperation)this).result_ = this.result_;
        this.leftExpression_ = expression;
        this.rightExpression_ = null;
        this.operation_ = n;
    }

    ExpressionPredicate(Expression expression, int n, Expression expression2) {
        ((ExpressionOperation)this).result_ = this.result_;
        this.leftExpression_ = expression;
        this.rightExpression_ = expression2;
        this.operation_ = n;
    }

    void evaluate(Plan plan) throws QueryException {
        this.result_.isNull_ = false;
        switch (this.operation_) {
            case 1: {
                this.evaluateEXISTS(plan);
                break;
            }
            case 13: {
                this.evaluateAND(plan);
                break;
            }
            case 12: {
                this.evaluateOR(plan);
                break;
            }
            case 14: {
                this.evaluateNOT(plan);
                break;
            }
            case 5: {
                this.evaluate_IS_NULL(plan);
                break;
            }
            case 4: {
                this.evaluate_IS_NOT_NULL(plan);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.evaluateComparisonOperation(plan, this.operation_);
            }
        }
    }

    private void evaluate_IS_NOT_NULL(Plan plan) throws QueryException {
        this.leftExpression_.evaluate(plan);
        this.result_.isNull_ = false;
        this.result_.setBoolean(!this.leftExpression_.result_.isNull_);
    }

    private void evaluate_IS_NULL(Plan plan) throws QueryException {
        this.leftExpression_.evaluate(plan);
        this.result_.isNull_ = false;
        this.result_.setBoolean(this.leftExpression_.result_.isNull_);
    }

    private void evaluateAND(Plan plan) throws QueryException {
        this.leftExpression_.evaluate(plan);
        if (!this.leftExpression_.result_.isNull_ && !((ConstantBoolean)this.leftExpression_.result_).getBoolean()) {
            this.result_.isNull_ = false;
            this.result_.setBoolean(false);
            return;
        }
        this.rightExpression_.evaluate(plan);
        if (this.leftExpression_.result_.isNull_) {
            if (!this.rightExpression_.result_.isNull_ && !((ConstantBoolean)this.rightExpression_.result_).getBoolean()) {
                this.result_.isNull_ = false;
                this.result_.setBoolean(false);
            } else {
                this.result_.isNull_ = true;
            }
        } else {
            this.result_.assign(this.rightExpression_.result_);
        }
    }

    private void evaluateComparisonOperation(Plan plan, int n) throws QueryException {
        this.leftExpression_.evaluate(plan);
        this.rightExpression_.evaluate(plan);
        if (this.leftExpression_.result_.isNull_ || this.rightExpression_.result_.isNull_) {
            this.result_.isNull_ = true;
            return;
        }
        if (this.leftExpression_ instanceof ExpressionTerm && this.rightExpression_ instanceof ExpressionTerm && ((ExpressionTerm)this.leftExpression_).term_ instanceof TermFunctionScalar && ((ExpressionTerm)this.rightExpression_).term_ instanceof TermFunctionScalar && ((TermFunctionScalar)((ExpressionTerm)this.leftExpression_).term_).getFunctionScalar() instanceof FunctionScalarMakeBO && ((TermFunctionScalar)((ExpressionTerm)this.rightExpression_).term_).getFunctionScalar() instanceof FunctionScalarMakeBO && ((FunctionScalarMakeBO)((TermFunctionScalar)((ExpressionTerm)this.leftExpression_).term_).getFunctionScalar()).pathExpression_ == null && ((FunctionScalarMakeBO)((TermFunctionScalar)((ExpressionTerm)this.rightExpression_).term_).getFunctionScalar()).pathExpression_ == null) {
            String string = queryLogger.message(4L, theClassName, "evaluateComparisonOperation", "RTIE", null);
            throw new QueryException(string);
        }
        this.result_.isNull_ = false;
        switch (n) {
            case 11: {
                if (this.leftExpression_.result_ instanceof ConstantCharacter && this.rightExpression_.result_ instanceof ConstantString && ((String)this.rightExpression_.result_.getObject()).length() != 1) {
                    String string = queryLogger.message(4L, theClassName, "evaluateComparisonOperation", "ICCTS", new Object[]{this.leftExpression_.result_.getObject(), this.rightExpression_.result_.getObject()});
                    throw new QueryException(string);
                }
                this.result_.setBoolean(this.leftExpression_.result_.compareTo(this.rightExpression_.result_) == 0);
                break;
            }
            case 8: {
                this.result_.setBoolean(this.leftExpression_.result_.compareTo(this.rightExpression_.result_) != 0);
                break;
            }
            case 10: {
                this.result_.setBoolean(this.leftExpression_.result_.compareTo(this.rightExpression_.result_) < 0);
                break;
            }
            case 9: {
                this.result_.setBoolean(this.leftExpression_.result_.compareTo(this.rightExpression_.result_) <= 0);
                break;
            }
            case 7: {
                this.result_.setBoolean(this.leftExpression_.result_.compareTo(this.rightExpression_.result_) > 0);
                break;
            }
            case 6: {
                this.result_.setBoolean(this.leftExpression_.result_.compareTo(this.rightExpression_.result_) >= 0);
            }
        }
    }

    private void evaluateEXISTS(Plan plan) throws QueryException {
        int n = 0;
        this.result_.setBoolean(false);
        for (Statement statement = ((TermExistsPredicate)((ExpressionTerm)this.leftExpression_).term_).getExistsPredicateBlock(); n == 0 && statement != null; statement = statement.next()) {
            n = statement.evaluate(plan);
        }
        if (n == 2) {
            this.result_.setBoolean(true);
        }
    }

    private void evaluateNOT(Plan plan) throws QueryException {
        this.leftExpression_.evaluate(plan);
        if (this.leftExpression_.result_.isNull_) {
            this.result_.isNull_ = true;
            return;
        }
        this.result_.isNull_ = false;
        this.result_.setBoolean(!((ConstantBoolean)this.leftExpression_.result_).getBoolean());
    }

    private void evaluateOR(Plan plan) throws QueryException {
        this.leftExpression_.evaluate(plan);
        if (!this.leftExpression_.result_.isNull_ && ((ConstantBoolean)this.leftExpression_.result_).getBoolean()) {
            this.result_.isNull_ = false;
            this.result_.setBoolean(true);
            return;
        }
        this.rightExpression_.evaluate(plan);
        if (this.leftExpression_.result_.isNull_) {
            if (!this.rightExpression_.result_.isNull_ && ((ConstantBoolean)this.rightExpression_.result_).getBoolean()) {
                this.result_.isNull_ = false;
                this.result_.setBoolean(true);
            } else {
                this.result_.isNull_ = true;
            }
        } else {
            this.result_.assign(this.rightExpression_.result_);
        }
    }

    static {
        try {
            queryLogger = IObjectQueryServiceImpl.getConfiguration().getLogger();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

