/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.eval;

import com.ibm.ObjectQuery.engine.OSQLMain;
import com.ibm.ObjectQuery.eval.Constant;
import com.ibm.ObjectQuery.eval.ConstantBigDecimal;
import com.ibm.ObjectQuery.eval.ConstantBoolean;
import com.ibm.ObjectQuery.eval.ConstantByte;
import com.ibm.ObjectQuery.eval.ConstantCharacter;
import com.ibm.ObjectQuery.eval.ConstantDouble;
import com.ibm.ObjectQuery.eval.ConstantDuration;
import com.ibm.ObjectQuery.eval.ConstantFloat;
import com.ibm.ObjectQuery.eval.ConstantInt;
import com.ibm.ObjectQuery.eval.ConstantLong;
import com.ibm.ObjectQuery.eval.ConstantShort;
import com.ibm.ObjectQuery.eval.ConstantString;
import com.ibm.ObjectQuery.eval.Expression;
import com.ibm.ObjectQuery.eval.ExpressionTerm;
import com.ibm.ObjectQuery.eval.FunctionScalar;
import com.ibm.ObjectQuery.eval.Plan;
import com.ibm.ObjectQuery.eval.PlanVariables;
import com.ibm.ObjectQuery.eval.TermAtom;
import com.ibm.ObjectQuery.eval.TermFunctionScalar;
import com.ibm.websphere.ejbquery.QueryException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class FunctionScalarSQL
extends FunctionScalar {
    private static String theClassName = FunctionScalarSQL.class.getName();
    static final int UPPER = 6;
    static final int LOWER = 7;
    static final int BIGINT = 8;
    static final int CHAR = 9;
    static final int DIGITS = 10;
    static final int SMALLINT = 11;
    static final int REAL = 12;
    static final int DOUBLE = 13;
    static final int INTEGER = 14;
    static final int YEAR = 15;
    static final int MONTH = 16;
    static final int DAY = 17;
    static final int DAYS = 18;
    static final int HOUR = 19;
    static final int MINUTE = 20;
    static final int SECOND = 21;
    static final int MICROSECOND = 22;
    static final int DECIMAL = 24;
    static final int DATE = 25;
    static final int TIME = 26;
    static final int TIMESTAMP = 27;
    static final int LENGTH = 28;
    static final int POSSTR = 29;
    static final int SUBSTR = 30;
    static final int BOOLEAN = 31;
    static final int SQRT = 32;
    static final int ABS = 33;
    static final int CONCAT = 34;
    static final int FLOAT = 35;
    static final int TINYINT = 36;
    static final int CHAR1 = 37;
    static final int BINTEGER = 38;
    static final int CALENDAR = 39;
    static final int MOD = 40;
    static final int BIT_LENGTH = 41;
    static final int TRIM = 42;
    private int function_;

    FunctionScalarSQL(int n, ArrayList arrayList) {
        super(arrayList);
        this.function_ = n;
    }

    void evaluate(Expression expression, Plan plan) throws QueryException {
        Expression expression2;
        this.evaluateSQLFunctionArgs(plan);
        if (expression != null && expression.result_ == null && (expression2 = (Expression)this.getArgs().get(0)) != null && expression2.result_ != null && expression2.result_ instanceof Constant) {
            expression.result_ = Constant.makeEmptyConstant(expression2.result_.getType());
        }
        switch (this.function_) {
            case 6: {
                this.evaluate_UPPER((ExpressionTerm)expression, plan);
                break;
            }
            case 7: {
                this.evaluate_LOWER((ExpressionTerm)expression, plan);
                break;
            }
            case 8: {
                this.evaluate_BIGINT((ExpressionTerm)expression, plan);
                break;
            }
            case 31: {
                this.evaluate_BOOLEAN((ExpressionTerm)expression, plan);
                break;
            }
            case 10: {
                this.evaluate_DIGITS(expression, plan);
                break;
            }
            case 11: {
                this.evaluate_SMALLINT(expression, plan);
                break;
            }
            case 36: {
                this.evaluate_TINYINT(expression, plan);
                break;
            }
            case 14: {
                this.evaluate_INTEGER(expression, plan);
                break;
            }
            case 12: {
                this.evaluate_REAL(expression, plan);
                break;
            }
            case 13: 
            case 35: {
                this.evaluate_DOUBLE(expression, plan);
                break;
            }
            case 24: {
                this.evaluate_DECIMAL(expression, plan);
                break;
            }
            case 15: {
                this.evaluate_YEAR(expression, plan);
                break;
            }
            case 16: {
                this.evaluate_MONTH(expression, plan);
                break;
            }
            case 17: {
                this.evaluate_DAY(expression, plan);
                break;
            }
            case 18: {
                this.evaluate_DAYS(expression, plan);
                break;
            }
            case 19: {
                this.evaluate_HOUR(expression, plan);
                break;
            }
            case 20: {
                this.evaluate_MINUTE(expression, plan);
                break;
            }
            case 21: {
                this.evaluate_SECOND(expression, plan);
                break;
            }
            case 25: {
                this.evaluate_DATE(expression, plan);
                break;
            }
            case 26: {
                this.evaluate_TIME(expression, plan);
                break;
            }
            case 27: {
                this.evaluate_TIMESTAMP(expression, plan);
                break;
            }
            case 38: {
                this.evaluate_BINTEGER(expression, plan);
                break;
            }
            case 22: {
                this.evaluate_MICROSECOND(expression, plan);
                break;
            }
            case 28: {
                this.evaluate_LENGTH(expression, plan);
                break;
            }
            case 29: {
                this.evaluate_POSSTR(expression, plan);
                break;
            }
            case 30: {
                this.evaluate_SUBSTR(expression, plan);
                break;
            }
            case 33: {
                this.evaluate_ABS(expression, plan);
                break;
            }
            case 34: {
                this.evaluate_CONCAT(expression, plan);
                break;
            }
            case 37: {
                this.evaluate_CHAR1(expression, plan);
                break;
            }
            case 32: {
                this.evaluate_SQRT(expression, plan);
                break;
            }
            case 39: {
                this.evaluate_CALENDAR(expression, plan);
                break;
            }
            case 40: {
                this.evaluate_MOD(expression, plan);
                break;
            }
            case 41: {
                this.evaluate_BIT_LENGTH(expression, plan);
                break;
            }
            case 42: {
                this.evaluate_TRIM(expression, plan);
            }
        }
    }

    private void evaluate_MOD(Expression expression, Plan plan) throws QueryException {
        Expression[] expressionArray = new Expression[]{(Expression)this.getArgs().get(0), (Expression)this.getArgs().get(1)};
        if (expressionArray[0].result_.isNull_ || expressionArray[1].result_.isNull_) {
            expression.result_.isNull_ = true;
            return;
        }
        int n = expressionArray[0].result_.getType();
        int n2 = expressionArray[1].result_.getType();
        if (n == -5 || n2 == -5) {
            long[] lArray = new long[2];
            block15: for (int i = 0; i < lArray.length; ++i) {
                switch (expressionArray[i].result_.getType()) {
                    case 5: {
                        lArray[i] = ((ConstantShort)expressionArray[i].result_).getShort();
                        continue block15;
                    }
                    case -6: {
                        lArray[i] = ((ConstantByte)expressionArray[i].result_).getByte();
                        continue block15;
                    }
                    case -5: {
                        lArray[i] = ((ConstantLong)expressionArray[i].result_).getLong();
                        continue block15;
                    }
                    case 4: {
                        lArray[i] = ((ConstantInt)expressionArray[i].result_).getInt();
                    }
                }
            }
            try {
                ((ConstantLong)expression.result_).setLong(lArray[0] % lArray[1]);
            }
            catch (ArithmeticException arithmeticException) {
                if (queryLogger.isLogging()) {
                    queryLogger.exception(512L, theClassName, "evaluate_MOD", arithmeticException);
                }
                String string = queryLogger.message(4L, theClassName, "evaluate_MOD", "RTAEDBZ", new Object[]{new String("MOD(").concat(new Long(lArray[0]).toString()).concat(",").concat(new Long(lArray[1]).toString()).concat(")")});
                throw new QueryException(string, arithmeticException, new Object[]{theClassName, "evaluate_MOD"});
            }
        }
        int[] nArray = new int[2];
        block16: for (int i = 0; i < nArray.length; ++i) {
            switch (expressionArray[i].result_.getType()) {
                case 5: {
                    nArray[i] = ((ConstantShort)expressionArray[i].result_).getShort();
                    continue block16;
                }
                case -6: {
                    nArray[i] = ((ConstantByte)expressionArray[i].result_).getByte();
                    continue block16;
                }
                case 4: {
                    nArray[i] = ((ConstantInt)expressionArray[i].result_).getInt();
                }
            }
        }
        try {
            ((ConstantInt)expression.result_).setInt(nArray[0] % nArray[1]);
        }
        catch (ArithmeticException arithmeticException) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "evaluate_MOD", arithmeticException);
            }
            String string = queryLogger.message(4L, theClassName, "evaluate_MOD", "RTAEDBZ", new Object[]{new String("MOD(").concat(new Integer(nArray[0]).toString()).concat(",").concat(new Integer(nArray[1]).toString()).concat(")")});
            throw new QueryException(string, arithmeticException, new Object[]{theClassName, "evaluate_MOD"});
        }
    }

    private void evaluate_ABS(Expression expression, Plan plan) {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 5: {
                    ((ConstantShort)expression.result_).setShort((short)Math.abs(((ConstantShort)expression2.result_).getShort()));
                    break;
                }
                case -6: {
                    ((ConstantShort)expression.result_).setShort((short)Math.abs(((ConstantByte)expression2.result_).getByte()));
                    break;
                }
                case -5: {
                    ((ConstantLong)expression.result_).setLong(Math.abs(((ConstantLong)expression2.result_).getLong()));
                    break;
                }
                case 4: {
                    ((ConstantInt)expression.result_).setInt(Math.abs(((ConstantInt)expression2.result_).getInt()));
                    break;
                }
                case 7: {
                    ((ConstantFloat)expression.result_).setFloat(Math.abs(((ConstantFloat)expression2.result_).getFloat()));
                    break;
                }
                case 6: 
                case 8: {
                    ((ConstantDouble)expression.result_).setDouble(Math.abs(((ConstantDouble)expression2.result_).getDouble()));
                    break;
                }
                case 3: {
                    ((ConstantBigDecimal)expression.result_).setBigDecimal(new BigDecimal(Math.abs(((BigDecimal)expression2.result_.getObject()).doubleValue())));
                }
            }
        }
    }

    private void evaluate_CONCAT(Expression expression, Plan plan) {
        Expression expression2 = (Expression)this.getArgs().get(0);
        Expression expression3 = (Expression)this.getArgs().get(1);
        if (expression2.result_.isNull_ || expression3.result_.isNull_) {
            expression.result_.isNull_ = true;
            return;
        }
        String string = null;
        StringBuffer stringBuffer = null;
        String string2 = null;
        String string3 = null;
        if (expression2.result_ instanceof ConstantString) {
            string2 = ((ConstantString)expression2.result_).getString();
        } else if (expression2.result_ instanceof ConstantCharacter) {
            string2 = ((ConstantCharacter)expression2.result_).getObject().toString();
        }
        if (expression3.result_ instanceof ConstantString) {
            string3 = ((ConstantString)expression3.result_).getString();
        } else if (expression3.result_ instanceof ConstantCharacter) {
            string3 = ((ConstantCharacter)expression3.result_).getObject().toString();
        }
        switch (expression2.result_.getType()) {
            case -1: 
            case 1: 
            case 12: {
                stringBuffer = new StringBuffer(string2);
                stringBuffer.append(string3);
                string = stringBuffer.toString();
                ((ConstantString)expression.result_).setString(string);
                break;
            }
        }
    }

    private void evaluate_SQRT(Expression expression, Plan plan) {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 5: {
                    ((ConstantDouble)expression.result_).setDouble(Math.sqrt(((ConstantShort)expression2.result_).getShort()));
                    break;
                }
                case -6: {
                    ((ConstantDouble)expression.result_).setDouble(Math.sqrt(((ConstantByte)expression2.result_).getByte()));
                    break;
                }
                case -5: {
                    ((ConstantDouble)expression.result_).setDouble(Math.sqrt(((ConstantLong)expression2.result_).getLong()));
                    break;
                }
                case 4: {
                    ((ConstantDouble)expression.result_).setDouble(Math.sqrt(((ConstantInt)expression2.result_).getInt()));
                    break;
                }
                case 7: {
                    ((ConstantDouble)expression.result_).setDouble(Math.sqrt(((ConstantFloat)expression2.result_).getFloat()));
                    break;
                }
                case 6: 
                case 8: {
                    ((ConstantDouble)expression.result_).setDouble(Math.sqrt(((ConstantDouble)expression2.result_).getDouble()));
                    break;
                }
                case 3: {
                    ((ConstantDouble)expression.result_).setDouble(Math.sqrt(((BigDecimal)expression2.result_.getObject()).doubleValue()));
                }
            }
        }
    }

    private void evaluate_DATE(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        int n = 0;
        boolean bl = false;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 5: {
                    n = ((ConstantShort)expression2.result_).getShort();
                    break;
                }
                case 4: {
                    n = ((ConstantInt)expression2.result_).getInt();
                    break;
                }
                case 6: 
                case 8: {
                    n = (int)((ConstantDouble)expression2.result_).getDouble();
                    break;
                }
                case 7: {
                    n = (int)((ConstantFloat)expression2.result_).getFloat();
                    break;
                }
                case 3: {
                    n = ((BigDecimal)expression2.result_.getObject()).intValue();
                    break;
                }
                case 1: {
                    expression.result_.setObject(OSQLMain.char2Date(new StringBuffer(expression2.result_.getObject().toString())));
                    bl = true;
                    break;
                }
                case 91: {
                    expression.result_.assign(expression2.result_);
                    bl = true;
                    break;
                }
                case 93: {
                    expression.result_.setObject(new Date(((Timestamp)expression2.result_.getObject()).getTime()));
                    bl = true;
                }
            }
            if (n < 0) {
                String string = queryLogger.message(4L, theClassName, "evaluate_DATE", "RTDTNV", null);
                throw new QueryException(string);
            }
            if (!bl) {
                this.setResultDate(expression, n);
            }
        }
    }

    private void evaluate_DAY(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            Calendar calendar = Calendar.getInstance();
            switch (expression2.result_.getType()) {
                case 2002: {
                    ((ConstantInt)expression.result_).setInt(((ConstantDuration)expression2.result_).getDate());
                    break;
                }
                case 3: {
                    ConstantBigDecimal constantBigDecimal = (ConstantBigDecimal)expression2.result_;
                    ConstantDuration constantDuration = FunctionScalarSQL.decimal2duration(constantBigDecimal);
                    ((ConstantInt)expression.result_).setInt(constantDuration.getDate());
                    break;
                }
                case 91: {
                    calendar.setTime((java.util.Date)expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt(calendar.get(5));
                    break;
                }
                case 93: {
                    calendar.setTime((Timestamp)expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt(calendar.get(5));
                    break;
                }
                case 1: {
                    Object object = OSQLMain.char2Date(new StringBuffer(expression2.result_.getObject().toString()));
                    calendar.setTime((java.util.Date)object);
                    ((ConstantInt)expression.result_).setInt(calendar.get(5));
                    break;
                }
            }
        }
    }

    private void evaluate_DAYS(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 91: 
                case 93: {
                    long l = this.date2days(expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt((int)l);
                    break;
                }
                case 1: {
                    long l = this.datestr2days(expression2.result_.getObject().toString());
                    ((ConstantInt)expression.result_).setInt((int)l);
                    break;
                }
            }
        }
    }

    private void evaluate_DECIMAL(Expression expression, Plan plan) throws QueryException {
        Object object;
        Serializable serializable;
        int n = 0;
        int n2 = 0;
        Iterator iterator = this.getArgs().iterator();
        Expression expression2 = (Expression)iterator.next();
        if (iterator.hasNext()) {
            serializable = (ExpressionTerm)iterator.next();
            n = ((ConstantInt)((TermAtom)((ExpressionTerm)serializable).term_).getAtom().constant_).getInt();
            if (iterator.hasNext()) {
                object = (ExpressionTerm)iterator.next();
                n2 = ((ConstantInt)((TermAtom)((ExpressionTerm)object).term_).getAtom().constant_).getInt();
            }
        }
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 5: {
                    try {
                        serializable = new BigDecimal(((ConstantShort)expression2.result_).getShort());
                        ((ConstantBigDecimal)expression.result_).setObject(((BigDecimal)serializable).setScale(n2, 3));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_DECIMAL", numberFormatException);
                        }
                        object = queryLogger.message(4L, theClassName, "evaluate_DECIMAL", "RTLPCTD", new Object[]{expression2.result_.getObject()});
                        throw new QueryException((String)object, numberFormatException, new Object[]{theClassName, "evaluate_DECIMAL"});
                    }
                }
                case -6: {
                    try {
                        serializable = new BigDecimal(((ConstantByte)expression2.result_).getByte());
                        ((ConstantBigDecimal)expression.result_).setObject(((BigDecimal)serializable).setScale(n2, 3));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_DECIMAL", numberFormatException);
                        }
                        object = queryLogger.message(4L, theClassName, "evaluate_DECIMAL", "RTLPCTD", new Object[]{expression2.result_.getObject()});
                        throw new QueryException((String)object, numberFormatException, new Object[]{theClassName, "evaluate_DECIMAL"});
                    }
                }
                case -5: {
                    try {
                        serializable = new BigDecimal(((ConstantLong)expression2.result_).getLong());
                        ((BigDecimal)serializable).setScale(n2, 3);
                        ((ConstantBigDecimal)expression.result_).setBigDecimal((BigDecimal)serializable, n);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_DECIMAL", numberFormatException);
                        }
                        object = queryLogger.message(4L, theClassName, "evaluate_DECIMAL", "RTLPCTD", new Object[]{expression2.result_.getObject()});
                        throw new QueryException((String)object, numberFormatException, new Object[]{theClassName, "evaluate_DECIMAL"});
                    }
                }
                case 4: {
                    try {
                        serializable = new BigDecimal(((ConstantInt)expression2.result_).getInt());
                        ((BigDecimal)serializable).setScale(n2, 3);
                        ((ConstantBigDecimal)expression.result_).setBigDecimal((BigDecimal)serializable, n);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_DECIMAL", numberFormatException);
                        }
                        object = queryLogger.message(4L, theClassName, "evaluate_DECIMAL", "RTLPCTD", new Object[]{expression2.result_.getObject()});
                        throw new QueryException((String)object, numberFormatException, new Object[]{theClassName, "evaluate_DECIMAL"});
                    }
                }
                case 7: {
                    try {
                        serializable = new BigDecimal(((ConstantFloat)expression2.result_).getFloat());
                        ((ConstantBigDecimal)expression.result_).setObject(((BigDecimal)serializable).setScale(n2, 3));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_DECIMAL", numberFormatException);
                        }
                        object = queryLogger.message(4L, theClassName, "evaluate_DECIMAL", "RTLPCTD", new Object[]{expression2.result_.getObject()});
                        throw new QueryException((String)object, numberFormatException, new Object[]{theClassName, "evaluate_DECIMAL"});
                    }
                }
                case 6: 
                case 8: {
                    try {
                        serializable = new BigDecimal(((ConstantDouble)expression2.result_).getDouble());
                        ((ConstantBigDecimal)expression.result_).setObject(((BigDecimal)serializable).setScale(n2, 3));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_DECIMAL", numberFormatException);
                        }
                        object = queryLogger.message(4L, theClassName, "evaluate_DECIMAL", "RTLPCTD", new Object[]{expression2.result_.getObject()});
                        throw new QueryException((String)object, numberFormatException, new Object[]{theClassName, "evaluate_DECIMAL"});
                    }
                }
                case 3: {
                    ((ConstantBigDecimal)expression.result_).setBigDecimal(((BigDecimal)expression2.result_.getObject()).setScale(n2, 3), n);
                    break;
                }
                case 1: {
                    try {
                        serializable = new BigDecimal((String)expression2.result_.getObject());
                        ((ConstantBigDecimal)expression.result_).setObject(((BigDecimal)serializable).setScale(n2, 3));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_DECIMAL", numberFormatException);
                        }
                        object = queryLogger.message(4L, theClassName, "evaluate_DECIMAL", "RTSTVF", new Object[]{expression2.result_.getObject(), new String("DECIMAL")});
                        throw new QueryException((String)object, numberFormatException, new Object[]{theClassName, "evaluate_DECIMAL"});
                    }
                }
            }
        }
    }

    private void evaluate_DIGITS(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 5: {
                    expression.result_.setObject(String.valueOf(Math.abs(((ConstantShort)expression2.result_).getShort())));
                    break;
                }
                case -6: {
                    expression.result_.setObject(String.valueOf(Math.abs(((ConstantByte)expression2.result_).getByte())));
                    break;
                }
                case -5: {
                    expression.result_.setObject(String.valueOf(Math.abs(((ConstantLong)expression2.result_).getLong())));
                    break;
                }
                case 4: {
                    expression.result_.setObject(String.valueOf(Math.abs(((ConstantInt)expression2.result_).getInt())));
                    break;
                }
                case 3: {
                    expression.result_.setObject(expression2.result_.getObject().toString());
                }
            }
        }
    }

    private void evaluate_DOUBLE(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 5: {
                    ((ConstantDouble)expression.result_).setDouble(((ConstantShort)expression2.result_).getShort());
                    break;
                }
                case -6: {
                    ((ConstantDouble)expression.result_).setDouble(((ConstantByte)expression2.result_).getByte());
                    break;
                }
                case -5: {
                    ((ConstantDouble)expression.result_).setDouble(((ConstantLong)expression2.result_).getLong());
                    break;
                }
                case 4: {
                    ((ConstantDouble)expression.result_).setDouble(((ConstantInt)expression2.result_).getInt());
                    break;
                }
                case 7: {
                    ((ConstantDouble)expression.result_).setDouble(((ConstantFloat)expression2.result_).getFloat());
                    break;
                }
                case 6: 
                case 8: {
                    ((ConstantDouble)expression.result_).setDouble(((ConstantDouble)expression2.result_).getDouble());
                    break;
                }
                case 3: {
                    ((ConstantDouble)expression.result_).setDouble(((BigDecimal)expression2.result_.getObject()).doubleValue());
                    break;
                }
                case 1: {
                    try {
                        ((ConstantDouble)expression.result_).setDouble(Double.parseDouble((String)expression2.result_.getObject()));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_DOUBLE", numberFormatException);
                        }
                        String string = queryLogger.message(4L, theClassName, "evaluate_DOUBLE", "RTSTVF", new Object[]{expression2.result_.getObject(), new String("DOUBLE")});
                        throw new QueryException(string, numberFormatException, new Object[]{theClassName, "evaluate_DOUBLE"});
                    }
                }
            }
        }
    }

    private void evaluate_HOUR(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            Calendar calendar = Calendar.getInstance();
            switch (expression2.result_.getType()) {
                case 2002: {
                    ((ConstantInt)expression.result_).setInt(((ConstantDuration)expression2.result_).getHour());
                    break;
                }
                case 3: {
                    ConstantBigDecimal constantBigDecimal = (ConstantBigDecimal)expression2.result_;
                    ConstantDuration constantDuration = FunctionScalarSQL.decimal2duration(constantBigDecimal);
                    ((ConstantInt)expression.result_).setInt(constantDuration.getHour());
                    break;
                }
                case 92: {
                    calendar.setTime((Time)expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt(calendar.get(11));
                    break;
                }
                case 93: {
                    calendar.setTime((Timestamp)expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt(calendar.get(11));
                    break;
                }
                case 1: {
                    Object object = OSQLMain.char2Time(new StringBuffer(expression2.result_.getObject().toString()));
                    calendar.setTime((java.util.Date)object);
                    ((ConstantInt)expression.result_).setInt(calendar.get(11));
                    break;
                }
            }
        }
    }

    private void evaluate_INTEGER(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 5: {
                    ((ConstantInt)expression.result_).setInt(((ConstantShort)expression2.result_).getShort());
                    break;
                }
                case -6: {
                    ((ConstantInt)expression.result_).setInt(((ConstantByte)expression2.result_).getByte());
                    break;
                }
                case -5: {
                    if (((ConstantLong)expression2.result_).getLong() > Integer.MIN_VALUE && ((ConstantLong)expression2.result_).getLong() < Integer.MAX_VALUE) {
                        ((ConstantInt)expression.result_).setInt((int)((ConstantLong)expression2.result_).getLong());
                        break;
                    }
                    String string = queryLogger.message(4L, theClassName, "evaluate_INTEGER", "AOODANDTC", new Object[]{new String("INTEGER")});
                    throw new QueryException(string);
                }
                case 4: {
                    ((ConstantInt)expression.result_).setInt(((ConstantInt)expression2.result_).getInt());
                    break;
                }
                case 7: {
                    if (((ConstantFloat)expression2.result_).getFloat() > -2.1474836E9f && ((ConstantFloat)expression2.result_).getFloat() < 2.1474836E9f) {
                        ((ConstantInt)expression.result_).setInt((int)((ConstantFloat)expression2.result_).getFloat());
                        break;
                    }
                    String string = queryLogger.message(4L, theClassName, "evaluate_INTEGER", "AOODANDTC", new Object[]{new String("INTEGER")});
                    throw new QueryException(string);
                }
                case 6: 
                case 8: {
                    if (((ConstantDouble)expression2.result_).getDouble() > -2.147483648E9 && ((ConstantDouble)expression2.result_).getDouble() < 2.147483647E9) {
                        ((ConstantInt)expression.result_).setInt((int)((ConstantDouble)expression2.result_).getDouble());
                        break;
                    }
                    String string = queryLogger.message(4L, theClassName, "evaluate_INTEGER", "AOODANDTC", new Object[]{new String("INTEGER")});
                    throw new QueryException(string);
                }
                case 3: {
                    if (((BigDecimal)expression2.result_.getObject()).doubleValue() > -2.147483648E9 && ((BigDecimal)expression2.result_.getObject()).doubleValue() < 2.147483647E9) {
                        ((ConstantInt)expression.result_).setInt(((BigDecimal)expression2.result_.getObject()).intValue());
                        break;
                    }
                    String string = queryLogger.message(4L, theClassName, "evaluate_INTEGER", "AOODANDTC", new Object[]{new String("INTEGER")});
                    throw new QueryException(string);
                }
                case 1: {
                    try {
                        ((ConstantInt)expression.result_).setInt(Integer.parseInt((String)expression2.result_.getObject()));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_INTEGER", numberFormatException);
                        }
                        String string = queryLogger.message(4L, theClassName, "evaluate_INTEGER", "RTSTVF", new Object[]{expression2.result_.getObject(), new String("INTEGER")});
                        throw new QueryException(string, numberFormatException, new Object[]{theClassName, "evaluate_INTEGER"});
                    }
                }
            }
        }
    }

    private void evaluate_LOWER(ExpressionTerm expressionTerm, Plan plan) throws QueryException {
        FunctionScalarSQL.to_upper_lower(plan.variables_, expressionTerm, 7);
    }

    private void evaluate_MICROSECOND(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            Calendar calendar = Calendar.getInstance();
            switch (expression2.result_.getType()) {
                case 2002: {
                    ((ConstantInt)expression.result_).setInt(((ConstantDuration)expression2.result_).getMicrosecond());
                    break;
                }
                case 3: {
                    ConstantBigDecimal constantBigDecimal = (ConstantBigDecimal)expression2.result_;
                    ConstantDuration constantDuration = FunctionScalarSQL.decimal2duration(constantBigDecimal);
                    ((ConstantInt)expression.result_).setInt(constantDuration.getMicrosecond());
                    break;
                }
                case 93: {
                    ((ConstantInt)expression.result_).setInt(((Timestamp)expression2.result_.getObject()).getNanos() / 1000);
                    break;
                }
                case 1: {
                    Object object = OSQLMain.char2Timestamp(new StringBuffer(expression2.result_.getObject().toString()));
                    ((ConstantInt)expression.result_).setInt(((Timestamp)object).getNanos() / 1000);
                    break;
                }
            }
        }
    }

    private void evaluate_MINUTE(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            Calendar calendar = Calendar.getInstance();
            switch (expression2.result_.getType()) {
                case 2002: {
                    ((ConstantInt)expression.result_).setInt(((ConstantDuration)expression2.result_).getMinute());
                    break;
                }
                case 3: {
                    ConstantBigDecimal constantBigDecimal = (ConstantBigDecimal)expression2.result_;
                    ConstantDuration constantDuration = FunctionScalarSQL.decimal2duration(constantBigDecimal);
                    ((ConstantInt)expression.result_).setInt(constantDuration.getMinute());
                    break;
                }
                case 92: {
                    calendar.setTime((Time)expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt(calendar.get(12));
                    break;
                }
                case 93: {
                    calendar.setTime((Timestamp)expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt(calendar.get(12));
                    break;
                }
                case 1: {
                    Object object = OSQLMain.char2Time(new StringBuffer(expression2.result_.getObject().toString()));
                    calendar.setTime((java.util.Date)object);
                    ((ConstantInt)expression.result_).setInt(calendar.get(12));
                    break;
                }
            }
        }
    }

    private void evaluate_MONTH(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            Calendar calendar = Calendar.getInstance();
            switch (expression2.result_.getType()) {
                case 2002: {
                    ((ConstantInt)expression.result_).setInt(((ConstantDuration)expression2.result_).getMonth());
                    break;
                }
                case 3: {
                    ConstantBigDecimal constantBigDecimal = (ConstantBigDecimal)expression2.result_;
                    ConstantDuration constantDuration = FunctionScalarSQL.decimal2duration(constantBigDecimal);
                    ((ConstantInt)expression.result_).setInt(constantDuration.getMonth());
                    break;
                }
                case 91: {
                    calendar.setTime((java.util.Date)expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt(calendar.get(2) + 1);
                    break;
                }
                case 93: {
                    calendar.setTime((Timestamp)expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt(calendar.get(2) + 1);
                    break;
                }
                case 1: {
                    Object object = OSQLMain.char2Date(new StringBuffer(expression2.result_.getObject().toString()));
                    calendar.setTime((java.util.Date)object);
                    ((ConstantInt)expression.result_).setInt(calendar.get(2) + 1);
                    break;
                }
            }
        }
    }

    private void evaluate_REAL(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 5: {
                    ((ConstantFloat)expression.result_).setFloat(((ConstantShort)expression2.result_).getShort());
                    break;
                }
                case -6: {
                    ((ConstantFloat)expression.result_).setFloat(((ConstantByte)expression2.result_).getByte());
                    break;
                }
                case -5: {
                    ((ConstantFloat)expression.result_).setFloat(((ConstantLong)expression2.result_).getLong());
                    break;
                }
                case 4: {
                    ((ConstantFloat)expression.result_).setFloat(((ConstantInt)expression2.result_).getInt());
                    break;
                }
                case 7: {
                    ((ConstantFloat)expression.result_).setFloat(((ConstantFloat)expression2.result_).getFloat());
                    break;
                }
                case 6: 
                case 8: {
                    ((ConstantFloat)expression.result_).setFloat((float)((ConstantDouble)expression2.result_).getDouble());
                    break;
                }
                case 3: {
                    ((ConstantFloat)expression.result_).setFloat(((BigDecimal)expression2.result_.getObject()).floatValue());
                    break;
                }
                case 1: {
                    try {
                        ((ConstantFloat)expression.result_).setFloat(Float.parseFloat((String)expression2.result_.getObject()));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_REAL", numberFormatException);
                        }
                        String string = queryLogger.message(4L, theClassName, "evaluate_REAL", "RTSTVF", new Object[]{expression2.result_.getObject(), new String("REAL")});
                        throw new QueryException(string, numberFormatException, new Object[]{theClassName, "evaluate_REAL"});
                    }
                }
            }
        }
    }

    private void evaluate_SECOND(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            Calendar calendar = Calendar.getInstance();
            switch (expression2.result_.getType()) {
                case 2002: {
                    ((ConstantInt)expression.result_).setInt(((ConstantDuration)expression2.result_).getSecond());
                    break;
                }
                case 3: {
                    ConstantBigDecimal constantBigDecimal = (ConstantBigDecimal)expression2.result_;
                    ConstantDuration constantDuration = FunctionScalarSQL.decimal2duration(constantBigDecimal);
                    ((ConstantInt)expression.result_).setInt(constantDuration.getSecond());
                    break;
                }
                case 92: {
                    calendar.setTime((Time)expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt(calendar.get(13));
                    break;
                }
                case 93: {
                    calendar.setTime((Timestamp)expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt(calendar.get(13));
                    break;
                }
                case 1: {
                    Object object = OSQLMain.char2Time(new StringBuffer(expression2.result_.getObject().toString()));
                    calendar.setTime((java.util.Date)object);
                    ((ConstantInt)expression.result_).setInt(calendar.get(13));
                    break;
                }
            }
        }
    }

    private void evaluate_SMALLINT(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 5: {
                    ((ConstantShort)expression.result_).setShort(((ConstantShort)expression2.result_).getShort());
                    break;
                }
                case -6: {
                    ((ConstantShort)expression.result_).setShort(((ConstantByte)expression2.result_).getByte());
                    break;
                }
                case -5: {
                    if (((ConstantLong)expression2.result_).getLong() > Long.MIN_VALUE && ((ConstantLong)expression2.result_).getLong() < Long.MAX_VALUE) {
                        ((ConstantShort)expression.result_).setShort((short)((ConstantLong)expression2.result_).getLong());
                        break;
                    }
                    String string = queryLogger.message(4L, theClassName, "evaluate_SMALLINT", "AOODANDTC", new Object[]{new String("SMALLINT")});
                    throw new QueryException(string);
                }
                case 4: {
                    if (((ConstantInt)expression2.result_).getInt() > Short.MIN_VALUE && ((ConstantInt)expression2.result_).getInt() < Short.MAX_VALUE) {
                        ((ConstantShort)expression.result_).setShort((short)((ConstantInt)expression2.result_).getInt());
                        break;
                    }
                    String string = queryLogger.message(4L, theClassName, "evaluate_SMALLINT", "AOODANDTC", new Object[]{new String("SMALLINT")});
                    throw new QueryException(string);
                }
                case 7: {
                    if (((ConstantFloat)expression2.result_).getFloat() > -32768.0f && ((ConstantFloat)expression2.result_).getFloat() < 32767.0f) {
                        ((ConstantShort)expression.result_).setShort((short)((ConstantFloat)expression2.result_).getFloat());
                        break;
                    }
                    String string = queryLogger.message(4L, theClassName, "evaluate_SMALLINT", "AOODANDTC", new Object[]{new String("SMALLINT")});
                    throw new QueryException(string);
                }
                case 6: 
                case 8: {
                    if (((ConstantDouble)expression2.result_).getDouble() > -32768.0 && ((ConstantDouble)expression2.result_).getDouble() < 32767.0) {
                        ((ConstantShort)expression.result_).setShort((short)((ConstantDouble)expression2.result_).getDouble());
                        break;
                    }
                    String string = queryLogger.message(4L, theClassName, "evaluate_SMALLINT", "AOODANDTC", new Object[]{new String("SMALLINT")});
                    throw new QueryException(string);
                }
                case 3: {
                    if (((BigDecimal)expression2.result_.getObject()).doubleValue() > -32768.0 && ((BigDecimal)expression2.result_.getObject()).doubleValue() < 32767.0) {
                        ((ConstantShort)expression.result_).setShort(((BigDecimal)expression2.result_.getObject()).shortValue());
                        break;
                    }
                    String string = queryLogger.message(4L, theClassName, "evaluate_SMALLINT", "AOODANDTC", new Object[]{new String("SMALLINT")});
                    throw new QueryException(string);
                }
                case 1: {
                    try {
                        ((ConstantShort)expression.result_).setShort(Short.parseShort((String)expression2.result_.getObject()));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_SMALLINT", numberFormatException);
                        }
                        String string = queryLogger.message(4L, theClassName, "evaluate_SMALLINT", "RTSTVF", new Object[]{expression2.result_.getObject(), new String("SMALLINT")});
                        throw new QueryException(string, numberFormatException, new Object[]{theClassName, "evaluate_SMALLINT"});
                    }
                }
            }
        }
    }

    private void evaluate_BOOLEAN(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            Integer n = null;
            Object var6_5 = null;
            boolean bl = false;
            switch (expression2.result_.getType()) {
                case 5: {
                    n = new Integer(((ConstantShort)expression2.result_).getShort());
                    break;
                }
                case -6: {
                    n = new Integer(((ConstantByte)expression2.result_).getByte());
                    break;
                }
                case 4: {
                    n = new Integer(((ConstantInt)expression2.result_).getInt());
                    break;
                }
                default: {
                    String string = queryLogger.message(4L, theClassName, "evaluate_BOOLEAN", "RTILBTM", null);
                    throw new QueryException(string);
                }
            }
            if (n != null) {
                if (n == 1) {
                    bl = true;
                } else if (n == 0) {
                    bl = false;
                } else {
                    String string = queryLogger.message(4L, theClassName, "evaluate_BOOLEAN", "RTILVFB", new Object[]{n});
                    throw new QueryException(string);
                }
            }
            ((ConstantBoolean)expression.result_).setBoolean(bl);
        }
    }

    private void evaluate_BIGINT(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 5: {
                    ((ConstantLong)expression.result_).setLong(((ConstantShort)expression2.result_).getShort());
                    break;
                }
                case -6: {
                    ((ConstantLong)expression.result_).setLong(((ConstantByte)expression2.result_).getByte());
                    break;
                }
                case -5: {
                    ((ConstantLong)expression.result_).setLong(((ConstantLong)expression2.result_).getLong());
                    break;
                }
                case 4: {
                    ((ConstantLong)expression.result_).setLong(((ConstantInt)expression2.result_).getInt());
                    break;
                }
                case 7: {
                    ((ConstantLong)expression.result_).setLong((long)((ConstantFloat)expression2.result_).getFloat());
                    break;
                }
                case 6: 
                case 8: {
                    ((ConstantLong)expression.result_).setLong((long)((ConstantDouble)expression2.result_).getDouble());
                    break;
                }
                case 3: {
                    if (((BigDecimal)expression2.result_.getObject()).doubleValue() > -9.223372036854776E18 && ((BigDecimal)expression2.result_.getObject()).doubleValue() < 9.223372036854776E18) {
                        ((ConstantLong)expression.result_).setLong(((BigDecimal)expression2.result_.getObject()).longValue());
                        break;
                    }
                    String string = queryLogger.message(4L, theClassName, "evaluate_BIGINT", "AOODANDTC", new Object[]{new String("BIGINT")});
                    throw new QueryException(string);
                }
                case 1: {
                    try {
                        ((ConstantLong)expression.result_).setLong(Long.parseLong((String)expression2.result_.getObject()));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_BIGINT", numberFormatException);
                        }
                        String string = queryLogger.message(4L, theClassName, "evaluate_BIGINT", "RTSTVF", new Object[]{expression2.result_.getObject(), new String("BIGINT")});
                        throw new QueryException(string, numberFormatException, new Object[]{theClassName, "evaluate_BIGINT"});
                    }
                }
            }
        }
    }

    private void evaluate_TIME(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 1: {
                    expression.result_.setObject(OSQLMain.char2Time(new StringBuffer(expression2.result_.getObject().toString())));
                    break;
                }
                case 92: {
                    expression.result_.assign(expression2.result_);
                    break;
                }
                case 93: {
                    expression.result_.setObject(new Time(((Timestamp)expression2.result_.getObject()).getTime()));
                    break;
                }
            }
        }
    }

    private void evaluate_TIMESTAMP(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            Calendar calendar = Calendar.getInstance();
            switch (expression2.result_.getType()) {
                case 1: {
                    expression.result_.setObject(OSQLMain.char2Timestamp(new StringBuffer(expression2.result_.getObject().toString())));
                    break;
                }
                case 93: {
                    expression.result_.assign(expression2.result_);
                    break;
                }
            }
        }
    }

    private void evaluate_UPPER(ExpressionTerm expressionTerm, Plan plan) throws QueryException {
        FunctionScalarSQL.to_upper_lower(plan.variables_, expressionTerm, 6);
    }

    private void evaluate_YEAR(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            Calendar calendar = Calendar.getInstance();
            switch (expression2.result_.getType()) {
                case 2002: {
                    ((ConstantInt)expression.result_).setInt(((ConstantDuration)expression2.result_).getYear());
                    break;
                }
                case 3: {
                    ConstantBigDecimal constantBigDecimal = (ConstantBigDecimal)expression2.result_;
                    ConstantDuration constantDuration = FunctionScalarSQL.decimal2duration(constantBigDecimal);
                    ((ConstantInt)expression.result_).setInt(constantDuration.getYear());
                    break;
                }
                case 91: {
                    calendar.setTime((java.util.Date)expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt(calendar.get(1));
                    break;
                }
                case 93: {
                    calendar.setTime((Timestamp)expression2.result_.getObject());
                    ((ConstantInt)expression.result_).setInt(calendar.get(1));
                    break;
                }
                case 1: {
                    Object object = OSQLMain.char2Date(new StringBuffer(expression2.result_.getObject().toString()));
                    calendar.setTime((java.util.Date)object);
                    ((ConstantInt)expression.result_).setInt(calendar.get(1));
                    break;
                }
            }
        }
    }

    private void evaluate_POSSTR(Expression expression, Plan plan) throws QueryException {
        int n;
        int n2 = this.getArgs().size();
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (expression2.result_.isNull_) {
            return;
        }
        Expression expression3 = (Expression)this.getArgs().get(1);
        expression.result_.isNull_ = expression3.result_.isNull_;
        if (expression3.result_.isNull_) {
            return;
        }
        String string = null;
        String string2 = null;
        Expression expression4 = null;
        if (n2 > 2) {
            expression4 = (Expression)this.getArgs().get(2);
            expression.result_.isNull_ = expression4.result_.isNull_;
            if (expression4.result_.isNull_) {
                return;
            }
            if (expression3.result_ instanceof ConstantString) {
                string2 = ((ConstantString)expression3.result_).getString();
            } else if (expression3.result_ instanceof ConstantCharacter) {
                string2 = ((ConstantCharacter)expression3.result_).getObject().toString();
            }
            n = ((ConstantInt)expression4.result_).getInt() - 1;
            string = n < 0 || n > string2.length() ? null : string2.substring(n);
        } else if (expression3.result_ instanceof ConstantString) {
            string = ((ConstantString)expression3.result_).getString();
        } else if (expression3.result_ instanceof ConstantCharacter) {
            string = ((ConstantCharacter)expression3.result_).getObject().toString();
        }
        n = 0;
        switch (expression2.result_.getType()) {
            case -1: 
            case 1: 
            case 12: {
                if (string == null) {
                    n = 0;
                } else {
                    if (expression2.result_ instanceof ConstantString) {
                        n = string.indexOf(((ConstantString)expression2.result_).getString());
                    }
                    if (expression2.result_ instanceof ConstantCharacter) {
                        n = string.indexOf(((ConstantCharacter)expression2.result_).getObject().toString());
                    }
                    ++n;
                }
                if (n2 > 2 && n > 0) {
                    n = n + ((ConstantInt)expression4.result_).getInt() - 1;
                }
                ((ConstantInt)expression.result_).setInt(n);
                break;
            }
        }
    }

    private void evaluate_LENGTH(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        String string = null;
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (expression2.result_.isNull_) {
            return;
        }
        if (expression2.result_ instanceof ConstantString) {
            string = ((ConstantString)expression2.result_).getString();
        } else if (expression2.result_ instanceof ConstantCharacter) {
            string = ((ConstantCharacter)expression2.result_).getObject().toString();
        }
        int n = 0;
        switch (expression2.result_.getType()) {
            case -1: 
            case 1: 
            case 12: {
                n = string.length();
                ((ConstantInt)expression.result_).setInt(n);
                break;
            }
        }
    }

    private void evaluate_BIT_LENGTH(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        String string = null;
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (expression2.result_.isNull_) {
            return;
        }
        if (expression2.result_ instanceof ConstantString) {
            string = ((ConstantString)expression2.result_).getString();
        } else if (expression2.result_ instanceof ConstantCharacter) {
            string = ((ConstantCharacter)expression2.result_).getObject().toString();
        }
        int n = 0;
        switch (expression2.result_.getType()) {
            case -1: 
            case 1: 
            case 12: {
                n = string.length() * 8;
                ((ConstantInt)expression.result_).setInt(n);
                break;
            }
        }
    }

    private void evaluate_TRIM(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (expression2.result_.isNull_) {
            return;
        }
        Expression expression3 = (Expression)this.getArgs().get(1);
        Expression expression4 = null;
        if (this.getArgs().size() == 3) {
            expression4 = (Expression)this.getArgs().get(2);
        }
        String string = null;
        String string2 = null;
        if (expression2.result_ instanceof ConstantString) {
            string2 = ((ConstantString)expression2.result_).getString();
        } else if (expression2.result_ instanceof ConstantCharacter) {
            string = ((ConstantCharacter)expression2.result_).getObject().toString();
        }
        char c = '\u0000';
        if (expression4 != null && !expression4.result_.isNull_) {
            c = ((ConstantString)expression4.result_).getString().charAt(0);
        }
        block0 : switch (expression2.result_.getType()) {
            case -1: 
            case 1: 
            case 12: {
                switch (((ConstantInt)expression3.result_).getInt()) {
                    case 0: {
                        if (expression4 == null) {
                            string = string2.trim();
                        } else {
                            int n;
                            int n2 = string2.length();
                            for (n = 0; n < n2 && string2.charAt(n) == c; ++n) {
                            }
                            while (n < n2 && string2.charAt(n2 - 1) == c) {
                                --n2;
                            }
                            string = n > 0 || n2 < string2.length() ? string2.substring(n, n2) : string2;
                        }
                        ((ConstantString)expression.result_).setString(string);
                        break block0;
                    }
                    case 1: {
                        int n;
                        int n3 = string2.length();
                        if (expression4 == null) {
                            for (n = 0; n < n3 && Character.isWhitespace(string2.charAt(n)); ++n) {
                            }
                        } else {
                            while (n < n3 && string2.charAt(n) == c) {
                                ++n;
                            }
                        }
                        string = n > 0 ? string2.substring(n, n3) : string2;
                        ((ConstantString)expression.result_).setString(string);
                        break block0;
                    }
                    case 2: {
                        int n;
                        int n4 = 0;
                        if (expression4 == null) {
                            for (n = string2.length(); n4 < n && Character.isWhitespace(string2.charAt(n - 1)); --n) {
                            }
                        } else {
                            while (n4 < n && string2.charAt(n - 1) == c) {
                                --n;
                            }
                        }
                        string = n < string2.length() ? string2.substring(n4, n) : string2;
                        ((ConstantString)expression.result_).setString(string);
                        break block0;
                    }
                }
            }
        }
    }

    private void evaluate_SUBSTR(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (expression2.result_.isNull_) {
            return;
        }
        Expression expression3 = (Expression)this.getArgs().get(1);
        expression.result_.isNull_ = expression3.result_.isNull_;
        if (expression3.result_.isNull_) {
            return;
        }
        Expression expression4 = null;
        if (this.getArgs().size() == 3) {
            expression4 = (Expression)this.getArgs().get(2);
            expression.result_.isNull_ = expression4.result_.isNull_;
            if (expression4.result_.isNull_) {
                return;
            }
        }
        long l = 0L;
        String string = null;
        String string2 = ((ConstantString)expression2.result_).getString();
        switch (expression2.result_.getType()) {
            case -1: 
            case 1: 
            case 12: {
                long l2 = string2.length();
                long l3 = ((ConstantInt)expression3.result_).getInt();
                if (--l3 < 0L || l3 > l2) {
                    String string3 = queryLogger.message(4L, theClassName, "evaluate_SUBSTR", "TSTASFOR", null);
                    throw new QueryException(string3);
                }
                if (expression4 != null) {
                    long l4;
                    l = ((ConstantInt)expression4.result_).getInt();
                    if ((l += (l4 = l - (l - l3))) < 0L || l > l2) {
                        String string4 = queryLogger.message(4L, theClassName, "evaluate_SUBSTR", "TSTASFOR", null);
                        throw new QueryException(string4);
                    }
                }
                if (expression4 != null) {
                    string = string2.substring((int)l3, (int)l);
                    ((ConstantString)expression.result_).setString(string);
                    break;
                }
                string = string2.substring((int)l3);
                ((ConstantString)expression.result_).setString(string);
                break;
            }
        }
    }

    private void evaluateSQLFunctionArgs(Plan plan) throws QueryException {
        Iterator iterator = this.getArgs().iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            expression.evaluate(plan);
        }
    }

    int getCode() {
        return this.function_;
    }

    private static void to_upper_lower(PlanVariables planVariables, ExpressionTerm expressionTerm, int n) {
        Expression expression = (Expression)((TermFunctionScalar)expressionTerm.term_).getFunctionScalar().getArgs().get(0);
        ConstantString constantString = null;
        if (expression.result_ instanceof ConstantString) {
            constantString = (ConstantString)expression.result_;
        } else if (expression.result_ instanceof ConstantCharacter) {
            constantString = new ConstantString(((ConstantCharacter)expression.result_).getObject().toString());
        }
        if (constantString.isNull_) {
            expressionTerm.result_.isNull_ = true;
        } else {
            expressionTerm.result_.isNull_ = false;
            if (n == 6) {
                ((ConstantString)expressionTerm.result_).setObject(((String)constantString.getObject()).toUpperCase());
            } else {
                ((ConstantString)expressionTerm.result_).setObject(((String)constantString.getObject()).toLowerCase());
            }
        }
    }

    private void evaluate_TINYINT(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 5: {
                    ((ConstantByte)expression.result_).setByte((byte)((ConstantShort)expression2.result_).getShort());
                    break;
                }
                case -5: {
                    ((ConstantByte)expression.result_).setByte((byte)((ConstantLong)expression2.result_).getLong());
                    break;
                }
                case 4: {
                    ((ConstantByte)expression.result_).setByte((byte)((ConstantInt)expression2.result_).getInt());
                    break;
                }
                case 7: {
                    ((ConstantByte)expression.result_).setByte((byte)((ConstantFloat)expression2.result_).getFloat());
                    break;
                }
                case 6: 
                case 8: {
                    ((ConstantByte)expression.result_).setByte((byte)((ConstantDouble)expression2.result_).getDouble());
                    break;
                }
                case 3: {
                    if (((BigDecimal)expression2.result_.getObject()).doubleValue() > -9.223372036854776E18 && ((BigDecimal)expression2.result_.getObject()).doubleValue() < 9.223372036854776E18) {
                        ((ConstantByte)expression.result_).setByte(((BigDecimal)expression2.result_.getObject()).byteValue());
                        break;
                    }
                    String string = queryLogger.message(4L, theClassName, "evaluate_TINYINT", "AOODANDTC", new Object[]{new String("BIGINT")});
                    throw new QueryException(string);
                }
                case 1: {
                    try {
                        ((ConstantByte)expression.result_).setByte(Byte.parseByte((String)expression2.result_.getObject()));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_TINYINT", numberFormatException);
                        }
                        String string = queryLogger.message(4L, theClassName, "evaluate_TINYINT", "RTSTVF", new Object[]{expression2.result_.getObject(), new String("TINYINT")});
                        throw new QueryException(string, numberFormatException, new Object[]{theClassName, "evaluate_TINYINT"});
                    }
                }
            }
        }
    }

    private void evaluate_BINTEGER(Expression expression, Plan plan) throws QueryException {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case 1: 
                case 12: {
                    try {
                        expression.result_.setObject(new BigInteger(((ConstantString)expression2.result_).getString()));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (queryLogger.isLogging()) {
                            queryLogger.exception(512L, theClassName, "evaluate_BIGINTEGER", numberFormatException);
                        }
                        String string = queryLogger.message(4L, theClassName, "evaluate_BIGINTEGER", "RTSTVF", new Object[]{expression2.result_.getObject(), new String("BIGINTEGER")});
                        throw new QueryException(string, numberFormatException, new Object[]{theClassName, "evaluate_BIGINTEGER"});
                    }
                }
            }
        }
    }

    private long datestr2days(String string) throws QueryException {
        return this.date2days(OSQLMain.char2Date(new StringBuffer(string)));
    }

    private long date2days(Object object) {
        long l = 86400000L;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, 0, 1);
        int n = calendar.get(15) + calendar.get(16);
        long l2 = calendar.getTime().getTime() + (long)n;
        Calendar calendar2 = Calendar.getInstance();
        calendar2.clear();
        calendar2.setTime((java.util.Date)object);
        int n2 = calendar2.get(15) + calendar2.get(16);
        long l3 = calendar2.getTime().getTime() + (long)n2;
        long l4 = l3 / l;
        long l5 = Math.abs(l2 / l);
        long l6 = l4 < 0L ? l5 - Math.abs(l4) + 1L : l5 + l4;
        if (++l6 > 36217L) {
            l6 = l6 > 72741L ? l6 - 2L : l6 - 1L;
        }
        return l6;
    }

    public static String dec2DTSTR(ConstantBigDecimal constantBigDecimal, String string) {
        int n = constantBigDecimal.getPrecision();
        String string2 = string;
        String string3 = null;
        String string4 = "0000000";
        if (n == 6) {
            string4 = "000000";
        } else if (n == 20) {
            int n2 = string.indexOf(46);
            if (n2 != -1) {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2);
            }
            string4 = "00000000000000";
            n = 14;
        }
        String string5 = string4 + string2;
        string5 = string5.substring(string5.length() - n);
        if (string3 != null) {
            string5 = string5 + string3;
        }
        return string5;
    }

    public static ConstantDuration decimal2duration(ConstantBigDecimal constantBigDecimal) {
        ConstantDuration constantDuration = constantBigDecimal.getCDR();
        if (constantDuration != null) {
            return constantDuration;
        }
        String string = constantBigDecimal.getObject().toString();
        boolean bl = true;
        if (string.charAt(0) == '-') {
            bl = false;
            string = string.substring(1);
        }
        String string2 = FunctionScalarSQL.dec2DTSTR(constantBigDecimal, string);
        int n = string2.length();
        ConstantDuration constantDuration2 = new ConstantDuration();
        if (n == 8) {
            constantDuration2.setDate(Integer.valueOf(string2.substring(6)), Integer.valueOf(string2.substring(4, 6)), Integer.valueOf(string2.substring(0, 4)));
        } else if (n == 6) {
            constantDuration2.setTime(Integer.valueOf(string2.substring(4)), Integer.valueOf(string2.substring(2, 4)), Integer.valueOf(string2.substring(0, 2)));
        } else if (n == 21) {
            constantDuration2.setTimestamp(Integer.valueOf(string2.substring(15)), Integer.valueOf(string2.substring(12, 14)), Integer.valueOf(string2.substring(10, 12)), Integer.valueOf(string2.substring(8, 10)), Integer.valueOf(string2.substring(6, 8)), Integer.valueOf(string2.substring(4, 6)), Integer.valueOf(string2.substring(0, 4)));
        } else if (n == 14) {
            constantDuration2.setTimestamp(0, Integer.valueOf(string2.substring(12, 14)), Integer.valueOf(string2.substring(10, 12)), Integer.valueOf(string2.substring(8, 10)), Integer.valueOf(string2.substring(6, 8)), Integer.valueOf(string2.substring(4, 6)), Integer.valueOf(string2.substring(0, 4)));
        }
        if (!bl) {
            constantDuration2.setPlus(false);
        }
        return constantDuration2;
    }

    private void evaluate_CHAR1(Expression expression, Plan plan) {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        String string = null;
        if (expression2.result_.isNull_) {
            return;
        }
        switch (expression2.result_.getType()) {
            case 1: 
            case 12: {
                if (expression2.result_ instanceof ConstantString) {
                    string = ((ConstantString)expression2.result_).getString();
                }
                if (expression2.result_ instanceof ConstantCharacter) {
                    string = ((ConstantCharacter)expression2.result_).getObject().toString();
                }
                ((ConstantCharacter)expression.result_).setChar(string.charAt(0));
                break;
            }
        }
    }

    private void setResultDate(Expression expression, int n) {
        if (--n > 36217) {
            n = n > 72741 ? n + 2 : n + 1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, 0, 1);
        calendar.add(6, n);
        expression.result_.setObject(new Date(calendar.getTime().getTime()));
    }

    private void evaluate_CALENDAR(Expression expression, Plan plan) {
        Expression expression2 = (Expression)this.getArgs().get(0);
        expression.result_.isNull_ = expression2.result_.isNull_;
        GregorianCalendar gregorianCalendar = null;
        if (!expression2.result_.isNull_) {
            switch (expression2.result_.getType()) {
                case -5: {
                    gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(new java.util.Date((Long)expression2.result_.getObject()));
                    expression.result_.setObject(gregorianCalendar);
                    break;
                }
                case 4: {
                    gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(new java.util.Date(((Integer)expression2.result_.getObject()).longValue()));
                    expression.result_.setObject(gregorianCalendar);
                    break;
                }
            }
        }
    }
}

