/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.eval;

import com.ibm.ObjectQuery.IObjectQueryServiceImpl;
import com.ibm.ObjectQuery.IPreparedQuery;
import com.ibm.ObjectQuery.IQueryLogger;
import com.ibm.ObjectQuery.engine.QurTemplate;
import com.ibm.ObjectQuery.eval.Plan;
import com.ibm.ObjectQuery.eval.PlanCursor;
import com.ibm.ObjectQuery.eval._PlanParser;
import com.ibm.ObjectQuery.java_cup.runtime.Symbol;
import com.ibm.websphere.ejbquery.QueryException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;

public class PlanProcessor {
    private static String theClassName = PlanProcessor.class.getName();
    private static IQueryLogger queryLogger = null;

    public static PlanCursor evaluatePlan(Plan plan, Object[] objectArray, Properties properties, Properties properties2) throws QueryException {
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "evaluatePlan", new Object[]{plan, properties, properties2});
        }
        try {
            PlanCursor planCursor = new PlanCursor(plan, objectArray);
            if (queryLogger.isLogging()) {
                queryLogger.exit(256L, theClassName, "evaluatePlan", planCursor);
            }
            return planCursor;
        }
        catch (QueryException queryException) {
            if (queryException.getException() != null) {
                queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
            }
            throw queryException;
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "evaluatePlan", exception);
            }
            String string = queryLogger.message(4L, theClassName, "evaluatePlan", "RTPPERR", null);
            queryLogger.stackTrace(exception, 4L, theClassName, "evaluatePlan");
            throw new QueryException(string);
        }
    }

    public static PlanCursor evaluatePlan(Plan plan, Object[] objectArray) throws QueryException {
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "evaluatePlan", new Object[]{plan, objectArray});
        }
        try {
            PlanCursor planCursor = new PlanCursor(plan, objectArray);
            if (queryLogger.isLogging()) {
                queryLogger.exit(256L, theClassName, "evaluatePlan", planCursor);
            }
            return planCursor;
        }
        catch (QueryException queryException) {
            if (queryException.getException() != null) {
                queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
            }
            throw queryException;
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "evaluatePlan", exception);
            }
            String string = queryLogger.message(4L, theClassName, "evaluatePlan", "RTPPERR", null);
            queryLogger.stackTrace(exception, 4L, theClassName, "evaluatePlan");
            throw new QueryException(string);
        }
    }

    public static Plan buildPlan(String string, boolean bl, Object[] objectArray, IPreparedQuery iPreparedQuery) throws QueryException {
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "buildPlan", new Object[]{string, new Boolean(bl), objectArray, iPreparedQuery});
        }
        try {
            Object object = null;
            if (iPreparedQuery != null) {
                Object object2 = object = iPreparedQuery.getCacheEntry() == null ? null : ((QurTemplate)iPreparedQuery.getCacheEntry()).getPlan();
            }
            if (object == null || object instanceof String) {
                object = new Plan(bl);
                ((Plan)object).setParmTypes(objectArray);
                _PlanParser _PlanParser2 = new _PlanParser((Plan)object, string);
                QueryException queryException = _PlanParser2.getQueryException();
                if (queryException != null) {
                    if (queryException.getException() != null) {
                        queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
                    }
                    throw queryException;
                }
                Symbol symbol = _PlanParser2.parse();
                queryException = _PlanParser2.getQueryException();
                if (queryException != null) {
                    if (queryException.getException() != null) {
                        queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
                    }
                    throw queryException;
                }
                if (iPreparedQuery != null && iPreparedQuery.getCacheEntry() != null) {
                    ((QurTemplate)iPreparedQuery.getCacheEntry()).setPlan(PlanProcessor.dup_a_plan((Plan)object));
                    if (queryLogger.isLogging()) {
                        queryLogger.text(1024L, theClassName, "buildPlan", "Query_plan_object_NOTFOUND in cache, create and set:*** cache KEY***: " + ((QurTemplate)iPreparedQuery.getCacheEntry()).getStringQuery());
                    }
                }
            } else {
                if (iPreparedQuery != null && queryLogger.isLogging()) {
                    queryLogger.text(1024L, theClassName, "buildPlan", "Query_plan_object_FOUND in cache:*** cache KEY***: " + ((QurTemplate)iPreparedQuery.getCacheEntry()).getStringQuery());
                }
                object = PlanProcessor.dup_a_plan((Plan)object);
            }
            if (queryLogger.isLogging()) {
                queryLogger.exit(256L, theClassName, "buildPlan", object);
            }
            if (iPreparedQuery != null && iPreparedQuery.getReplacementSqls() != null) {
                ((Plan)object).modifyStmtAssignSqlQry(iPreparedQuery.getReplacementSqls());
            }
            return (Plan)object;
        }
        catch (QueryException queryException) {
            if (queryException.getException() != null) {
                queryLogger.stackTrace(queryException.getException(), 4L, queryException.getClassname(), queryException.getMethodname());
            }
            throw queryException;
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "buildPlan", exception);
            }
            String string2 = queryLogger.message(4L, theClassName, "buildPlan", "RTPPERR", null);
            queryLogger.stackTrace(exception, 4L, theClassName, "buildPlan");
            throw new QueryException(string2);
        }
    }

    private static Plan dup_a_plan(Plan plan) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(plan);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return (Plan)object;
        }
        catch (IOException iOException) {
            System.out.println("Exception occured in Plan dup_a_plan" + iOException.toString());
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Exception occured in Plan dup_a_plan" + classNotFoundException.toString());
            classNotFoundException.printStackTrace();
        }
        return null;
    }

    static {
        try {
            queryLogger = IObjectQueryServiceImpl.getConfiguration().getLogger();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

