/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asc.bridge.ws.server;

import com.ibm.asc.ca.ChangeAgent;
import com.ibm.asc.ca.IChangeAgent;
import com.ibm.websphere.management.exception.AdminException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class WsAntAgent {
    private String workingDir;
    private IChangeAgent handler;

    public WsAntAgent(Properties properties) throws Exception {
        String string = System.getProperty("user.install.root");
        if (string != null && !string.equals("")) {
            this.workingDir = string + File.separator + "temp";
        } else {
            string = properties.getProperty("wsant.agent.root");
            if (string != null && !string.equals("")) {
                this.workingDir = string + File.separator + "temp";
            }
        }
        if (this.workingDir == null && (string = System.getProperty("was.install.root")) != null && !string.equals("")) {
            this.workingDir = string + File.separator + "temp";
        }
        this.handler = new ChangeAgent();
        this.handler.init(this.workingDir);
    }

    public void invokeAnt(String[] stringArray, String string, String string2) throws AdminException {
        try {
            Properties properties = this.loadPropsFromArray(stringArray);
            File file = new File(string);
            this.handler.invokeAnt(file, properties, string2);
        }
        catch (Exception exception) {
            throw new AdminException(exception.getMessage());
        }
    }

    public byte[] getScript(String string) throws AdminException {
        try {
            File file = new File(string);
            InputStream inputStream = this.handler.getFile(file);
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = inputStream.read(byArray);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    public void putScript(String string, byte[] byArray) throws AdminException {
        try {
            File file = new File(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.handler.putFile(file, byteArrayInputStream);
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    public byte[] getLastLog() throws AdminException {
        try {
            InputStream inputStream = this.handler.getLastLog();
            if (inputStream == null) {
                return null;
            }
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = inputStream.read(byArray);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }

    private Properties loadPropsFromArray(String[] stringArray) throws IOException {
        Object object;
        if (stringArray == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i] + "\n";
            byteArrayOutputStream.write(((String)object).getBytes());
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        object = new Properties();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ((Properties)object).load(byteArrayInputStream);
        return object;
    }

    private byte[] getBytes(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        int n = fileInputStream.read(byArray);
        while (n != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = fileInputStream.read(byArray);
        }
        byteArrayOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }
}

