/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asc.ca;

import com.ibm.asc.bridge.ws.server.ASCProject;
import com.ibm.asc.ca.IChangeAgent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class ChangeAgent
implements IChangeAgent {
    private File _workingDirectory;
    private Properties globalProperties = new Properties();
    private byte[] lastLog = null;

    public void init(String string) throws Exception {
        this._workingDirectory = new File(string);
    }

    public void putFile(File file, InputStream inputStream) throws Exception {
        Object object;
        File file2;
        File file3 = this.getAdjustedFile(file);
        if (file3.exists()) {
            file2 = new File(file3.getPath());
            object = new File(file3.getPath() + ".copy");
            file2.renameTo((File)object);
        }
        if ((file2 = file3.getParentFile()) != null) {
            file2.mkdirs();
        }
        file3.createNewFile();
        object = new FileOutputStream(file3);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
            ((FileOutputStream)object).write(byArray, 0, n);
        }
        ((OutputStream)object).flush();
        ((FileOutputStream)object).close();
    }

    public InputStream getFile(File file) throws Exception {
        File file2 = this.getAdjustedFile(file);
        return new FileInputStream(file2);
    }

    public void invokeAnt(File file, Properties properties, String string) throws Exception {
        this.invokeAnt(file, properties, string, null);
    }

    public void invokeAnt(File file, Properties properties, String string, DefaultLogger[] defaultLoggerArray) throws Exception {
        this.lastLog = null;
        File file2 = this.getAdjustedFile(file);
        ASCProject aSCProject = new ASCProject();
        this.loadProperties(aSCProject, properties);
        if (defaultLoggerArray != null) {
            for (int i = 0; i < defaultLoggerArray.length; ++i) {
                aSCProject.addBuildListener((BuildListener)defaultLoggerArray[i]);
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        DefaultLogger defaultLogger = new DefaultLogger();
        defaultLogger.setErrorPrintStream(printStream);
        defaultLogger.setOutputPrintStream(printStream);
        defaultLogger.setMessageOutputLevel(4);
        aSCProject.addBuildListener((BuildListener)defaultLogger);
        aSCProject.fireBuildStarted();
        aSCProject.init();
        ProjectHelper.configureProject((Project)aSCProject, (File)file2);
        if (string == null) {
            string = aSCProject.getDefaultTarget();
        }
        try {
            aSCProject.executeTarget(string);
            aSCProject.fireBuildFinished(null);
        }
        catch (BuildException buildException) {
            aSCProject.fireBuildFinished(buildException);
            throw buildException;
        }
        finally {
            printStream.flush();
            this.lastLog = byteArrayOutputStream.toByteArray();
        }
    }

    public InputStream getLastLog() {
        if (this.lastLog == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.lastLog);
        return byteArrayInputStream;
    }

    private void loadProperties(ASCProject aSCProject, Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            aSCProject.setProperty(string, properties.getProperty(string));
        }
    }

    private File getAdjustedFile(File file) throws IOException {
        Object object;
        if (file.isAbsolute()) {
            throw new IOException("A method of " + this.getClass().getName() + " was invoked with an absolute file reference (" + file.getPath() + ").  That is not allowed:  File references must be relative.");
        }
        if (file.isDirectory()) {
            throw new IOException("A method of " + this.getClass().getName() + " was invoked with a directory in place of a file reference (" + file.getPath() + ").  That is not allowed.");
        }
        Vector<String> vector = new Vector<String>();
        File file2 = new File(this._workingDirectory.getPath());
        for (object = file.getParentFile(); object != null; object = ((File)object).getParentFile()) {
            vector.add(0, ((File)object).getName());
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            file2 = new File(file2, string);
        }
        return new File(file2, file.getName());
    }

    public String toString() {
        return "ChangeAgent (working directory=" + this._workingDirectory.getAbsolutePath() + ")";
    }
}

