/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.util;

import com.ibm.bsf.util.IOUtils;
import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    public static final String lineSeparator = System.getProperty("line.separator", "\n");
    public static final String lineSeparatorStr = StringUtils.cleanString(lineSeparator);

    public static String classNameToVarName(String string) {
        int n = 0;
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            ++n;
        }
        int n2 = string.lastIndexOf(46);
        String string2 = Introspector.decapitalize(n2 != -1 ? string.substring(n2 + 1) : string);
        if (n > 0) {
            string2 = string2 + "_" + n + "D";
        }
        return StringUtils.getValidIdentifierName(string2);
    }

    public static String cleanString(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block6;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block6;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block6;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String getChars(int n, char c) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getClassName(Class clazz) {
        String string = clazz.getName();
        return clazz.isArray() ? StringUtils.parseDescriptor(string) : string;
    }

    public static String getCommaListFromVector(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append((i > 0 ? ", " : "") + vector.elementAt(i));
        }
        return stringBuffer.toString();
    }

    public static Reader getContentAsReader(URL uRL) throws SecurityException, IllegalArgumentException, IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        try {
            Object object = uRL.getContent();
            if (object == null) {
                throw new IllegalArgumentException("No content.");
            }
            if (object instanceof InputStream) {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
                if (((Reader)inputStreamReader).ready()) {
                    return inputStreamReader;
                }
                throw new FileNotFoundException();
            }
            throw new IllegalArgumentException(object instanceof String ? (String)object : "This URL points to a: " + StringUtils.getClassName(object.getClass()));
        }
        catch (SecurityException securityException) {
            throw new SecurityException("Your JVM's SecurityManager has disallowed this.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("This file was not found: " + uRL);
        }
    }

    public static String getContentAsString(URL uRL) throws SecurityException, IllegalArgumentException, IOException {
        return IOUtils.getStringFromReader(StringUtils.getContentAsReader(uRL));
    }

    public static String getSafeString(String string) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string2 != null) {
                    stringBuffer.append("\"" + string2 + lineSeparatorStr + "\" +" + lineSeparator);
                }
                string2 = StringUtils.cleanString(string3);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stringBuffer.append("\"" + (string2 != null ? string2 : "") + "\"" + lineSeparator);
        return stringBuffer.toString();
    }

    public static URL getURL(URL uRL, String string) throws MalformedURLException {
        return StringUtils.getURL(uRL, string, 1);
    }

    private static URL getURL(URL uRL, String string, int n) throws MalformedURLException {
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
            try {
                uRL2.openStream();
            }
            catch (IOException iOException) {
                throw new MalformedURLException("This file was not found: " + uRL2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = new URL("file", "", string);
            try {
                uRL2.openStream();
            }
            catch (IOException iOException) {
                String string2;
                String string3;
                if (uRL != null && (string3 = new File(string2 = uRL.getFile()).getParent()) != null && n < 3) {
                    return StringUtils.getURL(new URL("file", "", string3 + '/'), string, n + 1);
                }
                throw new MalformedURLException("This file was not found: " + uRL2);
            }
        }
        return uRL2;
    }

    public static String getValidIdentifierName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        stringBuffer.append(Character.isJavaIdentifierStart(cArray[0]) ? cArray[0] : (char)'_');
        for (int i = 1; i < cArray.length; ++i) {
            stringBuffer.append(Character.isJavaIdentifierPart(cArray[i]) ? cArray[i] : (char)'_');
        }
        return stringBuffer.toString();
    }

    public static boolean isValidIdentifierName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (Character.isJavaIdentifierPart(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPackageName(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        if (stringTokenizer.countTokens() % 2 != 1) {
            return false;
        }
        if (!StringUtils.isValidIdentifierName(stringTokenizer.nextToken())) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().equals(".")) {
                return false;
            }
            if (stringTokenizer.hasMoreTokens()) {
                if (StringUtils.isValidIdentifierName(stringTokenizer.nextToken())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static String parseDescriptor(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (cArray[n2] == '[') {
            ++n;
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (cArray[n2++]) {
            case 'B': {
                stringBuffer.append("byte");
                break;
            }
            case 'C': {
                stringBuffer.append("char");
                break;
            }
            case 'D': {
                stringBuffer.append("double");
                break;
            }
            case 'F': {
                stringBuffer.append("float");
                break;
            }
            case 'I': {
                stringBuffer.append("int");
                break;
            }
            case 'J': {
                stringBuffer.append("long");
                break;
            }
            case 'S': {
                stringBuffer.append("short");
                break;
            }
            case 'Z': {
                stringBuffer.append("boolean");
                break;
            }
            case 'L': {
                stringBuffer.append(cArray, n2, cArray.length - n2 - 1);
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }
}

