/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.jrom;

import com.ibm.cs.jrom.JROMValueImpl;
import com.ibm.jrom.JROMComplexValue;
import com.ibm.jrom.JROMType;
import com.ibm.jrom.JROMValue;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class JROMComplexValueImpl
extends JROMValueImpl
implements JROMComplexValue {
    private String typeNamespace;
    private String typeLocalPart;
    private Vector elements = new Vector();
    private Vector attributes = new Vector();

    public JROMComplexValueImpl(String string, String string2) {
        this.typeNamespace = string == null ? null : string.intern();
        this.typeLocalPart = string2.intern();
    }

    public JROMComplexValueImpl(String string, String string2, Vector vector, Vector vector2) {
        this(string, string2);
        this.elements = vector;
        this.attributes = vector2;
    }

    public String getTypeNamespace() {
        return this.typeNamespace;
    }

    public String getTypeLocalPart() {
        return this.typeLocalPart;
    }

    public void setTypeNamespace(String string) {
        this.typeNamespace = string == null ? null : string.intern();
    }

    public void setTypeLocalPart(String string) {
        this.typeLocalPart = string == null ? null : string.intern();
    }

    public boolean isTypeNamespaceEquals(String string) {
        if (this.typeNamespace != null) {
            return this.typeNamespace.equals(string);
        }
        return string == null;
    }

    public boolean isTypeNamespaceEquals(JROMComplexValue jROMComplexValue) {
        return this.isTypeNamespaceEquals(jROMComplexValue.getTypeNamespace());
    }

    public boolean isTypeLocalPartEquals(String string) {
        if (this.typeLocalPart != null) {
            return this.typeLocalPart.equals(string);
        }
        return string == null;
    }

    public boolean isTypeLocalPartEquals(JROMComplexValue jROMComplexValue) {
        return this.isTypeLocalPartEquals(jROMComplexValue.getTypeLocalPart());
    }

    public Iterator getElementValues() {
        return ((AbstractList)this.elements).iterator();
    }

    public Iterator getAttributeValues() {
        return ((AbstractList)this.attributes).iterator();
    }

    public void addElementValue(JROMValue jROMValue) {
        jROMValue.setParent(this);
        this.elements.add(jROMValue);
    }

    public JROMValue getNthElementValue(int n) {
        return (JROMValue)this.elements.get(n);
    }

    public int getNumElements() {
        return this.elements.size();
    }

    public int getNumAttributes() {
        return this.attributes.size();
    }

    public void addAttributeValue(JROMValue jROMValue) {
        jROMValue.setParent(this);
        this.attributes.add(jROMValue);
    }

    public JROMValue getAttributeValue(String string, String string2) {
        JROMValue jROMValue = null;
        if (string == null) {
            string = "";
        }
        int n = 0;
        while (n < this.attributes.size()) {
            jROMValue = (JROMValue)this.attributes.elementAt(n);
            if (string.equals(jROMValue.getNameNamespace()) && string2.equals(jROMValue.getNameLocalPart())) break;
            ++n;
        }
        return jROMValue;
    }

    public JROMType getJROMType() {
        return JROMType.JROM_COMPLEX_VALUE;
    }

    public boolean equals(Object object) {
        if (object instanceof JROMComplexValue) {
            JROMValue jROMValue;
            JROMComplexValue jROMComplexValue = (JROMComplexValue)object;
            if (!this.isNameNamespaceEquals(jROMComplexValue) || !this.isNameLocalPartEquals(jROMComplexValue)) {
                return false;
            }
            if (!this.isTypeNamespaceEquals(jROMComplexValue) || !this.isTypeLocalPartEquals(jROMComplexValue)) {
                return false;
            }
            Iterator iterator = jROMComplexValue.getAttributeValues();
            int n = 0;
            while (iterator.hasNext()) {
                jROMValue = (JROMValue)iterator.next();
                if (!jROMValue.equals(this.getAttributeValue(jROMValue.getNameNamespace(), jROMValue.getNameLocalPart()))) {
                    return false;
                }
                ++n;
            }
            if (n != this.attributes.size()) {
                return false;
            }
            iterator = jROMComplexValue.getElementValues();
            n = 0;
            while (iterator.hasNext()) {
                jROMValue = (JROMValue)iterator.next();
                if (!jROMValue.equals(this.elements.elementAt(n))) {
                    return false;
                }
                ++n;
            }
            return n == this.elements.size();
        }
        return false;
    }

    public int hashCode() {
        int n = this.typeNamespace.hashCode() + this.typeLocalPart.hashCode();
        return n;
    }
}

