/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db;

import com.ibm.db.DataEvent;
import com.ibm.db.IBMDBMessages;
import com.ibm.db.SelectResult;
import com.ibm.db.SelectStatement;
import com.ibm.db.Statement;
import com.ibm.db.StatementMetaData;
import com.ibm.db.Utilities;
import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseConnection;
import com.ibm.db.base.DatabaseQuerySpec;
import com.ibm.db.base.DatabaseResultTable;
import com.ibm.db.base.DatabaseResultTableParent;
import com.ibm.db.base.DatabaseRow;
import com.ibm.db.base.DatabaseStatement;
import com.ibm.db.base.DatabaseTypeField;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Vector;

public class CallableStatement
extends SelectStatement {
    protected int fieldNumResults = 0;
    protected int fieldNumResultsInCache = 0;
    protected int fieldCurrentResult = 0;
    protected int fieldCurrentResultInCache = 0;
    protected int fieldMaximumResultsInCache = 0;
    protected Vector fieldResult;
    protected Vector fieldMetaDataVector;
    protected boolean fieldFillResultCacheOnExecute = true;
    protected transient boolean moreResults = true;
    protected transient boolean nextOrPrev = false;
    protected boolean describeAtRuntime = false;
    protected boolean[] outputParameterFetched;
    static final long serialVersionUID = 453344251680908556L;
    private static final String copyright = "Licensed Materials -- Propert of IBM\n(c) Copyright International Business Machines Corporation, 1999, 2000.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";
    static Class class$java$sql$Blob;
    static Class class$java$sql$Clob;

    public CallableStatement() {
    }

    public CallableStatement(boolean bl) {
        super(bl);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChange().addPropertyChangeListener(propertyChangeListener);
    }

    public void cancelExecution() throws com.ibm.db.DataException {
        if (this.fieldConnection == null) {
            String string = Utilities.logMessage(IBMDBMessages.noConnection);
            throw new com.ibm.db.DataException(string, 206);
        }
        if (!this.executing || this.rt == null) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuting);
            throw new com.ibm.db.DataException(string, 246);
        }
        if (this.executingSQL) {
            try {
                this.rt.cancel();
                this.executingSQL = false;
            }
            catch (SQLException sQLException) {
                Statement.handleSQLException(sQLException);
            }
        } else {
            SelectResult selectResult = this.getCacheResultAt(this.fieldCurrentResultInCache);
            if (selectResult == null) {
                String string = Utilities.logMessage(IBMDBMessages.notExecuting);
                throw new com.ibm.db.DataException(string, 246);
            }
            selectResult.cancelAction();
        }
    }

    public void close() throws com.ibm.db.DataException {
        this.fireAboutToClose(new DataEvent(this));
        this.closeInternal(false);
        this.moreResults = false;
        this.fireClosed(new DataEvent(this));
    }

    protected void copyParameters(DatabaseRow databaseRow) {
        super.copyParameters(databaseRow);
        int n = databaseRow.size();
        boolean[] blArray = null;
        if (n > 0) {
            blArray = new boolean[n];
        }
        if (this.outputParameterFetched != null) {
            int n2 = 0;
            while (n2 < this.outputParameterFetched.length) {
                blArray[n2] = this.outputParameterFetched[n2];
                ++n2;
            }
        }
        this.outputParameterFetched = blArray;
    }

    protected void createResultTable() throws com.ibm.db.DataException {
        DatabaseConnection databaseConnection = this.fieldConnection.getConnection();
        DatabaseQuerySpec databaseQuerySpec = null;
        try {
            StatementMetaData statementMetaData = this.getMetaData();
            databaseQuerySpec = new DatabaseQuerySpec(statementMetaData.getDbQuerySpec());
            statementMetaData = statementMetaData.getNextMetaData();
            if (statementMetaData != null) {
                databaseQuerySpec.setOutputShape(statementMetaData.getColumnShape());
            }
            this.validateSQL();
            String string = databaseQuerySpec.getStatement();
            if (string.indexOf(58) != -1) {
                databaseQuerySpec.setStatement(Statement.replaceHostVars(string));
            }
            int n = 1003;
            if (this.fieldReadOnly && this.largeResultSetScrollingEnabled) {
                n = 1004;
            }
            this.rt = new DatabaseResultTable(databaseConnection, databaseQuerySpec, n, this.isReadOnly());
            this.rt.setTimeout(this.fieldTimeout);
            this.executingSQL = true;
            try {
                if (this.getParameters() == null) {
                    this.rt.execute();
                } else {
                    this.rt.execute(this.getParameters());
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.executingSQL = false;
                throw throwable;
            }
            Object var6_11 = null;
            this.executingSQL = false;
            if (this.fieldMetaDataVector.size() > 2) {
                int n2 = 2;
                while (n2 < this.fieldMetaDataVector.size()) {
                    statementMetaData = (StatementMetaData)this.fieldMetaDataVector.elementAt(n2);
                    ((DatabaseResultTableParent)this.rt).addQuerySpec(statementMetaData.getDbQuerySpec());
                    ++n2;
                }
            }
        }
        catch (SQLException sQLException) {
            Statement.handleSQLException(sQLException);
        }
        catch (DataException dataException) {
            String string = Utilities.logBaseException(dataException, this.forVAJavaSelect);
            throw new com.ibm.db.DataException(string, dataException.getErrorCode());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
    }

    protected void disconnect() {
        int n = 0;
        while (n < this.fieldResult.size()) {
            ((SelectResult)this.fieldResult.elementAt(n)).disconnect();
            ++n;
        }
        this.rt = null;
        this.moreResults = false;
    }

    public synchronized void execute() throws com.ibm.db.DataException {
        this.fireAboutToExecute(new DataEvent(this));
        this.executing = true;
        try {
            if (!this.connect()) {
                this.executing = false;
                Object var1_1 = null;
                this.executing = false;
                return;
            }
            if (this.isOpen()) {
                this.close();
            }
            try {
                this.initialize();
                this.createResultTable();
                this.fetchFirstResult();
            }
            catch (com.ibm.db.DataException dataException) {
                this.closeInternal(true);
                throw dataException;
            }
            this.fieldExecuted = true;
            this.fireExecuted(new DataEvent(this));
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.executing = false;
            throw throwable;
        }
        Object var1_3 = null;
        this.executing = false;
    }

    protected void fetchFirstResult() throws com.ibm.db.DataException {
        SelectResult selectResult = this.getCacheResultAt(1);
        SelectResult selectResult2 = null;
        if (this.rt.getAfterLastResult()) {
            this.moreResults = false;
        } else {
            block10: {
                this.fieldNumResults = 1;
                this.fieldNumResultsInCache = 1;
                this.fieldCurrentResult = 1;
                this.fieldCurrentResultInCache = 1;
                try {
                    DatabaseCompoundType databaseCompoundType = new DatabaseCompoundType(this.rt.getRowStruct());
                    this.getMetaData().setColumnShape(databaseCompoundType);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
                if (this.fieldResult.size() < this.fieldNumResultsInCache) {
                    selectResult2 = new SelectResult(this);
                    this.fieldResult.addElement(selectResult2);
                } else {
                    selectResult2 = selectResult;
                }
                selectResult2.setResultTable((DatabaseResultTableParent)this.rt);
                selectResult2.initialize();
                try {
                    selectResult2.firstRow();
                }
                catch (com.ibm.db.DataException dataException) {
                    if (dataException.getErrorCode() == 214) break block10;
                    throw dataException;
                }
            }
            boolean bl = this.fieldFillResultCacheOnExecute;
            int n = this.fieldMaximumResultsInCache;
            if (n == 0) {
                n = Integer.MAX_VALUE;
            }
            while (this.moreResults && bl && this.fieldNumResultsInCache < n) {
                this.fetchNextResult();
            }
            this.fieldCurrentResult = this.fieldCurrentResult - this.fieldCurrentResultInCache + 1;
            this.fieldCurrentResultInCache = 1;
            this.firePropertyChange("currentResult", new Integer(0), new Integer(this.fieldCurrentResult));
            this.firePropertyChange("currentResultInCache", new Integer(0), new Integer(this.fieldCurrentResultInCache));
        }
    }

    protected void fetchNextResult() throws com.ibm.db.DataException {
        block16: {
            SelectResult selectResult = this.getResult();
            SelectResult selectResult2 = null;
            if (!this.moreResults) {
                return;
            }
            selectResult.moreRows = false;
            selectResult.previousRows = false;
            if (this.describeAtRuntime) {
                this.rt.addQuerySpec(new DatabaseQuerySpec());
            }
            try {
                this.rt.nextResult();
            }
            catch (SQLException sQLException) {
                Statement.handleSQLException(sQLException);
            }
            catch (DataException dataException) {
                String string = Utilities.logBaseException(dataException, this.forVAJavaSelect);
                throw new com.ibm.db.DataException(string, dataException.getErrorCode());
            }
            if (this.rt.getAfterLastResult()) {
                this.moreResults = false;
            } else {
                if (this.fieldNumResultsInCache == this.fieldMaximumResultsInCache && this.fieldMaximumResultsInCache > 0) {
                    this.fieldResult.removeElementAt(0);
                    --this.fieldNumResultsInCache;
                    --this.fieldCurrentResultInCache;
                }
                ++this.fieldCurrentResult;
                ++this.fieldCurrentResultInCache;
                ++this.fieldNumResults;
                ++this.fieldNumResultsInCache;
                try {
                    DatabaseCompoundType databaseCompoundType = new DatabaseCompoundType(this.rt.getRowStruct());
                    this.getMetaData().setColumnShape(databaseCompoundType);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
                if (this.fieldResult.size() < this.fieldCurrentResultInCache) {
                    selectResult2 = new SelectResult(this);
                    this.fieldResult.addElement(selectResult2);
                    if (selectResult != null) {
                        selectResult.setResultTable(null);
                    }
                } else {
                    selectResult2 = this.getResult();
                }
                selectResult2.setResultTable((DatabaseResultTableParent)this.rt);
                selectResult2.initialize();
                if (selectResult2.getCurrentRow() == 0) {
                    this.firstFirstRow = true;
                    try {
                        selectResult2.firstRow();
                        this.firstFirstRow = false;
                    }
                    catch (com.ibm.db.DataException dataException) {
                        if (dataException.getErrorCode() == 214) break block16;
                        throw dataException;
                    }
                }
            }
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChange().firePropertyChange(string, object, object2);
    }

    public void firstResult() throws com.ibm.db.DataException {
        this.setCurrentResult(1);
    }

    public SelectResult getCacheResultAt(int n) {
        if (n < 1 || n > this.fieldResult.size()) {
            return null;
        }
        return (SelectResult)this.fieldResult.elementAt(n - 1);
    }

    public int getCurrentResult() {
        return this.fieldCurrentResult;
    }

    public int getCurrentResultInCache() {
        return this.fieldCurrentResultInCache;
    }

    public int getMaximumResultsInCache() {
        return this.fieldMaximumResultsInCache;
    }

    /*
     * Unable to fully structure code
     */
    public StatementMetaData getMetaData() {
        block3: {
            var1_1 = this.fieldMetaDataVector.size();
            var2_2 = null;
            if (var1_1 <= this.fieldCurrentResult) ** GOTO lbl15
            var2_2 = (StatementMetaData)this.fieldMetaDataVector.elementAt(this.fieldCurrentResult);
            break block3;
lbl-1000:
            // 1 sources

            {
                var2_2 = new StatementMetaData();
                var2_2.setStatement(this);
                if (var1_1 == 0) {
                    this.fieldMetaData = var2_2;
                } else {
                    ((StatementMetaData)this.fieldMetaDataVector.lastElement()).setNextMetaData(var2_2);
                    this.describeAtRuntime = true;
                }
                this.fieldMetaDataVector.addElement(var2_2);
                var1_1 = this.fieldMetaDataVector.size();
lbl15:
                // 2 sources

                ** while ((var1_1 < 2 || this.describeAtRuntime) && var1_1 <= this.fieldCurrentResult)
            }
lbl16:
            // 1 sources

            var2_2 = var1_1 > this.fieldCurrentResult ? (StatementMetaData)this.fieldMetaDataVector.elementAt(this.fieldCurrentResult) : (StatementMetaData)this.fieldMetaDataVector.lastElement();
        }
        return var2_2;
    }

    public int getNumResults() {
        return this.fieldNumResults;
    }

    public int getNumResultsInCache() {
        return this.fieldNumResultsInCache;
    }

    public Object getParameter(int n) throws com.ibm.db.DataException {
        Object object;
        block26: {
            object = null;
            if (this.parameters == null || this.parameters.size() < n) {
                String string = Utilities.logMessage(IBMDBMessages.noSuchParm);
                throw new IndexOutOfBoundsException(string);
            }
            DatabaseTypeField databaseTypeField = this.parameters.getType().fieldAt(n);
            if (databaseTypeField.getMode() != 1 && !this.outputParameterFetched[n - 1] && this.isExecuted()) {
                this.checkConnection();
                if (!this.isOpen()) {
                    String string = Utilities.logMessage(IBMDBMessages.notOpen);
                    throw new com.ibm.db.DataException(string, 207);
                }
                try {
                    object = this.rt.getParameter(n, databaseTypeField);
                }
                catch (SQLException sQLException) {
                    Statement.handleSQLException(sQLException);
                }
                this.parameters.putAtIndex(n, object);
                if (object == null) {
                    this.parameters.setColIsNull(n, true);
                }
                this.outputParameterFetched[n - 1] = true;
            } else {
                try {
                    object = this.parameters.getAtIndex(n);
                    if (!this.isValidateLOBs()) break block26;
                    Class<?> clazz = class$java$sql$Clob;
                    if (clazz == null) {
                        try {
                            clazz = class$java$sql$Clob = Class.forName("java.sql.Clob");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.isInstance(object)) {
                        try {
                            this.checkConnection();
                            if (!this.isOpen()) {
                                String string = Utilities.logMessage(IBMDBMessages.notOpen);
                                throw new com.ibm.db.DataException(string, 207);
                            }
                            ((Clob)object).getAsciiStream();
                        }
                        catch (SQLException sQLException) {
                            try {
                                object = this.rt.getParameter(n, databaseTypeField);
                                break block26;
                            }
                            catch (SQLException sQLException2) {
                                Statement.handleSQLException(sQLException2);
                            }
                        }
                        break block26;
                    }
                    Class<?> clazz2 = class$java$sql$Blob;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$java$sql$Blob = Class.forName("java.sql.Blob");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz2.isInstance(object)) break block26;
                    try {
                        this.checkConnection();
                        if (!this.isOpen()) {
                            String string = Utilities.logMessage(IBMDBMessages.notOpen);
                            throw new com.ibm.db.DataException(string, 207);
                        }
                        ((Blob)object).getBinaryStream();
                    }
                    catch (SQLException sQLException) {
                        try {
                            object = this.rt.getParameter(n, databaseTypeField);
                        }
                        catch (SQLException sQLException3) {
                            Statement.handleSQLException(sQLException3);
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    String string = Utilities.logMessage(IBMDBMessages.noSuchParm);
                    throw new IndexOutOfBoundsException(string);
                }
            }
        }
        return object;
    }

    protected PropertyChangeSupport getPropertyChange() {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        return this.propertyChange;
    }

    public SelectResult getResult() {
        return this.getCacheResultAt(this.fieldCurrentResultInCache);
    }

    public StatementMetaData getRootMetaData() {
        return this.fieldMetaData;
    }

    protected void initialize() {
        int n = this.fieldMaximumResultsInCache;
        if (n == 0) {
            n = 4;
        }
        if (this.fieldResult == null) {
            this.fieldResult = new Vector(n);
        }
        if (this.fieldMetaDataVector == null) {
            this.fieldMetaDataVector = new Vector(n);
        }
        this.fieldNumResults = 0;
        this.fieldNumResultsInCache = 0;
        this.fieldCurrentResult = 0;
        this.fieldCurrentResultInCache = 0;
        this.moreResults = true;
        if (this.fieldMetaData != null) {
            int n2 = this.fieldMetaData.getParameterCount();
            int n3 = 0;
            while (n3 < n2) {
                this.outputParameterFetched[n3] = false;
                ++n3;
            }
        }
    }

    public boolean isFillResultCacheOnExecute() {
        return this.fieldFillResultCacheOnExecute;
    }

    public boolean isLastResult() {
        boolean bl = this.fieldCurrentResult >= this.fieldNumResults && !this.moreResults;
        return bl;
    }

    public synchronized void lastResult() throws com.ibm.db.DataException {
        if (!this.isExecuted()) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new com.ibm.db.DataException(string, 213);
        }
        if (this.fieldCurrentResultInCache <= 0) {
            String string = Utilities.logMessage(IBMDBMessages.noResultSets);
            throw new com.ibm.db.DataException(string, 243);
        }
        if (this.isLastResult()) {
            return;
        }
        int n = this.fieldCurrentResult;
        int n2 = this.fieldCurrentResultInCache;
        this.getResult().updateRowBeforeLeaving();
        while (this.moreResults) {
            this.fetchNextResult();
        }
        this.fieldCurrentResult = this.fieldNumResults;
        this.fieldCurrentResultInCache = this.fieldNumResultsInCache;
        this.firePropertyChange("currentResult", new Integer(n), new Integer(this.fieldCurrentResult));
        this.firePropertyChange("currentResultInCache", new Integer(n2), new Integer(this.fieldCurrentResultInCache));
    }

    public void nextResult() throws com.ibm.db.DataException {
        this.nextOrPrev = true;
        try {
            this.setCurrentResult(this.fieldCurrentResult + 1);
        }
        catch (com.ibm.db.DataException dataException) {
            this.nextOrPrev = false;
            throw dataException;
        }
        this.nextOrPrev = false;
    }

    public void previousResult() throws com.ibm.db.DataException {
        this.nextOrPrev = true;
        try {
            this.setCurrentResult(this.fieldCurrentResult - 1);
        }
        catch (com.ibm.db.DataException dataException) {
            this.nextOrPrev = false;
            throw dataException;
        }
        this.nextOrPrev = false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.propertyChange = new PropertyChangeSupport(this);
        this.executing = false;
        this.moreResults = false;
        this.nextOrPrev = false;
    }

    public synchronized void refresh() throws com.ibm.db.DataException {
        this.checkConnection();
        if (!this.isOpen()) {
            String string = Utilities.logMessage(IBMDBMessages.notOpen);
            throw new com.ibm.db.DataException(string, 207);
        }
        this.fireAboutToExecute(new DataEvent(this));
        this.executing = true;
        try {
            if (this.getResult() != null && this.getResult().isOpen()) {
                this.getResult().closeResult();
            }
            this.initialize();
            this.refreshResultTable();
            this.fetchFirstResult();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.executing = false;
            throw throwable;
        }
        Object var2_4 = null;
        this.executing = false;
        this.fireExecuted(new DataEvent(this));
    }

    protected void refreshResultTable() throws com.ibm.db.DataException {
        try {
            this.executingSQL = true;
            if (this.getParameters() == null) {
                ((DatabaseResultTableParent)this.rt).refresh();
            } else {
                ((DatabaseResultTableParent)this.rt).refresh(this.getParameters());
            }
            this.executingSQL = false;
        }
        catch (SQLException sQLException) {
            Statement.handleSQLException(sQLException);
        }
        catch (DataException dataException) {
            String string = Utilities.logBaseException(dataException, this.forVAJavaSelect);
            throw new com.ibm.db.DataException(string, dataException.getErrorCode());
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChange().removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void setCurrentResult(int n) throws com.ibm.db.DataException {
        boolean bl = false;
        boolean bl2 = false;
        if (!this.isExecuted()) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new com.ibm.db.DataException(string, 213);
        }
        Integer n2 = new Integer(n);
        Integer n3 = new Integer(this.fieldCurrentResult);
        Integer n4 = new Integer(this.fieldCurrentResultInCache);
        if (this.fieldCurrentResult == 0 && this.executing) {
            n3 = null;
            n4 = null;
        }
        int n5 = this.fieldCurrentResult - this.fieldCurrentResultInCache + 1;
        int n6 = n5 + this.fieldNumResultsInCache - 1;
        if (n < n5) {
            bl = true;
            n = n5;
        }
        if (this.fieldCurrentResult > 0) {
            this.getResult().updateRowBeforeLeaving();
        }
        boolean bl3 = this.fieldFillResultCacheOnExecute;
        int n7 = this.fieldMaximumResultsInCache;
        if (n7 == 0) {
            n7 = Integer.MAX_VALUE;
        }
        while (this.moreResults && (n > n6 || bl3 && this.fieldNumResultsInCache < n7)) {
            this.fetchNextResult();
            n5 = this.fieldCurrentResult - this.fieldCurrentResultInCache + 1;
            n6 = n5 + this.fieldNumResultsInCache - 1;
        }
        if (n > n6) {
            bl2 = true;
            this.fieldCurrentResult = this.fieldNumResults;
            this.fieldCurrentResultInCache = this.fieldNumResultsInCache;
        } else {
            int n8 = this.fieldCurrentResult - n;
            this.fieldCurrentResult = n;
            this.fieldCurrentResultInCache -= n8;
        }
        this.firePropertyChange("currentResult", n3, new Integer(this.fieldCurrentResult));
        this.firePropertyChange("currentResultInCache", n4, new Integer(this.fieldCurrentResultInCache));
        if (bl || n == 0) {
            if (this.fieldNumResults == 0) {
                String string = Utilities.logMessage(IBMDBMessages.noResultSets);
                throw new com.ibm.db.DataException(string, 243);
            }
            if (!this.nextOrPrev || this.fieldCurrentResult != 1) {
                Object[] objectArray = new Object[]{n2};
                String string = Utilities.logMessage(IBMDBMessages.beforeResultCacheStart, objectArray);
                throw new com.ibm.db.DataException(string, 247);
            }
        }
        if (bl2) {
            if (this.fieldNumResults == 0) {
                String string = Utilities.logMessage(IBMDBMessages.noResultSets);
                throw new com.ibm.db.DataException(string, 243);
            }
            if (!this.nextOrPrev) {
                Object[] objectArray = new Object[]{n2};
                String string = Utilities.logMessage(IBMDBMessages.resultIndexTooLarge, objectArray);
                throw new com.ibm.db.DataException(string, 248);
            }
        }
    }

    protected void setCurrentResultInCache(int n) {
        int n2 = this.fieldCurrentResultInCache;
        this.fieldCurrentResultInCache = n;
        this.firePropertyChange("currentResultInCache", new Integer(n2), new Integer(this.fieldCurrentResultInCache));
    }

    public void setFillResultCacheOnExecute(boolean bl) {
        this.fieldFillResultCacheOnExecute = bl;
    }

    public void setMaximumResultsInCache(int n) {
        this.fieldMaximumResultsInCache = n;
    }

    public synchronized void setMetaData(StatementMetaData statementMetaData) {
        int n;
        super.setMetaData(statementMetaData);
        int n2 = this.fieldMetaData.getParameterCount();
        if (n2 > 0) {
            this.outputParameterFetched = new boolean[n2];
        }
        if ((n = this.fieldMaximumResultsInCache) == 0) {
            n = 4;
        }
        this.fieldMetaDataVector = new Vector(n);
        while (statementMetaData != null) {
            statementMetaData.setStatement(this);
            this.fieldMetaDataVector.addElement(statementMetaData);
            statementMetaData = statementMetaData.getNextMetaData();
        }
        this.describeAtRuntime = false;
    }

    public void setParameter(int n, Object object) throws com.ibm.db.DataException {
        super.setParameter(n, object);
        this.outputParameterFetched[n - 1] = true;
    }

    protected void validateSQL() throws com.ibm.db.DataException {
        String string = this.getMetaData().getSQL();
        boolean bl = false;
        try {
            bl = DatabaseStatement.isCallStatement(string);
        }
        catch (DataException dataException) {
            String string2 = Utilities.logMessage(IBMDBMessages.noSQL);
            throw new com.ibm.db.DataException(string2, 106);
        }
        if (!bl) {
            String string3 = Utilities.logMessage(IBMDBMessages.notCall);
            throw new com.ibm.db.DataException(string3, 242);
        }
    }
}

