/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db;

import com.ibm.db.DataEvent;
import com.ibm.db.DataException;
import com.ibm.db.StatementResultAfterEventMulticaster;
import com.ibm.db.StatementResultAfterListener;
import com.ibm.db.StatementResultBeforeEventMulticaster;
import com.ibm.db.StatementResultBeforeListener;
import com.ibm.db.Utilities;
import com.ibm.db.base.DatabaseResultTable;
import com.ibm.db.base.DatabaseResultTableParent;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;

public abstract class StatementResult
implements Serializable {
    protected int fieldNumRows = 0;
    protected transient DatabaseResultTableParent rt;
    protected transient StatementResultBeforeListener aStatementResultBeforeListener = null;
    protected transient StatementResultAfterListener aStatementResultAfterListener = null;
    static final long serialVersionUID = 5585816587776065874L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public void addStatementResultAfterListener(StatementResultAfterListener statementResultAfterListener) {
        this.aStatementResultAfterListener = StatementResultAfterEventMulticaster.add(this.aStatementResultAfterListener, statementResultAfterListener);
    }

    public void addStatementResultBeforeListener(StatementResultBeforeListener statementResultBeforeListener) {
        this.aStatementResultBeforeListener = StatementResultBeforeEventMulticaster.add(this.aStatementResultBeforeListener, statementResultBeforeListener);
    }

    public abstract void closeResult() throws DataException;

    public abstract Enumeration columnNames() throws DataException;

    public abstract void deleteRow() throws DataException;

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void fireAboutToAddNewRow(DataEvent dataEvent) {
        if (this.aStatementResultBeforeListener == null) {
            return;
        }
        this.aStatementResultBeforeListener.aboutToAddNewRow(dataEvent);
    }

    protected void fireAboutToClose(DataEvent dataEvent) {
        if (this.aStatementResultBeforeListener == null) {
            return;
        }
        this.aStatementResultBeforeListener.aboutToClose(dataEvent);
    }

    protected void fireAboutToDeleteRow(DataEvent dataEvent) {
        if (this.aStatementResultBeforeListener == null) {
            return;
        }
        this.aStatementResultBeforeListener.aboutToDeleteRow(dataEvent);
    }

    protected void fireAboutToUpdateRow(DataEvent dataEvent) {
        if (this.aStatementResultBeforeListener == null) {
            return;
        }
        this.aStatementResultBeforeListener.aboutToUpdateRow(dataEvent);
    }

    protected void fireAddedNewRow(DataEvent dataEvent) {
        if (this.aStatementResultAfterListener == null) {
            return;
        }
        this.aStatementResultAfterListener.addedNewRow(dataEvent);
    }

    protected void fireClosed(DataEvent dataEvent) {
        if (this.aStatementResultAfterListener == null) {
            return;
        }
        this.aStatementResultAfterListener.closed(dataEvent);
    }

    protected void fireDeletedRow(DataEvent dataEvent) {
        if (this.aStatementResultAfterListener == null) {
            return;
        }
        this.aStatementResultAfterListener.deletedRow(dataEvent);
    }

    protected void fireUpdatedRow(DataEvent dataEvent) {
        if (this.aStatementResultAfterListener == null) {
            return;
        }
        this.aStatementResultAfterListener.updatedRow(dataEvent);
    }

    public abstract int getColumnCount() throws DataException;

    public abstract String getColumnName(int var1) throws DataException;

    public abstract Object getColumnValue(int var1) throws DataException;

    public abstract Object getColumnValue(String var1) throws DataException;

    public abstract String getColumnValueToString(int var1) throws DataException;

    public abstract String getColumnValueToString(String var1) throws DataException;

    public ResultSetMetaData getJDBCMetaData() throws DataException {
        try {
            if (this.rt != null) {
                return this.rt.getMetaData();
            }
            return null;
        }
        catch (SQLException sQLException) {
            String string = Utilities.logSQLException(sQLException);
            throw new DataException(string, sQLException);
        }
    }

    public int getNumRows() {
        return this.fieldNumRows;
    }

    protected DatabaseResultTableParent getResultTable() {
        return this.rt;
    }

    protected static void handleSQLException(SQLException sQLException) throws DataException {
        String string = Utilities.logSQLException(sQLException);
        throw new DataException(string, sQLException);
    }

    protected abstract void initialize() throws DataException;

    public boolean isOpen() {
        return this.rt != null;
    }

    public void removeStatementResultAfterListener(StatementResultAfterListener statementResultAfterListener) {
        this.aStatementResultAfterListener = StatementResultAfterEventMulticaster.remove(this.aStatementResultAfterListener, statementResultAfterListener);
    }

    public void removeStatementResultBeforeListener(StatementResultBeforeListener statementResultBeforeListener) {
        this.aStatementResultBeforeListener = StatementResultBeforeEventMulticaster.remove(this.aStatementResultBeforeListener, statementResultBeforeListener);
    }

    public abstract void restoreRow() throws DataException;

    public abstract void setColumnValue(int var1, Object var2) throws DataException;

    public abstract void setColumnValue(String var1, Object var2) throws DataException;

    public abstract void setColumnValueFromString(int var1, String var2) throws DataException;

    public abstract void setColumnValueFromString(String var1, String var2) throws DataException;

    protected void setResultTable(DatabaseResultTable databaseResultTable) {
        this.rt = databaseResultTable;
    }

    protected void setResultTable(DatabaseResultTableParent databaseResultTableParent) {
        this.rt = databaseResultTableParent;
    }

    public abstract void updateRow() throws DataException;
}

