/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db;

import com.ibm.db.IBMDBMessages;
import com.ibm.db.Utilities;
import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseRow;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

class StatementResultRow
implements Serializable {
    protected DatabaseRow currentColumnValues;
    protected DatabaseRow previousColumnValues;
    protected int status;
    protected int action;
    protected boolean inDatabase;
    protected int numberWhenChanged;
    public static final int UNCHANGED = 0;
    public static final int VALUE_SET = 1;
    public static final int NEW = 2;
    public static final int TRUNCATED = 3;
    public static final int NONE = 0;
    public static final int UPDATED = 1;
    public static final int DELETED = 2;
    public static final int INSERTED = 3;
    static final long serialVersionUID = -2996084309658911637L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";
    static Class class$array1$$byte;
    static Class class$java$lang$Short;
    static Class class$java$sql$Time;
    static Class class$java$lang$String;
    static Class class$java$lang$Float;
    static Class class$java$sql$Timestamp;
    static Class class$java$lang$Double;
    static Class class$java$lang$Boolean;
    static Class class$java$sql$Date;
    static Class class$java$lang$Long;
    static Class class$java$lang$Integer;
    static Class class$java$math$BigDecimal;

    public StatementResultRow(DatabaseRow databaseRow) {
        this.currentColumnValues = databaseRow;
        this.previousColumnValues = null;
        this.status = 0;
        this.action = 0;
        this.inDatabase = true;
    }

    public StatementResultRow(StatementResultRow statementResultRow) throws com.ibm.db.DataException {
        if (statementResultRow.currentColumnValues != null) {
            this.currentColumnValues = new DatabaseRow(statementResultRow.currentColumnValues);
        }
        if (statementResultRow.previousColumnValues != null) {
            this.previousColumnValues = new DatabaseRow(statementResultRow.previousColumnValues);
        }
        this.status = statementResultRow.status;
        this.action = statementResultRow.action;
        this.inDatabase = statementResultRow.inDatabase;
    }

    public static Object copyValue(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            try {
                clazz2 = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return new String((String)object);
        }
        Class<?> clazz3 = class$java$lang$Integer;
        if (clazz3 == null) {
            try {
                clazz3 = class$java$lang$Integer = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return new Integer((Integer)object);
        }
        Class<?> clazz4 = class$java$lang$Long;
        if (clazz4 == null) {
            try {
                clazz4 = class$java$lang$Long = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz4)) {
            return new Long((Long)object);
        }
        Class<?> clazz5 = class$java$lang$Short;
        if (clazz5 == null) {
            try {
                clazz5 = class$java$lang$Short = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz5)) {
            return new Short((Short)object);
        }
        Class<?> clazz6 = class$java$math$BigDecimal;
        if (clazz6 == null) {
            try {
                clazz6 = class$java$math$BigDecimal = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz6)) {
            BigDecimal bigDecimal = (BigDecimal)object;
            int n = bigDecimal.scale();
            bigDecimal = bigDecimal.movePointRight(n);
            object = new BigDecimal(bigDecimal.toBigInteger(), n);
            return object;
        }
        Class<?> clazz7 = class$java$lang$Float;
        if (clazz7 == null) {
            try {
                clazz7 = class$java$lang$Float = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz7)) {
            return new Float(((Float)object).floatValue());
        }
        Class<?> clazz8 = class$java$lang$Double;
        if (clazz8 == null) {
            try {
                clazz8 = class$java$lang$Double = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz8)) {
            return new Double((Double)object);
        }
        Class<?> clazz9 = class$java$lang$Boolean;
        if (clazz9 == null) {
            try {
                clazz9 = class$java$lang$Boolean = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz9)) {
            return new Boolean((Boolean)object);
        }
        Class<?> clazz10 = class$array1$$byte;
        if (clazz10 == null) {
            try {
                clazz10 = class$array1$$byte = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz10)) {
            int n = ((byte[])object).length;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = ((byte[])object)[n2];
                ++n2;
            }
            return byArray;
        }
        Class<?> clazz11 = class$java$sql$Date;
        if (clazz11 == null) {
            try {
                clazz11 = class$java$sql$Date = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz11)) {
            return new Date(((Date)object).getTime());
        }
        Class<?> clazz12 = class$java$sql$Time;
        if (clazz12 == null) {
            try {
                clazz12 = class$java$sql$Time = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz12)) {
            return new Time(((Time)object).getTime());
        }
        Class<?> clazz13 = class$java$sql$Timestamp;
        if (clazz13 == null) {
            try {
                clazz13 = class$java$sql$Timestamp = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz13)) {
            Timestamp timestamp = (Timestamp)object;
            int n = timestamp.getNanos();
            object = new Timestamp(((java.util.Date)timestamp).getTime());
            ((Timestamp)object).setNanos(n);
            return object;
        }
        return object;
    }

    public int getAction() {
        return this.action;
    }

    public Object getColumnValue(int n) {
        Object object = null;
        try {
            object = this.currentColumnValues.getAtIndex(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = Utilities.logMessage(IBMDBMessages.noSuchColumn);
            throw new IndexOutOfBoundsException(string);
        }
        return StatementResultRow.copyValue(object);
    }

    public Object getColumnValue(String string) {
        try {
            return this.getColumnValue(this.currentColumnValues.getColumnIndex(string));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string2 = Utilities.logMessage(IBMDBMessages.noSuchColumn);
            throw new IndexOutOfBoundsException(string2);
        }
    }

    public DatabaseRow getCurrentColumnValues() {
        return this.currentColumnValues;
    }

    protected int getNumberWhenChanged() {
        return this.numberWhenChanged;
    }

    public Object getPreviousColumnValue(int n) {
        if (this.previousColumnValues == null) {
            return null;
        }
        try {
            return this.previousColumnValues.getAtIndex(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = Utilities.logMessage(IBMDBMessages.noSuchColumn);
            throw new IndexOutOfBoundsException(string);
        }
    }

    public DatabaseRow getPreviousColumnValues() {
        return this.previousColumnValues;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isInDatabase() {
        return this.inDatabase;
    }

    public synchronized void reset() {
        this.previousColumnValues = null;
        this.status = 0;
        this.action = 0;
        DatabaseCompoundType databaseCompoundType = this.currentColumnValues.getType();
        int n = 1;
        while (n <= databaseCompoundType.size()) {
            this.currentColumnValues.setColWasChanged(n, false);
            ++n;
        }
    }

    public synchronized void restore() {
        if (this.inDatabase) {
            if (this.previousColumnValues != null) {
                this.currentColumnValues = this.previousColumnValues;
                this.previousColumnValues = null;
            }
            this.status = 0;
        } else {
            DatabaseCompoundType databaseCompoundType = this.currentColumnValues.getType();
            this.currentColumnValues = new DatabaseRow(databaseCompoundType);
            this.status = 2;
        }
        this.action = 0;
    }

    public void setAction(int n) {
        this.action = n;
    }

    public synchronized void setColumnValue(int n, Object object) throws com.ibm.db.DataException, DataException {
        if (this.status == 3) {
            String string = Utilities.logMessage(IBMDBMessages.truncated);
            throw new com.ibm.db.DataException(string, 240);
        }
        if (this.status == 0) {
            this.previousColumnValues = new DatabaseRow(this.currentColumnValues);
        }
        this.currentColumnValues.putAtIndexWithCheck(n, StatementResultRow.copyValue(object));
        this.currentColumnValues.setColWasChanged(n, true);
        this.status = 1;
    }

    public void setInDatabase(boolean bl) {
        this.inDatabase = bl;
    }

    protected void setNumberWhenChanged(int n) {
        this.numberWhenChanged = n;
    }

    public void setStatus(int n) {
        this.status = n;
    }
}

