/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseConnectionSpec;
import com.ibm.db.base.IBMDBBaseMessages;
import com.ibm.db.base.JDBCConnectionManager;
import com.ibm.db.base.UtilitiesBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class DatabaseConnection {
    private DatabaseConnectionSpec connSpec;
    private Connection jdbcConnection;
    private JDBCConnectionManager databaseManager;
    private boolean externallyManaged = false;
    private transient Hashtable dbSearchTypeInfo;
    protected transient DatabaseMetaData conMetaData = null;
    transient Class websphereJdbcConnPoolAccess = null;
    protected transient Method getIBMJdbcConn = null;
    protected transient Object websphereConnection = null;
    protected transient Method getJdbcConn = null;
    protected transient Method releaseIBMConn = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 2000";
    static Class class$javax$sql$DataSource;
    static Class class$java$sql$SQLException;
    static Class class$java$lang$String;
    static Class class$javax$naming$NoInitialContextException;

    public DatabaseConnection(JDBCConnectionManager jDBCConnectionManager) {
        this.setDatabaseManager(jDBCConnectionManager);
    }

    public DatabaseConnection(Connection connection) throws SQLException {
        this.setJdbcConnection(connection);
        this.externallyManaged = true;
    }

    public void commitTransaction() throws SQLException {
        this.getJdbcConnection().commit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connectToDataSource() throws SQLException, DataException {
        String string = this.getConnectionSpec().getLogonSpec().getId();
        String string2 = this.getConnectionSpec().getLogonSpec().getPassword();
        String string3 = this.getConnectionSpec().getJndiDataSource();
        String string4 = null;
        if (string3 != null) {
            try {
                Object object;
                Object[] objectArray;
                Object object22;
                InitialContext initialContext;
                block44: {
                    initialContext = null;
                    try {
                        try {
                            string4 = this.getConnectionSpec().getInitialContextFactory();
                            object22 = this.getConnectionSpec().getProviderURL();
                            objectArray = new Hashtable(5);
                            if (string4 != null) {
                                objectArray.put("java.naming.factory.initial", string4);
                            }
                            if (object22 != null) {
                                objectArray.put("java.naming.provider.url", object22);
                            }
                            try {
                                initialContext = objectArray.isEmpty() ? new InitialContext() : new InitialContext((Hashtable<?, ?>)objectArray);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace(System.out);
                                Object[] objectArray2 = new Object[]{throwable.toString()};
                                String string5 = UtilitiesBase.getMessage(IBMDBBaseMessages.unexpectedError, objectArray2);
                                throw new DataException(string5, 114);
                            }
                            object = initialContext.lookup(string3);
                            Class<?> clazz = class$javax$sql$DataSource;
                            if (clazz == null) {
                                try {
                                    clazz = class$javax$sql$DataSource = Class.forName("javax.sql.DataSource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz.isInstance(object)) {
                                DataSource dataSource = (DataSource)object;
                                if (string != null || string2 != null) {
                                    this.setJdbcConnection(dataSource.getConnection(string, string2));
                                } else {
                                    this.setJdbcConnection(dataSource.getConnection());
                                }
                                break block44;
                            }
                            try {
                                Class<?> clazz2 = object.getClass();
                                Class[] classArray = new Class[2];
                                Class<?> clazz3 = class$java$lang$String;
                                if (clazz3 == null) {
                                    try {
                                        clazz3 = class$java$lang$String = Class.forName("java.lang.String");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                classArray[0] = clazz3;
                                Class<?> clazz4 = class$java$lang$String;
                                if (clazz4 == null) {
                                    try {
                                        clazz4 = class$java$lang$String = Class.forName("java.lang.String");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                classArray[1] = clazz4;
                                Method method2 = clazz2.getMethod("getConnection", classArray);
                                Connection cfr_ignored_0 = (Connection)method2.invoke(object, string, string2);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                Object[] objectArray3 = new Object[]{noSuchMethodException.toString()};
                                String string6 = UtilitiesBase.getMessage(IBMDBBaseMessages.unexpectedError, objectArray3);
                                throw new DataException(string6, 114);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                Class<?> clazz5 = class$java$sql$SQLException;
                                if (clazz5 == null) {
                                    try {
                                        clazz5 = class$java$sql$SQLException = Class.forName("java.sql.SQLException");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz5.isInstance(invocationTargetException.getTargetException())) {
                                    throw (SQLException)invocationTargetException.getTargetException();
                                }
                                Object[] objectArray4 = new Object[]{invocationTargetException.getTargetException().toString()};
                                String string7 = UtilitiesBase.getMessage(IBMDBBaseMessages.unexpectedError, objectArray4);
                                throw new DataException(string7, 114);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                Object[] objectArray5 = new Object[]{illegalAccessException.toString()};
                                String string8 = UtilitiesBase.getMessage(IBMDBBaseMessages.unexpectedError, objectArray5);
                                throw new DataException(string8, 114);
                            }
                        }
                        catch (Exception exception) {
                            Class<?> clazz = class$javax$naming$NoInitialContextException;
                            if (clazz == null) {
                                try {
                                    clazz = class$javax$naming$NoInitialContextException = Class.forName("javax.naming.NoInitialContextException");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz.isInstance(exception)) {
                                Object[] objectArray6 = new Object[]{string4};
                                String string9 = UtilitiesBase.getMessage(IBMDBBaseMessages.noInitialContext, objectArray6);
                                throw new DataException(string9, 115);
                            }
                            Object[] objectArray7 = new Object[]{exception.toString()};
                            String string10 = UtilitiesBase.getMessage(IBMDBBaseMessages.unexpectedError, objectArray7);
                            throw new DataException(string10, 114);
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            noClassDefFoundError.printStackTrace();
                            Object[] objectArray8 = new Object[]{noClassDefFoundError.toString()};
                            String string11 = UtilitiesBase.getMessage(IBMDBBaseMessages.unexpectedError, objectArray8);
                            throw new DataException(string11, 114);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_38 = null;
                        if (initialContext == null) throw throwable;
                        try {
                            initialContext.close();
                            throw throwable;
                        }
                        catch (Exception exception) {
                            Object[] objectArray9 = new Object[]{exception.toString()};
                            String string12 = UtilitiesBase.getMessage(IBMDBBaseMessages.unexpectedError, objectArray9);
                            throw new DataException(string12, 114);
                        }
                    }
                }
                Object var6_39 = null;
                if (initialContext == null) return;
                try {
                    initialContext.close();
                    return;
                }
                catch (Exception object22) {
                    objectArray = new Object[]{((Throwable)object22).toString()};
                    object = UtilitiesBase.getMessage(IBMDBBaseMessages.unexpectedError, objectArray);
                    throw new DataException((String)object, 114);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                noClassDefFoundError.printStackTrace();
                Object[] objectArray = new Object[]{noClassDefFoundError.toString()};
                String string13 = UtilitiesBase.getMessage(IBMDBBaseMessages.unexpectedError, objectArray);
                throw new DataException(string13, 114);
            }
        }
        if (this.getConnectionSpec().getConnectionPoolType() == 1) {
            this.obtainWebsphereConnection();
            return;
        } else if (this.getConnectionSpec().getProps() == null) {
            this.setJdbcConnection(DriverManager.getConnection(this.getConnectionUrl(), string, string2));
            return;
        } else {
            Properties properties = (Properties)((Hashtable)this.getConnectionSpec().getProps()).clone();
            ((Hashtable)properties).put("user", string);
            ((Hashtable)properties).put("password", string2);
            this.setJdbcConnection(DriverManager.getConnection(this.getConnectionUrl(), properties));
        }
    }

    public void disconnect() throws SQLException, DataException, NullPointerException {
        if (this.websphereConnection != null) {
            this.releaseWebsphereConnection();
        } else {
            try {
                this.getJdbcConnection().close();
            }
            catch (SQLException sQLException) {
                if (this.getConnectionMetaData().supportsTransactions()) {
                    this.rollbackTransaction();
                    this.getJdbcConnection().close();
                }
                throw sQLException;
            }
        }
        this.setJdbcConnection(null);
        this.conMetaData = null;
    }

    public String getAlias() {
        return this.getConnectionSpec().getAlias();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.getJdbcConnection().getAutoCommit();
    }

    public DatabaseMetaData getConnectionMetaData() throws SQLException {
        if (this.conMetaData == null) {
            this.conMetaData = this.getJdbcConnection().getMetaData();
        }
        return this.conMetaData;
    }

    public DatabaseConnectionSpec getConnectionSpec() {
        return this.connSpec;
    }

    private String getConnectionUrl() {
        return this.getConnectionSpec().getDataSourceName();
    }

    protected JDBCConnectionManager getDatabaseManager() {
        return this.databaseManager;
    }

    public Connection getJdbcConnection() {
        return this.jdbcConnection;
    }

    protected Hashtable getSearchTypeInfo() throws SQLException {
        if (this.dbSearchTypeInfo == null) {
            this.dbSearchTypeInfo = new Hashtable();
            ResultSet resultSet = this.getConnectionMetaData().getTypeInfo();
            while (resultSet.next()) {
                this.dbSearchTypeInfo.put(resultSet.getString(1), new Integer(resultSet.getInt(9)));
            }
            resultSet.close();
        }
        return this.dbSearchTypeInfo;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.getJdbcConnection().getTransactionIsolation();
    }

    public boolean isConnected() throws SQLException {
        if (this.jdbcConnection == null) {
            return false;
        }
        return !this.jdbcConnection.isClosed();
    }

    protected void obtainWebsphereConnection() throws DataException {
        block21: {
            try {
                if (this.getIBMJdbcConn != null) break block21;
                this.websphereJdbcConnPoolAccess = Class.forName("com.ibm.servlet.connmgr.WebsphereJdbcConnPoolAccess");
                Class[] classArray = new Class[4];
                Class<?> clazz = class$java$lang$String;
                if (clazz == null) {
                    try {
                        clazz = class$java$lang$String = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$java$lang$String = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                Class<?> clazz3 = class$java$lang$String;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$java$lang$String = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz3;
                Class<?> clazz4 = class$java$lang$String;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$java$lang$String = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[3] = clazz4;
                this.getIBMJdbcConn = this.websphereJdbcConnPoolAccess.getMethod("getIBMJdbcConnection", classArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string = UtilitiesBase.getMessage(IBMDBBaseMessages.websphereConnectionError);
                throw new DataException(string, 112);
            }
        }
        String string = this.getConnectionSpec().getDriverName();
        String string2 = this.getConnectionSpec().getDataSourceName();
        String string3 = this.getConnectionSpec().getLogonSpec().getId();
        String string4 = this.getConnectionSpec().getLogonSpec().getPassword();
        try {
            this.websphereConnection = this.getIBMJdbcConn.invoke((Object)this.websphereJdbcConnPoolAccess, string, string2, string3, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string5 = UtilitiesBase.getMessage(IBMDBBaseMessages.websphereConnectionError);
            throw new DataException(string5, 112);
        }
        try {
            Object object;
            if (this.websphereConnection != null) {
                if (this.getJdbcConn == null) {
                    object = Class.forName("com.ibm.servlet.connmgr.IBMJdbcConn");
                    this.getJdbcConn = ((Class)object).getMethod("getJdbcConnection", new Class[0]);
                }
            } else {
                String string6 = UtilitiesBase.getMessage(IBMDBBaseMessages.websphereConnectionError);
                throw new DataException(string6, 112);
            }
            object = (Connection)this.getJdbcConn.invoke(this.websphereConnection, new Object[0]);
            this.setJdbcConnection((Connection)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            UtilitiesBase.logMessage(exception.toString());
            String string7 = UtilitiesBase.getMessage(IBMDBBaseMessages.websphereConnectionError);
            throw new DataException(string7, 112);
        }
    }

    protected void releaseWebsphereConnection() throws DataException {
        try {
            if (this.releaseIBMConn == null) {
                Class<?> clazz = Class.forName("com.ibm.servlet.connmgr.IBMJdbcConn");
                this.releaseIBMConn = clazz.getMethod("releaseIBMConnection", new Class[0]);
            }
            this.releaseIBMConn.invoke(this.websphereConnection, new Object[0]);
            this.websphereConnection = null;
        }
        catch (Exception exception) {
            String string = UtilitiesBase.getMessage(IBMDBBaseMessages.websphereConnectionError);
            throw new DataException(string, 112);
        }
    }

    public void rollbackTransaction() throws SQLException {
        this.getJdbcConnection().rollback();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.getJdbcConnection().setAutoCommit(bl);
    }

    public void setConnectionSpec(DatabaseConnectionSpec databaseConnectionSpec) {
        this.connSpec = databaseConnectionSpec;
    }

    protected void setDatabaseManager(JDBCConnectionManager jDBCConnectionManager) {
        this.databaseManager = jDBCConnectionManager;
    }

    protected void setJdbcConnection(Connection connection) {
        this.jdbcConnection = connection;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.getJdbcConnection().setTransactionIsolation(n);
    }
}

