/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class OrderedHashtable
extends Dictionary
implements Serializable {
    private Vector sequenceableKeys = new Vector();
    private Vector sequenceableValues = new Vector();
    private Hashtable hashtable;
    static final long serialVersionUID = 6383502102138858878L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public OrderedHashtable() {
        this(101);
    }

    public OrderedHashtable(int n) {
        this.hashtable = new Hashtable(n);
    }

    public synchronized boolean contains(Object object) {
        return this.sequenceableValues.contains(object);
    }

    public synchronized boolean containsKey(Object object) {
        return this.sequenceableKeys.contains(object);
    }

    private synchronized void decrementIndexesBetween(int n, int n2) {
        Enumeration enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            int n3 = (Integer)this.hashtable.get(k);
            if (n > n3 || n3 > n2) continue;
            this.hashtable.put(k, new Integer(--n3));
        }
    }

    public synchronized Enumeration elements() {
        return this.sequenceableValues.elements();
    }

    public synchronized Object get(Object object) {
        Object e2;
        try {
            Object v = this.hashtable.get(object);
            if (v == null) {
                return null;
            }
            e2 = this.sequenceableValues.elementAt((Integer)v - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        return e2;
    }

    public synchronized Object getAtIndex(int n) {
        Object e2;
        try {
            e2 = this.sequenceableValues.elementAt(n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        return e2;
    }

    private synchronized void incrementIndexesBetween(int n, int n2) {
        Enumeration enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            int n3 = (Integer)this.hashtable.get(k);
            if (n > n3 || n3 > n2) continue;
            this.hashtable.put(k, new Integer(++n3));
        }
    }

    public synchronized int indexOfKey(Object object) {
        try {
            Object v = this.hashtable.get(object);
            if (v == null) {
                return 0;
            }
            return (Integer)v;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public boolean isEmpty() {
        return this.hashtable.isEmpty();
    }

    public synchronized Enumeration keys() {
        return this.sequenceableKeys.elements();
    }

    private Integer newIndex() {
        return new Integer(this.sequenceableValues.size() + 1);
    }

    public synchronized Object put(Object object, Object object2) {
        Object e2;
        Integer n = (Integer)this.hashtable.get(object);
        if (n == null) {
            n = this.newIndex();
            this.hashtable.put(object, n);
            this.sequenceableKeys.addElement(object);
            this.sequenceableValues.addElement(object2);
            e2 = null;
        } else {
            e2 = this.sequenceableValues.elementAt(n - 1);
            this.sequenceableKeys.setElementAt(object, n - 1);
            this.sequenceableValues.setElementAt(object2, n - 1);
        }
        return e2;
    }

    public synchronized Object remove(Object object) {
        Object var3_3;
        Integer n = (Integer)this.hashtable.get(object);
        if (n == null) {
            var3_3 = null;
        } else {
            this.decrementIndexesBetween(n + 1, this.sequenceableValues.size());
            var3_3 = this.hashtable.remove(object);
            this.sequenceableKeys.removeElementAt(n - 1);
            this.sequenceableValues.removeElementAt(n - 1);
        }
        return var3_3;
    }

    public synchronized Object removeElementAt(int n) {
        Object var2_3;
        if (this.sequenceableValues.size() < n) {
            return null;
        }
        Object e2 = this.sequenceableKeys.elementAt(n - 1);
        if (this.hashtable.get(e2) == null) {
            var2_3 = null;
        } else {
            this.decrementIndexesBetween(n + 1, this.sequenceableValues.size());
            var2_3 = this.hashtable.remove(e2);
            this.sequenceableKeys.removeElementAt(n - 1);
            this.sequenceableValues.removeElementAt(n - 1);
        }
        return var2_3;
    }

    public int size() {
        return this.hashtable.size();
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 <= n) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append("(" + new Integer(n2 + 1).toString() + ")" + string + "=" + string2);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

