/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug;

import com.ibm.debug.DebugComponentImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.logging.tracing.agent.AgentControllerUnavailableException;
import com.ibm.etools.logging.tracing.agent.LoggingAgent;
import com.ibm.etools.logging.tracing.common.CommandElement;
import com.ibm.etools.logging.tracing.common.CommandHandler;
import com.ibm.etools.logging.tracing.common.CustomCommand;
import java.net.InetAddress;

public class DebugAgent {
    private LoggingAgent _agent;
    private static final TraceComponent tc = Tr.register(DebugComponentImpl.class.getName(), "DebugComponent");

    public void initialize() {
        block2: {
            try {
                this._agent = new LoggingAgent("IBM Distributed Debugger", "Debugger");
                this._agent.setCommandHandler(new CommandHandler(){

                    public void incommingCommand(InetAddress inetAddress, CommandElement commandElement) {
                        switch ((int)commandElement.getTag()) {
                            case 26: {
                                String string;
                                CustomCommand customCommand = (CustomCommand)commandElement;
                                if (customCommand.getData() == null) break;
                                if (customCommand.getData().equals("GET_JVM_DEBUG_PORT")) {
                                    string = new String("JVMport:" + DebugComponentImpl.jvmDebugPort);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "sending JVM " + string + " to RAC");
                                    }
                                    DebugAgent.this._agent.sendMessageToAttachedClient(string, customCommand.getContext());
                                }
                                if (!customCommand.getData().equals("GET_BSF_DEBUG_PORT")) break;
                                string = new String("BSFport:" + DebugComponentImpl.bsfDebugPort);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "sending BSF" + string + " to RAC");
                                }
                                DebugAgent.this._agent.sendMessageToAttachedClient(string, customCommand.getContext());
                            }
                        }
                    }
                });
                this._agent.initialize();
            }
            catch (AgentControllerUnavailableException agentControllerUnavailableException) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "RAC not available");
            }
        }
    }
}

